 /*
  * Khoros: $Id$
  */
 
 /*
  * $Log$
  */
 
/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */
 
 
/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Defines for the Text Widget
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Sep 29, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */
 
#ifndef _xvwidgets_Text_h_
#define _xvwidgets_Text_h_
 
        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/
 


/*------------------------------------------------------------------------
| Attribute:	XVW_TEXT_STRING
|
| Description:	The string that currently appears in the text object.
|
| Type:		char *
| Default:	NULL
| Legal Values:	any printable text
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXT_STRING          "textString"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXT_INSERT_POS
|
| Description:	The location of the caret in the string, where each number
|		represents a character.  For example, if 
|		.symbol index XVW_TEXT_INSERT_POS
|		was set to 5, that would mean that the caret appeared 5
|		letters into the string.
|
| Type:		int
| Default:	0
| Legal Values:	0 <= value <= length of currently displayed string
| Resource:	textInsertPos
------------------------------------------------------------------------*/
#define XVW_TEXT_INSERT_POS      "textInsertPos"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXT_EDIT_TYPE
|
| Description:	The text in the text object may be read-only, or read-write.  
|		Specify 
|		.symbol index KTEXT_READ
|		for the former, 
|		.symbol index KTEXT_EDIT
|		or
|               .symbol index KTEXT_APPEND
| 		for the latter.  Note that 
|               .symbol index KTEXT_EDIT
|		will allow the user to edit any of the text, while
|               .symbol index KTEXT_APPEND
|		will only allow the user to add new text at the end of
|		the existing text.
|
| Type:		int
| Default:	.symbol index KTEXT_READ
| Legal Values:	.symbol index KTEXT_READ
|		.symbol index KTEXT_EDIT
|		.symbol index KTEXT_APPEND
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXT_EDIT_TYPE       "textEditType"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXT_TYPE
|
| Description:	The default contents of the text object (if any) may 
|		be specified directly, or a filename may be given so that 
|		the contents of the file may be displayed.  Specify 
|		.symbol index KTEXT_TYPE_STRING
|		for the former, 
|		.symbol index KTEXT_TYPE_FILE
|		for the latter.
|
| Type:		int
| Default:	.symbol index KTEXT_TYPE_STRING
| Legal Values: .symbol index KTEXT_TYPE_STRING
|		.symbol index KTEXT_TYPE_FILE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXT_TYPE            "textType"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXT_SCROLL_VERT
|
| Description:	If set to TRUE, this attribute will cause a 
|		vertical scrollbar to be used on the text object.
|
| Type:		int
| Default:	FALSE
| Legal Values:	TRUE/FALSE
| Resource:	textScrollVert
------------------------------------------------------------------------*/
#define XVW_TEXT_SCROLL_VERT     "textScrollVert"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXT_SCROLL_HORIZ
|
| Description:	If set to TRUE, this attribute will cause a 
|		horizontal scrollbar to be used on the text object.
|
| Type:		int
| Default:	FALSE
| Legal Values:	TRUE/FALSE
| Resource:	textScrollHoriz
------------------------------------------------------------------------*/
#define XVW_TEXT_SCROLL_HORIZ    "textScrollHoriz"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXT_LENGTH
|
| Description:	The length of the text which is currently displayed.
|
| Type:		int
| Default:	0
| Legal Values:	values >= 0
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXT_LENGTH         "textLength"

/*
 * use this attribute has not been implemented.
 */
#define XVW_TEXT_TRANSLATIONS   "textTranslations"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXT_LEFT_MARGIN
|
| Description:	The number of pixels from the leftmost edge of the text
|		object that the string will be displayed.
|
| Type:		unsigned short
| Default:	0
| Legal Values:	values >= 0
| Resource:	textLeftMargin
------------------------------------------------------------------------*/
#define XVW_TEXT_LEFT_MARGIN    "textLeftMargin"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXT_WRAP
|
| Description:	This attribute controls if and how text is wrapped when 
|		it is longer than the text object's width.  The text may 
|		be left unwrapped, it may wrap on a line which may divide
|		words, or attempt to wrap on words which will leave words
|		intact.
|		.sp
|		.symbol index KTEXT_WRAP_NEVER -
|		don't wrap text
|		.br
|		.symbol index  KTEXT_WRAP_LINE -
|		wrap text on lines (may break up words) 
|		.br
|		.symbol index KTEXT_WRAP_WORD -
|		wrap text on words (attempt to not break up words)
|
| Type:		int
| Default:	.symbol index KTEXT_WRAP_WORD
| Legal Values:	.symbol index KTEXT_WRAP_WORD
|		.symbol index KTEXT_WRAP_NEVER
|		.symbol index KTEXT_WRAP_LINE
| Resource:	textWrap
------------------------------------------------------------------------*/
#define XVW_TEXT_WRAP           "textWrap"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXT_MULTILINE
|
| Description:	Control whether or not more than one line of text can
|		be displayed.  Set to TRUE if you want to display more 
|		than one line of text.
|
| Type:		int
| Default:	FALSE
| Legal Values:	TRUE/FALSE
| Resource:	textMultiline
------------------------------------------------------------------------*/
#define XVW_TEXT_MULTILINE      "textMultiline"

/* 
 *   how to define whether to wrap (on text widgets) 
 */
#define KTEXT_WRAP_WORD     0
#define KTEXT_WRAP_LINE     1
#define KTEXT_WRAP_NEVER    2

/* 
 *   how to define edit type (for text widgets) 
 */
#define  KTEXT_READ    0
#define  KTEXT_EDIT    1
#define  KTEXT_APPEND  2

/*   
 *   how to define text source type (for text widgets) 
 */
#define  KTEXT_TYPE_STRING  0
#define  KTEXT_TYPE_FILE    1

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Text Widget
 */


xvobject xvw_create_text              PROTO((xvobject, char *));


#endif /* _xvwidgets_Text_h_ */
/* Do not add after this line */
