 /*
  * Khoros: $Id$
  */
 
 /*
  * $Log$
  */
 
/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */
 
 
/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Defines for the Shell Widget
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Sep 29, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */
 
#ifndef _xvwidgets_Shell_h_
#define _xvwidgets_Shell_h_
 
        /*-------------------------------------*
        |       #include 
        ---------------------------------------*/
 
#include <X11/Shell.h>

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/
 

/*------------------------------------------------------------------------
| Attribute:	XVW_SHELL_INPUT
|
| Description:	If set to TRUE, the window manager will set the keyboard
|		focus to this application or not, according to its pointer-
|		following or click-to-type model of keyboard input.
|		If set to FALSE, the window manager will not set the keyboard
|		focus to this application. For more details, see
|		\fIThe X Toolkit Intrinsics Programming Manual\fP by
|		Adrian Nye and Tim O'Reilly, section 10.1.4.
|
| Type:		int
| Default:	TRUE
| Legal Values:	TRUE/FALSE
| Resource:	shellInput
------------------------------------------------------------------------*/
#define XVW_SHELL_INPUT		  "shellInput"

/*------------------------------------------------------------------------
| Attribute:	XVW_SHELL_TITLE
|
| Description:	This is the title that appears on the window dressing of
|		the toplevel object.
|
| Type:		char *
| Default:	None (if shell is created with \fIxvf_create_form()\fP,
|		it will be set by the \fIxvforms\fP library to the title
|		of the Form given on the [-F] UIS line for GUI's with
|		master forms, or to the title of the Subform given on
|		the [-M] UIS line for subforms).
| Legal Values:	any printable text
| Resource:	shellTitle
------------------------------------------------------------------------*/
#define XVW_SHELL_TITLE		  "shellTitle"

/*------------------------------------------------------------------------
| Attribute:	XVW_SHELL_X
| Description:	For automatic placement of the toplevel object,
|		specify the (x,y) location on the screen where
|		the toplevel object is to be automatically mapped.
|		.symbol index XVW_SHELL_X
|		specifies the X location for automatic placement.
| Type:		int
| Default:	N/A
| Legal Values:	0 <= value <= screen width
| Resource:	shellX
------------------------------------------------------------------------*/
#define XVW_SHELL_X		  "shellX"

/*------------------------------------------------------------------------
| Attribute:	XVW_SHELL_Y
| Description:	For automatic placement of the toplevel object,
|               specify the (x,y) location on the screen where
|               the toplevel object is to be automatically mapped.
|               .symbol index XVW_SHELL_Y
|               specifies the Y location for automatic placement.
| Type:		int
| Default:	N/A
| Legal Values:	0 <= value <= screen height
| Resource:	shellY
------------------------------------------------------------------------*/
#define XVW_SHELL_Y	 	  "shellY"

/*------------------------------------------------------------------------
| Attribute:	XVW_SHELL_RESIZE
| Description:	Specifies whether or not the shell will request size change
|		from the window manager.
| Type:		int
| Default:	TRUE
| Legal Values:	TRUE/FALSE
| Resource:	shellResize
------------------------------------------------------------------------*/
#define XVW_SHELL_RESIZE	  "shellResize"

/*------------------------------------------------------------------------
| Attribute:	XVW_SHELL_ICON_WINDOW
| Description:	The window that is displayed when the application is iconified.
| Type:		Window
| Default:	Defined by window manager
| Legal Values:	any valid Window
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_SHELL_ICON_WINDOW	  "iconWindow"

/*------------------------------------------------------------------------
| Attribute:	XVW_SHELL_ICON_NAME
| Description:	This is the name that appears on the icon associated with
|		the shell when the application is iconified.
| Type:		char *
| Default:	The application name or the value of 
|		.symbol index XVW_SHELL_TITLE ;
|		the default is set by the window manager.
| Legal Values:	any printable text
| Resource:	iconName
------------------------------------------------------------------------*/
#define XVW_SHELL_ICON_NAME	  "iconName"

/*------------------------------------------------------------------------
| Attribute:	XVW_SHELL_ICON_PIXMAP
|
| Description:	This is the pixmap that appears on the icon
|               when the application is iconified.  Candidates
|               for the value of this attribute may be created with the use
|               of \fIXCreatePixmap()\fP;  see \fIThe Xlib Reference Manual\fP
|               by O'Reilly and Associates.  Note that this attribute is
|               mutually exclusive with
|               .symbol index XVW_SHELL_ICON_PIXMAPFILE ;
|               specify one or the other, not both.
|
|		Note that setting this attribute will over-ride use of
|		the icon name on the icon, as specified by the value of
|		.symbol index XVW_SHELL_ICON_NAME .
|
| Type:		Pixmap
| Default:	NULL
| Legal Values:	Valid Pixmap structure
| Resource:	iconPixmap
------------------------------------------------------------------------*/
#define XVW_SHELL_ICON_PIXMAP	  "iconPixmap"

/*------------------------------------------------------------------------
| Attribute:	XVW_SHELL_ICON_PIXMAPFILE
|
| Description:	The file defining the  pixmap that appears on the icon
|               when the application is iconified.
|
| Type:		char *
| Default:	NULL
| Legal Values:	The full path to a valid xpm or xbm file, defining
|               the desired pixmap.  Note that the path may contain
|               $TOOLBOX.
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_SHELL_ICON_PIXMAPFILE "iconPixmapfile"

/*------------------------------------------------------------------------
| Attribute:	XVW_SHELL_ICON_MASK
|
| Description:	Pixmaps are defined by a rectangular grid of values.  For
|               implementing non-rectangular pixmaps, a bitmap is used to
|               indicate which portions of the rectangular pixmap should
|               appear, and which portions should not be displayed. This
|               bitmap is referred to as a \fImask\fP.  The bitmap must be
|               defined in an xbm file, and the bitmap should be of the same
|               size as the pixmap being displayed.  Anywhere a 1 appears in
|               the bitmap, the value of the pixmap at that point is displayed;
|               anywhere a 0 appears in the bitmap, the value of the pixmap
|               at that point will not be displayed.  Thus, a circular pixmap
|               can be implemented with a pixmap/bitmap mask pair:  the pixmap
|               will define the picture in the circle, while the bitmap mask
|               has all 1's within the boundaries of the circle, and all 0's
|               outside the circle bounds. This is the mask used with the
|		icon pixmap, if any.
|
|               Candidates for the bitmap may be created with
|               \fIXCreateBitmapFromData()\fP;  see \fIThe Xlib Reference
|               Manual\fP by O'Reilly and Associates.  Note that this
|               attribute is
|               mutually exclusive with
|               .symbol index XVW_SHELL_ICON_MASKFILE ;
|               specify one or the other, not both.
|
| Type:		Pixmap
| Default:	NULL
| Legal Values:	Valid Pixmap structure
| Resource:	iconMask
------------------------------------------------------------------------*/
#define XVW_SHELL_ICON_MASK	  "iconMask"

/*------------------------------------------------------------------------
| Attribute:	XVW_SHELL_ICON_MASKFILE
|
| Description:	This is the file defining the bitmap mask used with
|               non-rectangular pixmaps;  see
|               .symbol index XVW_SHELL_ICON_MASK
|               for more details.
|
| Type:		char *
| Default:	NULL
| Legal Values:	The full path to the xbm file defining the mask;
|               Note that the path may contain $TOOLBOX.
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_SHELL_ICON_MASKFILE   "iconMaskfile"

/*------------------------------------------------------------------------
| Attribute:	XVW_SHELL_WIN_GRAVITY
|
| Description:	The window gravity controls the repositioning of subwindows
|		when a parent window is resized.  See Section 4.3.4. of 
|		\fIThe Xlib Programming Manual\fP by Adrian Nye for more
|		information.
|
| Type:		int
| Default:	NorthWestGravity
| Legal Values:	NorthWestGravity, NorthGravity, NorthEastGravity, WestGravity,
|		CenterGravity, EastGravity, SouthWestGravity, SouthGravity,
|		or SouthEastGravity
| Resource:	winGravity
------------------------------------------------------------------------*/
#define XVW_SHELL_WIN_GRAVITY	  "winGravity"

/*------------------------------------------------------------------------
| Attribute:	XVW_SHELL_INITIAL_STATE
|
| Description:	The window's initial state.  This specifies how the shell's
|		toplevel should be created, whether in a normal, iconic,
|		or withdrawn state. 
| Type:		int
| Default:	NormalState
| Legal Values:	WithdrawnState, NormalState, IconicState
| Resource:	initialState
------------------------------------------------------------------------*/
#define XVW_SHELL_INITIAL_STATE	  "initialState"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Application Shell Class by.
 */
#define ApplicationShellClass	applicationShellWidgetClass

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Transient Shell Class by.
 */
#define TransientShellClass	transientShellWidgetClass


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Shell Widget
 */
/* widgets.c */
xvobject xvw_create_application_shell PROTO((char *, Display *, Screen *));
xvobject xvw_create_transient_shell   PROTO((char *, Display *, Screen *));


#endif /* _xvwidgets_Shell_h_ */
/* Do not add after this line */
