 /*
  * Khoros: $Id$
  */
 
 /*
  * $Log$
  */
 
/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */
 
 
/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Defines for the Scrollbar Widget
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Sep 29, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */
 
#ifndef _xvwidgets_Scrollbar_h_
#define _xvwidgets_Scrollbar_h_
 
        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/
 


/*------------------------------------------------------------------------
| Attribute:	XVW_ORIENTATION
| Description:	Indicates whether the scrollbar is to be horizontal or 
|		vertical.
| Type:		int
| Default:	.symbol index KSCROLLBAR_ORIENT_HORIZ
| Legal Values:	.symbol index KSCROLLBAR_ORIENT_HORIZ
|		.symbol index KSCROLLBAR_ORIENT_VERT
| Resource:	orientation
------------------------------------------------------------------------*/
#define XVW_ORIENTATION         "orientation"

/*------------------------------------------------------------------------
| Attribute:	XVW_SCROLL_MIN
| Description:	The minimum world coordinate value that will be 
|		represented by the scroll bar.
| Type:		double
| Default:	0
| Legal Values:	value < scroll max
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_SCROLL_MIN          "scrollMin"

/*------------------------------------------------------------------------
| Attribute:	XVW_SCROLL_MAX
| Description:	The maximum world coordinate value that will be 
|               represented by the scroll bar.
| Type:		double
| Default:	0
| Legal Values:	value > scroll min
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_SCROLL_MAX          "scrollMax"

/*------------------------------------------------------------------------
| Attribute:	XVW_SCROLL_VALUE
| Description:	The current world coordinate represented by the current
|		position of the scroll bar thumb.
| Type:		double
| Default:	0
| Legal Values:	scroll min < value < scroll max
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_SCROLL_VALUE        "scrollValue"

/*------------------------------------------------------------------------
| Attribute:	XVW_SCROLL_INCR
| Description:	The value to increment the scroll bar thumb.
| Type:		double
| Default:	calculated using size of scrollbar
| Legal Values:	values < (scroll max - scroll min)/2
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_SCROLL_INCR         "scrollIncr"

/*------------------------------------------------------------------------
| Attribute:    XVW_SCROLL_CONT_MOTION
|
| Description:  If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the scrollbar object which will be fired when 
|		the user employs the middle mouse button to move the scrollbar
|		thumb continuously.  
|               When calling \fIxvw_add_callback()\fP, pass this attribute
|               directly, as in
|               .begin code
|               xvw_add_callback(scrollbar_obj, 
|				 XVW_SCROLL_CONT_MOTION,
|                                scrollbar_cb, client_data);
|               .end code
|
| Type:		kfunc_void
| Default:	NULL
| Legal Values: callback function, in the form:
|               .begin code
|               void callback_function
|                  xvobject object,
|                  kaddr client_data,
|                  kaddr call_data)
|               .end code
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_SCROLL_CONT_MOTION  "scrollContMotion"

/*------------------------------------------------------------------------
| Attribute:    XVW_SCROLL_INCR_MOTION
|
| Description:  If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the scrollbar object which will be fired when 
|               the user employs the right or left mouse buttons to move the 
|		scrollbar thumb incrementally.  
|               When calling \fIxvw_add_callback()\fP, pass this attribute
|               directly, as in
|               .begin code
|               xvw_add_callback(scrollbar_obj, 
|				 XVW_SCROLL_INCR_MOTION,
|                                scrollbar_cb, client_data);
|               .end code
|
| Type:		kfunc_void
| Default:	NULL
| Legal Values: callback function, in the form:
|               .begin code
|               void callback_function
|                  xvobject object,
|                  kaddr client_data,
|                  kaddr call_data)
|               .end code
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_SCROLL_INCR_MOTION  "scrollIncrMotion"

/*
 * orientation of scrollbar: vertical or horizontal
 */
#define KSCROLLBAR_ORIENT_VERT     0
#define KSCROLLBAR_ORIENT_HORIZ    1

/*   
 *   how to define whether to have scrollbar (on text widgets) 
 */
#define KSCROLLBAR_ALWAYS   0
#define KSCROLLBAR_IFNEEDED 1
#define KSCROLLBAR_NEVER    2



        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Scrollbar Widget
 */
xvobject xvw_create_scrollbar         PROTO((xvobject, char *));


#endif /* _xvwidgets_Scrollbar_h_ */
/* Do not add after this line */
