 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Definitions for List xvobject
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: 
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvwidgets_List_h_
#define _xvwidgets_List_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_LIST_SIZE	
|
| Description:	This \fIread-only\fP attribute returns size of the list 
|		being displayed by the list object.  Note that the list
|		displayed by the list object, as well as the size of that
|		list, is specified using the \fIxvw_change_list()\fP routine,
|		rather than by using an attribute of the list object.
|               .sp
|               Important note: \fIxvw_retrieve_list()\fP MUST be used
|               to retrieve the "actual list" component of the list object,
|               so that it can be passed to \fIxvw_get_attribute(s)\fP
|               to get this attribute. Passing to \fIxvw_get_attribute(s)()\fP
|               the list object that returned by \fIxvw_create_list()\fP will
|               not work (on all widget sets).
|
| Type:		int
| Default:	0
| Legal Values:	size of the list being displayed (read-only)
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_LIST_SIZE	  "listSize"

/*------------------------------------------------------------------------
| Attribute:    XVW_LIST_ITEM_SELECT
|
| Description:	\fIxvw_add_callback()\fP may be used to install a callback 
|		on the list object which will be fired when the user clicks 
|		\fIonce\fP on an item in the list.  
|		.sp
|		Important note: \fIxvw_retrieve_list()\fP MUST be used
|		to retrieve the "actual list" component of the list object, 
|		so that it can be passed to \fIxvw_add_callback()\fP as the
|		first parameter. Passing to \fIxvw_add_callback()\fP the list 
|		object that returned by \fIxvw_create_list()\fP will not work
|		(on all widget sets).
|		.sp
|		When calling 
|		\fIxvw_add_callback()\fP, pass this attribute directly, as in
|               .begin code
|		actual_list = xvw_retrieve_list(listobj);
|               xvw_add_callback(actual_list, 
|			         XVW_LIST_ITEM_SELECT,
|                                list_cb, client_data);
|               .end code
| Type:		kfunc_void
| Default:	NULL
| Legal Values: callback function, in the form:
|               .begin code
|               void callback_function
|                  xvobject object,
|                  kaddr client_data,
|                  kaddr call_data)
|               .end code
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_LIST_ITEM_SELECT    "listItemSelect"

/*------------------------------------------------------------------------
| Attribute:    XVW_LIST_ITEM_ACTION
|
| Description:	\fIxvw_add_callback()\fP may be used to install a callback 
|               on the list object which will be fired when the user clicks 
|               \fItwice, rapidly\fP on an item in the list.  
|		.sp
|               Important note: \fIxvw_retrieve_list()\fP MUST be used
|               to retrieve the "actual list" component of the list object, 
|               so that it can be passed to \fIxvw_add_callback()\fP as the
|               first parameter. Passing to \fIxvw_add_callback()\fP the list 
|               object that returned by \fIxvw_create_list()\fP will not work
|               (on all widget sets).
|               .sp
|               When calling
|               \fIxvw_add_callback()\fP, pass this attribute directly, as in
|               .begin code
|               actual_list = xvw_retrieve_list(listobj);
|               xvw_add_callback(actual_list, 
|				 XVW_LIST_ITEM_ACTION,
|                                list_cb, client_data);
|		.end code
|
| Type:		kfunc_void
| Default:	NULL
| Legal Values:	callback function, in the form:
|               .begin code
|               void callback_function
|                  xvobject object,
|                  kaddr client_data,
|                  kaddr call_data)
|               .end code
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_LIST_ITEM_ACTION    "listItemAction"

/*------------------------------------------------------------------------
| Attribute:    XVW_LIST_HIGHLT_ELEM
|
| Description:	This \fIaction\fP attribute may be used to highlight an 
|		element in the list.  Provide the index of the element 
|		to be highlighted. If the element is already highlighted
|               when the action attribute is used, nothing will happen.
|		Remember that indexing begins at 0.
|               .sp
|               Important note: \fIxvw_retrieve_list()\fP MUST be used
|               to retrieve the "actual list" component of the list object,
|               so that it can be passed to \fIxvw_set_attribute(s)\fP
|               to set this attribute. Passing to \fIxvw_set_attribute(s)()\fP 
|               the list object that returned by \fIxvw_create_list()\fP will 
|               not work (on all widget sets).
|
| Type:		int
| Default:	N/A
| Legal Values: 0 <= value <= (#items - 1)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_LIST_HIGHLT_ELEM    "listHighlightElem"

/*------------------------------------------------------------------------
| Attribute:    XVW_LIST_UNHIGHLT_ELEM
|
| Description:	This \fIaction\fP attribute may be used to un-highlight an 
|               element in the list.  Provide the index of the element 
|               to be un-highlighted.  If the element is not highlighted
|		when the action attribute is used, nothing will happen.
|		Remember that indexing begins at 0.
|		.sp
|		Important note: \fIxvw_retrieve_list()\fP MUST be used
|               to retrieve the "actual list" component of the list object,
|               so that it can be passed to \fIxvw_set_attribute(s)\fP
|		to set this attribute. Passing to \fIxvw_set_attribute(s)()\fP 
|		the list object that returned by \fIxvw_create_list()\fP will 
|		not work (on all widget sets).
|
| Type:		int
| Default:	N/A
| Legal Values:	0 <= value <= (#items - 1)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_LIST_UNHIGHLT_ELEM  "listUnhighlightElem"



        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

/*
 *  The list structure returned as callback data from the list widget
 */
typedef struct _xvw_list_struct {
	char   *string;
	int    list_index;
} xvw_list_struct;

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for List Widget
 */
xvobject xvw_create_list              PROTO((xvobject, char *));


#endif /* _xvwidgets_List_h_ */
/* Do not add after this line */
