 /*
  * Khoros: $Id$
  */
 
 /*
  * $Log$
  */
 
/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */
 
 
/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Defines for the Label Widget
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Sep 29, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */
 
#ifndef _xvwidgets_Label_h_
#define _xvwidgets_Label_h_
 
        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:	XVW_LABEL_TYPE
|
| Description:	A label object can be used to display text, or a pixmap.
|		This attribute specifies which is to be used.  Set to
|		.symbol index KLABEL_TYPE_LABEL
|		for a normal label,
|		.symbol index KLABEL_TYPE_PIXMAP
|		for a pixmap (or bitmap).
|               A label must be set using the
|               .symbol noindex XVW_LABEL
|               attribute, and the pixmap must be set using either the
|               .symbol noindex XVW_PIXMAP
|               or the
|               .symbol noindex XVW_PIXMAP_FILENAME
|               attribute.  By default, a label is used.
|               If the label object is to display a pixmap, this 
|		attribute must be set to
|               .symbol index KLABEL_TYPE_PIXMAP
|               \fIbefore\fP the pixmap is specified
|               with
|               .symbol index XVW_PIXMAP
|               or
|               .symbol index XVW_PIXMAP_FILENAME
|
| Type:		int
| Default:	.symbol index KLABEL_TYPE_LABEL
| Legal Values:	.symbol index KLABEL_TYPE_LABEL
|		.symbol index KLABEL_TYPE_PIXMAP
| Resource:	labelType
------------------------------------------------------------------------*/
#define XVW_LABEL_TYPE		"labelType"

/*------------------------------------------------------------------------
| Attribute:	XVW_LABEL
| Description:	The label used for the label object. Only used when
|		.symbol index XVW_LABEL_TYPE 
|		is set to
|		.symbol index KLABEL_TYPE_LABEL .
| Type:		char *
| Default:	NULL	
| Legal Values:	any printable text
| Resource:	label
------------------------------------------------------------------------*/
#define XVW_LABEL               "label"

/*------------------------------------------------------------------------
| Attribute:	XVW_LABEL_JUSTIFY
| Description:	Specifies whether the label on the label object
|		is to be left justified, middle justified, or right justified.
|		Only used when
|               .symbol index XVW_LABEL_TYPE 
|               is set to
|               .symbol index KLABEL_TYPE_LABEL .
| Type:		int
| Default:	.symbol index KLABEL_JUSTIFY_CENTER
| Legal Values:	.symbol index KLABEL_JUSTIFY_LEFT
|		.symbol index KLABEL_JUSTIFY_CENTER
|		.symbol index KLABEL_JUSTIFY_RIGHT
| Resource:	labelJustify
------------------------------------------------------------------------*/
#define XVW_LABEL_JUSTIFY	"labelJustify"

/*------------------------------------------------------------------------
| Attribute:    XVW_PIXMAP
|
| Description:	This is the pixmap (or bitmap) that appears on the label when
|               .symbol index XVW_LABEL_TYPE
|               is set to
|               .symbol index KLABEL_TYPE_PIXMAP .
|               Candidates for the value of this attribute may be created
|               with the use of \fIXCreatePixmap()\fP;  see \fIThe Xlib
|               Reference Manual\fP by O'Reilly and Associates.  Note that
|               this attribute is mutually exclusive with
|               .symbol index XVW_PIXMAP_FILENAME ;
|               specify one or the other, not both.
|
| Type:		Pixmap
| Default:	NULL
| Legal Values:	Valid Pixmap structure
| Resource:	pixmap
------------------------------------------------------------------------*/
#define XVW_PIXMAP		"pixmap"

/*------------------------------------------------------------------------
| Attribute:	XVW_PIXMAP_FILENAME
|
| Description:	This is the name of the file defining the pixmap (or bitmap)
|               to be used when
|               .symbol index XVW_LABEL_TYPE
|               is set to
|               .symbol index KLABEL_TYPE_PIXMAP .
|
| Type:		char *
| Default:	NULL
| Legal Values:	The full path to a valid xpm or xbm file, dfining the
|               desired pixmap (or bitmap).  Note that the path may contain
|               $TOOLBOX.
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_PIXMAP_FILENAME	"pixmapFilename"

/*------------------------------------------------------------------------
| Attribute:	XVW_PIXMAP_JUSTIFY
|
| Description:	Specifies whether the pixmap on the label object
|               is to be left justified, middle justified, or right justified.
|               Only used when
|               .symbol index XVW_LABEL_TYPE
|               is set to
|               .symbol index KLABEL_TYPE_PIXMAP .
|		Note that the same values are used as for
|		.symbol index XVW_LABEL_JUSTIFY .
| Type:		int
| Default:	.symbol index KLABEL_JUSTIFY_CENTER
| Legal Values: .symbol index KLABEL_JUSTIFY_LEFT
|               .symbol index KLABEL_JUSTIFY_CENTER
|               .symbol index KLABEL_JUSTIFY_RIGHT
| Resource:	pixmapJustify
------------------------------------------------------------------------*/
#define XVW_PIXMAP_JUSTIFY      "pixmapJustify"

/* 
 *   how to define justification of labels (for label widgets and 
 *   pixmap label widgets)
 */
#define KLABEL_JUSTIFY_LEFT    0
#define KLABEL_JUSTIFY_RIGHT   1
#define KLABEL_JUSTIFY_CENTER  2 

/* 
 * button & label type for attribute XVW_LABEL_TYPE
 */
#define KLABEL_TYPE_LABEL     1
#define KLABEL_TYPE_PIXMAP    2

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Label Widget
 */
xvobject xvw_create_label             PROTO((xvobject, char *));


#endif /* _xvwidgets_Label_h_ */
/* Do not add after this line */
