 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: attribute definitions for 
   >>>>		       general xvobject geometry
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvwidgets_GenGeometry_h_
#define _xvwidgets_GenGeometry_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:	XVW_WIDTH
| Description:	The width of the object in pixels. Will take 
|		precedence over
|		.symbol noindex XVW_CHAR_WIDTH .
| Type:		int
| Default:	calculated
| Legal Values:	values > 0
| Resource:	width
------------------------------------------------------------------------*/
#define XVW_WIDTH 		"width"

/*------------------------------------------------------------------------
| Attribute:	XVW_HEIGHT
| Description:	The height of the object in pixels.  Will take 
|		precedence over
|		.symbol noindex XVW_CHAR_HEIGHT .
| Type:		int
| Default:	calculated
| Legal Values:	values > 0
| Resource:	height
------------------------------------------------------------------------*/
#define XVW_HEIGHT 		"height"

/*------------------------------------------------------------------------
| Attribute:	XVW_XPOSITION
| Description:	The X position with respect to the upper left hand 
|		corner of the parent, in pixels.  Takes precedence over
|		.symbol noindex XVW_CHAR_XPOS .
| Type:		int
| Default:	0
| Legal Values:	values >= 0
| Resource:	xposition
------------------------------------------------------------------------*/
#define XVW_XPOSITION		"xposition"

/*------------------------------------------------------------------------
| Attribute:	XVW_YPOSITION
| Description:	The Y position with respect to the upper left hand 
|		corner of the parent, in pixels.  Takes precedence over
|		.symbol noindex XVW_CHAR_YPOS .
| Type:		int
| Default:	0
| Legal Values:	values >= 0
| Resource:	yposition
------------------------------------------------------------------------*/
#define XVW_YPOSITION		"yposition"

/*------------------------------------------------------------------------
| Attribute:	XVW_BORDER_WIDTH
| Description:	Specifies the size of the border, in pixels.  A value of 
|		zero (0) indicates that no border is desired.
| Type:		int
| Default:	1
| Legal Values:	values >= 0
| Resource:	borderWidth
------------------------------------------------------------------------*/
#define XVW_BORDER_WIDTH 	"borderWidth"

#endif /* _xvwidgets_GenGeometry_h_ */
/* Don't add after this point */
