 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes concerning spacing
   >>>>                between objects, given in pixels
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_ManagerPixelSpacing_h_
#define _xvobjects_ManagerPixelSpacing_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:    XVW_HORIZ_DIST
| Description:	Horizontal distance in pixels (to the right) from the 
|		location at which the object would otherwise be placed.
|		This is most often used in conjunction with relative layout.
|		For example, you might use the 
|		.symbol index XVW_RIGHT_OF
|		attribute to make an object appear to the right of 
|		a second object;
|		.symbol index XVW_HORIZ_DIST
|		can then be used to specify \fIhow many\fP pixels to the right
|		the first object should be spaced from the second.
| Type:		int
| Default:	unused
| Legal Values: values >= 0
| Resource:     horizDist
------------------------------------------------------------------------*/
#define XVW_HORIZ_DIST          "horizDist"

/*------------------------------------------------------------------------
| Attribute:    XVW_VERT_DIST
| Description:	Vertical distance in pixels (down) from the location at which 
|		the object would otherwise be placed.
|               This is most often used in conjunction with relative layout.
|               For example, you might use the 
|               .symbol index XVW_BELOW
|               attribute to make an object appear below a second object;
|               .symbol index XVW_VERT_DIST
|               can then be used to specify \fIhow many\fP pixels below
|               the second object the first object should appear.
| Type:		int
| Default:      unused
| Legal Values: values >= 0
| Resource:     vertDist
------------------------------------------------------------------------*/
#define XVW_VERT_DIST           "vertDist"

/*------------------------------------------------------------------------
| Attribute:    XVW_DEF_HORIZ_DIST
| Description:  This attribute is used only with \fIconstraint\fP objects 
|		that will be laying out children, such as manager objects,
|		rowcol objects, viewport objects, and so on.  It sets the
|		default horizontal distance, in pixels, that children will be 
|		spaced from one another when doing relative layout.  Suppose you
|		have a manager object containing many buttons, each of
|		which is right of the last.  If you wanted each button to 
|		appear 5 pixels to the right of the one before it, you could set
|		.symbol index XVW_HORIZ_DIST
|		to 5 on each of the children.  An easier approach, however,
|		would be to simply set
|		.symbol index XVW_DEF_HORIZ_DIST
|		to 5 once, on the manager object parent.
|		Note that the value specified by
|		.symbol index XVW_DEF_HORIZ_DIST
|		will be over-ridden by individual horizontal distances
|		specified by any of the children using
|               .symbol index XVW_HORIZ_DIST .
| Type:         int
| Default:      3
| Legal Values: values > 0
| Resource:     defHorizDist
------------------------------------------------------------------------*/
#define XVW_DEF_HORIZ_DIST      "defHorizDist"

/*------------------------------------------------------------------------
| Attribute:    XVW_DEF_VERT_DIST
| Description:  This attribute is used only with \fIconstraint\fP objects 
|               that will be laying out children, such as manager objects,
|               rowcol objects, viewport objects, and so on.  It sets the
|               default vertical distance, in pixels, that children will be 
|		spaced from one another when doing relative layout.  Suppose you
|               have a manager object containing many buttons, each of
|               which is below the last.  If you wanted each button to 
|               appear 7 pixels below the one above it, you could set
|               .symbol index XVW_VERT_DIST
|               to 7 on each of the children.  An easier approach, however,
|               would be to simply set
|               .symbol index XVW_DEF_VERT_DIST
|               to 7 once, on the manager object parent.
|               Note that the value specified by
|               .symbol index XVW_DEF_VERT_DIST
|               will be over-ridden by individual vertical distances
|               specified by any of the children using
|               .symbol index XVW_VERT_DIST .
| Type:         int
| Default:      3
| Legal Values: values > 0
| Resource:     defVertDist
------------------------------------------------------------------------*/
#define XVW_DEF_VERT_DIST       "defVertDist"

/*------------------------------------------------------------------------
| Attribute:    XVW_BUFFER_DIST
| Description:	This is the buffer distance in pixels around the edge of the
|		Manager.  It represents the minimum number of pixels that
|		will appear between a child and the nearest edge of its parent.
| Type:		int
| Default:      3
| Legal Values: values >= 0
| Resource:     bufferDist
------------------------------------------------------------------------*/
#define XVW_BUFFER_DIST          "bufferDist"

#endif /* _xvobjects_ManagerPixelSpacing_h_ */
/* Do not add after this line */
