 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private definitions for Manager Object
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_ManagerObjP_h_
#define _xvobjects_ManagerObjP_h_


        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <X11/RectObjP.h>
#include <xvobjects/ManagerObj.h>

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

/*
 *  general tolerence in picking graphical objects
 */
#define PICK_TOLERANCE        6

#undef XtInheritEraseSel
#undef XtInheritRefreshSel
#define XtInheritEraseSel       ((void (*)())_XtInherit)
#define XtInheritRefreshSel     ((void (*)())_XtInherit)
#define XtInheritPicking        ((int  (*)())_XtInherit)
#define XtInheritChangeGeometry ((void (*)())_XtInherit)

        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/


typedef struct _XvwManagerGadgetClassPart
{
   kfunc_int   pick_selection;
   kfunc_void  erase_selection;
   kfunc_void  refresh_selection;
   kfunc_void  change_geometry;
} XvwManagerGadgetClassPart;

typedef struct _XvwManagerGadgetClassRec
{
   RectObjClassPart		rect_class;
   XvwManagerGadgetClassPart	manager_class;
} XvwManagerGadgetClassRec;

extern XvwManagerGadgetClassRec xvwManagerGadgetClassRec;


typedef struct
{
    XtEventTable    event_table;	/* private to event dispatcher      */
    XtTMRec	    tm;                 /* translation management           */
    XtTranslations  accelerators;       /* accelerator translations         */
    Pixel	    border_pixel;	/* window border pixel		    */
    Pixmap          border_pixmap;	/* window border pixmap or NULL     */
    WidgetList      popup_list;         /* list of popups                   */
    Cardinal        num_popups;         /* how many popups                  */
    String          name;		/* widget resource name		    */
    Screen	    *screen;		/* window's screen		    */
    Colormap        colormap;           /* colormap                         */
    Window	    window;		/* window ID			    */
    Cardinal        depth;		/* number of planes in window       */
    Pixel	    background_pixel;	/* window background pixel	    */
    Pixmap          background_pixmap;	/* window background pixmap or NULL */
    Boolean         visible;		/* is window mapped and not ocluded?*/
    Boolean	    mapped_when_managed;/* map window if it's managed?      */
    Boolean	    force_redisplay;	/* force redisplay instead of expose*/

    GC	  gc;
    Boolean mapped;
    Boolean realized;
    Pixel foreground;
    Pixel background;
    XFontStruct *font;
} XvwManagerObjPart;


typedef struct _XvwManagerGadgetRec
{
   ObjectPart	      object;
   RectObjPart        rectobj;
   XvwManagerObjPart  manager;
} XvwManagerGadgetRec;

typedef struct  _XvwManagerGadgetClassRec  *XvwManagerGadgetClass;
typedef struct  _XvwManagerGadgetRec       *XvwManagerGadget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwManagerGadget
 */
extern XvwManagerGadgetClassRec xvwManagerGadgetClassRec;

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/
 
/* ManagerObj.c */
void ManagerObjForceRedisplay PROTO((Widget, Widget, int, Boolean *));


#endif /* _xvobjects_ManagerObjP_h_ */
/* Do not add after this line */
