 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private declarations for the graphical
   >>>>		       layout manager.
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_LayoutP_h_
#define _xvobjects_LayoutP_h_


    /*-------------------------------------*
    |       #include 
    ---------------------------------------*/

#include <xvobjects/ManagerP.h>
#include <xvobjects/Layout.h>

    /*-------------------------------------*
    |       typedefs
    ---------------------------------------*/

typedef struct _XvwLayoutWidgetClassPart
{
    XtPointer  extension;
} XvwLayoutWidgetClassPart;


typedef struct _XvwLayoutWidgetClassRec
{
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    XvwManagerWidgetClassPart   manager_class;
    XvwLayoutWidgetClassPart     layout_class;
} XvwLayoutWidgetClassRec;

typedef struct
{
    int		number_across;
    int		buffer_size;
    int		border_size;
    int		area_justification;
    Widget	selected_child;
    XtCallbackList layout_callback;

} XvwLayoutPart;


typedef struct _XvwLayoutWidgetRec
{
    CorePart	  core;
    CompositePart  composite;
    ConstraintPart constraint;
    XvwManagerPart manager;
    XvwLayoutPart  layout;
} XvwLayoutWidgetRec;


typedef struct  _XvwLayoutWidgetClassRec   *XvwLayoutWidgetClass;
typedef struct  _XvwLayoutWidgetRec        *XvwLayoutWidget;


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwLayoutWidget
 */
extern  XvwLayoutWidgetClassRec xvwLayoutWidgetClassRec;


#endif /* _xvobjects_LayoutP_h_ */
/* Don't add after this point */
