 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of  Integer Widget
   >>>>
   >>>>    Written By: Mark Young and Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Integer_h_
#define _xvobjects_Integer_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_INTEGER_LABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|		label object component of the the integer object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The label object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INTEGER_LABEL_OBJECT		"integerLabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_INTEGER_CRLABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|               pixmap object component of the the integer object that
|		indicates a "live" selection.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The pixmap object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INTEGER_CRLABEL_OBJECT	"integerCrlabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_INTEGER_SCROLLBAR_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|               scrollbar object component of the the integer object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The scrollbar object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INTEGER_SCROLLBAR_OBJECT	"integerScrollbarObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_INTEGER_TEXT_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|               text object component of the the integer object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The text object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INTEGER_TEXT_OBJECT		"integerTextObject"


/*------------------------------------------------------------------------
| Attribute:    XVW_INTEGER_LABEL
|
| Description:  This is the text that will appear in the label object
|		component of the integer object.  Provide text appropriate
|		as a title of the integer object.
|
| Type:         char *
| Default:      NULL
| Legal Values: any printable text
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INTEGER_LABEL		"integerLabelObject.label"

/*------------------------------------------------------------------------
| Attribute:	XVW_INTEGER_VALUE
|
| Description:  The integer precision value which is currently displayed in
|		the text object.  This attribute can be used to initialize
|		the integer value to be displayed in the text object, or to
|		acquire a integer value that has been entered by the user in
|		the text object.
|
| Type:         int
| Default:      0.0
| Legal Values: any integer value
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INTEGER_VALUE		"integerValue"

/*------------------------------------------------------------------------
| Attribute:	XVW_INTEGER_MINVALUE
|
| Description:  The minimum integer value allowed. If both
|		.symbol noindex XVW_INTEGER_MINVALUE
|		and
|		.symbol noindex XVW_INTEGER_MAXVALUE
|		are 0.0, the integer value is unbounded.
|
| Type:         int
| Default:      0.0
| Legal Values: any integer value
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INTEGER_MINVALUE		"integerMinvalue"

/*------------------------------------------------------------------------
| Attribute:	XVW_INTEGER_MAXVALUE
|
| Description:  The maximum integer value allowed. If both
|		.symbol noindex XVW_INTEGER_MINVALUE
|		and
|		.symbol noindex XVW_INTEGER_MAXVALUE
|		are 0, the integer value is unbounded.
|
| Type:         int
| Default:      1.0
| Legal Values: any integer value
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INTEGER_MAXVALUE		"integerMaxvalue"

/*------------------------------------------------------------------------
| Attribute:	XVW_INTEGER_CALLBACK
|
| Description:  If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback may be installed on the integer object which will
|               be fired when the user enters a new int value, either by
|               typing it in and pressing <cr>, or by using the scrollbar.
|               When calling \fIxvw_add_callback()\fP, pass this attribute
|               directly, as in
|               .begin code
|               xvw_add_callback(intobj, XVW_INTEGER_CALLBACK,
|                                int_cb, client_data);
|               .end code
|               Note that the current value of the integer object will
|		be passed to the callback in the \fIcall_data\fP.  The value 
|		must be cast to an integer pointer before use, as in:
|               .br
|               \f(CWint *value = (int *) call_data;\fP
|               .br
|               Alternatively, the int value may be obtained with
|               .symbol index XVW_INTEGER_VALUE .
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|		void callback_function
|		   xvobject object,
|		   kaddr client_data,
|		   kaddr call_data)
|		.end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_INTEGER_CALLBACK		"integerCallback"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Integer Object by.
 */
#define IntegerWidgetClass	xvwIntegerWidgetClass

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration IntegerWidgetClass
 */
extern   WidgetClass     IntegerWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Integer Object
 */
xvobject xvw_create_integer PROTO((xvobject, char *));


#endif /* _xvobjects_Integer_h_ */
/* Do not add after this line */
