 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for Canvas object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_CanvasP_h_
#define _xvobjects_CanvasP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvobjects/Canvas.h>
#include <xvobjects/ViewportP.h>


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct _XvwCanvasWidgetClassPart
{
     XtPointer  extension;
} XvwCanvasWidgetClassPart;

typedef struct _XvwCanvasWidgetClassRec
{
   CoreClassPart		core_class;
   CompositeClassPart		composite_class;
   ConstraintClassPart		constraint_class;
   XvwManagerWidgetClassPart	manager_class;
   XvwViewportWidgetClassPart	viewport_class;
   XvwCanvasWidgetClassPart	canvas_class;
} XvwCanvasWidgetClassRec;

extern  XvwCanvasWidgetClassRec xvwCanvasWidgetClassRec;

typedef struct
{
   Boolean rubberband;		/* whether objects should rubberband	      */

   xvobject selected;
} XvwCanvasPart;


typedef struct _XvwCanvasWidgetRec
{
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  XvwManagerPart	manager;
  XvwViewportPart	viewport;
  XvwCanvasPart		canvas;

} XvwCanvasWidgetRec;

typedef struct {int empty;} XvwCanvasConstraintsPart;

typedef struct _XvwCanvasWidgetConstraintsRec {
    XvwManagerConstraintsPart	manager;
    XvwViewportConstraintsPart	viewport;
    XvwCanvasConstraintsPart	canvas;
} XvwCanvasWidgetConstraintsRec, *XvwCanvasWidgetConstraints;

typedef struct  _XvwCanvasWidgetClassRec  *XvwCanvasWidgetClass;
typedef struct  _XvwCanvasWidgetRec       *XvwCanvasWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwCanvasWidget
 */
extern XvwCanvasWidgetClassRec xvwCanvasWidgetClassRec;


#endif /* _xvobjects_CanvasP_h_ */
/* Do not add after this line */
