 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for Workspace object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: May 21, 1993 09:42
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvlang_WorkspaceP_h_
#define _xvlang_WorkspaceP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvlang/Workspace.h>
#include <xvobjects/CanvasP.h>


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

typedef struct _XvwWorkspaceWidgetClassPart
{
     XtPointer  extension;
} XvwWorkspaceWidgetClassPart;

typedef struct _XvwWorkspaceWidgetClassRec
{
   CoreClassPart		core_class;
   CompositeClassPart		composite_class;
   ConstraintClassPart		constraint_class;
   XvwManagerWidgetClassPart	manager_class;
   XvwViewportWidgetClassPart	viewport_class;
   XvwCanvasWidgetClassPart	canvas_class;
   XvwWorkspaceWidgetClassPart	workspace_class;
} XvwWorkspaceWidgetClassRec;

extern  XvwWorkspaceWidgetClassRec xvwWorkspaceWidgetClassRec;

typedef struct
{
   int variables;
   Boolean inherit;
   Boolean parallel;
   Boolean responsive;

   /*
    *  Defaults for Icons and Connections within a workspace... 
    */
   Boolean glyph_echo;
   Boolean glyph_reporting;
   Boolean icon_placement;
   Boolean icon_leave;
   Boolean icon_show_dav;
   Boolean icon_show_modified;
   Boolean icon_remote_enable;
   int  connection_type;

   char *filename;		/* currently restored workspace filename    */
   xvobject titlebar;		/* the titlebar */
   xvobject input;		/* the input connector */
   xvobject output;		/* the output connector */
   xvobject procedure;		/* the procedure object associated with the */
				/* workspace (if any).			    */

   kfile     **saved;
   Boolean   running;
   Boolean   scheduling;
   int	     saved_num;

   XtCallbackList run_callback;
   XtCallbackList active_callback;

   Boolean        created_form; /* whether we created the form or not     */
   kform	  *wkspgui;
   xvobject	  delete_button;
   int		  num_selections;
   kform_struct   **selections;
   kbool	  wkspgui_initialized;

} XvwWorkspacePart;


typedef struct _XvwWorkspaceWidgetRec
{
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  XvwManagerPart	manager;
  XvwViewportPart	viewport;
  XvwCanvasPart		canvas;
  XvwWorkspacePart	workspace;

} XvwWorkspaceWidgetRec;

typedef struct {int empty;} XvwWorkspaceConstraintsPart;

typedef struct _XvwWorkspaceWidgetConstraintsRec {
    XvwManagerConstraintsPart	manager;
    XvwViewportConstraintsPart	viewport;
    XvwCanvasConstraintsPart	canvas;
    XvwWorkspaceConstraintsPart	workspace;
} XvwWorkspaceWidgetConstraintsRec, *XvwWorkspaceWidgetConstraints;

typedef struct  _XvwWorkspaceWidgetClassRec  *XvwWorkspaceWidgetClass;
typedef struct  _XvwWorkspaceWidgetRec       *XvwWorkspaceWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwWorkspaceWidget
 */
extern XvwWorkspaceWidgetClassRec xvwWorkspaceWidgetClassRec;

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/


#endif /* _xvlang_WorkspaceP_h_ */
/* Do not add after this line */
