 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Definitions for Khoros ToolboxList Object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Jul 02, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvlang_ToolboxList_h_
#define _xvlang_ToolboxList_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:    XVW_TOOLBOXLIST_SELECT
| Description:  If desired, a callback may be installed on the toolboxlist
|		object that will be fired each time an entry is selected
|		within the toolbox list.
| Type:         kfunc_void
| Default:      NULL
| Legal Values: N/A
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TOOLBOXLIST_SELECT	   "toolboxlistSelect"

/*------------------------------------------------------------------------
| Attribute:    XVW_TOOLBOXLIST_CREATE
| Description:  If desired, a callback may be installed on the toolboxlist
|               object that will be fired each time an entry is desired
|               to be created by the user.  This currently specified by
|		either the user "double" clicking on an entry, or the
|		programmer using the
|		.symbol index XVW_TOOLBOXLIST_OPEN
|		\fIaction attribute\fP.
| Type:         kfunc_void
| Default:      NULL
| Legal Values: N/A
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TOOLBOXLIST_CREATE	   "toolboxlistCreate"

/*------------------------------------------------------------------------
| Attribute:    XVW_TOOLBOXLIST_OPEN
| Description:  This \fIaction attribute\fP causes the
|		.symbol index XVW_TOOLBOXLIST_CREATE
|		to be fired with the currently selected toolbox list entry.
| Type:         int
| Default:      N/A
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TOOLBOXLIST_OPEN	   "toolboxlistOpen"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the ToolboxList Object by.
 */
#define ToolboxListWidgetClass	xvwToolboxListWidgetClass

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration ToolboxListWidgetClass
 */
extern   WidgetClass     ToolboxListWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for ToolboxList Object
 */
xvobject xvw_create_toolboxlist PROTO((xvobject, char *));


#endif /* _xvlang_ToolboxList_h_ */
/* Do not add after this line */
