 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of  Node Widget
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvlang_Node_h_
#define _xvlang_Node_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_NODE_NAME
| Description:  The name with which to identify the node.  The
|		name will be printed below the node.
| Type:         char *
| Default:      NULL
| Legal Values: any terminated string
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NODE_NAME          "nodeName"

/*------------------------------------------------------------------------
| Attribute:    XVW_NODE_PIXMAPFILE
| Description:  This is the file defining the pixmap that appears in 
|		the center of the node.
| Type:         char * 
| Default:      NULL 
| Legal Values: The full path to a valid xpm or xbm file, defining
|               the desired pixmap.  Note that the path may contain
|               $TOOLBOX.
| Resource:	nodePixmapfile
------------------------------------------------------------------------*/
#define XVW_NODE_PIXMAPFILE    "nodePixmapfile"

/*------------------------------------------------------------------------
| Attribute:	XVW_NODE_PIXMAP
|
| Description:  This is the pixmap that appears in the center of the node.  
|		Candidates for the value of this attribute may be created with 
|		the use of \fIXCreatePixmap()\fP;  see \fIThe Xlib Reference 
|		Manual\fP by O'Reilly and Associates.  Note that this attribute |		is mutually exclusive with
|               .symbol index XVW_NODE_PIXMAPFILE ;
|               specify one or the other, not both.
|
| Type:         Pixmap 
| Default:      NULL 
| Legal Values: Valid Pixmap structure 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NODE_PIXMAP        "nodePixmap"

/*------------------------------------------------------------------------
| Attribute:	XVW_NODE_PLACEMENT
| Description:  Indicates whether or not the node should be placed 
|               interactively (TRUE) or non-interactively (FALSE).
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	nodePlacement
------------------------------------------------------------------------*/
#define XVW_NODE_PLACEMENT     "nodePlacement"

/*------------------------------------------------------------------------
| Attribute:	XVW_NODE_LEAVE
| Description:  Indicates whether or not the node should be unmapped
|               when its menu is being displayed;  when set to TRUE
|               the node is left visible, when set to FALSE, the node
|               is unmapped.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	nodeLeave
------------------------------------------------------------------------*/
#define XVW_NODE_LEAVE         "nodeLeave"

/*------------------------------------------------------------------------
| Attribute:    XVW_NODE_MODIFIED
| Description:  Indicates whether the node is in an updated state, or has
|               been modified (and needs to be run).  If TRUE, this attribute
|               indicates that the node needs to be executed. When TRUE,
|               this attribute is also used to clear the node's data available
|               indicators.
|               
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_NODE_MODIFIED        "nodeModified"

/*------------------------------------------------------------------------
| Attribute:    XVW_NODE_RESET
| Description:  This \fIaction attribute\fP resets a node to it's initial
|               state.  After a node has been run, it is sometimes necessary
|		to reset the node in order to get it re-run.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_NODE_RESET        "nodeReset"

/*------------------------------------------------------------------------
| Attribute:	XVW_NODE_SHOW_DAV
| Description:  If TRUE, this attribute indicates that the node should
|               display a visual indication of when data is available
|               at a port.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	nodeShowDav
------------------------------------------------------------------------*/
#define XVW_NODE_SHOW_DAV      "nodeShowDav"

/*------------------------------------------------------------------------
| Attribute:    XVW_NODE_SHOW_MODIFIED
| Description:  If TRUE, this attribute specifies that the node should 
|               visually indicate when it has been modified.  See
|               .symbol index XVW_NODE_MODIFIED
|               for details on node modified status.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	nodeShowModified
------------------------------------------------------------------------*/
#define XVW_NODE_SHOW_MODIFIED "nodeShowModified"

/*------------------------------------------------------------------------
| Attribute:	XVW_NODE_REMOTE_ENABLE
| Description:  If TRUE, this attribute indicates that the node is capable
|		of being executed on a remote architecure. 
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NODE_REMOTE_ENABLE "nodeRemoteEnable"

/*------------------------------------------------------------------------
| Attribute:    XVW_NODE_RUN_CALLBACK
| Description:  If desired, a callback may be installed on the node that
|               will be fired when the node is executed (turned ON) or
|               stopped (turned OFF). 
| Type:         kfunc_void 
| Default:      NULL 
| Legal Values: callback function, in the form:
|               .begin code
|               void callback_function
|                  xvobject object,
|                  kaddr client_data,
|                  kaddr call_data)
|               .end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NODE_RUN_CALLBACK  "nodeRunCallback"

/*------------------------------------------------------------------------
| Attribute:    XVW_NODE_MODIFIED_CALLBACK
| Description:  If desired, a callback may be installed on the node that
|               will be fired when the node becomes modified.  See
|               .symbol index XVW_NODE_MODIFIED
|               for details on node modified status.
| Type:         kfunc_void 
| Default:      NULL 
| Legal Values: callback function, in the form:
|               .begin code
|               void callback_function
|                  xvobject object,
|                  kaddr client_data,
|                  kaddr call_data)
|               .end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NODE_MODIFIED_CALLBACK  "nodeModifiedCallback"

/*------------------------------------------------------------------------
| Attribute:    XVW_NODE_RUNNABLE
| Description:  This \fIaction attribute\fP allows the user to inquire if
|		a node is ready to run.  This is used by the workspace step
|		execute to see which glyph should be run.
| Type:         int 
| Default:      FALSE
| Legal Values: TRUE/FALSE 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NODE_RUNNABLE       "nodeRunnable"

/*------------------------------------------------------------------------
| Attribute:    XVW_NODE_TYPE
| Description:  This attribute is used to represent the node type within
|		a network topology.  The types of nodes are:
|		.symbol index KNODE_TYPE_UNKNOWN
|		.symbol index KNODE_TYPE_SOURCE
|		.symbol index KNODE_TYPE_TRANSFER
|		.symbol index KNODE_TYPE_SINK
|		The source type is used to represent a node which has no
|		inputs, but has optional outputs.  The transfer type is
|		a node which has both specified inputs and outputs.  And
|		finally the sink type is used to represent a node which
|		has inputs, but no outputs.
| Type:         int 
| Default:      KNODE_TYPE_UNKNOWN
| Legal Values: .symbol index KNODE_TYPE_UNKNOWN
|		.symbol index KNODE_TYPE_SOURCE
|		.symbol index KNODE_TYPE_TRANSFER
|		.symbol index KNODE_TYPE_SINK
| Resource:	nodeType
------------------------------------------------------------------------*/
#define XVW_NODE_TYPE          "nodeType"

/*------------------------------------------------------------------------
| Attribute:    XVW_NODE_TEST
| Description:  This \fIaction attribute\fP tests a non-running node 
|               (set to TRUE), or stops testing a currently executing node 
|               (set to FALSE).  It is used in order to simulate running
|		a network without actually running the network itself.
| Type:         int 
| Default:      FALSE
| Legal Values: TRUE/FALSE 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NODE_TEST          "nodeTest"

/*------------------------------------------------------------------------
| Attribute:    XVW_NODE_EXECUTE
| Description:  This \fIaction attribute\fP executes a non-running node 
|               (set to TRUE), or stops a currently executing node 
|               (set to FALSE).
| Type:         int 
| Default:      FALSE
| Legal Values: TRUE/FALSE 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NODE_EXECUTE       "nodeExecute"

/*
 *  The different execution states for the node.
 */
#define KNODE_STOPPED	0
#define KNODE_SCHEDULED 1
#define KNODE_RUNNING   2

/*
 *  The network node type represented within the network topology.
 */
#define KNODE_TYPE_UNKNOWN	0
#define KNODE_TYPE_SOURCE	1
#define KNODE_TYPE_TRANSFER	2
#define KNODE_TYPE_SINK		3


/*
 *  Define the Class name, by which people should be externally referencing
 *  the Node Object by.
 */
#define NodeWidgetClass	xvwNodeWidgetClass

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration NodeWidgetClass
 */
extern   WidgetClass     NodeWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Node Object
 */
xvobject xvw_create_node PROTO((xvobject, char *));


#endif /* _xvlang_Node_h_ */
/* Do not add after this line */
