 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private declarations for the color threshold
   >>>>		       widget.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 15:05
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_ThresholdP_h_
#define _xvisual_ThresholdP_h_


    /*-------------------------------------*
    |       #include 
    ---------------------------------------*/

#include <xvisual/ColorP.h>
#include <xvisual/Threshold.h>

    /*-------------------------------------*
    |       typedefs
    ---------------------------------------*/

typedef struct _XvwThresholdWidgetClass
{
    XtPointer extension;
} XvwThresholdWidgetClassPart;


typedef struct _XvwThresholdWidgetClassRec
{
    CoreClassPart			core_class;
    CompositeClassPart              composite_class;
    ConstraintClassPart             constraint_class;
    XvwManagerWidgetClassPart       manager_class;
    XvwGraphicsWidgetClassPart      graphics_class;
    XvwColorWidgetClassPart		color_class;
    XvwThresholdWidgetClassPart	threshold_class;
} XvwThresholdWidgetClassRec;


typedef struct
{
    /*  resources  */
    Boolean show_palette;
    Boolean clip_accept;
    Boolean thres_invert;
    int	    policy;
    int	    lowerval;
    int	    upperval;
    Pixel   clip_pixelval;
    Pixel   thres_pixelval;
    XtCallbackList threshold_callbacks;

    xvobject palette;
    xvobject lint;
    xvobject uint;
    xvobject rint;
} XvwThresholdPart;


typedef struct _XvwThresholdWidgetRec
{
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    XvwManagerPart	manager;
    XvwGraphicsPart	graphics;
    XvwColorPart	color;
    XvwThresholdPart	threshold;
} XvwThresholdWidgetRec;


typedef struct  _XvwThresholdWidgetClassRec  *XvwThresholdWidgetClass;
typedef struct  _XvwThresholdWidgetRec       *XvwThresholdWidget;


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwThresholdWidget
 */
extern  XvwThresholdWidgetClassRec xvwThresholdWidgetClassRec;


#endif /* _xvisual_ThresholdP_h_ */
/* Don't add after this point */
