 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       PrintPixel widget.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Nov 16, 1992 16:20
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_PrintPixel_h_
#define _xvisual_PrintPixel_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attribute definitions for PrintPixel Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTPIXEL_WIDTH
| Description:  .include $DESIGN/manual/shared/xvisual/printpixel/Width.sec
| Type:         int
| Default:      8
| Legal Values: 1 <= width <= image width
| Resource:     printpixelWidth
------------------------------------------------------------------------*/

#define XVW_PRINTPIXEL_WIDTH		"printpixelWidth"

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTPIXEL_HEIGHT
| Description:  .include $DESIGN/manual/shared/xvisual/printpixel/Height.sec
| Type:         int
| Default:      8
| Legal Values: 1 <= height <= image height
| Resource:     printpixelHeight
------------------------------------------------------------------------*/
#define XVW_PRINTPIXEL_HEIGHT		"printpixelHeight"

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTPIXEL_XPOSITION
| Description:  This is the X position in the image corresponding to the
|               map value that appears in the upper left hand corner of the
|               printmapval grid.
| Type:         int
| Default:      0
| Legal Values: 0 - image width
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PRINTPIXEL_XPOSITION       "printpixelXposition"

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTPIXEL_YPOSITION
| Description:  This is the Y position in the image corresponding to the
|               map value that appears in the upper left hand corner of the
|               printmapval grid.
| Type:         int
| Default:      0
| Legal Values: 0 - image height
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PRINTPIXEL_YPOSITION       "printpixelYposition"


/*
 * this attribute will allow the user to edit the pixel value directly.
 * it is not supported as of yet.
 */
#define XVW_PRINTPIXEL_EDITABLE		"printpixelEditable"

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTPIXEL_OBJECT
|
| Description:  .include $DESIGN/manual/shared/xvisual/printpixel/Object.sec
|               Note that this attribute is mutually exclusive with
|               .symbol index XVW_PRINTPIXEL_FILENAME ;
|               use one or the other, not both.
|
| Type:         kobject
| Default:      NULL
| Legal Values: valid data object
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PRINTPIXEL_OBJECT		"printpixelObject"

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTPIXEL_FILENAME
|
| Description:  .include $DESIGN/manual/shared/xvisual/printpixel/Filename.sec
|                Note that this attribute is mutually exclusive with
|               .symbol index XVW_PRINTPIXEL_OBJECT ;
|               use one or the other, not both.
|
| Type:         char *
| Default:      NULL
| Legal Values: valid input filename
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PRINTPIXEL_FILENAME		"printpixelFilename"

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTPIXEL_SHOWCOLOR
| Description:  .include $DESIGN/manual/shared/xvisual/printpixel/ShowColor.sec
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     printpixelShowcolor
------------------------------------------------------------------------*/
#define XVW_PRINTPIXEL_SHOWCOLOR	"printpixelShowcolor"

/*------------------------------------------------------------------------
| Attribute:    XVW_PRINTPIXEL_UPDATEMODE
| Description:  .include $DESIGN/manual/shared/xvisual/printpixel/UpdateMode.sec
| Type:         int
| Default:      .symbol index KPRINTPIXEL_UM_CONTINUOUS
| Legal Values: .symbol index KPRINTPIXEL_UM_CONTINUOUS
|               .symbol index KPRINTPIXEL_UM_BUTTONPRESS
| Resource:     printpixelUpdatemode
-----------------------------------------------------------------------*/
#define XVW_PRINTPIXEL_UPDATEMODE	"printpixelUpdatemode"

/*
 *  Value definitions for PrintPixel Visual Object
 */
#define KPRINTPIXEL_UM_CONTINUOUS      0
#define KPRINTPIXEL_UM_BUTTON_PRESS    1

/*
 *  Define the Class name, by which people should be externally referencing
 *  the PrintPixel Object by.
 */
#define PrintPixelWidgetClass	xvwPrintPixelWidgetClass

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

/*
 *  XToolkit Widget Declaration for PrintPixelWidgetClass
 */
extern   WidgetClass     PrintPixelWidgetClass;


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Function definitions for PrintPixel Visual Object
 */
xvobject xvw_create_printpixel  PROTO((xvobject, char *));


#endif /* _xvisual_PrintPixel_h_ */
/* Don't add after this point */
