 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       indicator annotation.
   >>>>
   >>>>    Written By: John Salas & Mark Young
   >>>>
   >>>>          Date: Feb 05, 1993 13:46
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Indicator_h_
#define _xvisual_Indicator_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attribute definitions for Indicator Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_INDICATOR_CONSTRAINT
| Description:  .include $DESIGN/manual/shared/xvisual/indicator/Constraint.sec
| Type:         int    
| Default:      .symbol index KINDICATOR_CONSTRAINT_NONE
| Legal Values: .symbol index KINDICATOR_CONSTRAINT_NONE
|               .symbol index KINDICATOR_CONSTRAINT_X
|               .symbol index KINDICATOR_CONSTRAINT_Y
| Resource:     indicatorConstraint
------------------------------------------------------------------------*/
#define XVW_INDICATOR_CONSTRAINT	"indicatorConstraint"

/*------------------------------------------------------------------------
| Attribute:    XVW_INDICATOR_XPOS
| Description:  This read-only attribute returns the stringvalue visual object
|               that displays the X position of the indicator.If the
|               .symbol noindex XVW_INDICATOR_SHOW_YPOS 
|               attribute is set to FALSE, the returned xvobject will be NULL.
| Type:         xvobject
| Default:      N/A  (read only)
| Legal Values: string xvobject
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_INDICATOR_XPOS		"indicatorXpos"

/*------------------------------------------------------------------------
| Attribute:    XVW_INDICATOR_YPOS
| Description:  This read-only attribute returns the stringvalue visual object
|               that displays the Y position of the indicator.  If the
|               .symbol noindex XVW_INDICATOR_SHOW_XPOS 
|               attribute is set to FALSE, the returned xvobject will be NULL.
| Type:         xvobject
| Default:      N/A (read only)
| Legal Values: string xvobject
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_INDICATOR_YPOS		"indicatorYpos"

/*------------------------------------------------------------------------
| Attribute:    XVW_INDICATOR_XPOS_VALUE
| Description:  .include $DESIGN/manual/shared/xvisual/indicator/XposValue.sec
| Type:         double
| Default:      KMAXFLOAT
| Legal Values: any double world coordinate value
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_INDICATOR_XPOS_VALUE	"indicatorXposValue"

/*------------------------------------------------------------------------
| Attribute:    XVW_INDICATOR_YPOS_VALUE
| Description:  .include $DESIGN/manual/shared/xvisual/indicator/YposValue.sec
| Type:         double
| Default:      KMAXFLOAT
| Legal Values: any double world coordinate value
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_INDICATOR_YPOS_VALUE	"indicatorYposValue"

/*------------------------------------------------------------------------
| Attribute:    XVW_INDICATOR_LINE
| Description:  .include $DESIGN/manual/shared/xvisual/indicator/Line.sec
| Type:         int
| Default:      .symbol index KINDICATOR_LINE_NONE
| Legal Values: .symbol index KINDICATOR_LINE_NONE
|               .symbol index KINDICATOR_LINE_VERTICAL
|               .symbol index KINDICATOR_LINE_HORIZONTAL
|               .symbol index KINDICATOR_LINE_BOTH
| Resource:     indicatorLine
------------------------------------------------------------------------*/
#define XVW_INDICATOR_LINE     		"indicatorLine"

/*------------------------------------------------------------------------
| Attribute:    XVW_INDICATOR_SHOW_XPOS
| Description:  .include $DESIGN/manual/shared/xvisual/indicator/ShowXPos.sec
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:     indicatorShowXpos
------------------------------------------------------------------------*/
#define XVW_INDICATOR_SHOW_XPOS     	"indicatorShowXpos"

/*------------------------------------------------------------------------
| Attribute:    XVW_INDICATOR_SHOW_YPOS
| Description:  .include $DESIGN/manual/shared/xvisual/indicator/ShowYPos.sec
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:     indicatorShowYpos
------------------------------------------------------------------------*/
#define XVW_INDICATOR_SHOW_YPOS     	"indicatorShowYpos"

/*
 *  Value definitions for Indicator Visual Object
 */
#define KINDICATOR_CONSTRAINT_NONE	(0L)
#define KINDICATOR_CONSTRAINT_X		(1L << 0)
#define KINDICATOR_CONSTRAINT_Y		(1L << 1)

#define KINDICATOR_LINE_NONE		0
#define KINDICATOR_LINE_VERTICAL	1
#define KINDICATOR_LINE_HORIZONTAL	2
#define KINDICATOR_LINE_BOTH		3

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Indicator Object by.
 */
#define IndicatorGadgetClass	xvwIndicatorGadgetClass

    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration IndicatorGadgetClass
 */
extern   WidgetClass     IndicatorGadgetClass;


    /*-------------------------------------*
    |       routine definitions
    ---------------------------------------*/

/*
 *  Function definitions for Indicator Visual Object
 */
xvobject xvw_create_indicator PROTO((xvobject, char *));


#endif /* _xvisual_Indicator_h_ */
/* Don't add after this point */
