 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines for graphics attributes that
   >>>>                deal with controlling the perspective
   >>>>
   >>>>    Written By: John Salas, Danielle Argiro, Mark Young
   >>>>
   >>>>          Date: Aug 20, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_GraphicsPersp_h_
#define _xvisual_GraphicsPersp_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Definitions for General Graphics Attributes for Visual Objects
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_PROJECTION
|
| Description:  This attribute specifies the projection type.  Supported 
|               settings include:
|		.br
|               .symbol index KGRAPHICS_PERSPECTIVE - 
|               a projection in which parallel lines not parallel to the 
|               projection plane converge to a vanishing point.
|               .br
|               .symbol index KGRAPHICS_ORTHOGRAPHIC - 
|               a parallel projection in which the direction of projection 
|               and the normal to the projection plane are identical.
|               .br
|               .symbol index KGRAPHICS_CAVALIER - 
|               an oblique projection in which the direction of projection 
|               makes a 45 degree angle with the direction of the projection 
|               plane; as a result, the projection of a line perpendicular to 
|               the projection plane is the same length as the line itself.
|               .br
|               .symbol index KGRAPHICS_CABINET\s+2 - 
|               an oblique projection in which the direction of projection
|               makes an angle of arccot (1/2) with the projection plane so 
|               that lines perpendicular to the projection plane project at 
|               half their actual length; this projection is considered more 
|               realistic than the cavalier projection.
|
| Type:         int
| Default:      .symbol index KGRAPHICS_PERSPECTIVE
| Legal Values: .symbol index KGRAPHICS_PERSPECTIVE
|               .symbol index KGRAPHICS_ORTHOGRAPHIC
|               .symbol index KGRAPHICS_CAVALIER
|               .symbol index KGRAPHICS_CABINET
| Resource:     graphicsProjection
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_PROJECTION		"graphicsProjection"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_ALPHA
|
| Description:  Rotates the camera (the eye) about the X axis.
|
| Type:         double
| Default:      300.0
| Legal Values: 0.0 - 360.0 (alpha is given in degrees)
| Resource:     graphicsAlpha
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_ALPHA		"graphicsAlpha"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_THETA
|
| Description:  Rotates the camera (the eye) about the Z axis.
|
| Type:         double
| Default:      70.0
| Legal Values: 0.0 - 360.0 (theta is given in degrees)
| Resource:     graphicsTheta
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_THETA		"graphicsTheta"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_GAMMA
|
| Description:  Rotates the camera (the eye) about the Y axis.
|
| Type:         double
| Default:      0.0
| Legal Values: 0.0 - 360.0 (gamma is given in degrees)
| Resource:     graphicsGamma
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_GAMMA		"graphicsGamma"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_EYE
|
| Description:  The eye distance moves the camera (the \fIeye\fP) either 
|               closer to or farther away from the plot. Setting the eye 
|               distance to 0 would be as if the eye was touching the object.
|
| Type:         double
| Default:      1.0
| Legal Values: value > 0.0
| Resource:     graphicsEye
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_EYE		"graphicsEye"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_VIEWDISTANCE
|
| Description:  The distance of the viewport from the object.
|
| Type:         double
| Default:      6.0
| Legal Values: any values within the world coordinate system
| Resource:     graphicsViewdistance
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_VIEWDISTANCE	"graphicsViewdistance"

#endif /* _xvisual_GraphicsPersp_h_ */
/* Don't add after this point */
