 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Definitions for Khoros AnnotateMenu Object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Jul 02, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_AnnotateMenu_h_
#define _xvisual_AnnotateMenu_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:    XVW_ANNOTATEMENU_CREATE
|
| Description:  A callback may be installed on the annotate menu object,
|               which will be fired when the user employs the annotate menu 
|               to request creation of an annotation.   Note that 
|		installation of a callback on annotation creation is generally 
|		used as an alternative to specification of a destination 
|		backplane for annotation creation using
|               .symbol index XVW_ANNOTATEMENU_WORKSPACE .
|               In other words, if you want the annotations created 
|               automatically, specify the workspace on which they will
|               be created with
|               .symbol index XVW_ANNOTATEMENU_WORKSPACE ;  
|               alternatively, you may use the
|               .symbol index XVW_ANNOTATEMENU_CREATE
|               attribute install your own callback which will deal with 
|               annotation creation.  Note that the class of the annotation
|               to be created is passed in as the \fIcall_data\fP.
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|               void callback_function
|                    xvobject object,
|                    kaddr client_data,
|                    kaddr call_data)
|               .end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_ANNOTATEMENU_CREATE     "annotatemenuCreate"

/*------------------------------------------------------------------------
| Attribute:    XVW_ANNOTATEMENU_WORKSPACE
|
| Description:  This is the xvobject that will serve as the backplane
|               in which annotations will be created.  Examples of 
|               candidates for the workspace include manager objects, 
|               viewport objects, canvas objects, and so on. 
|
| Type:         xvobject 
| Default:      NULL 
| Legal Values: Any visual objects that may be used as a backplanes.
| Resource: 	N/A
------------------------------------------------------------------------*/
#define XVW_ANNOTATEMENU_WORKSPACE  "annotatemenuWorkspace"

/*------------------------------------------------------------------------
| Attribute:    XVW_ANNOTATEMENU_ITEMS
|
| Description:  This mask value indicates which types of annotations are
|               to be offered in the annotate menu object.   Specify each
|               type of annotation that is to appear in the menu by \fIor\fPing
|               the corresponding value into the mask.  For example, if the
|               annotation menu is to offer the user creation of lines and 
|               circles, the 
|               .symbol index XVW_ANNOTATEMENU_ITEMS
|		attribute would be set as follows:
|		.begin code
|		unsigned long mask;
|               mask = KANNOTATEMENU_CIRCLE | 
|		       KANNOTATEMENU_LINE;
|               xvw_set_attribute(annotatemenu, 
|			XVW_ANNOTATEMENU_ITEMS, mask);
|               .end code
|
| Type:         xvobject
| Default:      NULL 
| Legal Values: The following values may be \fIor\fPed into the mask:
|               .symbol index KANNOTATEMENU_MARKER 
|               .symbol index KANNOTATEMENU_LINE 
|               .symbol index KANNOTATEMENU_CIRCLE 
|               .symbol index KANNOTATEMENU_OVAL 
|               .symbol index KANNOTATEMENU_RECTANGLE 
|               .symbol index KANNOTATEMENU_TEXT 
| Resource: 	N/A
------------------------------------------------------------------------*/
#define XVW_ANNOTATEMENU_ITEMS      "annotatemenuItems"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the AnnotateMenu Object by.
 */
#define AnnotateMenuWidgetClass	xvwAnnotateMenuWidgetClass

/*
 *  Masks to indicate which annotations are available via the Annotation menu 
 */
#define KANNOTATEMENU_MARKER      (1L < 0) 
#define KANNOTATEMENU_LINE	  (1L < 1) 
#define KANNOTATEMENU_CIRCLE	  (1L < 2) 
#define KANNOTATEMENU_OVAL	  (1L < 3) 
#define KANNOTATEMENU_RECTANGLE	  (1L < 4) 
#define KANNOTATEMENU_TEXT	  (1L < 5) 

        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration AnnotateMenuWidgetClass
 */
extern   WidgetClass     AnnotateMenuWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for AnnotateMenu Object
 */
xvobject xvw_create_annotatemenu PROTO((xvobject, char *));


#endif /* _xvisual_AnnotateMenu_h_ */
/* Do not add after this line */
