#include <xvinclude.h>

/*
 *  This example creates four variations on the text object:
 *
 *      1 - editable,    single-line
 *      2 - editable,    multi-line
 *      3 - noneditable, single-line
 *      4 - noneditable, multi-line
 */

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;
	xvobject text1,  text2,  text3,  text4;  
	xvobject label1, label2, label3, label4;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

        /* create a manager to be the parent */
	manager = xvw_create_manager(NULL, "back");
	
	/* create editable, singleline text object, and label */
	label1  = xvw_create_label(manager, "label1");
	xvw_set_attributes(label1, 
			   XVW_BELOW,  NULL,
			   XVW_LABEL, "Case 1: ",
 			   NULL);
	text1   = xvw_create_text(manager, "text1");
	xvw_set_attributes(text1, 
			   XVW_TEXT_MULTILINE, FALSE,
			   XVW_BELOW,          NULL,	
			   XVW_RIGHT_OF,       label1,
                           XVW_CHAR_WIDTH,     25.0,
			   XVW_TEXT_EDIT_TYPE, KTEXT_EDIT,
			   XVW_TEXT_TYPE,      KTEXT_TYPE_STRING,
			   XVW_TEXT_STRING,    "Single-line editable string",
			   NULL);
	

	/* create editable, multiline text object, and label */
	label2  = xvw_create_label(manager, "label2");
        xvw_set_attributes(label2, 
                           XVW_BELOW,  text1,
                           XVW_LABEL, "Case 2: ",
                           NULL);
	text2   = xvw_create_text(manager, "text2");
	xvw_set_attributes(text2, 
			   XVW_BELOW,          text1,	
			   XVW_RIGHT_OF,       label2,
                           XVW_CHAR_WIDTH,     25.0,
			   XVW_TEXT_EDIT_TYPE, KTEXT_EDIT,
			   XVW_TEXT_TYPE,      KTEXT_TYPE_STRING,
			   XVW_TEXT_STRING,    "Multi-line editable string in which you may modify text",
			   XVW_TEXT_MULTILINE, TRUE,
			   XVW_CHAR_HEIGHT,    7.0,
			   NULL);

        
	/*
	 *  create noneditable, singleline text object, and label
	 */
        label3  = xvw_create_label(manager,  "label3");
        xvw_set_attributes(label3, 
                           XVW_BELOW,  text2,
                           XVW_LABEL, "Case 3: ",
                           NULL);
        text3   = xvw_create_text(manager, "text3");
        xvw_set_attributes(text3,
			   XVW_BELOW,          text2,
			   XVW_RIGHT_OF,       label3,
                           XVW_CHAR_WIDTH,     25.0,
			   XVW_TEXT_EDIT_TYPE, KTEXT_READ,
			   XVW_TEXT_TYPE,      KTEXT_TYPE_STRING,
			   XVW_TEXT_STRING,    "Single-line read-only string",
			   NULL);


	/* create noneditable, singleline text object, and label */
        label4  = xvw_create_label(manager, "label4");
        xvw_set_attributes(label4, 
			   XVW_BELOW,    text3,
        		   XVW_LABEL,   "Case 4: ",
			   NULL);
        text4   = xvw_create_text(manager, "text4");
        xvw_set_attributes(text4,
                           XVW_BELOW,          text3,
                           XVW_RIGHT_OF,       label4,
                           XVW_CHAR_WIDTH,     25.0,
			   XVW_TEXT_EDIT_TYPE, KTEXT_READ,
			   XVW_TEXT_TYPE,      KTEXT_TYPE_STRING,
                           XVW_TEXT_STRING,    "Multi-line read-only string in which you may not modify text",
			   XVW_TEXT_MULTILINE, TRUE,
			   XVW_CHAR_HEIGHT,    7.0,
                           NULL);

	/* display & run program */
	xvf_run_form();
}
