#include <xvinclude.h>


/*
 *   This example program puts 5 vertical scrollbars & 5 horizontal
 *   scrollbars.  It adds callbacks to the scrollbars to print the value
 *   currently indicated by the scrollbar.  This example also serves to
 *   illustrate the use of call_data.
 */
#define SCROLLBAR_NUM 5

void scrollbar_cb PROTO((xvobject, kaddr, kaddr));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	int      i;
	char     name[KLENGTH];
	xvobject manager;
	xvobject sb;
	xvobject horiz_offset;
	xvobject vert_offset;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/* every GUI has a manager backplane */
	manager = xvw_create_manager(NULL, "back");

	horiz_offset = NULL;

	/*
	 *  five vertical scrollbars in a row
	 */
	for (i = 0; i < SCROLLBAR_NUM; i++)
	{
	   sprintf(name, "vert_sb_%d", i+1);
	   sb  = xvw_create_scrollbar(manager, name);
	   xvw_set_attributes(sb,
	      XVW_RIGHT_OF,     horiz_offset,    /* to R of neighbor        */
	      XVW_ORIENTATION,  KSCROLLBAR_ORIENT_VERT, /* vertical         */
	      XVW_CHAR_WIDTH,   2.0,             /* 2 chars wide            */
	      XVW_CHAR_HEIGHT,  10.0,            /* 10 chars  high          */
	      XVW_SCROLL_MIN,   0.0,             /* min value of 0          */
	      XVW_SCROLL_MAX,   100.0,           /* max value of 100        */
	      XVW_SCROLL_VALUE, ((double)i)*10.0, /* value = last val * 10  */
	      NULL);

	   horiz_offset = sb;
	   xvw_add_callback(sb, XVW_SCROLL_CONT_MOTION,
			    scrollbar_cb, NULL);
	   xvw_add_callback(sb, XVW_SCROLL_INCR_MOTION,
                            scrollbar_cb, NULL);
	}


	/*
	 *  five horizontal scrollbars in a row
	 */
	vert_offset = horiz_offset;
	for (i = 0; i < SCROLLBAR_NUM; i++)
	{
	   sprintf(name, "horiz_sb_%d", i+1);
	   sb  = xvw_create_scrollbar(manager, name);
	   xvw_set_attributes(sb,
	      XVW_BELOW,        vert_offset,      /* under vertical sb set  */
	      XVW_ORIENTATION,  KSCROLLBAR_ORIENT_HORIZ, /* horizontal      */
	      XVW_CHAR_WIDTH,   20.0,             /* 20 chars wide          */
	      XVW_CHAR_HEIGHT,  1.0,              /* 1 chars  high          */
	      XVW_SCROLL_MIN,   0.0,              /* min value of 0         */
	      XVW_SCROLL_MAX,   100.0,            /* max value of 100       */
	      XVW_SCROLL_VALUE, ((double)i)*10.0, /* value = last val * 10  */
	      NULL);

	   vert_offset = sb;
	   xvw_add_callback(sb, XVW_SCROLL_CONT_MOTION,
			    scrollbar_cb, NULL);
	   xvw_add_callback(sb, XVW_SCROLL_INCR_MOTION,
                            scrollbar_cb, NULL);
	}

	/* display & run the program */
	xvf_run_form();
}

void scrollbar_cb (
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	double value;
	double *movement = (double *) call_data;
	
        /*
         * a scrollbar object is one of the few objects that uses a call_data
         * structure.  it needs to => return information to the caller,
         * so that information is returned via the call_data.  The data type
         * of the call_data is determined by the object itself;  a scrollbar
         * object uses a call_data of type "double *".  The movement of the
         * scrollbar returned by the call_data is identical to the value
         * obtained by using the XVW_SCROLL_VALUE attribute, so you can 
         * get the value of the scrollbar either way.
         */

	xvw_get_attribute(object, XVW_SCROLL_VALUE, &value);
	kfprintf(kstderr, "value = %f\n", value);
	kfprintf(kstderr, "movement = %f\n", *movement);
}
