#include <xvinclude.h>

/*
 *  This example shows how the textdisplay object is used to display
 *  a text file.  If the file is formatted with "roff" commands, those
 *  commands will be interpreted, and the file formatted as specified.
 */

static void quit_cb	PROTO((xvobject, kaddr, kaddr));

xvobject text;
xvobject back;
xvobject label;

void main(
   int  argc,
   char **argv,
   char **envp)
{
	xvobject quit;
	float	width;
	char	*title;
	char    *filename = "./test_file";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");


        if (argc > 1)
           if (! (filename = kfullpath(argv[1], NULL, NULL)) )
	       kerror(NULL, "main", filename);

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "example", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	
	/* create the manager backplane object */
	back = xvw_create_manager(NULL, "Text Display");


	/* create the label object */
	title = kstring_cat("Viewing File: ", filename, NULL);
	width = (float) (kstrlen(title)) +1.0;
	label = xvw_create_label(back, "label");
	xvw_set_attributes(label,
		XVW_LABEL,		title,
		XVW_CHAR_WIDTH,		width,	   
		XVW_BELOW,		NULL,
		XVW_RIGHT_OF,		NULL,
		XVW_LEFT_OF,		NULL,
		NULL);

	/* create the quit button */
	quit = xvw_create_button(back, "quit");
	xvw_set_attributes(quit,
		XVW_LABEL,		"Quit",	     /* button label   */
		XVW_LEFT_OF,    	NULL,	     /* upper R corner */
		XVW_BELOW,		NULL,	     /* upper R corner */
		XVW_CHAR_HEIGHT,	1.0,	     /* set height     */
		NULL);


	/* create the textdisplay object; it will display the test file */
	text = xvw_create_textdisplay(back, "test_display");
	xvw_set_attributes(text,
               XVW_CHAR_MIN_WIDTH,       60.0,            /* set width     */
               XVW_CHAR_MIN_HEIGHT,      20.0,            /* set height    */
	       XVW_BELOW,		 quit,
               XVW_TEXTDISPLAY_ROFF,     TRUE,            /* want roff on  */
               XVW_TEXTDISPLAY_FILENAME, filename,        /* set filename  */
               NULL);

	/* add event handler to quit when they hit the quit button */
	xvw_add_callback(quit, XVW_BUTTON_SELECT, quit_cb, NULL);

	/* quit the program if they use the window manager to delete window */
	xvw_add_protocol(back, "WM_DELETE_WINDOW", quit_cb, NULL);

	/* display & run program */
	xvf_run_form();
}

static void quit_cb(
   xvobject object,
   kaddr  client_data,
   kaddr  call_data)
{

	xvw_remove_protocol(back, "WM_DELETE_WINDOW", quit_cb, NULL);
        xvw_unmap(back);
        xvw_destroy(back);

	kexit(KEXIT_SUCCESS);

}
