#include <xvinclude.h>


/*
 *  This example shows how the RowCol object can be used for convenient, 
 *  uniform layout of buttons (or labels) in rows and columns.  When objects
 *  need to be laid out in rows, a rowcol object backplane is also 
 *  significantly faster than a manager object backplane doing relative or 
 *  absolute layout.
 */

#define BUTTON_NUM 25
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	int      i;
	xvobject rowcol;
	xvobject button;
	char  *filename = "$DESIGN/repos/bitmaps/live_pixmaps/lightning.xbm";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidget library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
	 * This GUI has a rowcol backplane rather than a manager backplane.
         *
         * The RowCol object will lay out as many children in the first row
         * as it can fit given it's relative width;  it then continues in
         * a second row, and goes on to N rows until all children are created.
         *
         * By setting resizable to TRUE in conjunction with tacking the
         * edges, the user can resize the RowCol object, which will 
         * automatically re-layout its children according to the new size.
         *
         * If desired, you can explicitly set how may children will appear
         * in a row, by using the XVW_ROWCOL_NUMBER_ACROSS attribute;
         * you can also specify how may pixels divide each child from eht
         * next by using setting XVW_ROWCOL_SPACING to the desired integer.
	 */
	rowcol = xvw_create_rowcol(NULL, "back");
	xvw_set_attributes(rowcol,
		           XVW_MINIMUM_WIDTH,	256,
		           XVW_MINIMUM_HEIGHT,	256,
		           NULL);

	/*
	 * create the 25 buttons, each displaying the lightning bolt; no need 
         * to set any layout attributes, the RowCol object does it all.
	 */
	for (i = 0; i < BUTTON_NUM; i++)
	{
	   button = xvw_create_button(rowcol, "button");
	   xvw_set_attributes(button,
              XVW_PIXMAP_FILENAME, filename,
              XVW_BUTTON_TYPE,     KBUTTON_TYPE_PIXMAP,  
	      NULL);
	}

	/* display & run program */
	xvf_run_form();
}
