#include <xvinclude.h>

/*
 *  This example creates a simple outputfile GUI object, which may
 *  be used for allowing the user to enter a output file.  The user may
 *  enter a value in the text parameter box, or click on the label button,
 *  which will bring up the file browser from which a file may be picked.
 *
 *  A callback is installed on the output file object so that when the 
 *  user changes the value of the output file, the current 
 *  filename is printed to the tty.
 *
 *  Note that the output file object should *not* be created directly in an 
 *  xvroutine, as use of the OutputFile (-O) UIS line in the *.form file is 
 *  both easier to use and a more standard use of the Khoros system.  
 *  However, the outputfile object is provided for use with hybrid xvroutines,
 *  (such as this example) which do not use a "formalized" GUI as defined 
 *  in a *.form file.
 */
static void outputfile_cb PROTO((xvobject, kaddr, kaddr));

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;
	xvobject object;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager to be a parent for the outputfile object */
	manager = xvw_create_manager(NULL, "parent");
	xvw_set_attributes(manager,
			   XVW_WIDTH,       300,
		           XVW_HEIGHT,      100,
			   NULL);

	/*
         *  Create the outputfile object.  give it a label.
         *  tack it horizontally to the parent so that it spans the
         *  width of the manager backplane.  center it in the middle of
         *  the parent.
	 */
	object = xvw_create_outputfile(manager, "outputfile");
	xvw_set_attributes(object,
		XVW_OUTPUTFILE_LABEL,     "Output File",
		XVW_OUTPUTFILE_FILENAME,  "lulu",
		XVW_TACK_EDGE,             KMANAGER_TACK_HORIZ,
		XVW_ABOVE,	           NULL,
		XVW_BELOW,	           NULL,
		NULL);

	xvw_add_callback(object, XVW_OUTPUTFILE_CALLBACK, 
			 outputfile_cb, NULL);

	/* display & run the program */
	xvf_run_form();
}

/*
 *  the callback for the outputfile will be fired when the user changes the
 *  value of the output file & hits <cr>, or when they choose a file using
 *  the browser.  this callback simply prints the current filename.
 */
static void outputfile_cb(
    xvobject object,
    kaddr client_data,
    kaddr call_data)
{
	char *filename;

	xvw_get_attribute(object, XVW_OUTPUTFILE_FILENAME, &filename);
	kfprintf(kstderr, "Filename = %s\n", filename);
}

