#include "xvinclude.h"

void test_action_proc PROTO((xvobject, kaddr));

/* 
 *  our action handler will need 3 parameters: a string and two floats.
 */
typedef struct _textobject_info {
	
    char *text_object_label;
    float  value1;
    float  value2;

} textobject_info;

/*
 *  This program provides an example of the use of action handlers
 *  needing client_data.  It creates a text GUI object, initializes 
 *  a client_data structure, and installs an action handler which will 
 *  use the contents of the client_data structure to print out the
 *  values that were originally set when the user enters <cr>.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject        manager;
	xvobject        textobj;
	textobject_info *text_info;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create manager to serve as backplane */
	manager = xvw_create_manager(NULL, "back");

	
	/* create a text gui object */
	textobj = xvw_create_text(manager, "text");
	xvw_set_attributes(textobj, 
			  XVW_TEXT_TYPE,    KTEXT_TYPE_STRING,
                          XVW_TEXT_STRING,  "Enter Text Here <cr>", 
			  XVW_CHAR_MIN_WIDTH,   25.0,
			  XVW_CHAR_MIN_HEIGHT,  1.5,
			  XVW_TACK_EDGE,    KMANAGER_TACK_HORIZ,
                          NULL);

	/* allocate the client_data structure */
	text_info = (textobject_info *) kcalloc(1, sizeof(textobject_info));

	/* initialize the client_data structure */
	text_info->value1  = 25.3;
	text_info->value2  = 47.123;
	text_info->text_object_label = kstring_copy("text", NULL);
 
	/* 
	 * install "test_action_proc" action handler on <cr>. 
	 * pass the text_info structure as client_data 
         */
	xvw_add_action(textobj, "<Key>Return", test_action_proc, 
		       text_info, TRUE);

	/* display and run */
	xvf_run_form();
}

/*
 *  the action procedure simply prints out the 
 *  contents of the structure that was passed as client data 
 */
void test_action_proc(
   xvobject   object,
   kaddr      client_data)
{
	char *string;

	textobject_info *text_info = (textobject_info *) client_data;

	fprintf(stderr, "<cr> entered in %s\n", text_info->text_object_label); 
	fprintf(stderr, "     value1  = %f\n", text_info->value1);
	fprintf(stderr, "     value2 = %f\n",  text_info->value2);

	xvw_get_attribute(object, XVW_TEXT_STRING, &string);
	fprintf(stderr, "     string = '%s'\n", string);
}
