#include "dataserv.h"
#define TESTNAME "test.xv"

/* -- boring dilbert segment handlers -- */
static int _dull_create_func(
   kobject  obj,
   char    *segment)
{
   kprintf("\t%s says \"multidimensional segments are underated...\" \n", 
	   segment);
   return TRUE;
}

static int _dull_query_func(
   kobject  obj,
   char    *segment)
{
   kprintf("\t%s says \"why would anyone want a 1D segment anyway?\"\n", 
	   segment);
   return TRUE;
}

static int _dull_destroy_func(
   kobject  obj,
   char    *segment)
{
   kprintf("\t%s says \"never mind that you can only get data as 1D...\"\n",
	   segment);
   return TRUE;
}


/* -- exciting dogbert segment handlers -- */

static int _create_func(
   kobject  obj,
   char    *segment)
{
   int order[1] = {KWIDTH};
   int size[1] = {5};

   kprintf("\tCREATING the %s segment... \n", segment);

   kdms_create_segment(obj, segment);
   kdms_set_attribute(obj, segment, KDMS_DIMENSION, 1);
   kdms_set_attribute(obj, segment, KDMS_INDEX_ORDER, order);
   kdms_set_attribute(obj, segment, KDMS_SIZE, size);

   return TRUE;
}

static int _query_func(
   kobject  obj,
   char    *segment)
{
   if (kdms_query_segment(obj, segment))
   {
      kprintf("\tQUERYING : the %s segment exists... \n", segment);
      return TRUE;
   }
   else
      return FALSE;
}

static int _destroy_func(
   kobject  obj,
   char    *segment)
{
   kprintf("\tDESTROYING : i'm afraid i can't allow that "
	   "segment to be destroyed... \n");
   return TRUE;
}

main()
{
   kobject o;
   int i, status;
   int at;

   o = kdms_output(TESTNAME);

#define DOGBERT_SEGMENT "dogbert"
#define DILBERT_SEGMENT "dilbert"

   /* -- define boring segment to test multiple definitions -- */
   if (!kdms_define_segment(DILBERT_SEGMENT,
 			    _dull_create_func, _dull_destroy_func, 
			    _dull_query_func, NULL, NULL,
			    NULL, NULL, NULL, NULL, NULL, NULL))
   {
      kprintf("\tERROR : unable to define %s segment\n", DILBERT_SEGMENT);
      kexit(1);
   }

   /* -- define interesting segment -- */
   if (!kdms_define_segment(DOGBERT_SEGMENT,
 			    _create_func, _destroy_func, _query_func, 
			    NULL, NULL,
			    NULL, NULL, NULL, NULL, NULL, NULL))
   {
      kprintf("\tERROR : unable to define %s segment\n", DOGBERT_SEGMENT);
      kexit(1);
   }


/*
 * Phase 1 is the interesting segment definition testing
 */


	kprintf("Phase 1...\n");


   kdms_create_segment(o, DOGBERT_SEGMENT);

   if (!kdms_query_segment(o, DOGBERT_SEGMENT))
   {
      kprintf("\tERROR : unable to query %s segment\n", DOGBERT_SEGMENT);
      kexit(1);
   }

   if (!kdms_destroy_segment(o, DOGBERT_SEGMENT))
   {
      kprintf("\tERROR : unable to query %s segment\n", DOGBERT_SEGMENT);
      kexit(1);
   }

   if (!kdms_undefine_segment(DOGBERT_SEGMENT))
   {
      kprintf("\tERROR : unable to undefine %s segment\n", DOGBERT_SEGMENT);
      kexit(1);
   }

   kprintf("\n\t%s segment is now undefined...\n", DOGBERT_SEGMENT);

   if (kdms_query_segment(o, DOGBERT_SEGMENT))
      kprintf("\tnormal query confirms existence of %s segment\n", 
	      DOGBERT_SEGMENT);
   else
   {
      kprintf("\tERROR : unable to query %s segment\n", DOGBERT_SEGMENT);
      kexit(1);
   }

   if (kdms_destroy_segment(o, DOGBERT_SEGMENT))
      kprintf("\tnormal destroy has obliterated %s segment\n",DOGBERT_SEGMENT);
   else
   {
      kprintf("\tERROR : unable to destroy %s segment\n", DOGBERT_SEGMENT);
      kexit(1);
   }

   if (!kdms_query_segment(o, DOGBERT_SEGMENT))
      kprintf("\tnormal query confirms non-existence of %s segment\n", 
	      DOGBERT_SEGMENT);
   else
   {
      kprintf("\tEgads! %s segment still exists!\n", DOGBERT_SEGMENT);
      kexit(1);
   }

/*
 * Phase 2 is the boring segment definition testing and verifies that
 * the previous interesting undefine did not damage this boring definition
 */

	kprintf("\nPhase 2...\n");

   /* -- verify that the boring segment is still hangin around -- */

   if (!kdms_create_segment(o, DILBERT_SEGMENT))
   {
      kprintf("\tERROR : unable to create %s segment\n", DILBERT_SEGMENT);
      kexit(1);
   }

   if (!kdms_query_segment(o, DILBERT_SEGMENT))
   {
      kprintf("\tERROR : unable to query %s segment\n", DILBERT_SEGMENT);
      kexit(1);
   }

   if (!kdms_destroy_segment(o, DILBERT_SEGMENT))
   {
      kprintf("\tERROR : unable to destroy %s segment\n", DILBERT_SEGMENT);
      kexit(1);
   }

   if (!kdms_undefine_segment(DILBERT_SEGMENT))
   {
      kprintf("\tERROR : unable to undefine %s segment\n", DILBERT_SEGMENT);
      kexit(1);
   }

   kprintf("\n\tMrf!, Erk!, Grmf! ... \n"
	   "\twe're safe now, the %s segment has been undefined\n", 
	   DILBERT_SEGMENT);

   kdms_close(o);
   kexit(0);
}
