#include "dataserv.h"

#define FAIL(error)               \
        {                         \
          kinfo(KFORCE,error);    \
          kexit(KEXIT_FAILURE);   \
        }

main()
{
   kobject i;
   int     size[1] = {1};
   int     ord[1]  = {KWIDTH};
   int     beg[1]  = {0};
   int     end[1]  = {2};
   int    *data;

   if ((i = kdms_input("$DATASERV/data/testdata/100x100.ubyte.xvimage")) == NULL)
      FAIL("can not open the data set");

   if (!kdms_create_segment(i, "fred"))
      FAIL("can not create segment");

   if (!kdms_set_attributes(i, "fred",
		            KDMS_DIMENSION, 1,
		            KDMS_DATA_TYPE, KINT,
		            KDMS_INDEX_ORDER, ord, 
		            KDMS_SIZE, size, 
		            NULL))
      FAIL("can not set initial size, data type, or dimension.");

   /* do a small resize */
   size[0] = 3;
   if (!kdms_set_attribute(i, "fred", KDMS_SIZE, size, NULL))
      FAIL("can not set resize.");

   /* get some data */
   data = kdms_get_data(i, "fred", beg, end, NULL);

   if (data != NULL)
      kprintf("\tdata is %d %d %d\n", data[0], data[1], data[2]);
   else
      FAIL("\tERROR could not retreive data\n");
} 
