#include <dataserv.h>
#define TESTNAME "test.xv"
#define TESTCOPYNAME "copy.xv"
#define TESTFORMAT "viff"
#define TESTSIZE0 16
#define TESTSIZE1 16
#define TESTSIZE2 1
#define TESTSIZE3 1
#define TESTSIZE4 1
#define TESTINDEX_ORDER0 KWIDTH
#define TESTINDEX_ORDER1 KHEIGHT
#define TESTINDEX_ORDER2 KDEPTH
#define TESTINDEX_ORDER3 KTIME
#define TESTINDEX_ORDER4 KELEMENTS
#define TESTCOMPLEX_CONVERT KREAL

main()
{
	kobject i,o,c, tmpobj;
	int idummy, architecture, *size, *index_order, complex_convert;
	char *name, *format;

	signed char bdata1, bdata2, *abdata1, *abdata2;
	unsigned char ubdata1, ubdata2, *aubdata1, *aubdata2;
	short sdata1, sdata2, *asdata1, *asdata2;
	unsigned short usdata1, usdata2, *ausdata1, *ausdata2;
	int idata1, idata2, *aidata1, *aidata2;
	unsigned int uidata1, uidata2, *auidata1, *auidata2;
	long ldata1, ldata2, *aldata1, *aldata2;
	unsigned long uldata1, uldata2, *auldata1, *auldata2;
	float fdata1, fdata2, *afdata1, *afdata2;
	double ddata1, ddata2, *addata1, *addata2;
	kcomplex kcdata1, kcdata2, *akcdata1, *akcdata2;
	kdcomplex kdcdata1, kdcdata2, *akdcdata1, *akdcdata2;
	kstring stdata1, stdata2, *astdata1, *astdata2;

	int narg, asiz, dtyp, perm;
	kfile *outfile = kstdout;

	if ((i = kdms_input("input.sun4.viff")) == NULL) {
	   kprintf("Cannot read the sun4 test viff.\n");	   
	   kexit(1);
	}
	
	if ((o = kdms_output(TESTNAME)) == NULL)
	   kexit(1);

	if ((c = kdms_output(TESTCOPYNAME)) == NULL)
	   kexit(1);

       kdms_copy_segment_attributes(i,NULL,o,NULL);
       kdms_copy_segment_attributes(i,KDMS_SEGMENT_VALUE,o,KDMS_SEGMENT_VALUE);

	/* make sure the value segment exists! */
	if(!kdms_query_segment(o,KDMS_SEGMENT_VALUE)) {
	   kprintf("\tvalue segment does not exist!\n");
	   kexit(1);
	}
/*
 * Phase 1 is basic API testing
 */

	kprintf("Phase 1...\n");

/*
 * test the case where no attribute exists.  note that a non-existent
 * object takes not arguments, so so i shouldn't have to twiddle with
 * dummy arguments. 
 */

	if(kdms_get_attribute(o,NULL,"non-existent"))
	   kprintf("\tnon existent object attribute exists!\n");
	else
	   kprintf("\tnon existent object attribute OK\n");

	if(kdms_get_attribute(o,KDMS_SEGMENT_VALUE,"non-existent"))
	   kprintf("\tnon existent segment attribute exists!\n");
	else
	   kprintf("\tnon existent segment attribute OK\n");

/*
 * test deletion of non-existent object
 */

	if (!kdms_destroy_attribute(o,NULL,"non-existent"))
	   kprintf("\tdestroy of non existent object attribute OK\n");
	else
	   kprintf("\tdestroy of non existent object attribute wrong\n");

	if (!kdms_destroy_attribute(o,KDMS_SEGMENT_VALUE,"non-existent"))
	   kprintf("\tdestroy of non existent segment attribute OK\n");
	else
	   kprintf("\tdestroy of non existent segment attribute wrong\n");

/*
 * create an attribute and check that it exists.
 */

	kdms_create_attribute(o,NULL,"existent",1,1,KINT,TRUE,TRUE);
	kdms_set_attribute(o,NULL,"existent",14);
	if(kdms_get_attribute(o,NULL,"existent",&idummy) && idummy == 14)
	  kprintf("\texistent object attribute OK\n");
        else
          kprintf("\texistent object attribute doesn't exist\n");

	kdms_create_attribute(o,KDMS_SEGMENT_VALUE,"existent",1,1,KINT,
			TRUE, TRUE);
	kdms_set_attribute(o,KDMS_SEGMENT_VALUE,"existent",15);
	if(kdms_get_attribute(o,KDMS_SEGMENT_VALUE,"existent",&idummy) 
		&& idummy == 15)
	  kprintf("\texistent segment attribute OK\n");
        else
          kprintf("\texistent segment attribute doesn't exist\n");

/*
 * create an attribute and get it before setting it.
 */

	kdms_create_attribute(o,NULL,"existent2",1,1,KINT,TRUE,TRUE);
	if(kdms_get_attribute(o,NULL,"existent2",&idummy))
	  kprintf("\texistent unset object attribute = %d\n",idummy);
        else
          kprintf("\tget of unset existent object attribute OK.\n");

	kdms_create_attribute(o,KDMS_SEGMENT_VALUE,"existent2",1,1,KINT,
			TRUE, TRUE);
	if(kdms_get_attribute(o,KDMS_SEGMENT_VALUE,"existent2",&idummy))
	  kprintf("\texistent unset segment attribute = %d\n",idummy);
        else
          kprintf("\tget of unset existent segment attribute OK.\n");

/*
 * try to destroy an existent attribute
 */

	if(!kdms_destroy_attribute(o,NULL,"existent"))
	  kprintf("\tunable to destroy existent deletable object attribute.\n");
	if(kdms_get_attribute(o,NULL,"existent",&idummy))
	  kprintf("\tdestroyed object attribute still exists\n");
        else
          kprintf("\tdestroyed object attribute OK\n");

	if(!kdms_destroy_attribute(o,KDMS_SEGMENT_VALUE,"existent"))
	  kprintf("\tunable to destroy existent deletable segment attribute.\n");
	if(kdms_get_attribute(o,KDMS_SEGMENT_VALUE,"existent",&idummy))
	  kprintf("\tdestroyed segment attribute still exists\n");
        else
          kprintf("\tdestroyed segment attribute OK\n");

/*
 * try to destroy a non-deletable attribute
 */

	if(!kdms_destroy_attribute(o,NULL,KDMS_ARCHITECTURE))
	  kprintf("\tdestroy of non-deletable object attribute OK.\n");
	else
	  kprintf("\tdestroy of non-deletable object attribute wrong.\n");

	if(!kdms_destroy_attribute(o,KDMS_SEGMENT_VALUE,KDMS_SIZE))
	  kprintf("\tdestroy of non-deletable segment attribute OK.\n");
	else
	  kprintf("\tdestroy of non-deletable segment attribute wrong.\n");

/*** missing kdms_define_..., plural forms, copy attributes, etc. ***/

/*
 * Phase 2...verifying all "builtin" attributes
 */

	kprintf("\nPhase 2...\n");

	/*
	 * the name attribute
	 */
	if(!kdms_get_attribute(o,NULL,KDMS_NAME,&name))
	  kprintf("\tunable to get name attribute.\n");
	if(!kstrcmp(name,TESTNAME))
	    kprintf("\tname attribute retrieval OK\n");
	else
	    kprintf("\tname attribute not correct.\n");
	
	if(!kdms_match_attribute(i,o,NULL,KDMS_NAME))
	    kprintf("\tdifferent names match OK.\n");
	else
	    kprintf("\tdifferent names match wrong.\n");

        tmpobj = kdms_reference(i);
	if(kdms_match_attribute(i,tmpobj,NULL,KDMS_NAME))
	    kprintf("\tsame names match OK.\n");
	else
	    kprintf("\tsame names match wrong.\n");
	kprintf("\n");

	/*
	 * the format attribute
	 */
	if(!kdms_get_attribute(o,NULL,KDMS_FORMAT,&format))
	  kprintf("\tunable to get format attribute.\n");
	if(!kstrcmp(format,TESTFORMAT))
	    kprintf("\tformat attribute retrieval OK\n");
	else
	    kprintf("\tformat attribute not correct.\n");
	
	tmpobj = kdms_input("input.sun4.xvimage");
	if(!kdms_match_attribute(i,tmpobj,NULL,KDMS_FORMAT))
	    kprintf("\tdifferent formats match OK.\n");
	else
	    kprintf("\tdifferent formats match wrong.\n");
	kdms_close(tmpobj);

        tmpobj = kdms_reference(i);
	if(kdms_match_attribute(i,tmpobj,NULL,KDMS_FORMAT))
	    kprintf("\tsame formats match OK.\n");
	else
	    kprintf("\tsame formats match wrong.\n");
	kprintf("\n");

	/*
	 * the architecture attribute
	 */
	if(!kdms_get_attribute(o,NULL,KDMS_ARCHITECTURE,&architecture))
	  kprintf("\tunable to get architecture attribute.\n");
	if(architecture == kmach_type(NULL))
	    kprintf("\tarchitecture attribute retrieval OK\n");
	else
	    kprintf("\tarchitecture attribute not correct. %d\n", architecture);
	if ((tmpobj = kdms_input("input.alpha.viff")) == NULL) {
	   kprintf("Cannot read the alpha test viff.\n");	   
	   kexit(1);
	}
	if(!kdms_match_attribute(i,tmpobj,NULL,KDMS_ARCHITECTURE))
	    kprintf("\tdifferent architectures match OK.\n");
	else
	    kprintf("\tdifferent architectures match wrong.\n");
	kdms_close(tmpobj);

        tmpobj = kdms_reference(i);
	if(kdms_match_attribute(i,tmpobj,NULL,KDMS_ARCHITECTURE))
	    kprintf("\tsame architectures match OK.\n");
	else
	    kprintf("\tsame architectures match wrong.\n");
	kprintf("\n");

	/*
	 * the size attribute
	 */
	if(!kdms_get_attribute(o,KDMS_SEGMENT_VALUE,KDMS_SIZE,&size))
	  kprintf("\tunable to get size attribute.\n");
	if(size[0] == TESTSIZE0 && size[1] == TESTSIZE1 && 
	   size[2] == TESTSIZE2 && size[3] == TESTSIZE3 && 
	   size[4] == TESTSIZE4)
	    kprintf("\tsize attribute retrieval OK\n");
	else
	    kprintf("\tsize attribute not correct. %d\n", size);
	tmpobj = kdms_input("input.sun4.xvimage");
	if(!kdms_match_attribute(i,tmpobj,KDMS_SEGMENT_VALUE,KDMS_SIZE))
	    kprintf("\tdifferent sizes match OK.\n");
	else
	    kprintf("\tdifferent sizes match wrong.\n");
	kdms_close(tmpobj);

        tmpobj = kdms_reference(i);
	if(kdms_match_attribute(i,tmpobj,KDMS_SEGMENT_VALUE,KDMS_SIZE))
	    kprintf("\tsame sizes match OK.\n");
	else
	    kprintf("\tsame sizes match wrong.\n");
	kprintf("\n");

	/*
	 * the index_order attribute
	 */
	if(!kdms_get_attribute(o,KDMS_SEGMENT_VALUE,KDMS_INDEX_ORDER,
			      &index_order))
	  kprintf("\tunable to get index_order attribute.\n");
	if(index_order[0] == TESTINDEX_ORDER0 && 
	   index_order[1] == TESTINDEX_ORDER1 && 
	   index_order[2] == TESTINDEX_ORDER2 && 
	   index_order[3] == TESTINDEX_ORDER3 && 
	   index_order[4] == TESTINDEX_ORDER4)
	    kprintf("\tindex_order attribute retrieval OK\n");
	else
	    kprintf("\tindex_order attribute not correct. %d\n", index_order);
	tmpobj = kdms_input("input.sun4.xvimage");
	if(kdms_match_attribute(i,tmpobj,KDMS_SEGMENT_VALUE,KDMS_INDEX_ORDER))
	    kprintf("\tdifferent index_orders match OK.\n");
	else
	    kprintf("\tdifferent index_orders match wrong.\n");
	kdms_close(tmpobj);

        tmpobj = kdms_reference(i);
	if(kdms_match_attribute(i,tmpobj,KDMS_SEGMENT_VALUE,KDMS_INDEX_ORDER))
	    kprintf("\tsame index_orders match OK.\n");
	else
	    kprintf("\tsame index_orders match wrong.\n");
	kprintf("\n");

	/*
	 * the complex_convert attribute
	 */
	if(!kdms_get_attribute(o,KDMS_SEGMENT_VALUE,KDMS_COMPLEX_CONVERT,
			      &complex_convert))
	  kprintf("\tunable to get complex_convert attribute.\n");
	if(complex_convert == TESTCOMPLEX_CONVERT)
	    kprintf("\tcomplex_convert attribute retrieval OK\n");
	else
	    kprintf("\tcomplex_convert attribute not correct. %d\n", complex_convert);
	if ((tmpobj = kdms_input("input.sgi.viff")) == NULL) {
	   kprintf("Cannot read the sgi test viff.\n");	   
	   kexit(1);
	}

	kdms_set_attribute(tmpobj,KDMS_SEGMENT_VALUE,
				  KDMS_COMPLEX_CONVERT,KPHASE);	
	if(!kdms_match_attribute(i,tmpobj, KDMS_SEGMENT_VALUE,
				KDMS_COMPLEX_CONVERT))
	    kprintf("\tdifferent complex_converts match OK.\n");
	else
	    kprintf("\tdifferent complex_converts match wrong.\n");
	kdms_close(tmpobj);

        tmpobj = kdms_reference(i);
	if(kdms_match_attribute(i,tmpobj,KDMS_SEGMENT_VALUE,KDMS_COMPLEX_CONVERT))
	    kprintf("\tsame complex_converts match OK.\n");
	else
	    kprintf("\tsame complex_converts match wrong.\n");
	kprintf("\n");


/*
 * Phase 3...successfully getting, copying, matching, and querying of
 * 	     all data types and configurations of data.
 */

	kprintf("\nPhase 3...");
/*
 * testing byte data.
 */
	kprintf("\n");

#define BYTE11 "byte 1 1"

        kprintf("   KBYTE...\n");
	if(!kdms_create_attribute(o,NULL,BYTE11,1,1,KBYTE,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n", BYTE11);
	if(!kdms_set_attribute(o,NULL,BYTE11,(char)-65))
          kprintf("\tunable to set %s attribute\n",BYTE11);
        if(!kdms_copy_attribute(o,c,NULL,BYTE11))
          kprintf("\tunable to copy %s attribute\n",BYTE11);
        if(!kdms_match_attribute(o,c,NULL,BYTE11))
          kprintf("\tunable to match %s attribute\n",BYTE11);
        if (!kdms_query_attribute(c,NULL,BYTE11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", BYTE11);
	if(!kdms_get_attribute(c,NULL,BYTE11,&bdata1) || bdata1 != -65)
          kprintf("\tunable to get %s attribute\n",BYTE11);
        else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,BYTE11,outfile))
	    kprintf("\n\tunable to print %s attribute\n",BYTE11);
          else
	    kprintf("\n");
	}

#define BYTE21 "byte 2 1"

	if(!kdms_create_attribute(o,NULL,BYTE21,2,1,KBYTE,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n", BYTE21);
	if(!kdms_set_attribute(o,NULL,BYTE21,(char)-65,(char)-66))
          kprintf("\tunable to set %s attribute\n",BYTE21);
        if(!kdms_copy_attribute(o,c,NULL,BYTE21))
          kprintf("\tunable to copy %s attribute\n",BYTE21);
        if(!kdms_match_attribute(o,c,NULL,BYTE21))
          kprintf("\tunable to match %s attribute\n",BYTE21);
        if (!kdms_query_attribute(c,NULL,BYTE21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", BYTE21);
	if(!kdms_get_attribute(c,NULL,BYTE21,&bdata1,&bdata2) || 
	   bdata1 != -65 || bdata2 != -66)
          kprintf("\tunable to get %s attribute\n",BYTE21);
        else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,BYTE21,outfile))
	    kprintf("\n\tunable to print %s attribute\n",BYTE21);
          else
	    kprintf("\n");
	}

#define BYTE12 "byte 1 2"

	abdata1 = (signed char *)kmalloc(2 * sizeof(signed char));
	abdata1[0] = -65; abdata1[1] = -66;
	if(!kdms_create_attribute(o,NULL,BYTE12,1,2,KBYTE,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n", BYTE12);
	if(!kdms_set_attribute(o,NULL,BYTE12,abdata1))
          kprintf("\tunable to set %s attribute\n", BYTE12);
	kfree(abdata1);
        if(!kdms_copy_attribute(o,c,NULL,BYTE12))
          kprintf("\tunable to copy %s attribute\n", BYTE12);
        if(!kdms_match_attribute(o,c,NULL,"byte 1 2"))
          kprintf("\tunable to match %s attribute\n", BYTE12);
        if (!kdms_query_attribute(c,NULL,BYTE12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", BYTE11);
	if(!kdms_get_attribute(c,NULL,BYTE12,&abdata1) || 
	   abdata1[0] != -65 || abdata1[1] != -66)
          kprintf("\tunable to get BYTE12 attribute\n", BYTE12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,BYTE12,outfile))
	    kprintf("\n\tunable to print %s attribute\n", BYTE12);
          else
     	    kprintf("\n");
	}

#define BYTE22 "byte 2 2"

	abdata1 = (signed char *)kmalloc(2 * sizeof(signed char));
	abdata1[0] = -65; abdata1[1] = -66;
	abdata2 = (signed char *)kmalloc(2 * sizeof(signed char));
	abdata2[0] = -67; abdata2[1] = -68;
	if(!kdms_create_attribute(o,NULL,BYTE22,2,2,KBYTE,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n", BYTE22);
	if(!kdms_set_attribute(o,NULL,BYTE22,abdata1,abdata2))
          kprintf("\tunable to set BYTE22 attribute\n", BYTE22);
	kfree(abdata1);
	kfree(abdata2);
        if(!kdms_copy_attribute(o,c,NULL,BYTE22))
          kprintf("\tunable to copy %s attribute\n", BYTE22);
        if(!kdms_match_attribute(o,c,NULL,BYTE22))
          kprintf("\tunable to match %s attribute\n", BYTE22);
        if (!kdms_query_attribute(c,NULL,BYTE22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", BYTE11);
	if(!kdms_get_attribute(c,NULL,BYTE22,&abdata1,&abdata2) || 
	   abdata1[0] != -65 || abdata1[1] != -66 ||
	   abdata2[0] != -67 || abdata2[1] != -68)
          kprintf("\tunable to get %s attribute\n", BYTE22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,BYTE22,outfile))
	    kprintf("\tunable to print %s attribute\n", BYTE22);
          else
	    kprintf("\n");
	}
	kprintf("\n");	
/*
 * testing unsigned byte data.
 */

#define UBYTE11 "unsigned byte 1 1"

        kprintf("   KUBYTE... \n");
	if(!kdms_create_attribute(o,NULL,UBYTE11,1,1,KUBYTE,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n", UBYTE11);
	if(!kdms_set_attribute(o,NULL,UBYTE11,(unsigned char)65))
          kprintf("\tunable to set %s attribute\n", UBYTE11);
        if(!kdms_copy_attribute(o,c,NULL,UBYTE11))
          kprintf("\tunable to copy %s attribute\n", UBYTE11);
        if(!kdms_match_attribute(o,c,NULL,UBYTE11))
          kprintf("\tunable to match %s attribute\n",UBYTE11);
        if (!kdms_query_attribute(c,NULL,UBYTE11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KUBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", UBYTE11);
	if(!kdms_get_attribute(c,NULL,UBYTE11,&ubdata1) || ubdata1 != 65)
          kprintf("\tunable to get %s attribute\n", UBYTE11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UBYTE11,outfile))
	    kprintf("\tunable to print %s attribute\n", UBYTE11);
          else
	     kprintf("\n");
	}

#define UBYTE21 "unsigned byte 2 1"

	if(!kdms_create_attribute(o,NULL,UBYTE21,2,1,KUBYTE,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n", UBYTE21);
	if(!kdms_set_attribute(o,NULL,UBYTE21,
			      (unsigned char)65,(unsigned char)66))
          kprintf("\tunable to set %s attribute\n", UBYTE21);
        if(!kdms_copy_attribute(o,c,NULL,UBYTE21))
          kprintf("\tunable to copy %s attribute\n", UBYTE21);
        if(!kdms_match_attribute(o,c,NULL,UBYTE21))
          kprintf("\tunable to match %s attribute\n",UBYTE21);
        if (!kdms_query_attribute(c,NULL,UBYTE21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KUBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", UBYTE21);
	if(!kdms_get_attribute(c,NULL,UBYTE21,&ubdata1,&ubdata2) || 
	   ubdata1 != 65 || ubdata2 != 66)
          kprintf("\tunable to get %s attribute\n", UBYTE21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UBYTE21,outfile))
	    kprintf("\tunable to print %s attribute\n", UBYTE21);
          else
	     kprintf("\n");
	}

#define UBYTE12 "unsigned byte 1 2"

	aubdata1 = (unsigned char *)kmalloc(2 * sizeof(unsigned char));
	aubdata1[0] = 65; aubdata1[1] = 66;
	if(!kdms_create_attribute(o,NULL,UBYTE12,1,2,KUBYTE,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n", UBYTE12);
	if(!kdms_set_attribute(o,NULL,UBYTE12,aubdata1))
          kprintf("\tunable to set %s attribute\n", UBYTE12);
	kfree(aubdata1);
        if(!kdms_copy_attribute(o,c,NULL,UBYTE12))
          kprintf("\tunable to copy %s attribute\n", UBYTE12);
        if(!kdms_match_attribute(o,c,NULL,UBYTE12))
          kprintf("\tunable to match %s attribute\n",UBYTE12);
        if (!kdms_query_attribute(c,NULL,UBYTE12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KUBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", BYTE11);
	if(!kdms_get_attribute(c,NULL,UBYTE12,&aubdata1) || 
	   aubdata1[0] != 65 || aubdata1[1] != 66)
          kprintf("\tunable to get %s attribute\n",UBYTE12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UBYTE12,outfile))
	    kprintf("\tunable to print %s attribute\n", UBYTE12);
          else
	     kprintf("\n");
	}

#define UBYTE22 "unsigned byte 2 2"

	aubdata1 = (unsigned char *)kmalloc(2 * sizeof(unsigned char));
	aubdata1[0] = 65; aubdata1[1] = 66;
	aubdata2 = (unsigned char *)kmalloc(2 * sizeof(unsigned char));
	aubdata2[0] = 67; aubdata2[1] = 68;
	if(!kdms_create_attribute(o,NULL,UBYTE22,2,2,KUBYTE,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n", UBYTE22);
	if(!kdms_set_attribute(o,NULL,UBYTE22,aubdata1,aubdata2))
          kprintf("\tunable to set %s attribute\n", UBYTE22);
	kfree(aubdata1);
	kfree(aubdata2);
        if(!kdms_copy_attribute(o,c,NULL,UBYTE22))
          kprintf("\tunable to copy %s attribute\n", UBYTE22);
        if(!kdms_match_attribute(o,c,NULL,UBYTE12))
          kprintf("\tunable to match %s attribute\n",UBYTE22);
        if (!kdms_query_attribute(c,NULL,UBYTE22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KUBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", UBYTE21);
	if(!kdms_get_attribute(c,NULL,UBYTE22,&aubdata1,&aubdata2) || 
	   aubdata1[0] != 65 || aubdata1[1] != 66 ||
	   aubdata2[0] != 67 || aubdata2[1] != 68)
          kprintf("\tunable to get %s attribute\n", UBYTE22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UBYTE22,outfile))
	    kprintf("\tunable to print %s attribute\n", UBYTE22);
          else
	     kprintf("\n");
	}
	kprintf("\n");

/*
 * testing short data.
 */

#define SHORT11 "short 1 1"

        kprintf("   KSHORT... \n");
	if(!kdms_create_attribute(o,NULL,SHORT11,1,1,KSHORT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n", SHORT11);
	if(!kdms_set_attribute(o,NULL,SHORT11,(short)-65))
          kprintf("\tunable to set %s attribute\n", SHORT11);
        if(!kdms_copy_attribute(o,c,NULL,SHORT11))
          kprintf("\tunable to copy %s attribute\n", SHORT11);
        if(!kdms_match_attribute(o,c,NULL,SHORT11))
          kprintf("\tunable to match %s attribute\n",SHORT11);
        if (!kdms_query_attribute(c,NULL,SHORT11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", SHORT11);
	if(!kdms_get_attribute(c,NULL,SHORT11,&sdata1) || sdata1 != -65)
          kprintf("\tunable to get SHORT11 attribute\n");
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,SHORT11,outfile))
	    kprintf("\tunable to print %s attribute\n", SHORT11);
          else
	     kprintf("\n");
	}

#define SHORT21 "short 2 1"

	if(!kdms_create_attribute(o,NULL,SHORT21,2,1,KSHORT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n", SHORT21);
	if(!kdms_set_attribute(o,NULL,SHORT21,(short)-65,(short)-66))
          kprintf("\tunable to set %s attribute\n", SHORT21);
        if(!kdms_copy_attribute(o,c,NULL,SHORT21))
          kprintf("\tunable to copy %s attribute\n", SHORT21);
        if(!kdms_match_attribute(o,c,NULL,SHORT21))
          kprintf("\tunable to match %s attribute\n",SHORT21);
        if (!kdms_query_attribute(c,NULL,SHORT21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", SHORT21);
	if(!kdms_get_attribute(c,NULL,SHORT21,&sdata1,&sdata2) || 
	   sdata1 != -65 || sdata2 != -66)
          kprintf("\tunable to get %s attribute\n", SHORT21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,SHORT21,outfile))
	    kprintf("\tunable to print %s attribute\n", SHORT21);
          else
	     kprintf("\n");
	}

#define SHORT12 "short 1 2"

	asdata1 = (short *)kmalloc(2 * sizeof(short));
	asdata1[0] = -65; asdata1[1] = -66;
	if(!kdms_create_attribute(o,NULL,SHORT12,1,2,KSHORT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n", SHORT12);
	if(!kdms_set_attribute(o,NULL,SHORT12,asdata1))
          kprintf("\tunable to set %s attribute\n", SHORT12);
	kfree(asdata1);
        if(!kdms_copy_attribute(o,c,NULL,SHORT12))
          kprintf("\tunable to copy %s attribute\n", SHORT12);
        if(!kdms_match_attribute(o,c,NULL,SHORT12))
          kprintf("\tunable to match %s attribute\n",SHORT12);
        if (!kdms_query_attribute(c,NULL,SHORT12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", SHORT12);
	if(!kdms_get_attribute(c,NULL,SHORT12,&asdata1) || 
	   asdata1[0] != -65 || asdata1[1] != -66)
          kprintf("\tunable to get %s attribute\n", SHORT12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,SHORT12,outfile))
	    kprintf("\tunable to print %s attribute\n",SHORT12);
          else
	     kprintf("\n");
	}

#define SHORT22 "short 2 2"

	asdata1 = (short *)kmalloc(2 * sizeof(short));
	asdata1[0] = -65; asdata1[1] = -66;
	asdata2 = (short *)kmalloc(2 * sizeof(short));
	asdata2[0] = -67; asdata2[1] = -68;
	if(!kdms_create_attribute(o,NULL,SHORT22,2,2,KSHORT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n", SHORT22);
	if(!kdms_set_attribute(o,NULL,SHORT22,asdata1,asdata2))
          kprintf("\tunable to set %s attribute\n", SHORT22);
	kfree(asdata1);
	kfree(asdata2);
        if(!kdms_copy_attribute(o,c,NULL,SHORT22))
          kprintf("\tunable to copy %s attribute\n", SHORT22);
        if(!kdms_match_attribute(o,c,NULL,SHORT22))
          kprintf("\tunable to match %s attribute\n",SHORT22);
        if (!kdms_query_attribute(c,NULL,SHORT22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", SHORT22);
	if(!kdms_get_attribute(c,NULL,SHORT22,&asdata1,&asdata2) || 
	   asdata1[0] != -65 || asdata1[1] != -66 ||
	   asdata2[0] != -67 || asdata2[1] != -68)
          kprintf("\tunable to get %s attribute\n", SHORT22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,SHORT22,outfile))
	    kprintf("\tunable to print %s attribute\n", SHORT22);
          else
	     kprintf("\n");
	}
	kprintf("\n");
	
/*
 * testing unsigned short data.
 */

#define USHORT11 "unsigned short 1 1"

        kprintf("   KUSHORT... \n");
	if(!kdms_create_attribute(o,NULL,USHORT11,1,1,KUSHORT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n", USHORT11);
	if(!kdms_set_attribute(o,NULL,USHORT11,(unsigned short)65))
          kprintf("\tunable to set %s attribute\n", USHORT11);
        if(!kdms_copy_attribute(o,c,NULL,USHORT11))
          kprintf("\tunable to copy %s attribute\n", USHORT11);
        if(!kdms_match_attribute(o,c,NULL,USHORT11))
          kprintf("\tunable to match %s attribute\n",USHORT11);
        if (!kdms_query_attribute(c,NULL,USHORT11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KUSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", USHORT11);
	if(!kdms_get_attribute(c,NULL,USHORT11,&usdata1) || usdata1 != 65)
          kprintf("\tunable to get %s attribute\n", USHORT11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,USHORT11,outfile))
	    kprintf("\tunable to print %s attribute\n", USHORT11);
          else
	     kprintf("\n");
	}

#define USHORT21 "unsigned short 2 1"

	if(!kdms_create_attribute(o,NULL,USHORT21,2,1,KUSHORT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n", USHORT21);
	if(!kdms_set_attribute(o,NULL,USHORT21,(unsigned short)65,
					       (unsigned short)66))
          kprintf("\tunable to set %s attribute\n", USHORT21);
        if(!kdms_copy_attribute(o,c,NULL,USHORT21))
          kprintf("\tunable to copy %s attribute\n", USHORT21);
        if(!kdms_match_attribute(o,c,NULL,USHORT21))
          kprintf("\tunable to match %s attribute\n",USHORT21);
        if (!kdms_query_attribute(c,NULL,USHORT21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KUSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", USHORT11);
	if(!kdms_get_attribute(c,NULL,USHORT21,&usdata1,&usdata2) || 
	   usdata1 != 65 || usdata2 != 66)
          kprintf("\tunable to get %s attribute\n",USHORT21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,USHORT21,outfile))
	    kprintf("\tunable to print %s attribute\n",USHORT21);
          else
	     kprintf("\n");
	}

#define USHORT12 "unsigned short 1 2"

	ausdata1 = (unsigned short *)kmalloc(2 * sizeof(unsigned short));
	ausdata1[0] = 65; ausdata1[1] = 66;
	if(!kdms_create_attribute(o,NULL,USHORT12,1,2,KUSHORT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n");
	if(!kdms_set_attribute(o,NULL,USHORT12,ausdata1))
          kprintf("\tunable to set %s attribute\n",USHORT12);
	kfree(ausdata1);
        if(!kdms_copy_attribute(o,c,NULL,USHORT12))
          kprintf("\tunable to copy %s attribute\n", USHORT12);
        if(!kdms_match_attribute(o,c,NULL,USHORT12))
          kprintf("\tunable to match %s attribute\n",USHORT12);
        if (!kdms_query_attribute(c,NULL,USHORT12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KUSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", USHORT12);
	if(!kdms_get_attribute(c,NULL,USHORT12,&ausdata1) || 
	   ausdata1[0] != 65 || ausdata1[1] != 66)
          kprintf("\tunable to get %s attribute\n",USHORT12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,USHORT12,outfile))
	    kprintf("\tunable to print %s attribute\n",USHORT12);
          else
	     kprintf("\n");
	}

#define USHORT22 "unsigned short 2 2"

	ausdata1 = (unsigned short *)kmalloc(2 * sizeof(unsigned short));
	ausdata1[0] = 65; ausdata1[1] = 66;
	ausdata2 = (unsigned short *)kmalloc(2 * sizeof(unsigned short));
	ausdata2[0] = 67; ausdata2[1] = 68;
	if(!kdms_create_attribute(o,NULL,USHORT22,2,2,KUSHORT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",USHORT22);
	if(!kdms_set_attribute(o,NULL,USHORT22,ausdata1,ausdata2))
          kprintf("\tunable to set %s attribute\n",USHORT22);
	kfree(ausdata1);
	kfree(ausdata2);
        if(!kdms_copy_attribute(o,c,NULL,USHORT22))
          kprintf("\tunable to copy %s attribute\n", USHORT22);
        if(!kdms_match_attribute(o,c,NULL,USHORT22))
          kprintf("\tunable to match %s attribute\n",USHORT22);
        if (!kdms_query_attribute(c,NULL,USHORT22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KUSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", USHORT22);
	if(!kdms_get_attribute(c,NULL,USHORT22,&ausdata1,&ausdata2) || 
	   ausdata1[0] != 65 || ausdata1[1] != 66 ||
	   ausdata2[0] != 67 || ausdata2[1] != 68)
          kprintf("\tunable to get %s attribute\n",USHORT22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,USHORT22,outfile))
	    kprintf("\tunable to print %s attribute\n",USHORT22);
          else
	     kprintf("\n");
	}
	kprintf("\n");

/*
 * testing int data.
 */

#define INT11 "int 1 1"

        kprintf("   KINT... \n");
	if(!kdms_create_attribute(o,NULL,INT11,1,1,KINT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",INT11);
	if(!kdms_set_attribute(o,NULL,INT11,(int)-65))
          kprintf("\tunable to set %s attribute\n",INT11);
        if(!kdms_copy_attribute(o,c,NULL,INT11))
          kprintf("\tunable to copy %s attribute\n", INT11);
        if(!kdms_match_attribute(o,c,NULL,INT11))
          kprintf("\tunable to match %s attribute\n",INT11);
        if (!kdms_query_attribute(c,NULL,INT11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", INT11);
	if(!kdms_get_attribute(c,NULL,INT11,&idata1) || idata1 != -65)
          kprintf("\tunable to get %s attribute\n",INT11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,INT11,outfile))
	    kprintf("\tunable to print %s attribute\n",INT11);
          else
	     kprintf("\n");
	}

#define INT21 "int 2 1"

	if(!kdms_create_attribute(o,NULL,INT21,2,1,KINT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",INT21);
	if(!kdms_set_attribute(o,NULL,INT21,(int)-65,(int)-66))
          kprintf("\tunable to set %s attribute\n",INT21);
        if(!kdms_copy_attribute(o,c,NULL,INT21))
          kprintf("\tunable to copy %s attribute\n", INT21);
        if(!kdms_match_attribute(o,c,NULL,INT21))
          kprintf("\tunable to match %s attribute\n",INT21);
        if (!kdms_query_attribute(c,NULL,INT21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", INT21);
	if(!kdms_get_attribute(c,NULL,INT21,&idata1,&idata2) || 
	   idata1 != -65 || idata2 != -66)
          kprintf("\tunable to get %s attribute\n",INT21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,INT21,outfile))
	    kprintf("\tunable to print %s attribute\n",INT21);
          else
	     kprintf("\n");
	}

#define INT12 "int 1 2"

	aidata1 = (int *)kmalloc(2 * sizeof(int));
	aidata1[0] = -65; aidata1[1] = -66;
	if(!kdms_create_attribute(o,NULL,INT12,1,2,KINT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",INT12);
	if(!kdms_set_attribute(o,NULL,INT12,aidata1))
          kprintf("\tunable to set %s attribute\n",INT12);
	kfree(aidata1);
        if(!kdms_copy_attribute(o,c,NULL,INT12))
          kprintf("\tunable to copy %s attribute\n", INT12);
        if(!kdms_match_attribute(o,c,NULL,INT12))
          kprintf("\tunable to match %s attribute\n",INT12);
        if (!kdms_query_attribute(c,NULL,INT12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", INT12);
	if(!kdms_get_attribute(c,NULL,INT12,&aidata1) || 
	   aidata1[0] != -65 || aidata1[1] != -66)
          kprintf("\tunable to get %s attribute\n", INT12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,INT12,outfile))
	    kprintf("\tunable to print %s attribute\n",INT12);
          else
	     kprintf("\n");
	}

#define INT22 "int 2 2"

	aidata1 = (int *)kmalloc(2 * sizeof(int));
	aidata1[0] = -65; aidata1[1] = -66;
	aidata2 = (int *)kmalloc(2 * sizeof(int));
	aidata2[0] = -67; aidata2[1] = -68;
	if(!kdms_create_attribute(o,NULL,INT22,2,2,KINT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",INT22);
	if(!kdms_set_attribute(o,NULL,INT22,aidata1,aidata2))
          kprintf("\tunable to set %s attribute\n",INT22);
	kfree(aidata1);
	kfree(aidata2);
        if(!kdms_copy_attribute(o,c,NULL,INT22))
          kprintf("\tunable to copy %s attribute\n", INT22);
        if(!kdms_match_attribute(o,c,NULL,INT22))
          kprintf("\tunable to match %s attribute\n",INT22);
        if (!kdms_query_attribute(c,NULL,INT22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", INT22);
	if(!kdms_get_attribute(c,NULL,INT22,&aidata1,&aidata2) || 
	   aidata1[0] != -65 || aidata1[1] != -66 ||
	   aidata2[0] != -67 || aidata2[1] != -68)
          kprintf("\tunable to get %s attribute\n",INT22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,INT22,outfile))
	    kprintf("\tunable to print %s attribute\n",INT22);
          else
	     kprintf("\n");
	}
	kprintf("\n");
	
/*
 * testing unsigned int data.
 */

#define UINT11 "unsigned int 1 1"

        kprintf("   KUINT... \n");
	if(!kdms_create_attribute(o,NULL,UINT11,1,1,KUINT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",UINT11);
	if(!kdms_set_attribute(o,NULL,UINT11,(unsigned int)65))
          kprintf("\tunable to set %s attribute\n",UINT11);
        if(!kdms_copy_attribute(o,c,NULL,UINT11))
          kprintf("\tunable to copy %s attribute\n", UINT11);
        if(!kdms_match_attribute(o,c,NULL,UINT11))
          kprintf("\tunable to match %s attribute\n",UINT11);
        if (!kdms_query_attribute(c,NULL,UINT11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KUINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", UINT11);
	if(!kdms_get_attribute(c,NULL,UINT11,&uidata1) || uidata1 != 65)
          kprintf("\tunable to get %s attribute\n",UINT11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UINT11,outfile))
	    kprintf("\tunable to print %s attribute\n",UINT11);
          else
	     kprintf("\n");
	}

#define UINT21 "unsigned int 2 1"

	if(!kdms_create_attribute(o,NULL,UINT21,2,1,KUINT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",UINT21);
	if(!kdms_set_attribute(o,NULL,UINT21,(unsigned int)65,
				(unsigned int)66))
          kprintf("\tunable to set %s attribute\n",UINT21);
        if(!kdms_copy_attribute(o,c,NULL,UINT21))
          kprintf("\tunable to copy %s attribute\n", UINT21);
        if(!kdms_match_attribute(o,c,NULL,UINT21))
          kprintf("\tunable to match %s attribute\n",UINT21);
        if (!kdms_query_attribute(c,NULL,UINT21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KUINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", UINT21);
	if(!kdms_get_attribute(c,NULL,UINT21,&uidata1,&uidata2) || 
	   uidata1 != 65 || uidata2 != 66)
          kprintf("\tunable to get %s attribute\n",UINT21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UINT21,outfile))
	    kprintf("\tunable to print %s attribute\n",UINT21);
          else
	     kprintf("\n");
	}

#define UINT12 "unsigned int 1 2"

	auidata1 = (unsigned int *)kmalloc(2 * sizeof(unsigned int));
	auidata1[0] = 65; auidata1[1] = 66;
	if(!kdms_create_attribute(o,NULL,UINT12,1,2,KUINT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",UINT12);
	if(!kdms_set_attribute(o,NULL,UINT12,auidata1))
          kprintf("\tunable to set %s attribute\n",UINT12);
	kfree(auidata1);
        if(!kdms_copy_attribute(o,c,NULL,UINT12))
          kprintf("\tunable to copy %s attribute\n", UINT12);
        if(!kdms_match_attribute(o,c,NULL,UINT21))
          kprintf("\tunable to match %s attribute\n",UINT12);
        if (!kdms_query_attribute(c,NULL,UINT12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KUINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", UINT12);
	if(!kdms_get_attribute(c,NULL,UINT12,&auidata1) || 
	   auidata1[0] != 65 || auidata1[1] != 66)
          kprintf("\tunable to get %s attribute\n",UINT12);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UINT12,outfile))
	    kprintf("\tunable to print %s attribute\n",UINT12);
          else
	     kprintf("\n");
	}

#define UINT22 "unsigned int 2 2"

	auidata1 = (unsigned int *)kmalloc(2 * sizeof(unsigned int));
	auidata1[0] = 65; auidata1[1] = 66;
	auidata2 = (unsigned int *)kmalloc(2 * sizeof(unsigned int));
	auidata2[0] = 67; auidata2[1] = 68;
	if(!kdms_create_attribute(o,NULL,UINT22,2,2,KUINT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",UINT22);
	if(!kdms_set_attribute(o,NULL,UINT22,auidata1,auidata2))
          kprintf("\tunable to set %s attribute\n",UINT22);
	kfree(auidata1);
	kfree(auidata2);
        if(!kdms_copy_attribute(o,c,NULL,UINT22))
          kprintf("\tunable to copy %s attribute\n", UINT22);
        if(!kdms_match_attribute(o,c,NULL,UINT22))
          kprintf("\tunable to match %s attribute\n",UINT22);
        if (!kdms_query_attribute(c,NULL,UINT22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KUINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", UINT22);
	if(!kdms_get_attribute(c,NULL,UINT22,&auidata1,&auidata2) || 
	   auidata1[0] != 65 || auidata1[1] != 66 ||
	   auidata2[0] != 67 || auidata2[1] != 68)
          kprintf("\tunable to get %s attribute\n",UINT22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UINT22,outfile))
	    kprintf("\tunable to print %s attribute\n",UINT22);
          else
	     kprintf("\n");
	}
	kprintf("\n");

/*
 * testing long data.
 */

#define LONG11 "long 1 1"	

        kprintf("   KLONG... \n");
	if(!kdms_create_attribute(o,NULL,LONG11,1,1,KLONG,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute",LONG11);
	if(!kdms_set_attribute(o,NULL,LONG11,(long)-65))
          kprintf("\tunable to set %s attribute",LONG11);
        if(!kdms_copy_attribute(o,c,NULL,LONG11))
          kprintf("\tunable to copy %s attribute\n", LONG11);
        if(!kdms_match_attribute(o,c,NULL,LONG11))
          kprintf("\tunable to match %s attribute\n",LONG11);
        if (!kdms_query_attribute(c,NULL,LONG11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KLONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", LONG11);
	if(!kdms_get_attribute(c,NULL,LONG11,&ldata1) || ldata1 != -65)
          kprintf("\tunable to get %s attribute",LONG11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,LONG11,outfile))
	    kprintf("\tunable to print %s attribute",LONG11);
          else
	     kprintf("\n");
	}

#define LONG21 "long 2 1"	

	if(!kdms_create_attribute(o,NULL,LONG21,2,1,KLONG,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",LONG21);
	if(!kdms_set_attribute(o,NULL,LONG21,(long)-65,(long)-66))
          kprintf("\tunable to set %s attribute\n",LONG21);
        if(!kdms_copy_attribute(o,c,NULL,LONG21))
          kprintf("\tunable to copy %s attribute\n", LONG21);
        if(!kdms_match_attribute(o,c,NULL,LONG21))
          kprintf("\tunable to match %s attribute\n",LONG21);
        if (!kdms_query_attribute(c,NULL,LONG21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KLONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", LONG11);
	if(!kdms_get_attribute(c,NULL,LONG21,&ldata1,&ldata2) || 
	   ldata1 != -65 || ldata2 != -66)
          kprintf("\tunable to get %s attribute\n",LONG21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,LONG21,outfile))
	    kprintf("\tunable to print %s attribute\n",LONG21);
          else
	     kprintf("\n");
	}

#define LONG12 "long 1 2"

	aldata1 = (long *)kmalloc(2 * sizeof(long));
	aldata1[0] = -65; aldata1[1] = -66;
	if(!kdms_create_attribute(o,NULL,LONG12,1,2,KLONG,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",LONG12);
	if(!kdms_set_attribute(o,NULL,LONG12,aldata1))
          kprintf("\tunable to set %s attribute\n",LONG12);
	kfree(aldata1);
        if(!kdms_copy_attribute(o,c,NULL,LONG12))
          kprintf("\tunable to copy %s attribute\n", LONG12);
        if(!kdms_match_attribute(o,c,NULL,LONG12))
          kprintf("\tunable to match %s attribute\n",LONG12);
        if (!kdms_query_attribute(c,NULL,LONG12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KLONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", LONG12);
	if(!kdms_get_attribute(c,NULL,LONG12,&aldata1) || 
	   aldata1[0] != -65 || aldata1[1] != -66)
          kprintf("\tunable to get %s attribute\n",LONG12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,LONG12,outfile))
	    kprintf("\tunable to print %s attribute\n",LONG12);
          else
	     kprintf("\n");
	}

#define LONG22 "long 2 2"

	aldata1 = (long *)kmalloc(2 * sizeof(long));
	aldata1[0] = -65; aldata1[1] = -66;
	aldata2 = (long *)kmalloc(2 * sizeof(long));
	aldata2[0] = -67; aldata2[1] = -68;
	if(!kdms_create_attribute(o,NULL,LONG22,2,2,KLONG,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",LONG22);
	if(!kdms_set_attribute(o,NULL,LONG22,aldata1,aldata2))
          kprintf("\tunable to set %s attribute\n",LONG22);
	kfree(aldata1);
	kfree(aldata2);
        if(!kdms_copy_attribute(o,c,NULL,LONG22))
          kprintf("\tunable to copy %s attribute\n", LONG22);
        if(!kdms_match_attribute(o,c,NULL,LONG12))
          kprintf("\tunable to match %s attribute\n",LONG22);
        if (!kdms_query_attribute(c,NULL,LONG22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KLONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", LONG22);
	if(!kdms_get_attribute(c,NULL,LONG22,&aldata1,&aldata2) || 
	   aldata1[0] != -65 || aldata1[1] != -66 ||
	   aldata2[0] != -67 || aldata2[1] != -68)
          kprintf("\tunable to get %s attribute\n",LONG22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,LONG22,outfile))
	    kprintf("\tunable to print %s attribute\n",LONG22);
          else
	     kprintf("\n");
	}
	kprintf("\n");
	
/*
 * testing unsigned long data.
 */

#define ULONG11 "unsigned long 1 1"

        kprintf("   KULONG... \n");
	if(!kdms_create_attribute(o,NULL,ULONG11,1,1,KULONG,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",ULONG11);
	if(!kdms_set_attribute(o,NULL,ULONG11,(unsigned long)65))
          kprintf("\tunable to set %s attribute\n",ULONG11);
        if(!kdms_copy_attribute(o,c,NULL,ULONG11))
          kprintf("\tunable to copy %s attribute\n", ULONG11);
        if(!kdms_match_attribute(o,c,NULL,ULONG11))
          kprintf("\tunable to match %s attribute\n",ULONG11);
        if (!kdms_query_attribute(c,NULL,ULONG11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KULONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", ULONG11);
	if(!kdms_get_attribute(c,NULL,ULONG11,&uldata1) || uldata1 != 65)
          kprintf("\tunable to get %s attribute\n",ULONG11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,ULONG11,outfile))
	    kprintf("\tunable to print %s attribute\n",ULONG11);
          else
	     kprintf("\n");
	}

#define ULONG21 "unsigned long 2 1"

	if(!kdms_create_attribute(o,NULL,ULONG21,2,1,KULONG,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",ULONG21);
	if(!kdms_set_attribute(o,NULL,ULONG21,(unsigned long)65,
					      (unsigned long)66))
          kprintf("\tunable to set %s attribute\n",ULONG21);
        if(!kdms_copy_attribute(o,c,NULL,ULONG21))
          kprintf("\tunable to copy %s attribute\n", ULONG21);
        if(!kdms_match_attribute(o,c,NULL,ULONG21))
          kprintf("\tunable to match %s attribute\n",ULONG21);
        if (!kdms_query_attribute(c,NULL,ULONG21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KULONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", ULONG21);
	if(!kdms_get_attribute(c,NULL,ULONG21,&uldata1,&uldata2) || 
	   uldata1 != 65 || uldata2 != 66)
          kprintf("\tunable to get %s attribute\n",ULONG21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,ULONG21,outfile))
	    kprintf("\tunable to print %s attribute\n",ULONG21);
          else
	     kprintf("\n");
	}

#define ULONG12 "unsigned long 1 2"

	auldata1 = (unsigned long *)kmalloc(2 * sizeof(unsigned long));
	auldata1[0] = 65; auldata1[1] = 66;
	if(!kdms_create_attribute(o,NULL,ULONG12,1,2,KULONG,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",ULONG12);
	if(!kdms_set_attribute(o,NULL,ULONG12,auldata1))
          kprintf("\tunable to set %s attribute\n",ULONG12);
	kfree(auldata1);
        if(!kdms_copy_attribute(o,c,NULL,ULONG12))
          kprintf("\tunable to copy %s attribute\n", ULONG12);
        if(!kdms_match_attribute(o,c,NULL,ULONG12))
          kprintf("\tunable to match %s attribute\n",ULONG12);
        if (!kdms_query_attribute(c,NULL,ULONG12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KULONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", ULONG12);
	if(!kdms_get_attribute(c,NULL,ULONG12,&auldata1) || 
	   auldata1[0] != 65 || auldata1[1] != 66)
          kprintf("\tunable to get %s attribute\n",ULONG12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,ULONG12,outfile))
	    kprintf("\tunable to print %s attribute\n",ULONG12);
          else
	     kprintf("\n");
	}

#define ULONG22 "unsigned long 2 2"

	auldata1 = (unsigned long *)kmalloc(2 * sizeof(unsigned long));
	auldata1[0] = 65; auldata1[1] = 66;
	auldata2 = (unsigned long *)kmalloc(2 * sizeof(unsigned long));
	auldata2[0] = 67; auldata2[1] = 68;
	if(!kdms_create_attribute(o,NULL,ULONG22,2,2,KULONG,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",ULONG22);
	if(!kdms_set_attribute(o,NULL,ULONG22,auldata1,auldata2))
          kprintf("\tunable to set %s attribute\n",ULONG22);
	kfree(auldata1);
	kfree(auldata2);
        if(!kdms_copy_attribute(o,c,NULL,ULONG22))
          kprintf("\tunable to copy %s attribute\n", ULONG22);
        if(!kdms_match_attribute(o,c,NULL,ULONG12))
          kprintf("\tunable to match %s attribute\n",ULONG22);
        if (!kdms_query_attribute(c,NULL,ULONG22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KULONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", ULONG22);
	if(!kdms_get_attribute(c,NULL,ULONG22,&auldata1,&auldata2) || 
	   auldata1[0] != 65 || auldata1[1] != 66 ||
	   auldata2[0] != 67 || auldata2[1] != 68)
          kprintf("\tunable to get %s attribute\n",ULONG22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,ULONG22,outfile))
	    kprintf("\tunable to print %s attribute\n",ULONG22);
          else
	     kprintf("\n");
	}
	kprintf("\n");

/*
 * testing float data.
 */


#define FLOAT11 "float 1 1"

        kprintf("   KFLOAT... \n");
	if(!kdms_create_attribute(o,NULL,FLOAT11,1,1,KFLOAT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",FLOAT11);
	if(!kdms_set_attribute(o,NULL,FLOAT11,(float)-65.12))
          kprintf("\tunable to set %s attribute\n",FLOAT11);
        if(!kdms_copy_attribute(o,c,NULL,FLOAT11))
          kprintf("\tunable to copy %s attribute\n", FLOAT11);
        if(!kdms_match_attribute(o,c,NULL,FLOAT11))
          kprintf("\tunable to match %s attribute\n",FLOAT11);
        if (!kdms_query_attribute(c,NULL,FLOAT11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KFLOAT || perm != 1)
          kprintf("\tunable to query %s attribute\n", FLOAT11);
	if(!kdms_get_attribute(c,NULL,FLOAT11,&fdata1) || 
	   fdata1 != (float) -65.12)
          kprintf("\tunable to get %s attribute\n",FLOAT11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,FLOAT11,outfile))
	    kprintf("\tunable to print %s attribute\n",FLOAT11);
          else
	     kprintf("\n");
	}

#define FLOAT21 "float 2 1"

	if(!kdms_create_attribute(o,NULL,FLOAT21,2,1,KFLOAT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",FLOAT21);
	if(!kdms_set_attribute(o,NULL,FLOAT21,(float)-65.12,(float)-66.34))
          kprintf("\tunable to set %s attribute\n",FLOAT21);
        if(!kdms_copy_attribute(o,c,NULL,FLOAT21))
          kprintf("\tunable to copy %s attribute\n", FLOAT21);
        if(!kdms_match_attribute(o,c,NULL,FLOAT21))
          kprintf("\tunable to match %s attribute\n",FLOAT21);
        if (!kdms_query_attribute(c,NULL,FLOAT21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KFLOAT || perm != 1)
          kprintf("\tunable to query %s attribute\n", FLOAT21);
	if(!kdms_get_attribute(c,NULL,FLOAT21,&fdata1,&fdata2) || 
	   fdata1 != (float) -65.12 || fdata2 != (float) -66.34)
          kprintf("\tunable to get %s attribute\n",FLOAT21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,FLOAT21,outfile))
	    kprintf("\tunable to print %s attribute\n",FLOAT21);
          else
	     kprintf("\n");
	}

#define FLOAT12 "float 1 2"

	afdata1 = (float *)kmalloc(2 * sizeof(float));
	afdata1[0] = -65.12; afdata1[1] = -66.34;
	if(!kdms_create_attribute(o,NULL,FLOAT12,1,2,KFLOAT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",FLOAT12);
	if(!kdms_set_attribute(o,NULL,FLOAT12,afdata1))
          kprintf("\tunable to set %s attribute\n",FLOAT12);
	kfree(afdata1);
        if(!kdms_copy_attribute(o,c,NULL,FLOAT12))
          kprintf("\tunable to copy %s attribute\n", FLOAT12);
        if(!kdms_match_attribute(o,c,NULL,FLOAT12))
          kprintf("\tunable to match %s attribute\n",FLOAT12);
        if (!kdms_query_attribute(c,NULL,FLOAT12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KFLOAT || perm != 1)
          kprintf("\tunable to query %s attribute\n", FLOAT12);
	if(!kdms_get_attribute(c,NULL,FLOAT12,&afdata1) || 
	   afdata1[0] != (float) -65.12 || afdata1[1] != (float) -66.34)
          kprintf("\tunable to get %s attribute\n",FLOAT12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,FLOAT12,outfile))
	    kprintf("\tunable to print %s attribute\n",FLOAT12);
          else
	     kprintf("\n");
	}

#define FLOAT22 "float 2 2"

	afdata1 = (float *)kmalloc(2 * sizeof(float));
	afdata1[0] = (float) -65.12; afdata1[1] = (float) -66.34;
	afdata2 = (float *)kmalloc(2 * sizeof(float));
	afdata2[0] = (float) -67.56; afdata2[1] = (float) -68.78;
	if(!kdms_create_attribute(o,NULL,FLOAT22,2,2,KFLOAT,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",FLOAT22);
	if(!kdms_set_attribute(o,NULL,FLOAT22,afdata1,afdata2))
          kprintf("\tunable to set %s attribute\n",FLOAT22);
	kfree(afdata1);
	kfree(afdata2);
        if(!kdms_copy_attribute(o,c,NULL,FLOAT22))
          kprintf("\tunable to copy %s attribute\n", FLOAT22);
        if(!kdms_match_attribute(o,c,NULL,FLOAT22))
          kprintf("\tunable to match %s attribute\n",FLOAT22);
        if (!kdms_query_attribute(c,NULL,FLOAT22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KFLOAT || perm != 1)
          kprintf("\tunable to query %s attribute\n", FLOAT22);
	if(!kdms_get_attribute(c,NULL,FLOAT22,&afdata1,&afdata2) || 
	   afdata1[0] != (float) -65.12 || afdata1[1] != (float) -66.34 ||
	   afdata2[0] != (float) -67.56 || afdata2[1] != (float) -68.78)
          kprintf("\tunable to get %s attribute\n",FLOAT22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,FLOAT22,outfile))
	    kprintf("\tunable to print %s attribute\n",FLOAT22);
          else
	     kprintf("\n");
	}
	kprintf("\n");
	
/*
 * testing double data.
 */

#define DOUBLE11 "double 1 1"

        kprintf("   KDOUBLE... \n");
	if(!kdms_create_attribute(o,NULL,DOUBLE11,1,1,KDOUBLE,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",DOUBLE11);
	if(!kdms_set_attribute(o,NULL,DOUBLE11,(double)65.12))
          kprintf("\tunable to set %s attribute\n",DOUBLE11);
        if(!kdms_copy_attribute(o,c,NULL,DOUBLE11))
          kprintf("\tunable to copy %s attribute\n", DOUBLE11);
        if(!kdms_match_attribute(o,c,NULL,DOUBLE11))
          kprintf("\tunable to match %s attribute\n",DOUBLE11);
        if (!kdms_query_attribute(c,NULL,DOUBLE11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KDOUBLE || perm != 1)
          kprintf("\tunable to query %s attribute\n", DOUBLE11);
	if(!kdms_get_attribute(c,NULL,DOUBLE11,&ddata1) || ddata1 != 65.12)
          kprintf("\tunable to get %s attribute\n",DOUBLE11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DOUBLE11,outfile))
	    kprintf("\tunable to print %s attribute\n",DOUBLE11);
          else
	     kprintf("\n");
	}

#define DOUBLE21 "double 2 1"

	if(!kdms_create_attribute(o,NULL,DOUBLE21,2,1,KDOUBLE,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",DOUBLE21);
	if(!kdms_set_attribute(o,NULL,DOUBLE21,(double)65.12,(double)66.34))
          kprintf("\tunable to set %s attribute\n",DOUBLE21);
        if(!kdms_copy_attribute(o,c,NULL,DOUBLE21))
          kprintf("\tunable to copy %s attribute\n", DOUBLE21);
        if(!kdms_match_attribute(o,c,NULL,DOUBLE21))
          kprintf("\tunable to match %s attribute\n",DOUBLE21);
        if (!kdms_query_attribute(c,NULL,DOUBLE21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KDOUBLE || perm != 1)
          kprintf("\tunable to query %s attribute\n", DOUBLE21);
	if(!kdms_get_attribute(c,NULL,DOUBLE21,&ddata1,&ddata2) || 
	   ddata1 != 65.12 || ddata2 != 66.34)
          kprintf("\tunable to get %s attribute\n",DOUBLE21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DOUBLE21,outfile))
	    kprintf("\tunable to print %s attribute\n",DOUBLE21);
          else
	     kprintf("\n");
	}

#define DOUBLE12 "double 1 2"

	addata1 = (double *)kmalloc(2 * sizeof(double));
	addata1[0] = 65.12; addata1[1] = 66.34;
	if(!kdms_create_attribute(o,NULL,DOUBLE12,1,2,KDOUBLE,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",DOUBLE12);
	if(!kdms_set_attribute(o,NULL,DOUBLE12,addata1))
          kprintf("\tunable to set %s attribute\n",DOUBLE12);
	kfree(addata1);
        if(!kdms_copy_attribute(o,c,NULL,DOUBLE12))
          kprintf("\tunable to copy %s attribute\n", DOUBLE12);
        if(!kdms_match_attribute(o,c,NULL,DOUBLE12))
          kprintf("\tunable to match %s attribute\n",DOUBLE12);
        if (!kdms_query_attribute(c,NULL,DOUBLE12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KDOUBLE || perm != 1)
          kprintf("\tunable to query %s attribute\n", DOUBLE12);
	if(!kdms_get_attribute(c,NULL,DOUBLE12,&addata1) || 
	   addata1[0] != 65.12 || addata1[1] != 66.34)
          kprintf("\tunable to get %s attribute\n",DOUBLE12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DOUBLE12,outfile))
	    kprintf("\tunable to print %s attribute\n",DOUBLE12);
          else
	     kprintf("\n");
	}

#define DOUBLE22 "double 2 2"

	addata1 = (double *)kmalloc(2 * sizeof(double));
	addata1[0] = 65.12; addata1[1] = 66.34;
	addata2 = (double *)kmalloc(2 * sizeof(double));
	addata2[0] = 67.56; addata2[1] = 68.78;
	if(!kdms_create_attribute(o,NULL,DOUBLE22,2,2,KDOUBLE,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",DOUBLE22);
	if(!kdms_set_attribute(o,NULL,DOUBLE22,addata1,addata2))
          kprintf("\tunable to set %s attribute\n",DOUBLE22);
	kfree(addata1);
	kfree(addata2);
        if(!kdms_copy_attribute(o,c,NULL,DOUBLE22))
          kprintf("\tunable to copy %s attribute\n", DOUBLE22);
        if(!kdms_match_attribute(o,c,NULL,DOUBLE22))
          kprintf("\tunable to match %s attribute\n",DOUBLE22);
        if (!kdms_query_attribute(c,NULL,DOUBLE22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KDOUBLE || perm != 1)
          kprintf("\tunable to query %s attribute\n", DOUBLE22);
	if(!kdms_get_attribute(c,NULL,DOUBLE22,&addata1,&addata2) || 
	   addata1[0] != 65.12 || addata1[1] != 66.34 ||
	   addata2[0] != 67.56 || addata2[1] != 68.78)
          kprintf("\tunable to get %s attribute\n",DOUBLE22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DOUBLE22,outfile))
	    kprintf("\tunable to print %s attribute\n",DOUBLE22);
          else
	     kprintf("\n");
	}
	kprintf("\n");
	
/*
 * testing kcomplex data.
 */

#define COMPLEX11 "kcomplex 1 1"

        kprintf("   KCOMPLEX... \n");
	if(!kdms_create_attribute(o,NULL,COMPLEX11,1,1,KCOMPLEX,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",COMPLEX11);
	if(!kdms_set_attribute(o,NULL,COMPLEX11,kccomp(65.0,66.0)))
          kprintf("\tunable to set %s attribute\n",COMPLEX11);
        if(!kdms_copy_attribute(o,c,NULL,COMPLEX11))
          kprintf("\tunable to copy %s attribute\n", COMPLEX11);
        if(!kdms_match_attribute(o,c,NULL,COMPLEX11))
          kprintf("\tunable to match %s attribute\n",COMPLEX11);
        if (!kdms_query_attribute(c,NULL,COMPLEX11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", COMPLEX11);
	if(!kdms_get_attribute(c,NULL,COMPLEX11,&kcdata1) || 
	   kcreal(kcdata1) != 65.0 || kcimag(kcdata1) != 66.0)
          kprintf("\tunable to get %s attribute\n",COMPLEX11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,COMPLEX11,outfile))
	    kprintf("\tunable to print %s attribute\n",COMPLEX11);
          else
	     kprintf("\n");
	}

#define COMPLEX21 "kcomplex 2 1"

	if(!kdms_create_attribute(o,NULL,COMPLEX21,2,1,KCOMPLEX,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",COMPLEX21);
	if(!kdms_set_attribute(o,NULL,COMPLEX21,
	    kccomp(65.0,66.0),kccomp(67.0,68.0)))
          kprintf("\tunable to set %s attribute\n",COMPLEX21);
        if(!kdms_copy_attribute(o,c,NULL,COMPLEX21))
          kprintf("\tunable to copy %s attribute\n", COMPLEX21);
        if(!kdms_match_attribute(o,c,NULL,COMPLEX21))
          kprintf("\tunable to match %s attribute\n",COMPLEX21);
        if (!kdms_query_attribute(c,NULL,COMPLEX21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", COMPLEX21);
	if(!kdms_get_attribute(c,NULL,COMPLEX21,&kcdata1,&kcdata2) || 
	   kcreal(kcdata1) != 65.0 || kcimag(kcdata1) != 66.0 ||
	   kcreal(kcdata2) != 67.0 || kcimag(kcdata2) != 68.0)
          kprintf("\tunable to get %s attribute\n",COMPLEX21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,COMPLEX21,outfile))
	    kprintf("\tunable to print %s attribute\n",COMPLEX21);
          else
	     kprintf("\n");
	}

#define COMPLEX12 "kcomplex 1 2"

	akcdata1 = (kcomplex *)kmalloc(2 * sizeof(kcomplex));
	akcdata1[0] = kccomp(65.0,66.0); akcdata1[1] = kccomp(67.0,68.0);
	if(!kdms_create_attribute(o,NULL,COMPLEX12,1,2,KCOMPLEX,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",COMPLEX12);
	if(!kdms_set_attribute(o,NULL,COMPLEX12,akcdata1))
          kprintf("\tunable to set %s attribute\n",COMPLEX12);
	kfree(akcdata1);
        if(!kdms_copy_attribute(o,c,NULL,COMPLEX12))
          kprintf("\tunable to copy %s attribute\n", COMPLEX12);
        if(!kdms_match_attribute(o,c,NULL,COMPLEX12))
          kprintf("\tunable to match %s attribute\n",COMPLEX12);
        if (!kdms_query_attribute(c,NULL,COMPLEX12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", COMPLEX12);
	if(!kdms_get_attribute(c,NULL,COMPLEX12,&akcdata1) || 
	   kcreal(akcdata1[0]) != 65.0 || kcimag(akcdata1[0]) != 66.0 ||
	   kcreal(akcdata1[1]) != 67.0 || kcimag(akcdata1[1]) != 68.0)
          kprintf("\tunable to get %s attribute\n",COMPLEX12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,COMPLEX12,outfile))
	    kprintf("\tunable to print %s attribute\n",COMPLEX12);
          else
	     kprintf("\n");
	}

#define COMPLEX22 "kcomplex 2 2"

	akcdata1 = (kcomplex *)kmalloc(2 * sizeof(kcomplex));
	akcdata1[0] = kccomp(65.0,66.0); akcdata1[1] = kccomp(67.0,68.0);
	akcdata2 = (kcomplex *)kmalloc(2 * sizeof(kcomplex));
	akcdata2[0] = kccomp(69.0,70.0); akcdata2[1] = kccomp(71.0,72.0);
	if(!kdms_create_attribute(o,NULL,COMPLEX22,2,2,KCOMPLEX,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",COMPLEX22);
	if(!kdms_set_attribute(o,NULL,COMPLEX22,akcdata1,akcdata2))
          kprintf("\tunable to set %s attribute\n",COMPLEX22);
	kfree(akcdata1);
	kfree(akcdata2);
        if(!kdms_copy_attribute(o,c,NULL,COMPLEX22))
          kprintf("\tunable to copy %s attribute\n", COMPLEX22);
        if(!kdms_match_attribute(o,c,NULL,COMPLEX22))
          kprintf("\tunable to match %s attribute\n",COMPLEX22);
        if (!kdms_query_attribute(c,NULL,COMPLEX22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", COMPLEX22);
	if(!kdms_get_attribute(c,NULL,COMPLEX22,&akcdata1,&akcdata2) || 
	   kcreal(akcdata1[0]) != 65.0 || kcimag(akcdata1[0]) != 66.0 ||
	   kcreal(akcdata1[1]) != 67.0 || kcimag(akcdata1[1]) != 68.0 ||
	   kcreal(akcdata2[0]) != 69.0 || kcimag(akcdata2[0]) != 70.0 ||
	   kcreal(akcdata2[1]) != 71.0 || kcimag(akcdata2[1]) != 72.0)
          kprintf("\tunable to get %s attribute\n",COMPLEX22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,COMPLEX22,outfile))
	    kprintf("\tunable to print %s attribute\n",COMPLEX22);
          else
	     kprintf("\n");
	}
	kprintf("\n");

/*
 * testing kdcomplex data.
 */

#define DCOMPLEX11 "kdcomplex 1 1"

        kprintf("   KDCOMPLEX... \n");
	if(!kdms_create_attribute(o,NULL,DCOMPLEX11,1,1,KDCOMPLEX,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",DCOMPLEX11);
	if(!kdms_set_attribute(o,NULL,DCOMPLEX11,kdccomp(65.0,66.0)))
          kprintf("\tunable to set %s attribute\n",DCOMPLEX11);
        if(!kdms_copy_attribute(o,c,NULL,DCOMPLEX11))
          kprintf("\tunable to copy %s attribute\n", DCOMPLEX11);
        if(!kdms_match_attribute(o,c,NULL,DCOMPLEX11))
          kprintf("\tunable to match %s attribute\n",DCOMPLEX11);
        if (!kdms_query_attribute(c,NULL,DCOMPLEX11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KDCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", DCOMPLEX11);
	if(!kdms_get_attribute(c,NULL,DCOMPLEX11,&kdcdata1) || 
	   kdcreal(kdcdata1) != 65.0 || kdcimag(kdcdata1) != 66.0)
          kprintf("\tunable to get %s attribute\n",DCOMPLEX11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DCOMPLEX11,outfile))
	    kprintf("\tunable to print %s attribute\n",DCOMPLEX11);
          else
	     kprintf("\n");
	}

#define DCOMPLEX21 "kdcomplex 2 1"


	if(!kdms_create_attribute(o,NULL,DCOMPLEX21,2,1,KDCOMPLEX,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",DCOMPLEX21);
	if(!kdms_set_attribute(o,NULL,DCOMPLEX21,
	    kdccomp(65.0,66.0),kdccomp(67.0,68.0)))
          kprintf("\tunable to set %s attribute\n",DCOMPLEX21);
        if(!kdms_copy_attribute(o,c,NULL,DCOMPLEX21))
          kprintf("\tunable to copy %s attribute\n", DCOMPLEX21);
        if(!kdms_match_attribute(o,c,NULL,DCOMPLEX21))
          kprintf("\tunable to match %s attribute\n",DCOMPLEX21);
        if (!kdms_query_attribute(c,NULL,DCOMPLEX21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KDCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", DCOMPLEX21);
	if(!kdms_get_attribute(c,NULL,DCOMPLEX21,&kdcdata1,&kdcdata2) || 
	   kdcreal(kdcdata1) != 65.0 || kdcimag(kdcdata1) != 66.0 ||
	   kdcreal(kdcdata2) != 67.0 || kdcimag(kdcdata2) != 68.0)
          kprintf("\tunable to get %s attribute\n",DCOMPLEX21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DCOMPLEX21,outfile))
	    kprintf("\tunable to print %s attribute\n",DCOMPLEX21);
          else
	     kprintf("\n");
	}

#define DCOMPLEX12 "kdcomplex 1 2"

	akdcdata1 = (kdcomplex *)kmalloc(2 * sizeof(kdcomplex));
	akdcdata1[0] = kdccomp(65.0,66.0); akdcdata1[1] = kdccomp(67.0,68.0);
	if(!kdms_create_attribute(o,NULL,DCOMPLEX12,1,2,KDCOMPLEX,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",DCOMPLEX12);
	if(!kdms_set_attribute(o,NULL,DCOMPLEX12,akdcdata1))
          kprintf("\tunable to set %s attribute\n",DCOMPLEX12);
	kfree(akdcdata1);
        if(!kdms_copy_attribute(o,c,NULL,DCOMPLEX12))
          kprintf("\tunable to copy %s attribute\n", DCOMPLEX12);
        if(!kdms_match_attribute(o,c,NULL,DCOMPLEX12))
          kprintf("\tunable to match %s attribute\n",DCOMPLEX12);
        if (!kdms_query_attribute(c,NULL,DCOMPLEX12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KDCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", DCOMPLEX12);
	if(!kdms_get_attribute(c,NULL,DCOMPLEX12,&akdcdata1) || 
	   kdcreal(akdcdata1[0]) != 65.0 || kdcimag(akdcdata1[0]) != 66.0 ||
	   kdcreal(akdcdata1[1]) != 67.0 || kdcimag(akdcdata1[1]) != 68.0)
          kprintf("\tunable to get %s attribute\n",DCOMPLEX12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DCOMPLEX12,outfile))
	    kprintf("\tunable to print %s attribute\n",DCOMPLEX12);
          else
	     kprintf("\n");
	}

#define DCOMPLEX22 "kdcomplex 2 2"

	akdcdata1 = (kdcomplex *)kmalloc(2 * sizeof(kdcomplex));
	akdcdata1[0] = kdccomp(65.0,66.0); akdcdata1[1] = kdccomp(67.0,68.0);
	akdcdata2 = (kdcomplex *)kmalloc(2 * sizeof(kdcomplex));
	akdcdata2[0] = kdccomp(69.0,70.0); akdcdata2[1] = kdccomp(71.0,72.0);
	if(!kdms_create_attribute(o,NULL,DCOMPLEX22,2,2,KDCOMPLEX,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",DCOMPLEX22);
	if(!kdms_set_attribute(o,NULL,DCOMPLEX22,akdcdata1,akdcdata2))
          kprintf("\tunable to set %s attribute\n",DCOMPLEX22);
	kfree(akdcdata1);
	kfree(akdcdata2);
        if(!kdms_copy_attribute(o,c,NULL,DCOMPLEX22))
          kprintf("\tunable to copy %s attribute\n", DCOMPLEX22);
        if(!kdms_match_attribute(o,c,NULL,DCOMPLEX22))
          kprintf("\tunable to match %s attribute\n",DCOMPLEX22);
        if (!kdms_query_attribute(c,NULL,DCOMPLEX22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KDCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", DCOMPLEX22);
	if(!kdms_get_attribute(c,NULL,DCOMPLEX22,&akdcdata1,&akdcdata2) || 
	   kdcreal(akdcdata1[0]) != 65.0 || kdcimag(akdcdata1[0]) != 66.0 ||
	   kdcreal(akdcdata1[1]) != 67.0 || kdcimag(akdcdata1[1]) != 68.0 ||
	   kdcreal(akdcdata2[0]) != 69.0 || kdcimag(akdcdata2[0]) != 70.0 ||
	   kdcreal(akdcdata2[1]) != 71.0 || kdcimag(akdcdata2[1]) != 72.0)
          kprintf("\tunable to get %s attribute\n",DCOMPLEX22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DCOMPLEX22,outfile))
	    kprintf("\tunable to print %s attribute\n",DCOMPLEX22);
          else
	     kprintf("\n");
	}
	kprintf("\n");

/*
 * testing kstring data.
 */

#define STRING11 "kstring 1 1"

        kprintf("   KSTRING... \n");
	if(!kdms_create_attribute(o,NULL,STRING11,1,1,KSTRING,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",STRING11);
	if(!kdms_set_attribute(o,NULL,STRING11,"string1"))
	  kprintf("\tunable to create %s attribute\n",STRING11);
        if(!kdms_copy_attribute(o,c,NULL,STRING11))
          kprintf("\tunable to copy %s attribute\n", STRING11);
        if(!kdms_match_attribute(o,c,NULL,STRING11))
          kprintf("\tunable to match %s attribute\n",STRING11);
        if (!kdms_query_attribute(c,NULL,STRING11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KSTRING || perm != 1)
          kprintf("\tunable to query %s attribute\n", STRING11);
	if(!kdms_get_attribute(c,NULL,STRING11,&stdata1) || 
	   ( kstrcmp(stdata1, "string1") != 0) )
          kprintf("\tunable to get %s attribute\n",STRING11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,STRING11,outfile))
	    kprintf("\tunable to print %s attribute\n",STRING11);
          else
	     kprintf("\n");
	}

#define STRING21 "kstring 2 1"

	if(!kdms_create_attribute(o,NULL,STRING21,2,1,KSTRING,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",STRING21);
	if(!kdms_set_attribute(o,NULL,STRING21,
	    "string1", "string2"))
          kprintf("\tunable to set %s attribute\n",STRING21);
        if(!kdms_copy_attribute(o,c,NULL,STRING21))
          kprintf("\tunable to copy %s attribute\n", STRING21);
        if(!kdms_match_attribute(o,c,NULL,STRING21))
          kprintf("\tunable to match %s attribute\n",STRING21);
        if (!kdms_query_attribute(c,NULL,STRING21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KSTRING || perm != 1)
          kprintf("\tunable to query %s attribute\n", STRING21);
	if(!kdms_get_attribute(c,NULL,STRING21,&stdata1,&stdata2) || 
	   ( kstrcmp(stdata1, "string1") != 0) ||
	   ( kstrcmp(stdata2, "string2") != 0) )
          kprintf("\tunable to get %s attribute\n",STRING21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,STRING21,outfile))
	    kprintf("\tunable to print %s attribute\n",STRING21);
          else
	     kprintf("\n");
	}

#define STRING12 "kstring 1 2"

	astdata1 = (kstring *)kmalloc(2 * sizeof(kstring));
	astdata1[0] = kstring_copy("string1", NULL);
        astdata1[1] = kstring_copy("string2", NULL);
	if(!kdms_create_attribute(o,NULL,STRING12,1,2,KSTRING,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",STRING12);
	if(!kdms_set_attribute(o,NULL,STRING12,astdata1))
          kprintf("\tunable to set %s attribute\n",STRING12);
	kfree(astdata1[0]);	kfree(astdata1[1]);	kfree(astdata1);
        if(!kdms_copy_attribute(o,c,NULL,STRING12))
          kprintf("\tunable to copy %s attribute\n", STRING12);
        if(!kdms_match_attribute(o,c,NULL,STRING12))
          kprintf("\tunable to match %s attribute\n",STRING12);
        if (!kdms_query_attribute(c,NULL,STRING12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KSTRING || perm != 1)
          kprintf("\tunable to query %s attribute\n", STRING12);
	if(!kdms_get_attribute(c,NULL,STRING12,&astdata1) || 
	   ( kstrcmp(astdata1[0], "string1") != 0) ||
	   ( kstrcmp(astdata1[1], "string2") != 0) )
          kprintf("\tunable to get %s attribute\n",STRING12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,STRING12,outfile))
	    kprintf("\tunable to print %s attribute\n",STRING12);
          else
	     kprintf("\n");
	}

#define STRING22 "kstring 2 2"

	astdata1 = (kstring *)kmalloc(2 * sizeof(kstring));
	astdata1[0] = kstring_copy("string1", NULL);
        astdata1[1] = kstring_copy("string2", NULL);
	astdata2 = (kstring *)kmalloc(2 * sizeof(kstring));
	astdata2[0] = kstring_copy("string3", NULL);
        astdata2[1] = kstring_copy("string4", NULL);
	if(!kdms_create_attribute(o,NULL,STRING22,2,2,KSTRING,TRUE,TRUE))
	  kprintf("\tunable to create %s attribute\n",STRING22);
	if(!kdms_set_attribute(o,NULL,STRING22,astdata1,astdata2))
          kprintf("\tunable to set %s attribute\n",STRING22);
	kfree(astdata1[0]);	kfree(astdata1[1]);	kfree(astdata1);
	kfree(astdata2[0]);	kfree(astdata2[1]);	kfree(astdata2);
        if(!kdms_copy_attribute(o,c,NULL,STRING22))
          kprintf("\tunable to copy %s attribute\n", STRING22);
        if(!kdms_match_attribute(o,c,NULL,STRING22))
          kprintf("\tunable to match %s attribute\n",STRING22);
        if (!kdms_query_attribute(c,NULL,STRING22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KSTRING || perm != 1)
          kprintf("\tunable to query %s attribute\n", STRING22);
	if(!kdms_get_attribute(c,NULL,STRING22,&astdata1,&astdata2) || 
	   ( kstrcmp(astdata1[0], "string1") != 0) ||
	   ( kstrcmp(astdata1[1], "string2") != 0) ||
	   ( kstrcmp(astdata2[0], "string3") != 0) ||
	   ( kstrcmp(astdata2[1], "string4") != 0))
          kprintf("\tunable to get %s attribute\n",STRING22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,STRING22,outfile))
	    kprintf("\tunable to print %s attribute\n",STRING22);
          else
	     kprintf("\n");
	}
	kdms_close(o);
	kdms_close(c);
	kdms_close(i);
/*
 * Phase 4...successfully getting the generic attributes from a closed and
 *           reopened object.
 */

	kprintf("\nPhase 4...");

	if ((c = kdms_input(TESTCOPYNAME)) == NULL)
	   kexit(1);

/*
 * testing byte data.
 */
	kprintf("\n");

        kprintf("   KBYTE...\n");
        if (!kdms_query_attribute(c,NULL,BYTE11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", BYTE11);
	if(!kdms_get_attribute(c,NULL,BYTE11,&bdata1) || bdata1 != -65)
          kprintf("\tunable to get %s attribute\n",BYTE11);
        else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,BYTE11,outfile))
	    kprintf("\n\tunable to print %s attribute\n",BYTE11);
          else
	    kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,BYTE21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", BYTE21);
	if(!kdms_get_attribute(c,NULL,BYTE21,&bdata1,&bdata2) || 
	   bdata1 != -65 || bdata2 != -66)
          kprintf("\tunable to get %s attribute\n",BYTE21);
        else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,BYTE21,outfile))
	    kprintf("\n\tunable to print %s attribute\n",BYTE21);
          else
	    kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,BYTE12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", BYTE11);
	if(!kdms_get_attribute(c,NULL,BYTE12,&abdata1) || 
	   abdata1[0] != -65 || abdata1[1] != -66)
          kprintf("\tunable to get BYTE12 attribute\n", BYTE12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,BYTE12,outfile))
	    kprintf("\n\tunable to print %s attribute\n", BYTE12);
          else
     	    kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,BYTE22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", BYTE11);
	if(!kdms_get_attribute(c,NULL,BYTE22,&abdata1,&abdata2) || 
	   abdata1[0] != -65 || abdata1[1] != -66 ||
	   abdata2[0] != -67 || abdata2[1] != -68)
          kprintf("\tunable to get %s attribute\n", BYTE22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,BYTE22,outfile))
	    kprintf("\tunable to print %s attribute\n", BYTE22);
          else
	    kprintf("\n");
	}
	kprintf("\n");	
/*
 * testing unsigned byte data.
 */

        kprintf("   KUBYTE... \n");
        if (!kdms_query_attribute(c,NULL,UBYTE11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KUBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", UBYTE11);
	if(!kdms_get_attribute(c,NULL,UBYTE11,&ubdata1) || ubdata1 != 65)
          kprintf("\tunable to get %s attribute\n", UBYTE11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UBYTE11,outfile))
	    kprintf("\tunable to print %s attribute\n", UBYTE11);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,UBYTE21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KUBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", UBYTE21);
	if(!kdms_get_attribute(c,NULL,UBYTE21,&ubdata1,&ubdata2) || 
	   ubdata1 != 65 || ubdata2 != 66)
          kprintf("\tunable to get %s attribute\n", UBYTE21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UBYTE21,outfile))
	    kprintf("\tunable to print %s attribute\n", UBYTE21);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,UBYTE12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KUBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", BYTE11);
	if(!kdms_get_attribute(c,NULL,UBYTE12,&aubdata1) || 
	   aubdata1[0] != 65 || aubdata1[1] != 66)
          kprintf("\tunable to get %s attribute\n",UBYTE12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UBYTE12,outfile))
	    kprintf("\tunable to print %s attribute\n", UBYTE12);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,UBYTE22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KUBYTE || perm != 1)
          kprintf("\tunable to query %s attribute\n", UBYTE21);
	if(!kdms_get_attribute(c,NULL,UBYTE22,&aubdata1,&aubdata2) || 
	   aubdata1[0] != 65 || aubdata1[1] != 66 ||
	   aubdata2[0] != 67 || aubdata2[1] != 68)
          kprintf("\tunable to get %s attribute\n", UBYTE22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UBYTE22,outfile))
	    kprintf("\tunable to print %s attribute\n", UBYTE22);
          else
	     kprintf("\n");
	}
	kprintf("\n");

/*
 * testing short data.
 */
        kprintf("   KSHORT...\n");
        if (!kdms_query_attribute(c,NULL,SHORT11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", SHORT11);
	if(!kdms_get_attribute(c,NULL,SHORT11,&sdata1) || sdata1 != -65)
          kprintf("\tunable to get SHORT11 attribute\n");
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,SHORT11,outfile))
	    kprintf("\tunable to print %s attribute\n", SHORT11);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,SHORT21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", SHORT21);
	if(!kdms_get_attribute(c,NULL,SHORT21,&sdata1,&sdata2) || 
	   sdata1 != -65 || sdata2 != -66)
          kprintf("\tunable to get %s attribute\n", SHORT21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,SHORT21,outfile))
	    kprintf("\tunable to print %s attribute\n", SHORT21);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,SHORT12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", SHORT12);
	if(!kdms_get_attribute(c,NULL,SHORT12,&asdata1) || 
	   asdata1[0] != -65 || asdata1[1] != -66)
          kprintf("\tunable to get %s attribute\n", SHORT12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,SHORT12,outfile))
	    kprintf("\tunable to print %s attribute\n",SHORT12);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,SHORT22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", SHORT22);
	if(!kdms_get_attribute(c,NULL,SHORT22,&asdata1,&asdata2) || 
	   asdata1[0] != -65 || asdata1[1] != -66 ||
	   asdata2[0] != -67 || asdata2[1] != -68)
          kprintf("\tunable to get %s attribute\n", SHORT22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,SHORT22,outfile))
	    kprintf("\tunable to print %s attribute\n", SHORT22);
          else
	     kprintf("\n");
	}
	kprintf("\n");
	
/*
 * testing unsigned short data.
 */
        kprintf("   KUSHORT...\n");
        if (!kdms_query_attribute(c,NULL,USHORT11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KUSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", USHORT11);
	if(!kdms_get_attribute(c,NULL,USHORT11,&usdata1) || usdata1 != 65)
          kprintf("\tunable to get %s attribute\n", USHORT11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,USHORT11,outfile))
	    kprintf("\tunable to print %s attribute\n", USHORT11);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,USHORT21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KUSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", USHORT11);
	if(!kdms_get_attribute(c,NULL,USHORT21,&usdata1,&usdata2) || 
	   usdata1 != 65 || usdata2 != 66)
          kprintf("\tunable to get %s attribute\n",USHORT21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,USHORT21,outfile))
	    kprintf("\tunable to print %s attribute\n",USHORT21);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,USHORT12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KUSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", USHORT12);
	if(!kdms_get_attribute(c,NULL,USHORT12,&ausdata1) || 
	   ausdata1[0] != 65 || ausdata1[1] != 66)
          kprintf("\tunable to get %s attribute\n",USHORT12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,USHORT12,outfile))
	    kprintf("\tunable to print %s attribute\n",USHORT12);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,USHORT22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KUSHORT || perm != 1)
          kprintf("\tunable to query %s attribute\n", USHORT22);
	if(!kdms_get_attribute(c,NULL,USHORT22,&ausdata1,&ausdata2) || 
	   ausdata1[0] != 65 || ausdata1[1] != 66 ||
	   ausdata2[0] != 67 || ausdata2[1] != 68)
          kprintf("\tunable to get %s attribute\n",USHORT22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,USHORT22,outfile))
	    kprintf("\tunable to print %s attribute\n",USHORT22);
          else
	     kprintf("\n");
	}
	kprintf("\n");

/*
 * testing int data.
 */

        kprintf("   KINT... \n");
        if (!kdms_query_attribute(c,NULL,INT11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", INT11);
	if(!kdms_get_attribute(c,NULL,INT11,&idata1) || idata1 != -65)
          kprintf("\tunable to get %s attribute\n",INT11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,INT11,outfile))
	    kprintf("\tunable to print %s attribute\n",INT11);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,INT21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", INT21);
	if(!kdms_get_attribute(c,NULL,INT21,&idata1,&idata2) || 
	   idata1 != -65 || idata2 != -66)
          kprintf("\tunable to get %s attribute\n",INT21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,INT21,outfile))
	    kprintf("\tunable to print %s attribute\n",INT21);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,INT12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", INT12);
	if(!kdms_get_attribute(c,NULL,INT12,&aidata1) || 
	   aidata1[0] != -65 || aidata1[1] != -66)
          kprintf("\tunable to get %s attribute\n");
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,INT12,outfile))
	    kprintf("\tunable to print %s attribute\n",INT12);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,INT22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", INT22);
	if(!kdms_get_attribute(c,NULL,INT22,&aidata1,&aidata2) || 
	   aidata1[0] != -65 || aidata1[1] != -66 ||
	   aidata2[0] != -67 || aidata2[1] != -68)
          kprintf("\tunable to get %s attribute\n",INT22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,INT22,outfile))
	    kprintf("\tunable to print %s attribute\n",INT22);
          else
	     kprintf("\n");
	}
	kprintf("\n");
	
/*
 * testing unsigned int data.
 */

        kprintf("   KUINT... \n");
        if (!kdms_query_attribute(c,NULL,UINT11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KUINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", UINT11);
	if(!kdms_get_attribute(c,NULL,UINT11,&uidata1) || uidata1 != 65)
          kprintf("\tunable to get %s attribute\n",UINT11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UINT11,outfile))
	    kprintf("\tunable to print %s attribute\n",UINT11);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,UINT21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KUINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", UINT21);
	if(!kdms_get_attribute(c,NULL,UINT21,&uidata1,&uidata2) || 
	   uidata1 != 65 || uidata2 != 66)
          kprintf("\tunable to get %s attribute\n",UINT21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UINT21,outfile))
	    kprintf("\tunable to print %s attribute\n",UINT21);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,UINT12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KUINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", UINT12);
	if(!kdms_get_attribute(c,NULL,UINT12,&auidata1) || 
	   auidata1[0] != 65 || auidata1[1] != 66)
          kprintf("\tunable to get %s attribute\n",UINT12);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UINT12,outfile))
	    kprintf("\tunable to print %s attribute\n",UINT12);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,UINT22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KUINT || perm != 1)
          kprintf("\tunable to query %s attribute\n", UINT22);
	if(!kdms_get_attribute(c,NULL,UINT22,&auidata1,&auidata2) || 
	   auidata1[0] != 65 || auidata1[1] != 66 ||
	   auidata2[0] != 67 || auidata2[1] != 68)
          kprintf("\tunable to get %s attribute\n",UINT22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,UINT22,outfile))
	    kprintf("\tunable to print %s attribute\n",UINT22);
          else
	     kprintf("\n");
	}
	kprintf("\n");

/*
 * testing long data.
 */

#define LONG11 "long 1 1"	

        kprintf("   KLONG... \n");
        if (!kdms_query_attribute(c,NULL,LONG11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KLONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", LONG11);
	if(!kdms_get_attribute(c,NULL,LONG11,&ldata1) || ldata1 != -65)
          kprintf("\tunable to get %s attribute",LONG11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,LONG11,outfile))
	    kprintf("\tunable to print %s attribute",LONG11);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,LONG21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KLONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", LONG11);
	if(!kdms_get_attribute(c,NULL,LONG21,&ldata1,&ldata2) || 
	   ldata1 != -65 || ldata2 != -66)
          kprintf("\tunable to get %s attribute\n",LONG21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,LONG21,outfile))
	    kprintf("\tunable to print %s attribute\n",LONG21);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,LONG12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KLONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", LONG12);
	if(!kdms_get_attribute(c,NULL,LONG12,&aldata1) || 
	   aldata1[0] != -65 || aldata1[1] != -66)
          kprintf("\tunable to get %s attribute\n",LONG12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,LONG12,outfile))
	    kprintf("\tunable to print %s attribute\n",LONG12);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,LONG22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KLONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", LONG22);
	if(!kdms_get_attribute(c,NULL,LONG22,&aldata1,&aldata2) || 
	   aldata1[0] != -65 || aldata1[1] != -66 ||
	   aldata2[0] != -67 || aldata2[1] != -68)
          kprintf("\tunable to get %s attribute\n",LONG22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,LONG22,outfile))
	    kprintf("\tunable to print %s attribute\n",LONG22);
          else
	     kprintf("\n");
	}
	kprintf("\n");
	
/*
 * testing unsigned long data.
 */

#define ULONG11 "unsigned long 1 1"

        kprintf("   KULONG... \n");
        if (!kdms_query_attribute(c,NULL,ULONG11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KULONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", ULONG11);
	if(!kdms_get_attribute(c,NULL,ULONG11,&uldata1) || uldata1 != 65)
          kprintf("\tunable to get %s attribute\n",ULONG11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,ULONG11,outfile))
	    kprintf("\tunable to print %s attribute\n",ULONG11);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,ULONG21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KULONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", ULONG21);
	if(!kdms_get_attribute(c,NULL,ULONG21,&uldata1,&uldata2) || 
	   uldata1 != 65 || uldata2 != 66)
          kprintf("\tunable to get %s attribute\n",ULONG21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,ULONG21,outfile))
	    kprintf("\tunable to print %s attribute\n",ULONG21);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,ULONG12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KULONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", ULONG12);
	if(!kdms_get_attribute(c,NULL,ULONG12,&auldata1) || 
	   auldata1[0] != 65 || auldata1[1] != 66)
          kprintf("\tunable to get %s attribute\n",ULONG12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,ULONG12,outfile))
	    kprintf("\tunable to print %s attribute\n",ULONG12);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,ULONG22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KULONG || perm != 1)
          kprintf("\tunable to query %s attribute\n", ULONG22);
	if(!kdms_get_attribute(c,NULL,ULONG22,&auldata1,&auldata2) || 
	   auldata1[0] != 65 || auldata1[1] != 66 ||
	   auldata2[0] != 67 || auldata2[1] != 68)
          kprintf("\tunable to get %s attribute\n",ULONG22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,ULONG22,outfile))
	    kprintf("\tunable to print %s attribute\n",ULONG22);
          else
	     kprintf("\n");
	}
	kprintf("\n");

/*
 * testing float data.
 */

        kprintf("   KFLOAT... \n");
        if (!kdms_query_attribute(c,NULL,FLOAT11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KFLOAT || perm != 1)
          kprintf("\tunable to query %s attribute\n", FLOAT11);
	if(!kdms_get_attribute(c,NULL,FLOAT11,&fdata1) || 
	   fdata1 != (float) -65.12)
          kprintf("\tunable to get %s attribute\n",FLOAT11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,FLOAT11,outfile))
	    kprintf("\tunable to print %s attribute\n",FLOAT11);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,FLOAT21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KFLOAT || perm != 1)
          kprintf("\tunable to query %s attribute\n", FLOAT21);
	if(!kdms_get_attribute(c,NULL,FLOAT21,&fdata1,&fdata2) || 
	   fdata1 != (float) -65.12 || fdata2 != (float) -66.34)
          kprintf("\tunable to get %s attribute\n",FLOAT21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,FLOAT21,outfile))
	    kprintf("\tunable to print %s attribute\n",FLOAT21);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,FLOAT12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KFLOAT || perm != 1)
          kprintf("\tunable to query %s attribute\n", FLOAT12);
	if(!kdms_get_attribute(c,NULL,FLOAT12,&afdata1) || 
	   afdata1[0] != (float) -65.12 || afdata1[1] != (float) -66.34)
          kprintf("\tunable to get %s attribute\n",FLOAT12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,FLOAT12,outfile))
	    kprintf("\tunable to print %s attribute\n",FLOAT12);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,FLOAT22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KFLOAT || perm != 1)
          kprintf("\tunable to query %s attribute\n", FLOAT22);
	if(!kdms_get_attribute(c,NULL,FLOAT22,&afdata1,&afdata2) || 
	   afdata1[0] != (float) -65.12 || afdata1[1] != (float) -66.34 ||
	   afdata2[0] != (float) -67.56 || afdata2[1] != (float) -68.78)
          kprintf("\tunable to get %s attribute\n",FLOAT22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,FLOAT22,outfile))
	    kprintf("\tunable to print %s attribute\n",FLOAT22);
          else
	     kprintf("\n");
	}
	kprintf("\n");
	
/*
 * testing double data.
 */

        kprintf("   KDOUBLE... \n");
        if (!kdms_query_attribute(c,NULL,DOUBLE11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KDOUBLE || perm != 1)
          kprintf("\tunable to query %s attribute\n", DOUBLE11);
	if(!kdms_get_attribute(c,NULL,DOUBLE11,&ddata1) || ddata1 != 65.12)
          kprintf("\tunable to get %s attribute\n",DOUBLE11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DOUBLE11,outfile))
	    kprintf("\tunable to print %s attribute\n",DOUBLE11);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,DOUBLE21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KDOUBLE || perm != 1)
          kprintf("\tunable to query %s attribute\n", DOUBLE21);
	if(!kdms_get_attribute(c,NULL,DOUBLE21,&ddata1,&ddata2) || 
	   ddata1 != 65.12 || ddata2 != 66.34)
          kprintf("\tunable to get %s attribute\n",DOUBLE21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DOUBLE21,outfile))
	    kprintf("\tunable to print %s attribute\n",DOUBLE21);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,DOUBLE12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KDOUBLE || perm != 1)
          kprintf("\tunable to query %s attribute\n", DOUBLE12);
	if(!kdms_get_attribute(c,NULL,DOUBLE12,&addata1) || 
	   addata1[0] != 65.12 || addata1[1] != 66.34)
          kprintf("\tunable to get %s attribute\n",DOUBLE12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DOUBLE12,outfile))
	    kprintf("\tunable to print %s attribute\n",DOUBLE12);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,DOUBLE22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KDOUBLE || perm != 1)
          kprintf("\tunable to query %s attribute\n", DOUBLE22);
	if(!kdms_get_attribute(c,NULL,DOUBLE22,&addata1,&addata2) || 
	   addata1[0] != 65.12 || addata1[1] != 66.34 ||
	   addata2[0] != 67.56 || addata2[1] != 68.78)
          kprintf("\tunable to get %s attribute\n",DOUBLE22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DOUBLE22,outfile))
	    kprintf("\tunable to print %s attribute\n",DOUBLE22);
          else
	     kprintf("\n");
	}
	kprintf("\n");
	
/*
 * testing kcomplex data.
 */
        kprintf("   KCOMPLEX... \n");
        if (!kdms_query_attribute(c,NULL,COMPLEX11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", COMPLEX11);
	if(!kdms_get_attribute(c,NULL,COMPLEX11,&kcdata1) || 
	   kcreal(kcdata1) != 65.0 || kcimag(kcdata1) != 66.0)
          kprintf("\tunable to get %s attribute\n",COMPLEX11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,COMPLEX11,outfile))
	    kprintf("\tunable to print %s attribute\n",COMPLEX11);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,COMPLEX21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", COMPLEX21);
	if(!kdms_get_attribute(c,NULL,COMPLEX21,&kcdata1,&kcdata2) || 
	   kcreal(kcdata1) != 65.0 || kcimag(kcdata1) != 66.0 ||
	   kcreal(kcdata2) != 67.0 || kcimag(kcdata2) != 68.0)
          kprintf("\tunable to get %s attribute\n",COMPLEX21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,COMPLEX21,outfile))
	    kprintf("\tunable to print %s attribute\n",COMPLEX21);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,COMPLEX12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", COMPLEX12);
	if(!kdms_get_attribute(c,NULL,COMPLEX12,&akcdata1) || 
	   kcreal(akcdata1[0]) != 65.0 || kcimag(akcdata1[0]) != 66.0 ||
	   kcreal(akcdata1[1]) != 67.0 || kcimag(akcdata1[1]) != 68.0)
          kprintf("\tunable to get %s attribute\n",COMPLEX12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,COMPLEX12,outfile))
	    kprintf("\tunable to print %s attribute\n",COMPLEX12);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,COMPLEX22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", COMPLEX22);
	if(!kdms_get_attribute(c,NULL,COMPLEX22,&akcdata1,&akcdata2) || 
	   kcreal(akcdata1[0]) != 65.0 || kcimag(akcdata1[0]) != 66.0 ||
	   kcreal(akcdata1[1]) != 67.0 || kcimag(akcdata1[1]) != 68.0 ||
	   kcreal(akcdata2[0]) != 69.0 || kcimag(akcdata2[0]) != 70.0 ||
	   kcreal(akcdata2[1]) != 71.0 || kcimag(akcdata2[1]) != 72.0)
          kprintf("\tunable to get %s attribute\n",COMPLEX22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,COMPLEX22,outfile))
	    kprintf("\tunable to print %s attribute\n",COMPLEX22);
          else
	     kprintf("\n");
	}
	kprintf("\n");

/*
 * testing kdcomplex data.
 */
        kprintf("   KDCOMPLEX... \n");
        if (!kdms_query_attribute(c,NULL,DCOMPLEX11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KDCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", DCOMPLEX11);
	if(!kdms_get_attribute(c,NULL,DCOMPLEX11,&kdcdata1) || 
	   kdcreal(kdcdata1) != 65.0 || kdcimag(kdcdata1) != 66.0)
          kprintf("\tunable to get %s attribute\n",DCOMPLEX11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DCOMPLEX11,outfile))
	    kprintf("\tunable to print %s attribute\n",DCOMPLEX11);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,DCOMPLEX21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KDCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", DCOMPLEX21);
	if(!kdms_get_attribute(c,NULL,DCOMPLEX21,&kdcdata1,&kdcdata2) || 
	   kdcreal(kdcdata1) != 65.0 || kdcimag(kdcdata1) != 66.0 ||
	   kdcreal(kdcdata2) != 67.0 || kdcimag(kdcdata2) != 68.0)
          kprintf("\tunable to get %s attribute\n",DCOMPLEX21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DCOMPLEX21,outfile))
	    kprintf("\tunable to print %s attribute\n",DCOMPLEX21);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,DCOMPLEX12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KDCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", DCOMPLEX12);
	if(!kdms_get_attribute(c,NULL,DCOMPLEX12,&akdcdata1) || 
	   kdcreal(akdcdata1[0]) != 65.0 || kdcimag(akdcdata1[0]) != 66.0 ||
	   kdcreal(akdcdata1[1]) != 67.0 || kdcimag(akdcdata1[1]) != 68.0)
          kprintf("\tunable to get %s attribute\n",DCOMPLEX12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DCOMPLEX12,outfile))
	    kprintf("\tunable to print %s attribute\n",DCOMPLEX12);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,DCOMPLEX22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KDCOMPLEX || perm != 1)
          kprintf("\tunable to query %s attribute\n", DCOMPLEX22);
	if(!kdms_get_attribute(c,NULL,DCOMPLEX22,&akdcdata1,&akdcdata2) || 
	   kdcreal(akdcdata1[0]) != 65.0 || kdcimag(akdcdata1[0]) != 66.0 ||
	   kdcreal(akdcdata1[1]) != 67.0 || kdcimag(akdcdata1[1]) != 68.0 ||
	   kdcreal(akdcdata2[0]) != 69.0 || kdcimag(akdcdata2[0]) != 70.0 ||
	   kdcreal(akdcdata2[1]) != 71.0 || kdcimag(akdcdata2[1]) != 72.0)
          kprintf("\tunable to get %s attribute\n",DCOMPLEX22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,DCOMPLEX22,outfile))
	    kprintf("\tunable to print %s attribute\n",DCOMPLEX22);
          else
	     kprintf("\n");
	}
	kprintf("\n");

/*
 * testing kstring data.
 */
        kprintf("   KSTRING... \n");
        if (!kdms_query_attribute(c,NULL,STRING11,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 1 || dtyp != KSTRING || perm != 1)
          kprintf("\tunable to query %s attribute\n", STRING11);
	if(!kdms_get_attribute(c,NULL,STRING11,&stdata1) || 
	   ( kstrcmp(stdata1, "string1") != 0) )
          kprintf("\tunable to get %s attribute\n",STRING11);
	else {
	  kprintf("   1 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,STRING11,outfile))
	    kprintf("\tunable to print %s attribute\n",STRING11);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,STRING21,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 1 || dtyp != KSTRING || perm != 1)
          kprintf("\tunable to query %s attribute\n", STRING21);
	if(!kdms_get_attribute(c,NULL,STRING21,&stdata1,&stdata2) || 
	   ( kstrcmp(stdata1, "string1") != 0) ||
	   ( kstrcmp(stdata2, "string2") != 0) )
          kprintf("\tunable to get %s attribute\n",STRING21);
	else {
	  kprintf("   2 arg  1 value OK : ");
	  if (!kdms_print_attribute(c,NULL,STRING21,outfile))
	    kprintf("\tunable to print %s attribute\n",STRING21);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,STRING12,&narg,&asiz,&dtyp,&perm) ||
	       narg != 1 || asiz != 2 || dtyp != KSTRING || perm != 1)
          kprintf("\tunable to query %s attribute\n", STRING12);
	if(!kdms_get_attribute(c,NULL,STRING12,&astdata1) || 
	   ( kstrcmp(astdata1[0], "string1") != 0) ||
	   ( kstrcmp(astdata1[1], "string2") != 0) )
          kprintf("\tunable to get %s attribute\n",STRING12);
	else {
	  kprintf("   1 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,STRING12,outfile))
	    kprintf("\tunable to print %s attribute\n",STRING12);
          else
	     kprintf("\n");
	}

        if (!kdms_query_attribute(c,NULL,STRING22,&narg,&asiz,&dtyp,&perm) ||
	       narg != 2 || asiz != 2 || dtyp != KSTRING || perm != 1)
          kprintf("\tunable to query %s attribute\n", STRING22);
	if(!kdms_get_attribute(c,NULL,STRING22,&astdata1,&astdata2) || 
	   ( kstrcmp(astdata1[0], "string1") != 0) ||
	   ( kstrcmp(astdata1[1], "string2") != 0) ||
	   ( kstrcmp(astdata2[0], "string3") != 0) ||
	   ( kstrcmp(astdata2[1], "string4") != 0))
          kprintf("\tunable to get %s attribute\n",STRING22);
	else {
	  kprintf("   2 arg  2 value OK : ");
	  if (!kdms_print_attribute(c,NULL,STRING22,outfile))
	    kprintf("\tunable to print %s attribute\n",STRING22);
          else
	     kprintf("\n");
	}

/*
 * the end
 */
	kdms_close(c);

	kexit(0);
}
