/*
 *  The following test program is used to show what appears to be a bug
 *  in the segment creation.  There is two mechanism used, the first which
 *  mallocs the data does not work.  The second, which uses the dataservices
 *  get data to initialize the data does work.  So the two secenarios are:
 *
 *
 *      1) create and initialize segment
 *      2) malloc region data
 *      3) put region into segment
 *
 *  The above does not work as expected.  The output file appears to be
 *  correct, but if you check the size, there is no actual data stored, just
 *  the correctly assigned segment attributes.
 *
 *  The second scenario is to use kpds_get_data() to malloc and initialize the
 *  pad value, so it looks more like:
 *
 *      1) create and initialize segment
 *      2) get region from segment
 *      3) put region into segment
 *
 *  So the only difference was that the first secenario doesn't do the
 *  get_data, but explicitly creates the data itself.
 */
#include <dataserv.h>

main(
   int  argc,
   char **argv,
   char **envp)
{
        kobject  object;
        unsigned char *data;
        int      i, w = 512, h = 512, d = 1, t = 1, e = 1;
 
 
        khoros_initialize(argc, argv, envp, "XVISUAL");
        if ((object = kpds_open_output_object("junk.xv")) == NULL)
        {
           kerror(NULL, "example", "Failed to open output object 'junk.xv'.");
           kexit(KEXIT_FAILURE);
        }
 
        kpds_create_value(object);
        kpds_set_attributes(object,
           KPDS_VALUE_SIZE, w, h, d, t, e,
           KPDS_VALUE_DATA_TYPE, KUBYTE,
           KPDS_VALUE_POSITION, 0, 0, 0, 0, 0,
           KPDS_VALUE_OFFSET, 0, -256, 0, 0, 0,
           KPDS_VALUE_REGION_SIZE,  w, h, d, t, e,
           NULL);
 
#if 1
        if ((data = kmalloc(w*h*d*t*e)) == NULL)
        {
           kerror(NULL, "example", "Failed to malloc data for output object.");
           kexit(KEXIT_FAILURE);
        }
#else
        if ((data = kpds_get_data(object, KPDS_VALUE_REGION, NULL)) == NULL)
        {
           kerror(NULL, "example", "Failed to get data from output object.");
           kexit(KEXIT_FAILURE);
        }
#endif
        for (i = 0; i < w*h*d*t*e; i++)
           data[i] = i % 256;
 
        kpds_put_data(object, KPDS_VALUE_REGION, data);
        kpds_close_object(object);
        kexit(KEXIT_SUCCESS);
}
