 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Internal Data Services Declaration
   >>>>
   >>>>    Written By: Mark Young & Jeremy Worley
   >>>>
   >>>>          Date: Jul 13, 1992 16:45
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _internals_h_
#define _internals_h_

 /*-------------------------------------*
 |       #include
 ---------------------------------------*/

#include <dataserv.h>
#include "attributes.h"
#include "segue.h"


 /*-------------------------------------*
 |       #defines
 ---------------------------------------*/

/*
 * note:  this should match the _INTERNAL_COLORSPACE used in 
 * kappser/internals.h.  This is done because the print attribute in
 * kappserv for colorspace is colliding with the xvimage creation
 * of the KCOLOR_COLORSPACE attribute, when xvimage should be using
 * the internal one...
 */
#define _INTERNAL_COLORSPACE "colorspace"


 /*-------------------------------------*
 |       typedefs
 ---------------------------------------*/

typedef struct _presentation kpresentation;

/*
 * this is for sanity because nearly all dbx (not gdb) get totally
 * baffled and insist on resolving to the wrong kobject.
 */
typedef struct _kobject _data_object;

typedef struct _callback {
   union 
   {
      void (*data) PROTO((kobject, char *, kaddr, kdms_callback *));
      void (*object) PROTO((kobject, char *, kaddr));
   }
   callback;
   
   kobject object;
   int segment;
   int type;
   char *whence;
   kaddr clientData;
} kcallback;

/*
 * Physical layer of main object
 */
typedef struct _physobject {
   char *filename;	/* this is the *real* filename of the file */
   int flags;		/* read/write/etc. flags for opening the file */
   int temporary;	/* if TRUE, the file is the temporary file */
   int protected;	/* if TRUE, the original file should not be written
			 * to on closure.  This is very important now that we
			 * have write-able input objects */
   int locked;
   int headerless;

   /*
    * a close hook...do this thing whenever we close the object
    */
   /*kfunc_int close_hook;*/
   int (*close_hook) PROTO((kobject));

   /*
    * The "resources" structure is an internal pointer used by each of the
    * different service formats.  When initiailized the resource pointer is
    * used to hold specific information necessary for the correct data
    * manipultion routines.  The different routines are called via the
    * "DataServiceRoutine" structure.
    */
   kaddr resources;
   struct _data_service_info *routines;

   /*
    * User defined object level attributes at the physical level
    */
   kdms_attribute_list *attributes;

   /*
    * callback stuff
    */
   int num_callbacks;
   kcallback **callbacks;

   /*
    * list of referenced object
    */
   klist *list;

} kphysobj;
 
/*
 *   Definition for data service structure, used by the internal data object
 *   manipulation routines.  This structure should not be manipulated by the
 *   application programmer but used as the "id" parameter for the public
 *   data service routines.
 */
struct _kobject {
   int type;	/* kobject identifier */

   kphysobj *phys;

   /*
    * User defined object level attributes at the presentation level
    */
   kdms_attribute_list *attributes;

   /*
    * The following list of data segment structures allow the data services
    * library direct access to the internal object's data structure. The
    * following list of attribute structure contain the presentation
    * attributes used
    */
   klist *presentations;
};

/*
 *  This is the core data structure for data services.  It is thru this
 *  structure that data services can get direct access to the object's
 *  data.
 */

typedef struct _kdsegment {
   int id;
   kfile *file;
   int temporary;	/* is the file descriptor pointing to a tmp */
   int permanence;      /* TRUE if this segment gets saved on close */
   kaddr data;

   int datatype;

   int dimension;
   int *begin;
   int *end;
   int *size;
   int *order;

   int *outerbound;     /* used to maintain outer bounding box of data written
			   to the *temporary* file.  Not used with permanent
			   file. */
   
   int buffer_threshold; /* maximum desirable size of a buffer of data */

   int initialized;	/* this segment has been initialized */
   int locked;		/* has the segment been locked */
   int update;          /* this segment requires updating at the next flush*/

   /*
    * user defined segment level attributes at the physical level
    */
   kdms_attribute_list *attributes;

   /*
    * callback stuff
    */
   int num_callbacks;
   kcallback **callbacks;

   klist *list;
} kdsegment;

/*
 *  These are the presentation resources or attributes that can be changed
 *  by the programmer at any time.
 */
struct _presentation {
   int id;	/* tokenized name of presentation */
   kdsegment *segment;

   /*
    * user defined segment level attributes at the presentation level
    */
   kdms_attribute_list *attributes;

   int datatype;

   int dimension;
   int *size;
   int *order;
   int *offset;
   
   int ragged;
   int coupling;

   int complex_convert;
   int interp;

   double pad_real;
   double pad_imag;

   int scaling;
   double scale_factor;
   double scale_offset_real;
   double scale_offset_imag;
   double norm_min;
   double norm_max;
};

/*
 *  Internal data services driver routines for manipulating the different
 *  data formats.
 */
typedef struct _data_service_info {
   char  *label;
   char  *identifier;
   int   (*check)          PROTO((int));
   int   (*input)          PROTO((kobject, int, int));
   int   (*output)         PROTO((kobject, int, int));
   int   (*destroy)        PROTO((kobject));
   kaddr (*read)           PROTO((kobject, int, kaddr *, int *, int *));
   int   (*write)          PROTO((kobject, int, kaddr, int *, int *));
   int   (*order)          PROTO((char *, int *));
   int   (*get_architecture)   PROTO((kobject));
   int   (*set_architecture)   PROTO((kobject, int));
   int   (*lock)            PROTO((kobject, int));
} DataServiceInformation;

struct _segment_info {
   int token;
   char *name;
   int dimensions;
   int default_order[5];
   int vector_def;
};

 /*-------------------------------------*
 |       global variable declarations
 ---------------------------------------*/

 /*-------------------------------------*
 |       macros
 ---------------------------------------*/

/*
 * a nifty macro to issue a message in addition to setting errno
 * when debug is defined
 */
#define _kdms_set_error(num) \
   { \
     errno = num; \
     kinfo(KDEBUG,"%s:%d\t%s\n",__FILE__,__LINE__,kerrno_lookup(num)); \
   }

/*
 * generate a traceback message
 */
#define _kdms_traceback(a) \
        kinfo(KDEBUG,"%s:%s()\tline %d\n",__FILE__,a,__LINE__)

/*
 * Ok.  On the alphas, ints and pointers are of different sizes, which
 * causes gcc to complain.  This may seem like dumb, but its nice to 
 * have code compile cleanly on all architectures.  Besides, I usually
 * assume that klist_identifier returns an int.
 */
#define klist_token(a) ((int)((long)klist_identifier(a)))


 /*-------------------------------------*
 |       routine definitions
 ---------------------------------------*/

/*
 * stuff in Glue.c
 */
extern void  _kdms_init_formats PROTO((void));
extern int   _kdms_glue_input PROTO((kobject, char *, int));
extern int   _kdms_glue_output PROTO((kobject, char *, int));
extern int   _kdms_glue_destroy PROTO((kobject));
extern int   _kdms_glue_order PROTO((kobject, char *, int *));
extern char* _kdms_glue_identifier PROTO((kobject));
extern kaddr  _kdms_glue_read_data PROTO((kobject, int, kaddr *, int *, int *));
extern int   _kdms_glue_write_data PROTO((kobject, int, kaddr, int *, int *));
extern int   _kdms_glue_get_architecture PROTO((kobject));
extern int   _kdms_glue_set_architecture PROTO((kobject, int));
extern int   _kdms_glue_write_segment_data PROTO((kaddr, int, 
						 kfunc_int, kfunc_int,
                   int, int, int, int *, int *, kaddr, int *, int *));
extern kaddr _kdms_glue_read_segment_data PROTO((kaddr, int, 
						kfunc_int, kfunc_int,
                   int, int, int, int *, int *, kaddr *, int *, int *));
extern kaddr _kdms_glue_get_resources PROTO((kobject));
extern int   _kdms_glue_set_resources PROTO((kobject, kaddr));
extern kaddr __kdms_glue_rw_segment_data PROTO((kaddr, int, kfunc_int, 
                   kfunc_int, int, int, int, int *, int *, kaddr *, int *, 
                   int *));
extern DataServiceInformation * _kdms_glue_routines PROTO((char *));
extern char ** _kdms_glue_support PROTO((int *));
extern int _kdms_glue_lock PROTO((kobject, int));

/* 
 *  private routines found in attributes.c
 *  - note this can not go in attributes.h because of the kpresentation 
 *    used in the prototype for kdms_free_pres_attributes
 */
kdms_attribute *kdms_establish_attribute PROTO((kdms_attribute_list **, 
						kdms_attribute *));

int kdms_get_Vattribute         PROTO((kobject, char *, char *, kaddr *));
int kdms_set_Vattribute         PROTO((kobject, char *, char *, kaddr));
int kdms_free_segment_attributes   PROTO((kpresentation *));
int kdms_free_pres_attributes   PROTO((kpresentation *));
int kdms_free_object_attributes PROTO((kobject));
void kdms_free_attribute_defins PROTO((void));

/*
 *  internal routines found in admin.c
 */
extern kobject _kdms_create PROTO((void));
extern kobject _kdms_open PROTO((char *, int));
extern int     _kdms_close PROTO((kobject, int));
extern int     _kdms_lock PROTO((kobject));
extern kobject _kdms_reference PROTO((kobject));
extern int     _kdms_copy_data PROTO((kobject, int, kobject, int));
extern kobject _kdms_locate PROTO((char *));
extern int     _kdms_sync PROTO((kobject, char *, int));
extern int     _kdms_update_references PROTO((kobject, char *));
extern kobject _kdms_reopen PROTO((kobject, char *, int));
extern int     _kdms_copy_remaining_data PROTO((kobject, kobject));

/*
 * routines from callbacks.c
 */
extern int _kdms_process_data_callbacks PROTO((kobject, kpresentation *, 
               int *, int *, char *));
extern int _kdms_process_object_callbacks PROTO((kobject object, char *type));
extern int _kdms_remove_all_callbacks PROTO((kobject));
extern int _kdms_disable_callbacks PROTO((void));
extern int _kdms_enable_callbacks PROTO((void));
extern int _kdms_delete_object_callbacks PROTO((kobject, int));

/*
 *  internal routines found in data.c
 */
extern kaddr _kdms_get_data PROTO((kobject, kpresentation *, int *, int *, 
                     kaddr));
extern int   _kdms_put_data PROTO((kobject, kpresentation *, int *, int *, 
                     kaddr));
extern int   _kdms_flush_segment PROTO((kobject, kpresentation *));
extern int   _kdms_flush_segments PROTO((kobject));
extern void  _kdms_free_pipeline_memory PROTO((void));

/*
 *  internal routines found in segment.c
 */
extern int _kdms_get_segment_info PROTO((kobject, int, kpresentation **));
extern int _kdms_set_segment_info PROTO((kobject, int, kpresentation *));
extern int _kdms_create_segment PROTO((kobject, int, kpresentation *));
extern int _kdms_destroy_segment PROTO((kobject, int));
extern int _kdms_destroy_segments PROTO((kobject));
extern int _kdms_lock_segment PROTO((kobject, kpresentation *));
extern int _kdms_lock_segments PROTO((kobject));
extern int _kdms_reference_segments PROTO((kobject, kobject));
extern int _kdms_establish_segment PROTO((kobject, int, kobject, int));
extern int _kdms_set_segment PROTO((kobject, char *, kaddr, int, int *, 
		    int *, int *, int *, int));
extern int _kdms_get_segment PROTO((kobject, char *, kaddr *, int *, int **, 
                    int **, int **, int **, int *));
extern int _kdms_update_segment PROTO((kobject, kpresentation *));
extern int _kdms_initialize_segment PROTO((kpresentation *));
extern int _kdms_migrate_segment_data PROTO((kobject, kpresentation *, 
                    kobject, kpresentation *));
extern int _kdms_copy_pres_struct PROTO((kpresentation *, kpresentation *));
extern int _kdms_rename_segment PROTO((kobject object, char *old_name, 
				       char *new_name));

/*
 *  segue.c
 */
void kdms_free_segment_defins PROTO((void));

/*
 * errors.c
 */
extern void _kdms_init_errors PROTO((void));

/*
 * init
 */
extern int _kdms_init PROTO((void));

/*
 * routines from transport.c
 */
extern kaddr _kdms_transport_segment_data PROTO((kaddr, int, kfunc_int, 
						 kfunc_int, int, int, int,
						 int *, int *, kaddr *, 
						 int *, int *));
extern int    _kdms2kfile_flags PROTO((int));
extern int    _kdms_write_data PROTO((kobject, kdsegment *, int *, int *));
extern char * _kdms_read_data PROTO((kobject, kdsegment *, int *, int *));
extern int    _kdms_read_buffer PROTO((kobject, kdsegment *, int *, int *));
extern int    _kdms_make_temporary PROTO((kobject, kpresentation *));
extern int    _kdms_merge_temps PROTO((kobject));
extern int    _kdms_copy_temps PROTO((kobject));

/*
 * internal routines found in utility.c
 */
extern int _kdms_buffer_offset PROTO((int *, int *, int, int));
extern int _kdms_num_elements PROTO((int *, int *, int));
extern int _kdms_in_buffer PROTO((kdsegment *, int *, int *));
extern int _kdms_in_space PROTO((kdsegment *, int *, int *));
extern int _kdms_in_pres_data_space PROTO((kpresentation *, int *, int *));
extern int _kdms_in_phys_data_space PROTO((kdsegment *, int *, int *));
extern int _kdms_pres2phys PROTO((kdsegment *, kpresentation *, int *, int *,
				 int));
extern int _kdms_translate_coords PROTO((int *, int *, int *, int *, int *, 
                 int *, int, int, int));
extern int _kdms_transpose_coords PROTO((int *, int *, int *, int *, int, int));
extern int _kdms_initialized PROTO((kobject));
extern int _kdms_preset_data PROTO((kaddr, int, int, double, double));
extern int _kdms_position_in_space PROTO((int *, int *, int));

extern int _kdms_legal_order PROTO((int *, int));
extern int _kdms_legal_size PROTO((int *, int));
extern int _kdms_legal_datatype PROTO((int));

extern int _kdms_compute_chunk_size PROTO((int *, int, int *, int, int));
extern int _kdms_advance_position PROTO((int*, int*, int*, int*, int));
extern int _kdms_get_buffer_threshold PROTO((kpresentation *));


#endif	/* _internals_h_ */

/* Don't add after this point */
