 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";

#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Khoros PNM Data Service Routines
   >>>>
   >>>>   Static:
   >>>>  Private:
   >>>>             pnm_check()
   >>>>             pnm_input()
   >>>>             pnm_output()
   >>>>             _init()
   >>>>             pnm_destroy()
   >>>>   Public:
   >>>>             None - no public should ever exist as these are
   >>>>                    internal routines only accessible via the
   >>>>                    DataServiceInformation *services[] structure.
   >>>>
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


#if !defined(KPNM_DEF)
DataServiceInformation pnm_format[] =
{NULL};

#else

#include "kdatafmt/pnm.h"

static int pnm_check PROTO((int));
static int pnm_input PROTO((kobject, int, int));
static int pnm_output PROTO((kobject, int, int));
static int pnm_destroy PROTO((kobject));

DataServiceInformation pnm_format[] =
{
   {
      "PBMPLUS's Portable Anymap File Format (pnm)",
      "pnm",
      pnm_check,
      pnm_input,
      pnm_output,
      pnm_destroy,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
   }
};

/*
 *  Internal Resource Structure for the following data services
 *
 *              pnm  -  PBMPLUS's Portable Anymap File Format (pnm)
 */
typedef struct
{
   pnm *image;
}
ResourceStruct;

/*-----------------------------------------------------------
|
|  Routine Name: _init - Creates an pnm image
|
|       Purpose: This function is used to create an pnm image.  Which
|                means that we use the current dimension values in order
|                to create a proper pnm.
|
|         Input: data - initial sample of data
|                num  - number of bytes in the sample
|
|        Output: Returns: returns TRUE or FALSE if an error occurs
|
|    Written By: Mark Young
|          Date: Jul 13, 1992 15:50
| Modifications:
|
------------------------------------------------------------*/

static int
_init(kobject object)
{
   ResourceStruct *resources;


   /*
    * Create the image to the object file
    */
   resources = (ResourceStruct *) kcalloc(1, sizeof(ResourceStruct));

   if (resources == NULL)
      return (FALSE);

   _kdms_glue_set_resources(object, resources);

   return (TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: pnm_check - Checks to see if the file is
|                                an pnm
|
|       Purpose: This function is used to check the first few bytes of
|                the stream to see if it is an pnm.
|
|         Input: object - the pnm object to be initialized
|
|        Output: Returns: returns TRUE or FALSE if an error occurs
|
|    Written By: Mark Young
|          Date: Jul 13, 1992 15:50
| Modifications:
|
------------------------------------------------------------*/

static int
pnm_check(int fid)
{
   char line[KLENGTH];
   kfile *file;

   file = kfdopen(fid, "r");
   
   if (!kfgets(line, KLENGTH, file))
      return (FALSE);           /* not an error */

   if (kstrncmp(line, "P1", 2) == 0 ||
       kstrncmp(line, "P2", 2) == 0 ||
       kstrncmp(line, "P3", 2) == 0 ||
       kstrncmp(line, "P4", 2) == 0 ||
       kstrncmp(line, "P5", 2) == 0 ||
       kstrncmp(line, "P6", 2) == 0)
   {
      return (TRUE);
   }
   return (FALSE);
}



/*-----------------------------------------------------------
|
|  Routine Name: pnm_input - Reda a pnm image
|
|       Purpose: This function is used to read in the image if the
|                supplied data is pnm image.  The data was checked
|                by the pnm_check() routine in which the pnm
|                identifier indicated that the data is a valid pnm.
|                Since the data was valid we can assume simply read
|                the header in and initialize that data segments.
|
|         Input: object - the pnm object to be initialized
|
|        Output: Returns: returns TRUE or FALSE if an error occurs
|
|    Written By: Mark Young
|          Date: Jul 13, 1992 15:50
| Modifications:
|
------------------------------------------------------------*/

/*ARGSUSED */
static int
pnm_input(kobject object, int fid, int flags)
{
   int type;
   int num_bands;
   int i;
   int size[KDMS_MAX_DIM],
      order[KDMS_MAX_DIM],
      begin[KDMS_MAX_DIM],
      end[KDMS_MAX_DIM];

   ResourceStruct *resources;
   pnm *image;

   if (!_kdms_initialized(object))
      _init(object);

   resources = (ResourceStruct *) _kdms_glue_get_resources(object);

   /*
    * Read the image from the object file and go ahead and set the pnm image
    * within the resource structure.
    */
   image = resources->image = pnm_fdread(fid);
   if (image == NULL)
   {
      _kdms_set_error(KDMS_EFMT_FAILURE);
      return (FALSE);
   }

   /*
    * Initialize the data segments according to the data found in the pnm
    * structure.
    * 
    * The pnm structure only contains value (image->data)
    */

   /* check the value data */
   if (image->data != NULL)
   {
      if (!kdms_query_attribute_definition(KDMS_OBJECT, _INTERNAL_COLORSPACE))
	 kdms_define_attribute(KDMS_OBJECT, _INTERNAL_COLORSPACE, 1, 1, KINT,
			       TRUE, TRUE,
			       KCOLOR_COLORSPACE_DEFAULT);

      if (image->type == PBM)
      {
         type = KBIT;
         num_bands = 1;
      }
      else
      {
         type = (image->raw) ? KUBYTE : KINT;
         num_bands = (image->type == PGM) ? 1 : 3;
      }
      if (num_bands == 1)
      {
	 size[0] = image->width;
	 size[1] = image->height;
	 size[2] = size[3] = size[4] = 1;

	 order[0] = KWIDTH;
	 order[1] = KHEIGHT;
	 order[2] = KDEPTH;
	 order[3] = KTIME;
	 order[4] = KELEMENTS;

	 kdms_set_attribute(object, NULL, _INTERNAL_COLORSPACE, KGREYSCALE);
      }
      else
      {
	 size[0] = num_bands;
	 size[1] = image->width;
	 size[2] = image->height;
	 size[3] = size[4] = 1;

	 order[0] = KELEMENTS;
	 order[1] = KWIDTH;
	 order[2] = KHEIGHT;
	 order[3] = KDEPTH;
	 order[4] = KTIME;

	 kdms_set_attribute(object, NULL, _INTERNAL_COLORSPACE, KRGB);
      }

      for (i = 0; i < KDMS_MAX_DIM; i++)
      {
         begin[i] = 0;
         end[i] = size[i] - 1;
      }

      _kdms_set_segment(object, KDMS_SEGMENT_VALUE, image->data, type,
                        order, size, begin, end, 5);

      /*
       * it is vitally important that you include this step because if the
       * data set larger than the buffer threshold, then spurous flushes
       * will ensue that should not happen...it turns out that xvimages and
       * viffs will cope with that situation (though not very efficiently),
       * but file formats that buffer the whole thing in memory won't.
       */
      kdms_set_attribute(object, KDMS_SEGMENT_VALUE, KDMS_COUPLING,KUNCOUPLED);
   }
   return (TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: pnm_output - Closes the pnm image
|
|       Purpose: This function is used to close the pnm image.  Which
|                means if the image was modified we then re-write image
|                back out.
|
|         Input: object - the pnm object to be closed
|
|        Output: Returns: returns TRUE or FALSE if an error occurs
|
|    Written By: Mark Young
|          Date: Jul 13, 1992 15:50
| Modifications:
|
------------------------------------------------------------*/

/*ARGSUSED */
static int
pnm_output(kobject object, int fid, int flags)
{
   ResourceStruct *resources;

   kaddr data = NULL;
   unsigned char *map_data = NULL;
   pnm *image;
   int  *size;
   int  *map_size = NULL;
   int i;
   int begin[5] = {0, 0, 0, 0, 0};
   int end[5];
   int type;
   int status;
   
   if (!_kdms_initialized(object))
      _init(object);

   resources = (ResourceStruct *) _kdms_glue_get_resources(object);


   if (resources->image == NULL)
   {
      resources->image = pnm_create(0, 0, PBM, FALSE);
      if (!resources->image)
      {
         _kdms_traceback("pnm_output");
         _kdms_set_error(KDMS_EFMT_FAILURE);
         return (FALSE);
      }
   }
   image = resources->image;

   /*
    * check the map data.  This sortof assumes that data will be loaded
    * with all of the data.  Hope that's true.  We're assuming alot
    * here, because we want map_data to be unsigned char, the index order
    * to be MAP_WIDTH, MAP_HEIGHT.
    */
   if (kdms_query_segment(object, KDMS_SEGMENT_MAP)) 
   {
      int order[KDMS_MAX_DIM] = {KMAP_WIDTH, KMAP_HEIGHT, KMAP_DEPTH, 
				 KMAP_TIME, KMAP_ELEMENTS};
      
      kdms_set_attributes(object, KDMS_SEGMENT_MAP, 
			  KDMS_COUPLING, KUNCOUPLED,
			  KDMS_DATA_TYPE, KUBYTE,
			  KDMS_INDEX_ORDER, order,
			  NULL);

      kdms_get_attribute(object, KDMS_SEGMENT_MAP, KDMS_SIZE, &map_size);
      end[0] = map_size[0] - 1;
      end[1] = map_size[1] - 1;
      end[2] = map_size[2] - 1;
      end[3] = map_size[3] - 1;
      end[4] = map_size[4] - 1;

      map_data = kdms_get_data(object, KDMS_SEGMENT_MAP, begin, end, NULL);
   }
      
   /* 
    * check the value data 
    */
   if (kdms_query_segment(object, KDMS_SEGMENT_VALUE))
   {
      int order[KDMS_MAX_DIM] = {KELEMENTS, KWIDTH, KHEIGHT, KDEPTH, KTIME};
      unsigned char *dta;

      kdms_get_attribute(object, KDMS_SEGMENT_VALUE, KDMS_DATA_TYPE, &type);

      kdms_set_attributes(object, KDMS_SEGMENT_VALUE,
			  KDMS_COUPLING, KUNCOUPLED,
			  KDMS_INDEX_ORDER, order,
			  NULL);

      if (type != KUBYTE && map_data == NULL) 
      {
	 kdms_set_attribute(object, KDMS_SEGMENT_VALUE, KDMS_DATA_TYPE, KINT);
	 image->raw = FALSE;
      }
      else
      {
	 kdms_set_attribute(object, KDMS_SEGMENT_VALUE, KDMS_DATA_TYPE,KUBYTE);
	 image->raw = TRUE;
      }
      
      kdms_get_attribute(object, KDMS_SEGMENT_VALUE, KDMS_SIZE, &size);
      
      image->width = size[1];
      image->height = size[2];

      end[0] = size[0] - 1;
      end[1] = size[1] - 1;
      end[2] = size[2] - 1;
      end[3] = size[3] - 1;
      end[4] = size[4] - 1;
      
      data = kdms_get_data(object, KDMS_SEGMENT_VALUE, begin, end, NULL);

      if (image->raw) 
      {
	 if (map_data != NULL) 
	 {
	    unsigned char *c = (unsigned char *)data;
	    char *d;
	    
	    d = image->data = kmalloc(size[1] * size[2] * 3 * sizeof(char));
	    size[0] = 3;
	    for (i = 0; i < size[1] * size[2]; i++)
	    {
	       d[3*i] = map_data[3 * c[i]];
	       d[3*i + 1] = map_data[3 * c[i] + 1];
	       d[3*i + 2] = map_data[3 * c[i] + 2];
	    }
	    image->maxval = 255;
	 }
	 else
	    image->data = (char *)data;

	 dta = (unsigned char *)image->data;
	 
	 image->type = (size[0] == 3) ? PPM : PGM;
	 
	 if (image->maxval == 0)
	    for (i = 0, image->maxval = 0;i < size[0] * size[1] * size[2]; i++)
	       image->maxval = (int)kmax(image->maxval,(int)dta[i]);
      } 
      else
      {
	 int *d = (int *)data;
	 image->data = (char *)data;
	 
	 image->type = (size[0] == 3) ? PPM : PGM;
	 
	 if (image->maxval == 0)
	    for (i = 0, image->maxval = 0;i < size[0] * size[1] * size[2]; i++)
	       image->maxval = (int)kmax(image->maxval,d[i]);
      }
   }

   /*
    * Write the pnm structure out to the specified filename
    */
   status = pnm_fdwrite(fid, image);

   kfree(data);
   kfree(map_data);

   return (status);
}

/*-----------------------------------------------------------
|
|  Routine Name: pnm_destroy - Frees an pnm image
|
|       Purpose: This function is used to create an pnm image.  Which
|                means that we use the current dimension values in order
|                to create a proper pnm.
|
|         Input: data - initial sample of data
|                num  - number of bytes in the sample
|
|        Output: Returns: returns TRUE or FALSE if an error occurs
|
|    Written By: Mark Young
|          Date: Jul 13, 1992 15:50
| Modifications:
|
------------------------------------------------------------*/

static int
pnm_destroy(kobject object)
{
   ResourceStruct *resources;

   resources = (ResourceStruct *) _kdms_glue_get_resources(object);

   /*
    * free the pnm structure
    */
   /* kludge */ if (resources->image) resources->image->data = NULL;
   pnm_free(resources->image);

   /*
    * free the resources
    */
   kfree(resources);

   return (TRUE);
}

#endif /* KPNM_DEF */

/* don`t add after the endif */
