 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: The "rast" format describes the conversion
   >>>>		       used for the format:
   >>>>
   >>>>			   Sun Rasterfile File Format
   >>>>
   >>>>	               The format was orignially developed by the
   >>>>		       company/persons:
   >>>>
   >>>>			   Sun Microsystems
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Sep 30, 1992 10:33
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kdatafmt_rast_h_
#define _kdatafmt_rast_h_

/*
 *	The "rast" image file format describes the format used by
 *	the Sun Rasterfile File Format  conversion routines.  The format
 *      was developed by Sun Microsystems
 *
 *	The following structure is used by the conversion routines to read
 *	and write the rast files.  This format is not a standard, just an
 *	intermediate format used by the Khoros routines to do convert rast
 *	files to and from the format.
 */

/*
 * NOTES:
 *      Each line of the image is rounded out to a multiple of 16 bits.
 *   This corresponds to the rounding convention used by the memory pixrect
 *   package (/usr/include/pixrect/memvar.h) of the SunWindows system.
 *
 *      The ras_encoding field (always set to 0 by Sun's supported software)
 *   was renamed to ras_length in release 2.0.  As a result, rasterfiles
 *   of type 0 generated by the old software claim to have 0 length; for
 *   compatibility, code reading rasterfiles must be prepared to compute the
 *   true length from the width, height, and depth fields.
 */

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Magic Identifier for Rasterfile
 */
#define RAS_MAGIC       0x59a66a95

/*
 *  Types of Rasterfile data formats
 */
#define RT_OLD          0       /* Raw pixrect image in 68000 byte order     */
#define RT_STANDARD     1       /* Raw pixrect image in 68000 byte order     */
#define RT_BYTE_ENCODED 2       /* Run-length compression of bytes           */
#define RT_FORMAT_RGB   3       /* XRGB or RGB instead of XBGR or BGR        */
#define RT_FORMAT_TIFF  4       /* tiff <-> standard rasterfile              */
#define RT_FORMAT_IFF   5       /* iff (TAAC format) <-> standard rasterfile */
#define RT_EXPERIMENTAL 0xffff  /* Reserved for testing                      */

/*
 *  Types of Rasterfile map formats
 */
#define RMT_NONE        0
#define RMT_EQUAL_RGB   1
#define RMT_RAW         2

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct _rast {
	int ras_magic;              /* magic number                      */
	int ras_width;              /* width (pixels) of image           */
	int ras_height;             /* height (pixels) of image          */
	int ras_depth;              /* depth (1, 8, or 24 bits) of pixel */
	int ras_length;             /* length (bytes) of image           */
	int ras_type;               /* type of file; see RT_* below      */
	int ras_maptype;            /* type of colormap; see RMT_* below */
	int ras_maplength;          /* length (bytes) of following map   */
	/* color map follows for ras_maplength bytes, followed by image  */

	char *data;		    /* rasterfile image data		 */
	char *map;		    /* rasterfile map data		 */
} rast;

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* rast.c */
rast *rast_readheader PROTO((int));
rast *rast_read PROTO((char *));
rast *rast_fdread PROTO((int));
int rast_write PROTO((char *, rast *));
int rast_fdwrite PROTO((int, rast *));
int rast_writeheader PROTO((int, rast *));
void rast_free PROTO((rast *));
rast *rast_create PROTO((void));

#endif /* _kdatafmt_rast_h_ */
/* Don't add after this point */
