 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: The "avs" format describes the conversion
   >>>>		       used for the format:
   >>>>
   >>>>			   Advanced Visualization System File Format
   >>>>
   >>>>	               The format was orignially developed by the
   >>>>		       company/persons:
   >>>>
   >>>>			   AVS Inc.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Nov 14, 1993 
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kdatafmt_avs_h_
#define _kdatafmt_avs_h_

/*
 *	The "avs" image file format describes the format used by
 *	the Advanced Visualization System File Format conversion routines.
 *	The format was developed by AVS Inc.
 *
 *	The following structure is used by the conversion routines to read
 *	and write the avs files.  This format is not a standard, just an
 *	intermediate format used by the Khoros routines to do convert avs
 *	files to and from the format.
 */

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct _avs {
	int  width;
	int  height;
	unsigned char *data;
} avs;

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

avs   *avs_readheader PROTO((int));
avs   *avs_read       PROTO((char *));
avs   *avs_fdread       PROTO((int));
avs   *avs_create     PROTO((void));
int     avs_writeheader PROTO((int, avs *));
int     avs_write       PROTO((char *, avs *));
int     avs_fdwrite       PROTO((int, avs *));
int     avs_free        PROTO((avs *));


#endif /* _kdatafmt_avs_h_ */
/* Don't add after this point */
