/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "copyright.h"		/* Khoros copyright */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose:  ARF File Format.
   >>>>
   >>>>    Written By: Tim Williams
   >>>>
   >>>>          Date: 9 May 1994
   >>>>
   >>>> Modifications: Converted to Khoros 2.0 from "regular" ARF headers
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kdatafmt_arf_h_
#define _kdatafmt_arf_h_

#if 0
#include <stdio.h>
#endif

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 * Primitives
 */
#define ARF_COLORMAP_SIZE 256
#define ARF_MAX_COMMENT_SIZE 512
#define ARF_MAX_SIMPLE_STR_SIZE 32
#define ARF_MAX_BANDS 16
#define ARF_MAX_NAME_SIZE 16

enum ARF_IMAGE_TYPE {
  arf_eight_bit = 0,
  arf_ten_bit = 1,
  arf_twelve_bit = 2,
  arf_short_int = 3,
  arf_long_int = 4,
  arf_short_word = 5,
  arf_long_word = 6,
  arf_float_single = 7,
  arf_float_double = 8,
  arf_complex = 9,
  arf_multi_band = 10,
  arf_complex_double = 11
};
typedef enum ARF_IMAGE_TYPE ARF_IMAGE_TYPE;

enum ARF_IMAGE_SOURCE {
  arf_rs_330 = 0,
  arf_rs_170 = 1,
  arf_rs_343_875 = 2,
  arf_slow_scan = 3,
  arf_non_std_analog = 4,
  arf_digital = 5,
  arf_fake = 6
};
typedef enum ARF_IMAGE_SOURCE ARF_IMAGE_SOURCE;

struct ARF_COMPLEX {
  float r;
  float i;
};
typedef struct ARF_COMPLEX ARF_COMPLEX;

struct ARF_COMPLEX_DOUBLE {
  double r;
  double i;
};
typedef struct ARF_COMPLEX_DOUBLE ARF_COMPLEX_DOUBLE;

struct ARF_IRIG_TIME {
  unsigned short yy;
  unsigned short dd;
  unsigned short hh;
  unsigned short mm;
  unsigned short ss;
  unsigned short ms;
};
typedef struct ARF_IRIG_TIME ARF_IRIG_TIME;

struct ARF_INFO {
  ARF_IMAGE_SOURCE image_source;
  unsigned long start_x;
  unsigned long start_y;
  unsigned long num_avg;
  unsigned long capture_rate;
  ARF_IRIG_TIME capture_time;
  char capture_loc[ARF_MAX_SIMPLE_STR_SIZE+1];
  char sensor_name[ARF_MAX_SIMPLE_STR_SIZE+1];
  char digitizer[ARF_MAX_SIMPLE_STR_SIZE+1];
  float sensor_hor_fov;
  float sensor_ver_fov;
  unsigned long samples_per_dwell;
};
typedef struct ARF_INFO ARF_INFO;

struct ARF_COLORMAP {
  unsigned char red[ARF_COLORMAP_SIZE];
  unsigned char green[ARF_COLORMAP_SIZE];
  unsigned char blue[ARF_COLORMAP_SIZE];
};
typedef struct ARF_COLORMAP ARF_COLORMAP;

struct ARF_COMMENT {
  char bs[ARF_MAX_COMMENT_SIZE+1];
};
typedef struct ARF_COMMENT ARF_COMMENT;

struct ARF_BAND_DESC {
  char name[ARF_MAX_NAME_SIZE+1];
  ARF_IMAGE_TYPE type;
};
typedef struct ARF_BAND_DESC ARF_BAND_DESC;

struct ARF_MULTI_BAND {
  char name[ARF_MAX_NAME_SIZE+1];
  unsigned short num_bands;
  ARF_BAND_DESC band[ARF_MAX_BANDS];
};
typedef struct ARF_MULTI_BAND ARF_MULTI_BAND;

struct ARF_FRAME_DATA {
  unsigned long footer_flags;
};
typedef struct ARF_FRAME_DATA ARF_FRAME_DATA;

struct ARF_FRAME_INFO {
  unsigned long x;
  unsigned long y;
  float azimuth;
  float elevation;
  ARF_IRIG_TIME irig_time;
};
typedef struct ARF_FRAME_INFO ARF_FRAME_INFO;

struct ARF_PLATFORM_ATTITUDE {
  double vel_north;
  double vel_east;
  double vel_vertical;
  double acc_north;
  double acc_east;
  double acc_vertical;
  double latitude;
  double longitude;
  double altitude;
  double elevation;
  double bank;
  double heading;
};
typedef struct ARF_PLATFORM_ATTITUDE ARF_PLATFORM_ATTITUDE;

struct ARF_FRAME_FOOTER {
  ARF_FRAME_INFO info;
  ARF_PLATFORM_ATTITUDE attitude;
};
typedef struct ARF_FRAME_FOOTER ARF_FRAME_FOOTER;

struct ARF_LADAR_PARAM {
  float fm_scale;
  float resolved_range_bias;
  float hor_ifov;
  float ver_ifov;
  float coarse_res;
  float fine_res;
};
typedef struct ARF_LADAR_PARAM ARF_LADAR_PARAM;

struct ARF_SUBHEADER {
  ARF_INFO info;
  ARF_COLORMAP colormap;
  ARF_COMMENT comment;
  ARF_MULTI_BAND multi_band;
  ARF_FRAME_DATA frame_data;
  ARF_LADAR_PARAM ladar_param;
};
typedef struct ARF_SUBHEADER ARF_SUBHEADER;

struct ARF_MAIN_HDR {
  unsigned long _magic_num;
  unsigned long _version;
  unsigned long _num_rows;
  unsigned long _num_cols;
  ARF_IMAGE_TYPE _image_type;
  unsigned long _num_frames;
  unsigned long _image_offset;
  unsigned long _subheader_flags;
};
typedef struct ARF_MAIN_HDR ARF_MAIN_HDR;

#define ARF_INFO_FLAG                (1L<<0)
#define ARF_COLORMAP_FLAG            (1L<<1)
#define ARF_COMMENT_FLAG             (1L<<2)
#define ARF_MULTI_BAND_FLAG          (1L<<3)
#define ARF_FRAME_DATA_FLAG          (1L<<4)
#define ARF_LADAR_PARAM_FLAG         (1L<<5)

#define ARF_FRAME_INFO_FLAG          (1L<<0)
#define ARF_PLATFORM_ATTITUDE_FLAG   (1<<1)

#define ARF_NUM_SUBHEADERS     6
#define ARF_NUM_FRAME_FOOTERS  2

#define ARF_MAIN_HDR_SIZE         32

#define ARF_A_OK           0
#define ARF_FILE_ERR      -1
#define ARF_XDR_ERR       -2
#define ARF_BAD_ARGS      -3
#define ARF_INTERNAL_ERR  -4
#define ARF_NOT_ARF_ERR   -5
#define ARF_NOT_DEFINED   -6

#define ARF_MAGIC_NUM         0xBBBBBAADL
#define ARF_NUM_IMAGE_TYPES   11
#define ARF_NUM_BANDS         2
#define ARF_CURRENT_VERSION   2  
#define ARF_MAX_IMAGE_SIZE    16*1024

#define ARF_VERSION            0
#define ARF_NUM_ROWS           1
#define ARF_NUM_COLS           2
#define ARF_TYPE               3
#define ARF_NUM_FRAMES         4
#define ARF_SUBHEADER_FLAGS    5
#define ARF_IMAGE_BUF_SIZE     6
#define ARF_IMAGE_OFFSET       7
#define ARF_FILENAME           8
#define ARF_FRAME_FOOTER_FLAGS 9

typedef struct
{
  /*
    FILE           *fh;
    XDR            xdrs;
    */
  ARF_MAIN_HDR   hdr;
  char           *filename;
  ARF_MULTI_BAND multi_band;
  unsigned long         frame_footer_flags;
} ARF;

/* footer lengths */
#define ARF_FRAME_INFO_LEN 40L
#define ARF_PLATFORM_ATTITUDE_LEN 96L

typedef struct
{
  unsigned long *frame_info_x, *frame_info_y;
  float *frame_info_az, *frame_info_el;
  unsigned short *frame_info_irig_yy, *frame_info_irig_dd, *frame_info_irig_hh;
  unsigned short *frame_info_irig_mm, *frame_info_irig_ss, *frame_info_irig_ms;
  double *platform_attitude_vel_n, *platform_attitude_vel_e;
  double *platform_attitude_vel_v;
  double *platform_attitude_acc_n, *platform_attitude_acc_e;
  double *platform_attitude_acc_v;
  double *platform_attitude_lat, *platform_attitude_long;
  double *platform_attitude_alt, *platform_attitude_elev;
  double *platform_attitude_bank, *platform_attitude_head;
} ARF_FOOTER_ATTRIBUTES;


	/*
	 *   Attribute Definitions
	 */

/*------------------------------------------------------------------------
| Attribute:	ARF_DATATYPE
| Type:		KINT arf_type
| Default:      
| Legal Values: arf_eight_bit
|               arf_ten_bit
|               arf_twelve_bit
|               arf_short_int
|               arf_long_int
|               arf_short_word
|               arf_long_word
|               arf_float_single
|               arf_float_double
|               arf_complex
|               arf_multi_band
|               arf_complex_double
|               
|
| Description:	This attribute preserves the ARF datatype of an 
|               ARF formatted image to resolve the ambiguity between a
|               KUSHORT datatype and arf_ten_bit, arf_twelve_bit, 
|               arf_short_word datatypes.
|
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_DATATYPE "ARF_DATATYPE"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_IMAGE_SOURCE
| Type:		KULONG image_source
| Default:      
| Legal Values: arf_rs_330
|               arf_rs_170
|               arf_rs_343_875
|               arf_slow_scan
|               arf_non_std_analog
|               arf_digital = 5
|               arf_fake
|
| Description:	This attribute 
|               stores an enumerated type of the source that collected 
|               the data.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_IMAGE_SOURCE "ARF_INFO_image_source"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_START_X
| Type:		KULONG start_x
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores a horizontal offset to the data.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_START_X "ARF_INFO_start_x"

/*------------------------------------------------------------------------
 Attribute:    ARF_INFO_START_Y
| Type:		KULONG start_y
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores a vertical offset to the data.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_START_Y "ARF_INFO_start_y"

/*------------------------------------------------------------------------
 Attribute:    ARF_INFO_NUM_AVG
| Type:		KULONG num_avg
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the number of frames averaged to generate this frame.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_NUM_AVG "ARF_INFO_num_avg"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_CAPTURE_RATE
| Type:		KULONG capture_rate
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the rate at which the frame was captured.
|               (Hz)
|               
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_CAPTURE_RATE "ARF_INFO_capture_rate"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_CAPTURE_TIME_yy
| Type:		KUSHORT capture_time_yy
| Default:      
| Legal Values: 0-99
|
| Description:	This attribute 
|               stores the two-digit year portion of the IRIG time
|               at the time of frame capture.
|               
| access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_CAPTURE_TIME_YY "ARF_INFO_capture_time_yy"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_CAPTURE_TIME_dd
| Type:		KUSHORT capture_time_dd
| Default:      
| Legal Values: 0-365(6)
|
| Description:	This attribute 
|               stores the day-of-year portion of the IRIG time
|               at the time of frame capture.
|               
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_CAPTURE_TIME_DD "ARF_INFO_capture_time_dd"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_CAPTURE_TIME_HH
| Type:		KUSHORT capture_time_hh
| Default:      
| Legal Values: 0-23
|
| Description:	This attribute 
|               stores the hour portion of the IRIG time (24 hour clock)
|               at the time of frame capture.
|               
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_CAPTURE_TIME_HH "ARF_INFO_capture_time_hh"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_CAPTURE_TIME_MM
| Type:		KUSHORT capture_time_mm
| Default:      
| Legal Values: 0-59
|
| Description:	This attribute 
|               stores the minute portion of the IRIG time
|               at the time of frame capture.
|               
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_CAPTURE_TIME_MM "ARF_INFO_capture_time_mm"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_CAPTURE_TIME_SS
| Type:		KUSHORT capture_time_ss
| Default:      
| Legal Values: 0-59
|
| Description:	This attribute 
|               stores the second portion of the IRIG time
|               at the time of frame capture.
|               
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_CAPTURE_TIME_SS "ARF_INFO_capture_time_ss"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_CAPTURE_TIME_MS
| Type:		KUSHORT capture_time_ms
| Default:      
| Legal Values: 0-999
|
| Description:	This attribute 
|               stores the millisecond portion of the IRIG time
|               at the time of frame capture.
|               
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_CAPTURE_TIME_MS "ARF_INFO_capture_time_ms"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_CAPTURE_TIME_LOC
| Type:		KSTRING capture_loc
| Default:      
| Legal Values: "ap-hill_lr" - Ft A.P. Hill, laser range
|               "ap-hill_dz" - Ft A.P. Hill, drop zone
|               "tb_ccnveo"  - CCNVEO, terrain board
|               <other strings are allowed>
|
| Description:	This attribute 
|               stores the capture location. 
|               There is a 32 character limit on the string.
|               
|               
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_CAPTURE_LOC "ARF_INFO_capture_loc"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_SENSOR_NAME
| Type:		KSTRING sensor_name
| Default:      
| Legal Values: "cohu"
|               "ti-sairs"
|               "mm-sairs"
|               "vtads"
|               <other strings are allowed>|

| Description:	This attribute 
|               stores the sensor name that performed the frame capture.
|               There is a 32 character limit on the string.
|               
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_SENSOR_NAME "ARF_INFO_sensor_name"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_DIGITIZER
| Type:		KSTRING digitizer
| Default:      
| Legal Values: "trapix_plus"
|               "epix"
|               "dt2851"
|               "hbr"
|               <other strings are allowed>
|
| Description:	This attribute 
|               stores the sensor name that performed the frame capture.
|               There is a 32 character limit on the string.
|               
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_DIGITIZER "ARF_INFO_digitizer"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_SENSOR_HOR_FOV
| Type:		KFLOAT sensor_hor_fov
| Default:      
| Legal Values:
|
| Description:	This attribute 
|               stores the sensor horizontal field-of-view (degrees).
|               
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_SENSOR_HOR_FOV "ARF_INFO_sensor_hor_fov"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_SENSOR_VER_FOV
| Type:		KFLOAT sensor_ver_fov
| Default:      
| Legal Values:
|
| Description:	This attribute 
|               stores the sensor vertical field-of-view (degrees).
|               
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_SENSOR_VER_FOV "ARF_INFO_sensor_ver_fov"

/*------------------------------------------------------------------------
| Attribute:    ARF_INFO_samples_per_dwell
| Type:		KULONG samples_per_dwell
| Default:      
| Legal Values:
|
| Description:	This attribute 
|               stores the number of samples per dwell of the sensor.
|               
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_INFO_SAMPLES_PER_DWELL "ARF_INFO_samples_per_dwell"

/*------------------------------------------------------------------------
| Attribute:    ARF_LADAR_PARAM_FM_SCALE
| Type:		KFLOAT fm_scale
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the FM scale parameter.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_LADAR_PARAM_FM_SCALE "ARF_LADAR_PARAM_fm_scale"

/*------------------------------------------------------------------------
| Attribute:    ARF_LADAR_PARAM_RESOLVED_RANGE_BIAS
| Type:		KFLOAT resolved_range_bias
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the resolved range bias paramter.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_LADAR_PARAM_RESOLVED_RANGE_BIAS "ARF_LADAR_PARAM_resolved_range_bias"

/*------------------------------------------------------------------------
| Attribute:    ARF_LADAR_PARAM_HOR_IFOV
| Type:		KFLOAT hor_ifov
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the horizontal instantaneous field-of-view paramter.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_LADAR_PARAM_HOR_IFOV "ARF_LADAR_PARAM_hor_ifov"

/*------------------------------------------------------------------------
| Attribute:    ARF_LADAR_PARAM_VER_IFOV
| Type:		KFLOAT ver_ifov
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the vertical instantaneous field-of-view paramter.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_LADAR_PARAM_VER_IFOV "ARF_LADAR_PARAM_ver_ifov"

/*------------------------------------------------------------------------
| Attribute:    ARF_LADAR_PARAM_COARSE_RES
| Type:		KFLOAT coarse_res
| Default:      
| Legal Values: 
|
| Description:	This attribute
|               stores the  coarse range resolution paramter.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_LADAR_PARAM_COARSE_RES "ARF_LADAR_PARAM_coarse_res"

/*------------------------------------------------------------------------
| Attribute:    ARF_LADAR_PARAM_FINE_RES
| Type:		KFLOAT fine_res
| Default:      
| Legal Values: 
|
| Description:	This attribute
|               stores the fine range resolution paramter.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_LADAR_PARAM_FINE_RES "ARF_LADAR_PARAM_fine_res"

/*------------------------------------------------------------------------
| Attribute:	ARF_FRAME_DATA_FOOTER_FLAGS
| Type:		KULONG footer_flags
| Default:      0
| Legal Values: 0 - none
|               1 - ARF_FRAME_INFO footer
|               2 - ARF_PLATFORM_ATTITUDE footer
|               3 - both
|
| Description:	This attribute 
|               stores the bit mask of which ARF frame footers are present
|               in the data.  The actual frame footers are represented as an
|               array of attributes.
|
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/

#define ARF_FRAME_DATA_FOOTER_FLAGS "ARF_FRAME_DATA_footer_flags"

/*------------------------------------------------------------------------
| Attribute:    ARF_FRAME_INFO_X
| Type:		KULONG *frame_info_x
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the horizontal location in pixels of an arbitrary
|               point in an image, normally the center of field-of-view.
|               This location corresponds to ARF_FRAME_INFO_AZ.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_FRAME_INFO_X "ARF_FRAME_INFO_x"

/*------------------------------------------------------------------------
| Attribute:    ARF_FRAME_INFO_Y
| Type:		KULONG *frame_info_y
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the vertical location in pixels of an arbitrary
|               point in an image, normally the center of field-of-view.
|               This location corresponds to ARF_FRAME_INFO_EL.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_FRAME_INFO_Y "ARF_FRAME_INFO_y"

/*------------------------------------------------------------------------
| Attribute:    ARF_FRAME_INFO_AZ
| Type:		KFLOAT *frame_info_az
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the horizontal location in degrees of an arbitrary
|               point in an image, normally the center of field-of-view.
|               This location corresponds to ARF_FRAME_INFO_X.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_FRAME_INFO_AZ "ARF_FRAME_INFO_az"

/*------------------------------------------------------------------------
| Attribute:    ARF_FRAME_INFO_EL
| Type:		KFLOAT *frame_info_el
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the vertical location in degrees of an arbitrary
|               point in an image, normally the center of field-of-view.
|               This location corresponds to ARF_FRAME_INFO_Y.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_FRAME_INFO_EL "ARF_FRAME_INFO_el"

/*------------------------------------------------------------------------
| Attribute:    ARF_FRAME_INFO_IRIG_YY
| Type:		KUSHORT *frame_info_yy
| Default:      
| Legal Values: 0-99
|
| Description:	This attribute 
|               stores the two-digit year portion of the IRIG time.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_FRAME_INFO_IRIG_YY "ARF_FRAME_INFO_irig_yy"

/*------------------------------------------------------------------------
| Attribute:    ARF_FRAME_INFO_IRIG_DD
| Type:		KUSHORT *frame_info_dd
| Default:      
| Legal Values: 0-365(6)
|
| Description:	This attribute 
|               stores the day-of-year portion of the IRIG time.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_FRAME_INFO_IRIG_DD "ARF_FRAME_INFO_irig_dd"

/*------------------------------------------------------------------------
| Attribute:    ARF_FRAME_INFO_IRIG_HH
| Type:		KUSHORT *frame_info_hh
| Default:      
| Legal Values: 0-23
|
| Description:	This attribute 
|               stores the hour portion of the IRIG time (24 hour clock).
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_FRAME_INFO_IRIG_HH "ARF_FRAME_INFO_irig_hh"

/*------------------------------------------------------------------------
| Attribute:    ARF_FRAME_INFO_IRIG_MM
| Type:		KUSHORT *frame_info_mm
| Default:      
| Legal Values: 0-59
|
| Description:	This attribute 
|               stores the minute portion of the IRIG time
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_FRAME_INFO_IRIG_MM "ARF_FRAME_INFO_irig_mm"

/*------------------------------------------------------------------------
| attribute:    ARF_FRAME_INFO_IRIG_SS
| Type:		KUSHORT *frame_info_ss
| Default:      
| Legal Values: 0-59
|
| Description:	This attribute 
|               stores the second portion of the IRIG time
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_FRAME_INFO_IRIG_SS "ARF_FRAME_INFO_irig_ss"

/*------------------------------------------------------------------------
| Attribute:    ARF_FRAME_INFO_IRIG_MS
| Type:		KUSHORT *frame_info_ms
| Default:      
| Legal Values: 0-999
|
| Description:	This attribute 
|               stores the millisecond portion of the IRIG time
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_FRAME_INFO_IRIG_MS "ARF_FRAME_INFO_irig_ms"

/*------------------------------------------------------------------------
| Attribute:    ARF_PLATFORM_ATTITUDE_VEL_N
| Type:		KDOUBLE *platform_att_vel_n
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the northward velocity of the sensor platform.
|               (meters/sec)
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_PLATFORM_ATTITUDE_VEL_N "ARF_PLATFORM_ATTITUDE_vel_n"

/*------------------------------------------------------------------------
| Attribute:    ARF_PLATFORM_ATTITUDE_VEL_E
| Type:		KDOUBLE *platform_att_vel_e
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the eastward velocity of the sensor platform.
|               (meters/sec)
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_PLATFORM_ATTITUDE_VEL_E "ARF_PLATFORM_ATTITUDE_vel_e"

/*------------------------------------------------------------------------
| Attribute:    ARF_PLATFORM_ATTITUDE_VEL_V
| Type:		KDOUBLE *platform_att_vel_v
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the vertical velocity of the sensor platform.
|               (meters/sec)
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_PLATFORM_ATTITUDE_VEL_V "ARF_PLATFORM_ATTITUDE_vel_v"

/*------------------------------------------------------------------------
| Attribute:    ARF_PLATFORM_ATTITUDE_ACC_N
| Type:		KDOUBLE *platform_att_acc_n
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the northward acceleration of the sensor platform.
|               (meters/sec^2)
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_PLATFORM_ATTITUDE_ACC_N "ARF_PLATFORM_ATTITUDE_acc_n"

/*------------------------------------------------------------------------
| Attribute:    ARF_PLATFORM_ATTITUDE_ACC_E
| Type:		KDOUBLE *platform_att_acc_e
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the eastward acceleration of the sensor platform.
|               (meters/sec^2)
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_PLATFORM_ATTITUDE_ACC_E "ARF_PLATFORM_ATTITUDE_acc_e"

/*------------------------------------------------------------------------
| Attribute:    ARF_PLATFORM_ATTITUDE_ACC_V
| Type:		KDOUBLE *platform_att_acc_v
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the vertical acceleration of the sensor platform.
|               (meters/sec^2)
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_PLATFORM_ATTITUDE_ACC_V "ARF_PLATFORM_ATTITUDE_acc_v"

/*------------------------------------------------------------------------
| Attribute:    ARF_PLATFORM_ATTITUDE_LAT
| Type:		KDOUBLE *platform_att_lat
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the lattitude of the sensor platform.
|               (degrees+float((minutes+float(seconds/60.0))/60.0))
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_PLATFORM_ATTITUDE_LAT "ARF_PLATFORM_ATTITUDE_lat"

/*------------------------------------------------------------------------
| Attribute:    ARF_PLATFORM_ATTITUDE_LONG
| Type:		KDOUBLE *platform_att_long
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the longitude of the sensor platform.
|               (degrees+float((minutes+float(seconds/60.0))/60.0))
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_PLATFORM_ATTITUDE_LONG "ARF_PLATFORM_ATTITUDE_long"

/*------------------------------------------------------------------------
| Attribute:    ARF_PLATFORM_ATTITUDE_ALT
| Type:		KDOUBLE *platform_att_alt
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the altitude of the sensor platform.
|               (meters above sea level)
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_PLATFORM_ATTITUDE_ALT "ARF_PLATFORM_ATTITUDE_alt"

/*------------------------------------------------------------------------
| Attribute:    ARF_PLATFORM_ATTITUDE_ELEV
| Type:		KDOUBLE *platform_att_elev
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the elevation angle of the sensor platform.
|               (positive up relative to local horizontal plane)
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_PLATFORM_ATTITUDE_ALT "ARF_PLATFORM_ATTITUDE_alt"

/*------------------------------------------------------------------------
| Attribute:    ARF_PLATFORM_ATTITUDE_BANK
| Type:		KDOUBLE *platform_att_bank
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the bank angle of the sensor platform.
|               (positive when right wing is below horizontal plane)
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_PLATFORM_ATTITUDE_BANK "ARF_PLATFORM_ATTITUDE_bank"

/*------------------------------------------------------------------------
| Attribute:    ARF_PLATFORM_ATTITUDE_HEAD
| Type:		KDOUBLE *platform_att_head
| Default:      
| Legal Values: 
|
| Description:	This attribute 
|               stores the heading of the sensor platform.
|               (true north torwards east relative to local horizon
tal plane
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define ARF_PLATFORM_ATTITUDE_HEAD "ARF_PLATFORM_ATTITUDE_head"

/*-------------------------------------*
  |       routine definitions
  ---------------------------------------*/

/* arf.c */
int arf_get_main_hdr PROTO((kfile *, ARF_MAIN_HDR *));
int arf_get_info PROTO((kfile *, ARF_SUBHEADER *));
int arf_get_colormap PROTO((kfile *, ARF_SUBHEADER *));
int arf_get_comment PROTO((kfile *, ARF_SUBHEADER *));
int arf_get_multi_band PROTO((kfile *, ARF_SUBHEADER *));
int arf_get_frame_data PROTO((kfile *, ARF_SUBHEADER *));
int arf_get_ladar_param PROTO((kfile *, ARF_SUBHEADER *));
int arf_get_footer PROTO((kfile *, unsigned long, ARF_FRAME_FOOTER *));
void  read_xdr_string PROTO((kfile *, char *));
void  write_xdr_string PROTO((kfile *, char *));
    
int arf2khoros_datatype PROTO((ARF_IMAGE_TYPE, int *));
int khoros2arf_datatype PROTO((int, ARF_IMAGE_TYPE *));
    
int arf_put_main_hdr PROTO((kfile *, ARF_MAIN_HDR *));
int arf_put_info PROTO((kfile *, ARF_INFO *));
int arf_put_colormap PROTO((kfile *, ARF_COLORMAP *));
int arf_put_comment PROTO((kfile *, ARF_COMMENT *));
int arf_put_multi_band PROTO((kfile *, ARF_MULTI_BAND *));
int arf_put_frame_data PROTO((kfile *, ARF_FRAME_DATA *));
int arf_put_ladar_param PROTO((kfile *, ARF_LADAR_PARAM *));
int arf_read_data PROTO((kfile *, kaddr *, int, int));
int arf_put_footer PROTO((kfile *, unsigned long, ARF_FRAME_FOOTER *));
     
#endif /* _kdatafmt_arf_h_ */
     /* Don't add after this point */
