 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Polymorphic Application Services
   >>>>
   >>>>    Written By: Jeremy Worley, John Salas, and Steve Kubica
   >>>>
   >>>>          Date: May 03, 1994 10:48
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kappserv_kpolymorphic_h_
#define _kappserv_kpolymorphic_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

	/*
	 * Initialization Function for Polymorphic Services 
	 */

int	kpds_init			PROTO((void));
#define KPDS_INIT			kpds_init()
	

/* ################################################################## */

/*
 * Primitives
 */

#define KPDS_VALUE_VECTOR		"pdsPrimitiveValueVector"
#define KPDS_VALUE_POINT		"pdsPrimitiveValuePoint"
#define KPDS_VALUE_LINE			"pdsPrimitiveValueLine"
#define KPDS_VALUE_PLANE		"pdsPrimitiveValuePlane"
#define KPDS_VALUE_VOLUME		"pdsPrimitiveValueVolume"
#define KPDS_VALUE_REGION		"pdsPrimitiveValueRegion"
#define KPDS_VALUE_ALL			"pdsPrimitiveValueAll"
#define KPDS_VALUE_HISTOGRAM		"pdsPrimitiveValueHistogram"

#define KPDS_MASK_VECTOR		"pdsPrimitiveMaskVector"
#define KPDS_MASK_POINT			"pdsPrimitiveMaskPoint"
#define KPDS_MASK_LINE			"pdsPrimitiveMaskLine"
#define KPDS_MASK_PLANE			"pdsPrimitiveMaskPlane"
#define KPDS_MASK_VOLUME		"pdsPrimitiveMaskVolume"
#define KPDS_MASK_REGION		"pdsPrimitiveMaskRegion"
#define KPDS_MASK_ALL			"pdsPrimitiveMaskAll"

#define KPDS_LOCATION_VECTOR		"pdsPrimitiveLocationVector"
#define KPDS_LOCATION_POINT		"pdsPrimitiveLocationPoint"
#define KPDS_LOCATION_LINE		"pdsPrimitiveLocationLine"
#define KPDS_LOCATION_PLANE		"pdsPrimitiveLocationPlane"
#define KPDS_LOCATION_VOLUME		"pdsPrimitiveLocationVolume"
#define KPDS_LOCATION_REGION		"pdsPrimitiveLocationRegion"
#define KPDS_LOCATION_ALL		"pdsPrimitiveLocationAll"

#define KPDS_LOCATION_WIDTH_ALL		"pdsPrimitiveLocationWidthAll"
#define KPDS_LOCATION_WIDTH_POINT	"pdsPrimitiveLocationWidthPoint"
#define KPDS_LOCATION_WIDTH_REGION	"pdsPrimitiveLocationWidthRegion"

#define KPDS_LOCATION_HEIGHT_ALL 	"pdsPrimitiveLocationHeightAll" 
#define KPDS_LOCATION_HEIGHT_POINT 	"pdsPrimitiveLocationHeightPoint" 
#define KPDS_LOCATION_HEIGHT_REGION 	"pdsPrimitiveLocationHeightRegion"

#define KPDS_LOCATION_DEPTH_ALL 	"pdsPrimitiveLocationDepthAll" 
#define KPDS_LOCATION_DEPTH_POINT 	"pdsPrimitiveLocationDepthPoint" 
#define KPDS_LOCATION_DEPTH_REGION 	"pdsPrimitiveLocationDepthRegion"

#define KPDS_MAP_VECTOR			"pdsPrimitiveMapVector"
#define KPDS_MAP_POINT			"pdsPrimitiveMapPoint"
#define KPDS_MAP_LINE			"pdsPrimitiveMapLine"
#define KPDS_MAP_PLANE			"pdsPrimitiveMapPlane"
#define KPDS_MAP_VOLUME			"pdsPrimitiveMapVolume"
#define KPDS_MAP_REGION			"pdsPrimitiveMapRegion"
#define KPDS_MAP_ALL			"pdsPrimitiveMapAll"

#define KPDS_TIME_ALL			"pdsPrimitiveTimeAll"
#define KPDS_TIME_POINT			"pdsPrimitiveTimePoint"
#define KPDS_TIME_REGION		"pdsPrimitiveTimeRegion"

	/*
	 *   Attribute Definitions
	 */

/*------------------------------------------------------------------------
| Attribute:	KPDS_ARCHITECTURE
| Type:		int architecture
| Default:      
| Category:     global
| Legal Values: KMACH_UNKNOWN
|               KMACH_I80x86
|               KMACH_NS32000
|               KMACH_MIPSEL
|               KMACH_I860
|               KMACH_SPARC
|               KMACH_IBMRT
|               KMACH_RS6000
|               KMACH_POWERPC
|               KMACH_MC680x0
|               KMACH_M88x00
|               KMACH_MIPSEB
|               KMACH_PARISC
|               KMACH_CONVEX
|               KMACH_APOLLO
|               KMACH_ALPHA
|               KMACH_CYBER
|               KMACH_CRAY
|               KMACH_VAX
| Description:	This attribute is an integer value which encodes a 
|		description of the floating point and integer representation
|		for the machine which what used to generate the object.
|		A set of C defines are typically used when operating on the
|		value of this attribute in a program.  Typically, this
|		attribute is set based on an examination of the input object,
|		and is set to the local architecture on an output object.
|		The encoding scheme and specific values for these defines 
|		can be found in 
|		.symbol noindex "$BOOTSTRAP/include/machine/kmachine.h" .
|
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_ARCHITECTURE		KDMS_ARCHITECTURE	

/*------------------------------------------------------------------------
| Attribute:	KPDS_AXIS_ASSIGNMENT
| Type:		int w, h, d
| Default:      KWIDTH, KHEIGHT, KDEPTH
| Category:     global
| Legal Values: KWIDTH
|		KHEIGHT
|		KDEPTH
| Description:	This attribute allows the width, height, and depth axes to be
|               reassigned to one-another to simplify visualization or 
|		processing. The effect of reassigning axes is similar to 
|		transposing a matrix.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_AXIS_ASSIGNMENT  		"axisAssignment"

/*------------------------------------------------------------------------
| Attribute:	KPDS_COMMENT
| Type:		char *comment
| Default:      NULL
| Category:     global
| Legal Values: 
| Description:	This attribute is a 
|		.symbol - NULL 
|		terminated string used to document
|		the object.  This attribute is used by a user or programmer
|		to describe the origin or nature of the data set.  When 
|		this attribute is set, it overwrites anything previously
|               held in this attribute.  Therefore, it is up to the 
|		programmer to first get the comment attribute, append new 
|		information to it, and then set the entire comment
|		attribute, if prior comment information is to be
|               propagated.  To clear the comment attribute, pass in 
|		.symbol - NULL
|		 when setting the attribute. This attribute is 
|		copied with the 
|		.symbol index kpds_copy_object() 
|		and 
|		.symbol index kpds_copy_object_attr()
|		calls.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_COMMENT			KDMS_COMMENT

/*------------------------------------------------------------------------
| Attribute:	KPDS_COUPLING
| Type:		int coupling
| Default:      See Note 1.
| Category:     global
| Legal Values: KCOUPLED
|               KDEMAND
|               KUNCOUPLED
| Description:	When this attribute is set to 
|		.symbol index KCOUPLED , 
|		changes to any 
|		attribute that affects the physical representation of the 
|		data (for example, data type, size, etc.) will be 
|		propagated to the physical layer immediately. Otherwise, 
|		the presentation layer is the only layer that is changed,
|		--the physical layer remains unchanged.  The difference 
|		between 
|		.symbol index KUNCOUPLED 
|		and 
|		.symbol index KDEMAND 
|		is that 
|		.symbol index KDEMAND 
|		allows the
|		.symbol index kpds_sync_object()
|		function call to force an update
|		of the presentation and physical layers.  When this 
|		attribute is set to 
|		.symbol index KUNCOUPLED , 
|		the calling the
|               .symbol index kpds_sync_object() 
|		will not do anything.  See
|               .symbol index kpds_sync_object()
|		for more information.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_COUPLING			KDMS_COUPLING

/*------------------------------------------------------------------------
| Attribute:	KPDS_DATE
| Type:		char *date
| Default:      current date
| Category:     global
| Legal Values: 
| Description:	This attribute is a
|		.symbol noindex NULL
|		terminated string used to record
|		the date of the creation of the data object.  This attribute
|		is NOT copied by 
|		.symbol index kpds_copy_attributes() .  
|		To assign
|		the current date as defined by computer system, pass in 
|		.symbol - NULL
|		when setting the attribute.  The date will be
|		stored in the default format of the UNIX 
|		.symbol index date
|               command ("day month date HH:MM:SS timezone year", e.g. 
|		"Wed Mar 10 00:07:23 MST 1994")
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_DATE			KDMS_DATE

/*------------------------------------------------------------------------
| Attribute:	KPDS_FORMAT
| Type:		char *format
| Default:      viff
| Category:     global
| Legal Values: viff
|		xvimage
|		xpm
|		xbm
|		xwd
|		pnm
|		eps
|		rast
|		avs
|		ascii
|		raw
| Description:	This attribute specifies the file format that will be
|		used with the object.  If the object is an input object,
|		then this attribute is automatically initialized to the
|		file format that the object is stored in.  If the object
|		is an output object, then this attribute defaults to 
|		"viff", indicating that the output data file will be a
|		viff.  On output objects, this attribute can be set to
|		any of the legal values.  The result is that when the
|		object is closed, it will be written out in the format
|		specified.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_FORMAT			KDMS_FORMAT

/*------------------------------------------------------------------------
| Attribute:	KPDS_HISTORY
| Type:		char *history
| Default:      NULL
| Category:     global
| Legal Values: 
| Description:	This attribute is a string that describes the operations
|		that have been performed on the original data set that
|		result in the current data set.  Typically, programs names
|		and their command line arguments are listed here to reproduce
|               this data set.  This attribute will only be set if the
|		.symbol index KHOROS_HISTORY 
|		environment variable is set.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_HISTORY			"pdsHistory"

/*------------------------------------------------------------------------
| Attribute:	KPDS_HISTORY_MODE
| Type:		int hmode
| Default:      
| Category:     global
| Legal Values: KAPPEND_HISTORY 
|		KREPLACE_HISTORY
| Description:	This attribute determines how the 
|		.symbol index KPDS_HISTORY 
|		attribute is 
|		interpreted when being set.  If the history mode is
|		set to 
|		.symbol index KAPPEND_HISTORY , 
|		then the string begin set will
|		be appended to the exisiting history string.  If the
|		history mode is set to 
|		.symbol index KREPLACE_HISTORY , 
|		then the string
|		being set will replace the existing history string.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_HISTORY_MODE		"pdsHistoryMode"

/*------------------------------------------------------------------------
| Attribute:	KPDS_KERNEL_ORIGIN
| Type:		int w, h, d, t, e
| Default:      0, 0, 0, 0, 0
| Category:     global
| Legal Values: 
| Description:	This attribute is used to specify a "hot spot" in the
|		data set that is interpreted as the center point of 
|		a 5 dimensional convolution kernel.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_KERNEL_ORIGIN		"kernel_origin"

/*------------------------------------------------------------------------
| Attribute:	KPDS_NAME
| Type:		char *name
| Default:      
| Category:     global
| Legal Values: 
| Description:	This attribute is used to obtain the filename associated
|		with the specified data object.  This is that name
|		passed in to 
|		.symbol index kpds_open_object , 
|		.symbol index kpds_open_output_object ,
|		or 
|		.symbol index kpds_open_input_object .  
|		Objects that are instantiated with 
|		.symbol index kpds_create_object 
|		do not have a filename.  In such
|		instances, this attribute's value is 
|		.symbol noindex NULL .
| Access:	read only
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_NAME			KDMS_NAME

/*------------------------------------------------------------------------
| Attribute:	KPDS_SUBOBJECT_POSITION
| Type:		int w, h, d, t, e
| Default:      0, 0, 0, 0, 0
| Category:     global
| Legal Values: 
| Description:	This is the offset of the current data object in a parent 
|		object.  Typically the value of this attribute will be 
|		{0, 0, 0, 0, 0}, but if this object was extracted from a
|		"parent object", via kextract or other means, then this 
|		attribute will indicate the position in the parent object 
|		from which this region was extracted.  It is intended to
|		be used to automate the process of reinserting the object
|		into its parent once region-of-interest processing is
|		complete.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_SUBOBJECT_POSITION		"subobject_position"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAPPING_MODE
| Type:		int mapping_mode
| Default:      KUNMAPPED
| Category:     global
| Legal Values: KMAPPED
|               KUNMAPPED
| Description:	This attribute specifies how to interpret the
|		.segment index map
|		data if it is present.  The default interpretation       
|		.symbol index KUNMAPPED
|		means that nothing is done with the    
|		map.  It is then the responsibility of the programmer to 
|		interpret or ignore the map.  The 
|		.symbol index KMAPPED
|		mode causes the 
|		.segment index map
|		and 
|		.segment index value
|		data to be      
|		merged.  This means that the 
|		.segment index map
|		will not appear 
|		to be present.  Instead, the 
|		.segment index value
|		data will     
|		assimilate the attributes of the 
|		.segment index map
|		data as appropriate.  Furthermore, any 
|		.segment index value
|		data that is
|		retrieved via a call to 
|		.symbol index kpds_get_data
|		will be    
|		mapped through the 
|		.segment index map
|		before being returned.    
|		For example, the 
|		.symbol index KPDS_VALUE_SIZE
|		attribute will  
|		have its 
|		.symbol index KELEMENTS 
|		value multiplied by the        
|		.symbol index KMAP_WIDTH 
|		size of the 
|		.segment index map .  
|		The         
|		.symbol index KPDS_VALUE_DATA_TYPE
|		will actually take the value of  
|		the 
|		.symbol index KPDS_MAP_DATA_TYPE . 
|		Each value will be used 
|		as an index into the 
|		.segment index map 
|		and used as the         
|		.symbol index KMAP_HEIGHT
|		index.  All get and and set attribute
|		calls will behave in this manner.                        
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAPPING_MODE		"pdsMappingMode"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASKED_VALUE_PRESENTATION
| Type:		int mask_mode
| Default:      KUSE_ORIGINAL
| Category:     global
| Legal Values: KUSE_ORIGINAL
|               KUSE_SUBSTITUTE_VALUE
| Description:	This attribute takes on one of two values: either       
|               .symbol index KUSE_ORIGINAL , 
|		or 
|		.symbol index KUSE_SUBSTITUTE_VALUE .
|               If set to 
|		.symbol index KUSE_ORIGINAL , 
|		then regardless of the 
|               .segment index mask 
|		value at a given data point, the value returned for
|               that data point is what is stored there.  If the        
|               attribute is set to 
|		.symbol index KUSE_SUBSTITUTE_VALUE ,
|		then the 
|		.symbol index KPDS_MASK_SUBSTITUTE_VALUE 
|		will replace any 
|		.segment index value   
|		data point that has a 0 mask.                           
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MASKED_VALUE_PRESENTATION	"maskedValuePresentation"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_SUBSTITUTE_VALUE
| Type:		double real, imag
| Default:      1.0, 0.0
| Category:     global
| Legal Values: 
| Description:	This value is used to replace 
|		.segment index value 
|		data whose mask 
|		indicates that it is invalid data.  It is only used when 
|		the 
|		.symbol index KPDS_MASKED_VALUE_PRESENTATION 
|		is set to 
|		.symbol index KUSE_SUBSTITUTE_VALUE .
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_MASK_SUBSTITUTE_VALUE	"pdsMaskSubstituteValue"

/*------------------------------------------------------------------------
| Attribute:	KPDS_POINT_SIZE
| Type:		double w, h, d, t, e
| Default:      1.0, 1.0, 1.0, 1.0, 1.0
| Category:     global
| Legal Values: > 0.0
| Description:	This attribute indicates the physical dimension in world 
|		coordinates of a point in the data set.  A single sampled 
|		point represents a continuous volume of data in world 
|		coordinate space.  This attribute indicates the size of 
|		that volume.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_POINT_SIZE			"point_size"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_COMPLEX_CONVERT
| Type:		int convert
| Default:      KREAL
| Category:     value
| Legal Values: KIMAGINARY
|               KMAGNITUDE
|               KPHASE
|               KREAL
|		KMAGSQ
|		KMAGSQP1
|		KLOGMAG
|		KLOGMAGP1
| Same As:      KPDS_LOCATION_COMPLEX_CONVERT
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_COMPLEX_CONVERT	"pdsValueComplexConversion"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_DATA_TYPE
| Type:		int data_type
| Default:      
| Category:     value
| Legal Values: KBIT
|               KBYTE
|               KUBYTE
|               KSHORT
|               KUSHORT
|               KINT
|               KUINT
|               KLONG
|               KULONG
|               KFLOAT
|               KDOUBLE
|               KCOMPLEX
|               KDCOMPLEX
| Same As:      KPDS_LOCATION_DATA_TYPE
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_VALUE_DATA_TYPE		"pdsValueDatatype"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_INTERPOLATE
| Type:		int interpolate
| Default:      KPAD
| Category:     value
| Legal Values: KNONE
|               KPAD
|               KZERO_ORDER
| Same As:	KPDS_LOCATION_INTERPOLATE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_INTERPOLATE		"pdsValueInterpolate"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_LINE_INFO
| Type:		int line_size, num_lines
| Default:      
| Category:     value
| Legal Values: 
| Same As:	KPDS_LOCATION_LINE_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_LINE_INFO		"pdsValueLineInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_NORM_MAX
| Type:		double norm_max
| Default:      
| Category:     value
| Legal Values: > norm_min
| Same As:	KPDS_LOCATION_NORM_MAX
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_NORM_MAX		"pdsValueNormMax"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_NORM_MIN
| Type:		double norm_min
| Default:      
| Category:     value
| Legal Values: < norm_max
| Same As:	KPDS_LOCATION_NORM_MIN
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_NORM_MIN		"pdsValueNormMin"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_OFFSET
| Type:		int offset_w,offset_h,offset_d,offset_t,offset_e
| Default:      0, 0, 0, 0, 0
| Category:     value
| Legal Values: +/- int
| Same As:	KPDS_LOCATION_OFFSET
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_OFFSET		"pdsValueOffset"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_PAD_VALUE
| Type:		double real_value, imag_value
| Default:      0.0, 0.0
| Category:     value
| Legal Values: 
| Same As:	KPDS_LOCATION_PAD_VALUE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_PAD_VALUE		"pdsValuePadValue"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_PLANE_INFO
| Type:		int plane_width,plane_height,num_planes
| Default:      
| Category:     value
| Legal Values: 
| Same As:	KPDS_LOCATION_PLANE_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_PLANE_INFO		"pdsValuePlaneInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_POSITION
| Type:		int w, h, d, t, e
| Default:      0, 0, 0, 0, 0
| Category:     value
| Legal Values: +/- int
| Same As:	KPDS_LOCATION_POSITION
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_POSITION		"pdsValuePosition"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_INCREMENT_SIZE
| Type:		int width,height,depth,num_volumes
| Default:      
| Category:     value
| Legal Values: 
| Same As:	KPDS_LOCATION_INCREMENT_SIZE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_INCREMENT_SIZE       "pdsValueIncrementSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_REGION_INFO
| Type:		int region_width,region_height,region_depth,region_time,region_elements,num_regions
| Default:      
| Category:     value
| Legal Values: 
| Same As:	KPDS_LOCATION_REGION_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_REGION_INFO		"pdsValueRegionInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_REGION_SIZE
| Type:		int region_width, region_height, region_depth,region_time,region_elements
| Default:      1, 1, 1, 1, 1
| Category:     value
| Legal Values:  > 0
| Same As:	KPDS_LOCATION_REGION_SIZE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_REGION_SIZE		"pdsValueRegionSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_OPTIMAL_REGION_SIZE
| Type:		int region_width,region_height,region_depth,region_time,region_elements,number_of_regions
| Default:      
| Category:     value
| Legal Values: > 0
| Same As:	KPDS_LOCATION_OPTIMAL_REGION_SIZE
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_OPTIMAL_REGION_SIZE    "pdsOptimalValueRegionSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_SCALING
| Type:		int scaling
| Default:      KNONE
| Category:     value
| Legal Values: KNONE
|               KNORMALIZE
|               KSCALE
| Same As:	KPDS_LOCATION_SCALING
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_SCALING		"pdsValueScaling"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_SCALE_FACTOR
| Type:		double scale_factor
| Default:      1.0
| Category:     value
| Legal Values: 
| Same As:	KPDS_LOCATION_SCALE_FACTOR
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_SCALE_FACTOR		"pdsValueScaleFactor"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_SCALE_OFFSET
| Type:		double offset_real, offset_imaginary
| Default:      0.0, 0.0
| Category:     value
| Legal Values: 
| Same As:	KPDS_LOCATION_SCALE_OFFSET
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_SCALE_OFFSET		"pdsValueScaleOffset"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_SIZE
| Type:		int width,height,depth,time,elements
| Default:      
| Category:     value
| Legal Values: > 0
| Same As:	KPDS_LOCATION_SIZE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_SIZE			"pdsValueSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_VECTOR_INFO
| Type:		int plane_size,num_vectors
| Default:      
| Category:     value
| Legal Values: 
| Same As:	KPDS_LOCATION_VECTOR_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_VECTOR_INFO		"pdsValueVectorInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_VALUE_VOLUME_INFO
| Type:		int width,height,depth,num_volumes
| Default:      
| Category:     value
| Legal Values: 
| Same As:	KPDS_LOCATION_VOLUME_INFO
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_VALUE_VOLUME_INFO		"pdsValueVolumeInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_DATA_TYPE
| Type:		int data_type
| Default:      
| Category:     mask
| Legal Values: KBIT
|               KBYTE
|               KUBYTE
|               KSHORT
|               KUSHORT
|               KINT
|               KUINT
|               KLONG
|               KULONG
|               KFLOAT
|               KDOUBLE
|               KCOMPLEX
|               KDCOMPLEX
| Same As:      KPDS_LOCATION_DATA_TYPE
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_MASK_DATA_TYPE		"pdsMaskDatatype"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_INTERPOLATE
| Type:		int interpolate
| Default:      KPAD
| Category:     mask
| Legal Values: KNONE
|               KPAD
|               KZERO_ORDER
| Same As:	KPDS_LOCATION_INTERPOLATE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MASK_INTERPOLATE		"pdsMaskInterpolate"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_LINE_INFO
| Type:		int line_size, num_lines
| Default:      
| Category:     mask
| Legal Values: 
| Same As:	KPDS_LOCATION_LINE_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MASK_LINE_INFO		"pdsMaskLineInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_OFFSET
| Type:		int offset_w,offset_h,offset_d,offset_t,offset_e
| Default:      0, 0, 0, 0, 0
| Category:     mask
| Legal Values: +/- int
| Same As:	KPDS_LOCATION_OFFSET
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MASK_OFFSET		"pdsMaskOffset"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_PAD_VALUE
| Type:		double pad_value
| Default:      1.0
| Category:     mask
| Legal Values: 
| Same As:	KPDS_LOCATION_PAD_VALUE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MASK_PAD_VALUE		"pdsMaskPadValue"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_PLANE_INFO
| Type:		int plane_width,plane_height,num_planes
| Default:      
| Category:     mask
| Legal Values: 
| Same As:	KPDS_LOCATION_PLANE_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MASK_PLANE_INFO		"pdsMaskPlaneInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_POSITION
| Type:		int w, h, d, t, e
| Default:      0, 0, 0, 0, 0
| Category:     mask
| Legal Values: +/- int
| Same As:	KPDS_LOCATION_POSITION
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MASK_POSITION		"pdsMaskPosition"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_INCREMENT_SIZE
| Type:		int width,height,depth,num_volumes
| Default:      
| Category:     mask
| Legal Values: 
| Same As:	KPDS_LOCATION_INCREMENT_SIZE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MASK_INCREMENT_SIZE        "pdsMaskIncrementSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_REGION_INFO
| Type:		int region_width,region_height,region_depth,region_time,region_elements,num_regions
| Default:      
| Category:     mask
| Legal Values: 
| Same As:	KPDS_LOCATION_REGION_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MASK_REGION_INFO		"pdsMaskRegionInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_REGION_SIZE
| Type:		int region_width,region_height,region_depth,region_time,region_elements
| Default:      1, 1, 1, 1, 1
| Category:     mask
| Legal Values: > 0
| Same As:	KPDS_LOCATION_REGION_SIZE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MASK_REGION_SIZE		"pdsMaskRegionSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_OPTIMAL_REGION_SIZE
| Type:		int region_width,region_height,region_depth,region_time,region_elements,number_of_regions
| Default:      
| Category:     mask
| Legal Values: > 0
| Same As:	KPDS_LOCATION_OPTIMAL_REGION_SIZE
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MASK_OPTIMAL_REGION_SIZE     "pdsOptimalMaskRegionSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_SIZE
| Type:		int width,height,depth,time,elements
| Default:      
| Category:     mask
| Legal Values: > 0
| Same As:	KPDS_LOCATION_SIZE
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_MASK_SIZE			"pdsMaskSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_VECTOR_INFO
| Type:		int vector_length, num_vectors
| Default:      
| Category:     mask
| Legal Values: 
| Same As:	KPDS_LOCATION_VECTOR_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MASK_VECTOR_INFO		"pdsMaskVectorInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MASK_VOLUME_INFO
| Type:		int width,height,depth,num_volumes
| Default:      
| Category:     mask
| Legal Values: 
| Same As:	KPDS_LOCATION_VOLUME_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MASK_VOLUME_INFO		"pdsMaskVolumeInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_BEGIN
| Type:		double w, h, d
| Default:      0.0, 0.0, 0.0
| Category:     location
| Legal Values: 
| Description:	This attribute represents an explicit begin marker point
|		for the polymorphic data model.  This begin point maps
|		to the implicit origin of the data model.  This attribute 
|		can only be set if uniform 
|		.segment index location 
|		data has been 
|		explicitly created with a 
|		.symbol index kpds_create_location
|		call. 
|		See also:  
|		.symbol index KPDS_LOCATION_END.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_BEGIN		"locationBegin"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_COMPLEX_CONVERT
| Type:		int convert
| Default:      KREAL
| Category:     location
| Legal Values: KIMAGINARY
|               KMAGNITUDE
|               KPHASE
|               KREAL
|		KMAGSQ
|		KMAGSQP1
|		KLOGMAG
|		KLOGMAGP1
| Description:	This attribute specifies how complex data should be 
|		converted.  If it is converted to a "lower" data type,
|               this attribute specifies how to down-convert the data.
|               For example if the data is actually complex, but the 
|		presentation attribute is byte, the complex data would 
|		first be converted to the representation defined by 
|		this attribute, and then converted to byte.  
|               .br
|               If the data is being converted from a "lower" data type
|		to a complex data type, this attribute defines how the
|		data should be interpreted \*- as the real or imaginary 
|		component of the complex pair.  
|		.symbol index KPHASE
|		and 
|		.symbol index KMAGNITUDE
|		are invalid values for up converting
|		to complex, and will result in an error.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_COMPLEX_CONVERT	"pdsLocationComplexConversion"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_DATA_TYPE
| Type:		int datatype
| Default:      
| Category:     location
| Legal Values: KBIT
|               KBYTE
|               KUBYTE
|               KSHORT
|               KUSHORT
|               KINT
|               KUINT
|               KLONG
|               KULONG
|               KFLOAT
|               KDOUBLE
|               KCOMPLEX
|               KDCOMPLEX
| Description:	This attribute is used to get or set the data type, or 
|		numerical representation of the data.  This 
|		data type will be the presentation data type, not 
|		necessarily the physical data type.  See the 
|		.symbol index KPDS_COUPLING
|		attribute for more information on how to control the 
|		presentation and physical data types.  When the 
|		application programmer specifies a presentation data type
|               that is different than the actual data type of the stored
|		data, the get 
|		.symbol index kpds_get_data 
|		function will convert the data
|		to return the requested data type.  Likewise, the 
|		.symbol index kpds_put_data 
|		function expects data that is in the data 
|		type specified by this attribute to the output object, and
|		if the data being "put" is of a different type, it will be
|               converted.  This attribute must be set for objects created
|		via 
|		.symbol index kpds_create_object 
|		or output objects that are opened 
|		with 
|		.symbol index kpds_open_output_object 
|		or 
|		.symbol index kpds_open_object , 
|		or else the get and put data calls will fail.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_LOCATION_DATA_TYPE		"pdsLocationDatatype"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_END
| Type:		double w, h, d
| Default:      0.0, 0.0, 0.0
| Category:     location
| Legal Values: 
| Description:	This attribute represents an explicit end marker point
|		for the polymorphic data model.  This end point maps
|		to the implicit extent of the data model.  This attribute 
|		can only be set if uniform 
|		.segment index location 
|		data has been 
|		explicitly created with a 
|		.symbol index kpds_create_location 
|		call. 
|		See also: 
|		.symbol index KPDS_LOCATION_BEGIN .
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_END		"locationEnd"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_GRID
| Type:		int grid_type
| Default:      
| Category:     location
| Legal Values: KNONE 
|		KUNIFORM
|		KRECTILINEAR
|		KCURVILINEAR
| Description:	The 
|		.segment index location 
|		grid attribute specifies the grid type
|		to use when creating the 
|		.segment index location 
|		data.  This attribute
|		should be set before a 
|		.symbol index kpds_create_location 
|		operation.
|		By default, if the 
|		.segment index location 
|		data type is 
|		.symbol noindex KNONE 
|		and 
|		.segment index location 
|		data is created, a curvilinear 
|		.segment index location 
|		grid will be created
|		and this attribute will be set to KCURVILINEAR.
| Access:	
| Persistence:	permanent
------------------------------------------------------------------------*/
#define KPDS_LOCATION_GRID		"pdsLocationGrid"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_INTERPOLATE
| Type:		int interpolate
| Default:      KPAD
| Category:     location
| Legal Values: KNONE
|               KPAD
|               KZERO_ORDER
| Description:	This attribute specifies how the data should be         
|               presented if the application program requests a size    
|		different from what is physically stored. If the size   
|		requested is larger than the physical size and the      
|               interpolation requested is 
|		.symbol index KPAD
|		the pad value   
|               will be returned for all points outside of the physical 
|               size.  If the size requested is smaller than the        
|               physical size and the interpolation requested is        
|               .symbol index KPAD 
|		the returned data is clipped to the size   
|               requested.  If the size requested is larger than the    
|               physical size and the interpolation requested is        
|               .symbol index KZERO_ORDER
|		the data is duplicated.  If the size
|               requested is smaller than the physical size and the     
|               interpolation requested is 
|		.symbol index KZERO_ORDER
|		the data 
|               is sub-sampled.  If the interpolate attribute is set to 
|               .symbol index KNONE , 
|		an error will be returned if the program 
|		requests a size different from what is physically       
|		stored.                                                 
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_INTERPOLATE	"pdsLocationInterpolate"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_LINE_INFO
| Type:		int line_size, num_lines
| Default:      
| Category:     location
| Legal Values: 
| Description:	This attribute will return the size of a line of data and
|		the number of lines in the data.  The line size will be 
|		the size of the width axis and the of lines number will be
|		the product of the other axes' sizes.
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_LINE_INFO		"pdsLocationLineInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_NORM_MAX
| Type:		double norm_max
| Default:      
| Category:     location
| Legal Values: > norm_min
| Description:	This attribute specifies the maximum to be used when 
|		normalizing data values.  This attribute is used in 
|		conjunction with the 
|		.symbol noindex KPDS_*_NORM_MIN 
|		attribute, 
|		respectively, to determine the bounds of a normalization
|               operation.  This attribute comes into play when the 
|		.symbol noindex KPDS_*_SCALING 
|		attribute is set to 
|		.symbol index KNORMALIZE .
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_NORM_MAX		"pdsLocationNormMax"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_NORM_MIN
| Type:		double norm_min
| Default:      unknown
| Category:     location
| Legal Values: < norm_max
| Description:	This attribute specifies the minimum to be used when 
|		normalizing data values.  This attribute is used in 
|		conjunction with the 
|		.symbol noindex KPDS_*_NORM_MAX 
|		attribute, 
|		respectively, to determine the bounds of a normalization
|               operation.  This attribute comes into play when the 
|		.symbol noindex KPDS_*_SCALING 
|		attribute is set to 
|		.symbol index KNORMALIZE .
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_NORM_MIN		"pdsLocationNormMin"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_OFFSET
| Type:		int w, h, d, n
| Default:      0, 0, 0, 0
| Category:     location
| Legal Values: +/- int
| Description:	These attribute values specify the offset into the
|               data position for all primitives.
|               Offset values beyond the boundaries of the data are valid.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_OFFSET		"pdsLocationOffset"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_PAD_VALUE
| Type:		double real, imag
| Default:      0.0, 0.0
| Category:     location
| Legal Values: 
| Description:	This attribute specifies the real (and imaginary) values of the pad
|               data if the 
|		.symbol noindex KPDS_*_INTERPOLATE 
|		attribute is set to 
|		.symbol index KPAD ,
|               respectively.  The double values must be specified, whether the data
|               is real or complex.  The pad values will internally be converted from
|               double to the appropriate data type.
|               .br
|               The default pad value for 
|		.segment index location , 
|		.segment index map , 
|		.segment index time 
|		and 
|		.segment index value 
|		is 0.  The
|               default pad value for the 
|		.segment index mask 
|		is 1 because when padding data, the
|               padded portion of the 
|		.segment index value 
|		data should initially be considered
|               valid.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_PAD_VALUE		"pdsLocationPadValue"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_PLANE_INFO
| Type:		int w, h, num_planes
| Default:      
| Category:     location
| Legal Values: 
| Description:	This attribute will return the size of a plane of data and the number
|               of planes in the data.  The plane size will be the size of the width
|               and height axes and the number will be the product of the sizes of the
|               other axes.
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_PLANE_INFO	"pdsLocationPlaneInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_POSITION
| Type:		int w, h, d, n
| Default:      0, 0, 0, 0
| Category:     location
| Legal Values: +/- int
| Description:	The position attribute specifies four indices to
|               locate a specific PRIMITIVE in the 
|		.segment index location 
|		data.
|               w is 
|		.property - width , 
|		h is 
|		.property - height , 
|               d is 
|		.property - depth 
|		and 
|		n is
|		.property - dimension .
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_POSITION		"pdsLocationPosition"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_INCREMENT_SIZE
| Type:		int width,height,depth,num_volumes
| Default:      
| Category:     location
| Legal Values: 
| Description:	This attribute is used to alter how the auto-increment
|		state machine behaves.  Normally, the size of the data set
|		is used to dictate how position auto-advances from one
|		position to the next, based on the primitive being accessed.
|		This attribute, if set, will be used instead of the size
|		of the data set for controlling auto-advancement.  One place
|		where such functionality is useful is when a smaller data set
|		is being inserted into a larger one.  The larger destination 
|		data set's INCREMENT_SIZE attribute can be set to the size 
|		of the smaller source data set so that the auto-advancement
|		stays synchronized across all dimensions.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_INCREMENT_SIZE    "pdsLocationIncrementSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_REGION_INFO
| Type:		int w, h, d, dim, num_regions
| Default:      
| Category:     location
| Legal Values: 
| Description:	This attribute will return the size of a region of data 
|		and the number of regions in the data.  The 
|		.symbol noindex KPDS_*_REGION_SIZE 
|		attribute controls the size and 
|		dictates the number of regions, which will always be 
|		rounded up.  See 
|		.symbol noindex KPDS_*_REGION_SIZE 
|		for more information.
| Access:	read_only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_REGION_INFO	"pdsLocationRegionInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_REGION_SIZE
| Type:		int w, h, d, dim
| Default:      1, 1, 1, 1
| Category:     location
| Legal Values: > 0
| Description:	These attribute values specify the size of the region being processed.
|               If the region size for one or more dimensions is not a even multiple of
|               the data size, then the pad value will be returned by 
|		.symbol index kpds_get_data 
|		for all data outside of the data space, which is set by 
|		.symbol noindex KPDS_*_PAD_VALUE .  
|		On a 
|		.symbol index kpds_put_data 
|		call, data points outside of the data space 
|               will be truncated.  E.g. if the object width is 512 and the region width is
|               200, then getting the first two regions will return the data for those
|               regions.  The next get will return the remaining 112 points from the data
|               in the width direction with the remaining 88 points set to the pad value.
|               On a put for this same setup, the first two puts will place full regions
|               into the data object, but the last put will place only the first 112 points
|               into the data object in the width direction and the last 88 points are
|               truncated.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_REGION_SIZE	"pdsLocationRegionSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_OPTIMAL_REGION_SIZE
| Type:		int w, h, d, dim, num_regions
| Default:      
| Category:     location
| Legal Values: > 0
| Description:	This attribute will return the size of a region of data and the number
|               of such regions that is most efficient to process in terms of
|               performance and memory use.  The 
|		.symbol noindex KPDS_*_REGION_SIZE 
|		attribute
|               controls the size and dictates the number of regions, which will
|               always be rounded up.  See 
|		.symbol noindex KPDS_*_REGION_SIZE 
|		for more information.
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_OPTIMAL_REGION_SIZE "pdsOptimalLocationRegionSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_SCALING
| Type:		int scaling
| Default:      KNONE
| Category:     location
| Legal Values: KNONE
|               KNORMALIZE
|               KSCALE
| Description:	This attribute specifies whether scaling or normalization should be
|               performed.
|               .br
|               If
|		.symbol index KSCALE 
|		is specified for the 
|		.segment index value 
|		data, values will be
|               scaled, according to the
|               .symbol index KPDS_VALUE_SCALE_FACTOR
|               and
|               .symbol index KPDS_VALUE_SCALE_OFFSET
|               attributes.  If 
|		.symbol index KNORMALIZE 
|		is specified for the 
|		.segment index value
|		data, values will be normalized using the
|               .symbol index KPDS_VALUE_NORM_MIN
|               and
|               .symbol index KPDS_VALUE_NORM_MAX
|               attributes.  If this attribute is set to 
|		.symbol index KNONE 
|		for the value
|               data, values will not be scaled or normalized.  The same is true
|               for the 
|		.segment index map
|		and
|		.segment index mask
|		data.  They will use their respective scale
|               factor & offset and normalize minimum & maximum attributes.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_SCALING		"pdsLocationScaling"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_SCALE_FACTOR
| Type:		double scale_factor
| Default:      1.0
| Category:     location
| Legal Values: 
| Description:	This attribute specifies the scaling factor to be used when scaling
|               data values.  This attribute comes into play when the 
|		.symbol noindex KPDS_*_SCALING
|               attribute is set to 
|		.symbol index KSCALE , 
|		respectively.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_SCALE_FACTOR	"pdsLocationScaleFactor"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_SCALE_OFFSET
| Type:		double real, offset
| Default:      0.0, 0.0
| Category:     location
| Legal Values: 
| Description:	This attribute specifies the scaling offset to be used when scaling
|               data values.  This attribute comes into play when the 
|		.symbol noindex KPDS_*_SCALING
|               attribute is set to 
|		.symbol index KSCALE , 
|		respectively.
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_SCALE_OFFSET	"pdsLocationScaleOffset"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_SIZE
| Type:		int w, h, d, dim
| Default:      
| Category:     location
| Legal Values: > 0
| Description:	This attribute specifies the size of the dimensions 
|		.property - width ,
|               .property - height , 
|		.property - depth , 
|		.property - elements , 
|		.property - time , 
|		.property - "location dimension" , 
|		.property - "map width" , 
|		.property - "map height" , 
|		.property - "map elements" ,
|               .property - "map depth"
|	 	and 
|		.property - "map time" .
|               .br
|               When the application programmer specifies a size larger than the
|               actual size of stored data, the get functions will sub-sampled,
|               clipped, padded or duplicated the data to present the program with the
|               requested amount, see the attribute
|               .symbol index KPDS_VALUE_INTERPOLATE
|               for more details.  The put functions store exactly the size that the
|               physical attributes will allow even if the amount of data "put" (set
|               by the presentation attributes) is different.  This attribute must be
|               set for objects created via 
|		.symbol index kpds_create_object 
|		or output objects else get/put data calls will fail.
|               .br
|               The size of the 
|		.segment index mask
|		and 
|		.segment index value
|		data is identical.  The
|               .segment index time
|		size is shared between the
|		.segment index time , 
|		.segment index mask 
|		and
|               .segment index value
|		data.  The 
|		.property - width , 
|		.property - height
|	        and 
|		.property - depth
|               are shared between the 
|		.segment index location , 
|		.segment index mask
|	        and 
|		.segment index value
|               data.
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_LOCATION_SIZE		"pdsLocationSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_VECTOR_INFO
| Type:		int vector_length, num_vectors
| Default:      
| Category:     location
| Legal Values: 
| Description:	This attribute will return the size of a vector of data and the number
|               of vectors in the data.  The vector size and number depend on the
|               vector definition for the data primitive.  For 
|		.symbol index KPDS_VALUE_VECTOR_INFO ,
|               the size is the size of the element vector and the number is the
|               product of the remaining dimensions.  
| Access:	readonly
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_VECTOR_INFO	"pdsLocationVectorInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_LOCATION_VOLUME_INFO
| Type:		int w, h, d, num_volumes
| Default:      
| Category:     location
| Legal Values: 
| Description:	This attribute will return the size of a volume of data and the number
|               of volumes in the data.  The volume size will be the size of the
|               width, height, and depth axes.  The number volumes will be the product
|               of the sizes of the remaining axes.
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_LOCATION_VOLUME_INFO	"pdsLocationVolumeInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_COMPLEX_CONVERT
| Type:		int convert
| Default:      KREAL
| Category:     time
| Legal Values: KIMAGINARY
|               KMAGNITUDE
|               KPHASE
|               KREAL
|		KMAGSQ
|		KMAGSQP1
|		KLOGMAG
|		KLOGMAGP1
| Same As:      KPDS_LOCATION_COMPLEX_CONVERT
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_TIME_COMPLEX_CONVERT	"pdsTimeComplexConversion"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_DATA_TYPE
| Type:		int datatype
| Default:      
| Category:     time
| Legal Values: KBIT
|               KBYTE
|               KUBYTE
|               KSHORT
|               KUSHORT
|               KINT
|               KUINT
|               KLONG
|               KULONG
|               KFLOAT
|               KDOUBLE
|               KCOMPLEX
|               KDCOMPLEX
| Same As:      KPDS_LOCATION_DATA_TYPE
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_TIME_DATA_TYPE		"pdsTimeDatatype"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_INTERPOLATE
| Type:		int interpolate
| Default:      KPAD
| Category:     time
| Legal Values: KNONE
|               KPAD
|               KZERO_ORDER
| Same As:	KPDS_LOCATION_INTERPOLATE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_TIME_INTERPOLATE		"pdsTimeInterpolate"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_NORM_MAX
| Type:		double norm_max
| Default:      
| Category:     time
| Legal Values: > norm_min
| Same As:	KPDS_LOCATION_NORM_MAX
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_TIME_NORM_MAX		"pdsTimeNormMax"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_NORM_MIN
| Type:		double norm_min
| Default:      
| Category:     time
| Legal Values: < norm_max
| Same As:	KPDS_LOCATION_NORM_MIN
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_TIME_NORM_MIN		"pdsTimeNormMin"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_OFFSET
| Type:		int offset_time
| Default:      0
| Category:     time
| Legal Values: +/- int
| Same As:	KPDS_LOCATION_OFFSET
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_TIME_OFFSET		"pdsTimeOffset"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_PAD_VALUE
| Type:		double real_value,imag_value
| Default:      0.0, 0.0
| Category:     time
| Legal Values: 
| Same As:	KPDS_LOCATION_PAD_VALUE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_TIME_PAD_VALUE		"pdsTimePadValue"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_POSITION
| Type:		int t
| Default:      0
| Category:     time
| Legal Values: +/- int
| Same As:	KPDS_LOCATION_POSITION
|               locate a specific PRIMITIVE in the 
|		.segment index time 
|		data.
|               t is 
|		.property - time .
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_TIME_POSITION		"pdsTimePosition"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_INCREMENT_SIZE
| Type:		int width,height,depth,num_volumes
| Default:      
| Category:     time
| Legal Values: 
| Same As:	KPDS_LOCATION_INCREMENT_SIZE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_TIME_INCREMENT_SIZE        "pdsTimeIncrementSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_REGION_INFO
| Type:		int region_time,num_regions
| Default:      
| Category:     time
| Legal Values: 
| Same As:	KPDS_LOCATION_REGION_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_TIME_REGION_INFO		"pdsTimeRegionInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_REGION_SIZE
| Type:		int region_time
| Default:      1
| Category:     time
| Legal Values: > 0
| Same As:	KPDS_LOCATION_REGION_SIZE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_TIME_REGION_SIZE		"pdsTimeRegionSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_SCALING
| Type:		int scaling
| Default:      KNONE
| Category:     time
| Legal Values: KNONE
|               KNORMALIZE
|               KSCALE
| Same As:	KPDS_LOCATION_SCALING
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_TIME_SCALING		"pdsTimeScaling"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_SCALE_FACTOR
| Type:		double scale_factor
| Default:      1.0
| Category:     time
| Legal Values: 
| Same As:	KPDS_LOCATION_SCALE_FACTOR
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_TIME_SCALE_FACTOR		"pdsTimeScaleFactor"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_SCALE_OFFSET
| Type:		double offset_real, offset_imaginary
| Default:      0.0, 0.0
| Category:     time
| Legal Values: 
| Same As:	KPDS_LOCATION_SCALE_OFFSET
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_TIME_SCALE_OFFSET		"pdsTimeScaleOffset"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_SIZE
| Type:		int t
| Default:      
| Category:     time
| Legal Values: > 0
| Same As:	KPDS_LOCATION_SIZE
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_TIME_SIZE			"pdsTimeSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_TIME_OPTIMAL_REGION_SIZE
| Type:		int t, num
| Default:      
| Category:     time
| Legal Values: 
| Same As:	KPDS_LOCATION_OPTIMAL_REGION_SIZE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_TIME_OPTIMAL_REGION_SIZE     "pdsOptimalTimeRegionSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_COMPLEX_CONVERT
| Type:		int convert
| Default:      KREAL
| Category:     map
| Legal Values: KIMAGINARY
|               KMAGNITUDE
|               KPHASE
|               KREAL
|		KMAGSQ
|		KMAGSQP1
|		KLOGMAG
|		KLOGMAGP1
| Same As:      KPDS_LOCATION_COMPLEX_CONVERT
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_COMPLEX_CONVERT	"pdsMapComplexConversion"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_DATA_TYPE
| Type:		int datatype
| Default:      
| Category:     map
| Legal Values: KBIT
|               KBYTE
|               KUBYTE
|               KSHORT
|               KUSHORT
|               KINT
|               KUINT
|               KLONG
|               KULONG
|               KFLOAT
|               KDOUBLE
|               KCOMPLEX
|               KDCOMPLEX
| Same As:      KPDS_LOCATION_DATA_TYPE
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_MAP_DATA_TYPE		"pdsMapDatatype"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_INTERPOLATE
| Type:		int interpolate
| Default:      KPAD
| Category:     map
| Legal Values: KNONE
|               KPAD
|               KZERO_ORDER
| Same As:	KPDS_LOCATION_INTERPOLATE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_INTERPOLATE		"pdsMapInterpolate"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_LINE_INFO
| Type:		int line_size, num_lines
| Default:      
| Category:     map
| Legal Values: 
| Same As:	KPDS_LOCATION_LINE_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_LINE_INFO		"pdsMapLineInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_NORM_MAX
| Type:		double norm_max
| Default:      
| Category:     map
| Legal Values: > norm_min
| Same As:	KPDS_LOCATION_NORM_MAX
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_NORM_MAX		"pdsMapNormMax"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_NORM_MIN
| Type:		double norm_min
| Default:      
| Category:     map
| Legal Values: < norm_max
| Same As:	KPDS_LOCATION_NORM_MIN
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_NORM_MIN		"pdsMapNormMin"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_OFFSET
| Type:		int mw, mh, md, mt, me
| Default:      0, 0, 0, 0, 0
| Category:     map
| Legal Values: +/- int
| Same As:	KPDS_LOCATION_OFFSET
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_OFFSET			"pdsMapOffset"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_PAD_VALUE
| Type:		double real, imag
| Default:      0.0, 0.0
| Category:     map
| Legal Values: 
| Same As:	KPDS_LOCATION_VALUE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_PAD_VALUE		"pdsMapPadValue"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_PLANE_INFO
| Type:		int map_plane_width, map_plane_height, num_planes
| Default:      
| Category:     map
| Legal Values: 
| Same As:	KPDS_LOCATION_PLANE_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_PLANE_INFO		"pdsMapPlaneInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_POSITION
| Type:		int mw, mh, md, mt, me
| Default:      0, 0, 0, 0, 0
| Category:     map
| Legal Values: 
| Same As:	KPDS_LOCATION_POSITION
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_POSITION		"pdsMapPosition"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_INCREMENT_SIZE
| Type:		int width, height, depth, time, elements, num_volumes
| Default:      
| Category:     map
| Legal Values: 
| Same As:	KPDS_LOCATION_INCREMENT_SIZE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_INCREMENT_SIZE         "pdsMapIncrementSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_REGION_INFO
| Type:		int region_width, region_height, region_depth, region_time, region_elements, num_regions
| Default:      
| Category:     map
| Legal Values: 
| Same As:	KPDS_LOCATION_REGION_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_REGION_INFO		"pdsMapRegionInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_REGION_SIZE
| Type:		int region_width, region_height, region_depth, region_time, region_elements
| Default:      1, 1, 1, 1, 1
| Category:     map
| Legal Values: > 0
| Same As:	KPDS_LOCATION_REGION_SIZE
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_REGION_SIZE		"pdsMapRegionSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_OPTIMAL_REGION_SIZE
| Type:		int region_width, region_height, region_depth, region_time, region_elements, number_of_regions
| Default:      
| Category:     map
| Legal Values: > 0
| Same As:	KPDS_LOCATION_OPTIMAL_REGION_SIZE
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_OPTIMAL_REGION_SIZE      "pdsOptimalMapRegionSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_SCALING
| Type:		int scaling
| Default:      KNONE
| Category:     map
| Legal Values: KNONE
|               KNORMALIZE
|               KSCALE
| Same As:	KPDS_LOCATION_SCALING
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_SCALING		"pdsMapScaling"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_SCALE_FACTOR
| Type:		double scale_factor
| Default:      
| Category:     map
| Legal Values: 1.0
| Same As:	KPDS_LOCATION_SCALE_FACTOR
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_SCALE_FACTOR		"pdsMapScaleFactor"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_SCALE_OFFSET
| Type:		double offset_real, offset_imaginary
| Default:      0.0, 0.0
| Category:     map
| Legal Values: 
| Same As:	KPDS_LOCATION_SCALE_OFFSET
| Access:	
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_SCALE_OFFSET		"pdsMapScaleOffset"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_SIZE
| Type:		int map_width, map_height, map_depth, map_time, map_elements
| Default:      
| Category:     map
| Legal Values: > 0
| Same As:	KPDS_LOCATION_SIZE
| Access:	
| Persistence:	stored
------------------------------------------------------------------------*/
#define KPDS_MAP_SIZE			"pdsMapSize"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_VECTOR_INFO
| Type:		int vector_length, num_vectors
| Default:      
| Category:     map
| Legal Values: 
| Same As:	KPDS_LOCATION_VECTOR_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_VECTOR_INFO		"pdsMapVectorInfo"

/*------------------------------------------------------------------------
| Attribute:	KPDS_MAP_VOLUME_INFO
| Type:		int map_width,map_height,map_depth,num_volumes
| Default:      
| Category:     map
| Legal Values: 
| Same As:	KPDS_LOCATION_VOLUME_INFO
| Access:	read only
| Persistence:	transient
------------------------------------------------------------------------*/
#define KPDS_MAP_VOLUME_INFO		"pdsMapVolumeInfo"

/*
 * these attributes should be documented soon.
 */
#define KPDS_LOCATION_OPTIMAL_REGION_CONSTRAINT  "pdsLocationOptimalRegionConstraint"
#define KPDS_LOCATION_OPTIMAL_REGION_FLAGS       "pdsLocationOptimalRegionFlags"

#define KPDS_TIME_OPTIMAL_REGION_CONSTRAINT  "pdsTimeOptimalRegionConstraint"
#define KPDS_TIME_OPTIMAL_REGION_FLAGS       "pdsTimeOptimalRegionFlags"

#define KPDS_VALUE_OPTIMAL_REGION_CONSTRAINT  "pdsValueOptimalRegionConstraint"
#define KPDS_VALUE_OPTIMAL_REGION_FLAGS       "pdsValueOptimalRegionFlags"

#define KPDS_MASK_OPTIMAL_REGION_CONSTRAINT  "pdsMaskOptimalRegionConstraint"
#define KPDS_MASK_OPTIMAL_REGION_FLAGS       "pdsMaskOptimalRegionFlags"

#define KPDS_MAP_OPTIMAL_REGION_CONSTRAINT  "pdsMapOptimalRegionConstraint"
#define KPDS_MAP_OPTIMAL_REGION_FLAGS       "pdsMapOptimalRegionFlags"

/*
 * These attributes are not documented because they shouldn't even
 * exist.  If you are planning on using these, DON'T.
 */
#define KPDS_LOCATION_MINMAX		"pdsLocationMinmax"
#define KPDS_MAP_MINMAX			"pdsMapMinmax"
#define KPDS_TIME_MINMAX		"pdsTimeMinmax"
#define KPDS_VALUE_MINMAX		"pdsValueMinmax"
#define KPDS_ELEMENTS_FIRST		"pdsElementsFirst"
#define KPDS_LOCATION_DIMENSION		"pdsLocationDimension"
#define KPDS_VALUE_HIST_POSITION	"pdsValueHistPosition"
#define KPDS_VALUE_HIST_NUMBINS		"pdsValueHistNumBins"
#define KPDS_VALUE_HIST_RANGE		"pdsValueHistRange"
#define KPDS_VALUE_HIST_REGION_SIZE	"pdsValueHistRegionSize"


/* ################################################################## */


	/*
	 *   Callback values
	 */

#define KPDS_CALLBACK_CHANGE		KDMS_CALLBACK_CHANGE
#define KPDS_CALLBACK_ACCESS		KDMS_CALLBACK_ACCESS
#define KPDS_CALLBACK_DELETE		KDMS_CALLBACK_DELETE
#define KPDS_CALLBACK_SAVE		KDMS_CALLBACK_SAVE

	/*
	 *   Mapping Modes
         */

#define KUNMAPPED 0
#define KMAPPED 1

	/*
	 *   Location Grid Types
         */

#define KUNIFORM     1
#define KRECTILINEAR 2
#define KCURVILINEAR 3


	/*
	 *   Masking Modes
         */

#define KUSE_ORIGINAL 	      0
#define KUSE_SUBSTITUTE_VALUE 1

	/*
	 *    History Modes
         */

#define KAPPEND_HISTORY 	0
#define KREPLACE_HISTORY 	1



	/*
	 *  Attribute DEFAULT VALUES 
	 */

/* Polymorphic Attributes */
#define KPDS_COMMENT_DEFAULT		NULL
#define KPDS_COMPLEX_CONVERT_DEFAULT	KREAL
#define KPDS_COUPLING_DEFAULT		KCOUPLED
#define KPDS_DATE_DEFAULT		NULL
#define KPDS_FORMAT_DEFAULT		KVIFF
#define KPDS_HISTORY_DEFAULT		NULL

#define KPDS_MAP_ENABLE_DEFAULT		KOPTIONAL 
#define KPDS_INCREMENT_DEFAULT		1
#define KPDS_INTERPOLATE_DEFAULT	KPAD
#define KPDS_MAX_DEFAULT		1
#define KPDS_MIN_DEFAULT		0
#define KPDS_NORM_MAX_DEFAULT		1
#define KPDS_NORM_MIN_DEFAULT		0
#define KPDS_OFFSET_DEFAULT		0
#define KPDS_PAD_VALUE_DEFAULT		0.0
#define KPDS_MAP_POSITION_DEFAULT	0
#define KPDS_POSITION_DEFAULT		0
#define KPDS_REGION_SIZE_DEFAULT	1
#define KPDS_SCALING_DEFAULT		KNONE
#define KPDS_SCALE_FACTOR_DEFAULT	1.0
#define KPDS_SCALE_OFFSET_DEFAULT	0.0
#define KPDS_MAP_SIZE_DEFAULT		1
#define KPDS_SIZE_DEFAULT		1

#define KPDS_LOCATION_DATA_TYPE_DEFAULT		KBYTE
#define KPDS_MAP_DATA_TYPE_DEFAULT		KBYTE
#define KPDS_MASK_DATA_TYPE_DEFAULT		KBIT
#define KPDS_TIME_DATA_TYPE_DEFAULT		KBYTE
#define KPDS_VALUE_DATA_TYPE_DEFAULT		KBYTE

#define KPDS_NAME_DEFAULT		NULL

#define KPDS_DELTA_SIZE_DEFAULT		0.0



	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/

/************************************************************
*
*  Routine Name: kpds_open_input_object - open an input object for 
*		 reading
*
*       Purpose: 
*		 This function is a simplified interface to the
*		 kpds_open_object function.  It differs from
*		 kpds_open_object in that it assumes that the object
*		 is read-only and its transport has permanence.  If a
*		 permanent file is not desired (i.e.  the object is
*		 going to be used as temporary storage, and will not
*		 be used by any other process) then the
*		 kpds_create_object function call should be used
*		 instead.
*
*		 The argument to this function is the transport or
*		 file name.  This argument indicates the name of the
*		 transport that is associated with the object.  The
*		 transport name can be any legal Khoros transport
*		 description.  While this will usually be a regular
*		 UNIX file name, it is also possible to specify such
*		 things as shared memory pointers, memory map
*		 pointers, sockets, streams, and even transports on
*		 other machines.  For more information on the syntax
*		 of a Khoros transport name, refer to the online man
*		 page for the Khoros function kopen.  For more
*		 information about opening an object, see
*		 kpds_open_object.
*
*		 The presentation index order will be set to KWIDTH,
*		 KHEIGHT, KDEPTH, KTIME and KELEMENTS for the value
*		 and mask data, to KMAP_WIDTH, KMAP_HEIGHT,
*		 KMAP_ELEMENTS, KMAP_SPATIAL and KMAP_TIME for the map
*		 data and KWIDTH, KHEIGHT, KDEPTH and KDIMENSION for
*		 the location data.  The only way to get the index
*		 order to reflect the stored index order of the data
*		 is to call kpds_sync_object.  See the man page for
*		 kpds_sync_object for more information.
*
*		 Because this function opens an input object, the
*		 KPDS_COUPLING attribute is set to KPDS_UNCOUPLED.
*
*		 This function is equivalent to:
*
*	!	kpds_open_object(name, KOBJ_READ)
*
*	  Input: name - a string that contains the path name
*			of a file or transport that will be 
*			associated with the object.
*
*        Output: 
*
*       Returns: a kobject on success, KOBJECT_INVALID on failure.
*
*  Restrictions:
*
*    Written By: Jeremy Worley & John Salas
*          Date: Sep 16, 1993 17:14
*      Verified:
*  Side Effects: 
* Modifications: 
* 
*   Declaration: kobject kpds_open_input_object( 
*		!   char *name) 
* 
*************************************************************/

#define kpds_open_input_object(name)    kpds_open_object(name, KOBJ_READ)

/************************************************************
*
*  Routine Name: kpds_open_output_object - open an output object for 
*		 writing
*
*       Purpose: 
*		 This function is a simplified interface to the
*		 kpds_open_object function.  It differs from
*		 kpds_open_object in that it assumes that the object
*		 is write-only and its transport has permanence.  If a
*		 permanent file is not desired (i.e. the object is
*		 going to be used as temporary storage, and will not
*		 be used by any other process) then the
*		 kpds_create_object function call should be used
*		 instead.
*
*		 The argument to this function is the transport or
*		 file name.  This argument indicates the name of the
*		 transport that is associated with the object.  The
*		 transport name can be any legal khoros transport
*		 description.  While this will usually be a regular
*		 UNIX file name, it is also possible to specify such
*		 things as shared memory pointers, memory map
*		 pointers, sockets, streams, and even transports on
*		 other machines.  For more information on the syntax
*		 of a Khoros transport name, refer to the online man
*		 page for the Khoros function kopen.  For more
*		 information about opening objects, see
*		 kpds_open_object.
*
*		 The default index order will be set to KWIDTH,
*		 KHEIGHT, KDEPTH, KTIME and KELEMENTS for the value
*		 and mask data, to KMAP_WIDTH, KMAP_HEIGHT,
*		 KMAP_ELEMENTS, KMAP_SPATIAL and KMAP_TIME for the map
*		 data and KWIDTH, KHEIGHT, KDEPTH and KDIMENSION for
*		 the location data.
*
*		 This function is equivalent to:
*
*	!	kpds_open_object(name, KOBJ_WRITE)
*
*	  Input: name - a string that contains the path name
*			of a file or transport that will be 
*			associated with the object.
*
*        Output: 
*
*       Returns: a kobject on success, KOBJECT_INVALID on failure.
*
*  Restrictions:
*
*    Written By: Jeremy Worley & John Salas
*          Date: Sep 16, 1993 17:14
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: kobject kpds_open_output_object(
*		!   char *name)
*
*************************************************************/

#define kpds_open_output_object(name)   kpds_open_object(name, KOBJ_WRITE)

/************************************************************
*
*  Routine Name: kpds_create_object - create a temporary data object.
*
*       Purpose: 
*		 This function is used to instantiate a data object
*		 (kobject) when it will only be used for temporary
*		 storage of information.  If you are intending to
*		 process an object that already exists as a file or
*		 transport (input), or you are planning on saving the
*		 kobject to a file or transport (output), then the
*		 appropriate routines to use are
*		 kpds_open_input_object, kpds_open_output_object, or
*		 kpds_open_object.
*
*                This function creates an instance of a data object
*                that will have associated with it a temporary
*                transport that will be used for buffering large
*                amounts of data.  This temporary transport will be
*                automatically removed when the process terminates.
*                There is no way to rename the temporary file or
*                replace the temporary file with a permanent one.
*
*		 The kpds_create_object function call creates what is
*		 essentially a "blank" object.  That is, the object
*		 will initially have no data and all attributes will
*		 be initialized to default values or to an initialized
*		 state.  The default values for attributes are
*		 described in the Khoros 2.0 Programming Services
*		 Volume 2 Manual.
*
*		 An object that is created with this function call
*		 behaves similarly to an output object that is created
*		 with the kpds_open_output_object function call,
*		 i.e. the object initially has no data or attributes.
*		 Thus, it is necessary to create the location, map,
*		 mask, time and/or value data and initialize
*		 attributes such as size and datatype prior to using
*		 the object.
*
*         Input: 
*
*        Output: 
*
*       Returns: kobject on success, KOBJECT_INVALID upon failure
*
*  Restrictions:
*    Written By: Jeremy Worley & John Salas
*          Date: Sep 16, 1993 17:14
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: kobject kpds_create_object(void)
*
*************************************************************/

#define kpds_create_object()  (kdms_create())

/************************************************************
*
*  Routine Name: kpds_close_object - close an open data object.
*
*       Purpose: 
*		 This function is called on an object when all
*		 interaction with the object is complete.  In addition
*		 to freeing resources that were used to manage the
*		 object, this function also writes any component of
*		 the data set that has not yet been written and may
*		 alter index order and datatype of the data to that is
*		 supported by the file format.
*
*		 If the object was created with the
*		 kpds_reference_object function call, or if another
*		 object was created as a reference of the one being
*		 closed, then the object might be sharing some of its
*		 resources with other objects.  If this is the case,
*		 then those shared resources will not be freed, but
*		 rather they will be disassociated from the object
*		 being closed.  Thus, closing an object does not
*		 affect any other object.
*
*         Input: object - the object to be closed.
*
*        Output: 
*       Returns: TRUE (1) if object is closed successfully, FALSE (0) otherwise
*
*  Restrictions:
*    Written By: Jeremy Worley & John Salas
*          Date: Sep 16, 1993 17:22
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: int kpds_close_object(
*		!   kobject object)
*
*************************************************************/

#define kpds_close_object(object)  (kdms_close(object))

/************************************************************
*
*  Routine Name: kpds_sync_object - synchronize physical and presentation
*                layers of a data object.
*
*       Purpose: 
*		 This function is used to update physical attributes
*		 of the entire data object to match those of the
*		 presentation layer, or visa-versa.
*
*		 When an attribute is set via kpds_set_attribute(s) or
*		 kpds_copy_object_attr, the presentation version of
*		 the attribute is the only thing that is directly
*		 manipulated. The KPDS_COUPLING attribute is used at
*		 that time to determine if the physical attribute
*		 should be updated to correspond to its value at the
*		 presentation level or vice versa.  The KPDS_COUPLING
*		 attribute can take on one of three values:
*		 KUNCOUPLED, KCOUPLED, or KDEMAND.  If it is set to
*		 KUNCOUPLED or KDEMAND, then Polymorphic Services will
*		 not update the physical layer.  If the attribute is
*		 set to KCOUPLED, then Polymorphic Services
*		 immediately updates the physical layer any time
*		 kpds_set_attribute(s) is called.  If the attribute is
*		 set to KDEMAND, then this updating will only occur
*		 when kpds_sync_object is called.  If the
*		 KPDS_COUPLING attribute is set to KUNCOUPLED, then
*		 this routine will simply return and an error message
*		 will be returned.
*
*         Input: object	   - data object to be re-synchronized.
*                direction - the desired direction of the synchronization.
*                            the legal values are KPRES2PHYS, which
*                            indicates that the physical layer will be
*                            updated to correspond to the presentation
*                            layer; and KPHYS2PRES, which indicates
*                            that the presentation layer will be updated
*                            to correspond to the physical layer.
*
*        Output: 
*
*       Returns: TRUE (1) if object sync'ed, FALSE (0) otherwise
*
*  Restrictions: 
*    Written By: Jeremy Worley & John Salas
*          Date: Sep 19, 1993 14:52
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: int kpds_sync_object(
*		!   kobject object,
*		!   int direction)
*
*************************************************************/

#define kpds_sync_object(object, direction) \
 (kdms_sync(object, KDMS_OBJECT, direction))

/************************************************************
*
*  Routine Name: kpds_copy_object_data - copy all data from
*                one object to another object.
*
*       Purpose: 
*		 This function copies all of the data associated with
*		 the source_object to the destination_object.  This
*		 means that all of the data in the object will be
*		 copied, not just the data associated with the
*		 polymorphic data model (Value, Mask, Map, Location
*		 and Time data).  For example, the source object may
*		 contain data that one of the other services (such as
*		 geometry services or color services.) use.  These
*		 data will also be copied.
*
*		 This routine will create all of the data in the
*		 destination_object that do not exist. It will
*		 initialize two attributes that are used to define the
*		 physical storage the of the data: KPDS_*_SIZE, and
*		 KPDS_*_DATA_TYPE.  If the data already exists in the
*		 destination_object, then the data will be replaced
*		 with what is in the source_object. In this case, the
*		 data type and size will not be changed.  As the data
*		 is copied from the source to the destination, it will
*		 be cast and resized to fit the destination.  The
*		 attribute that is used to control how the resize
*		 occurs is KPDS_*_INTERPOLATE.  This attribute can
*		 take on the values KNONE indicating that no resize
*		 should occur (if resize is necessary, then this
*		 function will fail); KPAD, indicating that the data
*		 should be padded with the KPDS_*_PAD_VALUE if the
*		 source object is larger than the source, or clipped
*		 if the destination is smaller than the source; or
*		 KZERO_ORDER, which indicates that a zero-order hold
*		 interpolation (pixel replication) should occur.
*
*         Input: source_object - the object that serves as a source
*				 for the data.
*
*        Output: destination_object - the object that will serve as
*				      a destination in the copy
*				      operation.
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions:
*    Written By: Jeremy Worley & John Salas
*          Date: Sep 20, 1993 14:28
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: int kpds_copy_object_data(
*		!   kobject source_object,
*		!   kobject destination_object)
*
*************************************************************/

#define kpds_copy_object_data(source, destination) \
    (KPDS_INIT ? kaps_copy_object(source,destination,FALSE,TRUE) : FALSE)

/************************************************************
*
*  Routine Name: kpds_create_object_attr - create an attribute
*                associated the data object.
*
*       Purpose: 
*                The purpose of this routine is to provide the programmer 
*                with a mechanism for creating attributes that
*                are specific to the program being written.  The attribute
*		 created will be associated with the data object
*		 itself and not with the Value, Mask, Map, Location
*		 or Time data.
*
*                The second argument to this function is the name
*                of the attribute to be created.  If the attribute
*                specified already exists then this function will
*		 return FALSE.
*                
*                The type argument indicates the data type of all the
*		 elements associated with the attribute.  It
*                take on any of the following values:  KUBYTE,
*                KBYTE, KUSHORT, KSHORT, KUINT, KINT, KULONG, KLONG,
*                KFLOAT, KDOUBLE, KCOMPLEX, or KDCOMPLEX.  Any other
*                value is considered illegal.  Passing this argument
*                with an illegal value will force this function to
*                return FALSE.
*
*		 The num argument indicates how many of elements of
*                the type "type" will be contained in the attribute.
*                This information is necessary so that Polymorphic Services
*                can allocate sufficient memory to store the attribute.
*		 A negative or 0 value passed in will force this function to
*		 return FALSE.
*
*		 The length argument indicates the size of each element,
*		 (i.e. you could be passing in a pointer to an array of
*		 integers or several arrays if num greater than 1).
*                This information is necessary so that Polymorphic Services
*                can allocate sufficient memory to store the attribute.
*		 This argument specifies the length of the array that
*		 needs to be allocated.
*
*		 The last argument, permanent indicates whether the
*		 attribute should be saved when the data object is
*		 closed and being stored in a permanent transport.  It
*		 should be set to TRUE if the attribute is permanent
*		 and FALSE if the attribute is transient.
*
*		 For example, calling this function as follows:
*
*		!	kpds_create_object_attr(object, "Nose", 1, 10, KFLOAT, FALSE);
*
*		 will create an attribute called "Nose" that contains 10
*		 floats that are accessed as a single array.  A call to 
*		 kpds_get_attribute might look like this:
*
*		!	float *array;
*		!	kpds_get_attribute(object, "Nose", &array);
*
*         Input: object         - the object on which to instantiate
*                                 the new attribute.
*
*                segment        - segment identifier string specifying
*                                 which segment to create the attribute in.  
*                                 If NULL, then the attribute will be
*                                 created at the object level.
*
*                attribute      - attribute identifier string.  This
*                                 identifier must be unique for the
*                                 given segment.
*
*                num_args       - number of arguments in the attribute
*
*                arg_size       - size of each attribute argument
*
*                data_type      - data type of the attribute can be
*                                  KBIT, KUBYTE, KBYTE,
*                                  KUSHORT, KSHORT, KUINT, 
*                                  KINT, KULONG, KLONG, KFLOAT
*                                  KDOUBLE, KCOMPLEX, 
*                                  KDCOMPLEX, or KSTRING  
*
*                permanent      - TRUE if attribute is permanent.
*
*                shared         - TRUE if attribute is shared
*
*        Output: none
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: The length variable indicates the length of all
*		 the attribute elements.  If different size length
*		 are desired, different attributes must be created.
*    Written By: Jeremy Worley & John Salas
*          Date: Sep 20, 1993 13:22
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: int kpds_create_object_attr(
*		!   kobject object,
*		!   char   *attribute,
*		!   int     num_args,
*		!   int     arg_size,
*		!   int     data_type,
*		!   int     permanent,
*		!   int     shared)
*
*************************************************************/

#define kpds_create_object_attr(object,attribute,num_args,arg_size,data_type,permanent,shared) \
    (KPDS_INIT ? \
    kdms_create_attribute(object,KDMS_OBJECT,attribute,num_args,arg_size, \
			  data_type,permanent,shared) : FALSE)

/************************************************************
*
*  Routine Name: kpds_destroy_object_attr - destroy an attribute
*                associated with the data object.
*
*       Purpose: 
*                The purpose of this routine is to provide the programmer 
*                with a mechanism for deleting attributes that were
*                previously created with a call to kpds_create_object_attr.
*
*                The name argument specifies the name of the 
*                attribute to be destroyed.  This function will
*		 fail if the attribute is one of the predefined
*		 KPDS attributes or if the specified attribute does
*		 not exist.
*
*        Input:  object    - the object that contains the attribute.
*                attribute - the name of the attribute to destroy.
*
*        Output: 
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: 
*    Written By: Jeremy Worley & John Salas
*          Date: Sep 20, 1993 13:04
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: int kpds_destroy_object_attr(
*		!   kobject object,
*		!   char   *attribute)
*
*************************************************************/

#define kpds_destroy_object_attr(source, attribute) \
 (KPDS_INIT ? kdms_destroy_attribute(source,KDMS_OBJECT,attribute) : FALSE)

/************************************************************
*
*  Routine Name: kpds_copy_object - copy all data and
*		 attributes from one object to another.
*
*       Purpose: 
*		 kpds_copy_object copies all physical & presentation
*		 attributes and all data from the source_object to the
*		 destination_object.  This means that all the
*		 attributes and data (not just those that are part of
*		 the polymorphic data model) are copied.  For example,
*		 the source object may contain data and attributes
*		 that one of the other services (geometry, numerical,
*		 etc.) uses.  These will also be copied.
*
*         Input: source_object - the object that serves as a
*				 source for the data and attributes.
*
*        Output: destination_object - the object that will serve
*				      as a destination in the
*				      copy operation.
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions:
*    Written By: Jeremy Worley & John Salas
*          Date: Sep 19, 1993 15:40
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: int kpds_copy_object(
*		!   kobject source_object,
*		!   kobject destination_object)
*
*************************************************************/

#define kpds_copy_object(source,destination) \
	(KPDS_INIT ? kaps_copy_object(source,destination,TRUE,TRUE) : FALSE)

/************************************************************
*
*  Routine Name: kpds_copy_remaining_data - copy remaining data from source
*					to destination
*
*       Purpose: kpds_copy_remaining_data copies any data 
*		 that has not been previously written to
*		 in the destination from a specified source.
*
*         Input: source_object - the source object
*
*        Output: destination_object - the destination object
*		
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions:
*    Written By: Steve Kubica
*          Date: Jun 24, 1994 15:18
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: int kpds_copy_remaining_data(
*		!   kobject source_object,
*		!   kobject destination_object)
*
*************************************************************/

#define kpds_copy_remaining_data(source,destination) \
   (KPDS_INIT ? \
    kdms_copy_remaining_data(source,destination) : FALSE)


/************************************************************
*
*  Routine Name: kpds_history_string - get the command line arguments
*
*       Purpose: This function returns a string containing the command
*		 line arguments for the currently running program. 
*		 The output of this program can be passed in directly
*	         as the argument for a kpds_set_attribute on the 
*		 KPDS_HISTORY attribute.     
*
*         Input: none
*
*        Output: none
*		
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Returns a static string.  Do not free this string
*    Written By: Steve Kubica
*          Date: Jun 23, 1994 11:07
*      Verified:
*  Side Effects:
* Modifications:
*
*   Declaration: char *kpds_history_string(void)
*
*************************************************************/

#define kpds_history_string() \
   (kprog_get_command())

/*-----------------------------------------------------------
|
|  Routine Name: kpds_locate
|
|       Purpose: Return an existing open kobject for the given filename
|		 and flags.  If one does not exist, return NULL.
|
|         Input: filename - name of file
|		 flags    - flags with which kobject was opened.
|			    (see kpds_open_object for gory details)
|
|        Output:
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 11, 1993 15:55
| Modifications:
|
------------------------------------------------------------*/

#define kpds_locate(filename,flags) \
 (KPDS_INIT ? kdms_locate(filename,flags) : FALSE)

/*-----------------------------------------------------------
|
|  Routine Name: kpds_add_value_callback
|
|       Purpose: 
|
|         Input:
|
|        Output:
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 11, 1993 15:55
| Modifications:
|
------------------------------------------------------------*/

#define kpds_add_value_callback(object,type,callback,clientData) \
   kdms_add_callback(object,KDMS_SEGMENT_VALUE,type,callback,clientData)

/*-----------------------------------------------------------
|
|  Routine Name: kpds_add_map_callback
|
|       Purpose: 
|
|         Input:
|
|        Output:
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 11, 1993 15:55
| Modifications:
|
------------------------------------------------------------*/

#define kpds_add_mask_callback(object,type,callback,clientData) \
   kdms_add_callback(object,KDMS_SEGMENT_MASK,type,callback,clientData)

/*-----------------------------------------------------------
|
|  Routine Name: kpds_add_map_callback
|
|       Purpose: 
|
|         Input:
|
|        Output:
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 11, 1993 15:55
| Modifications:
|
------------------------------------------------------------*/

#define kpds_add_map_callback(object,type,callback,clientData) \
   kdms_add_callback(object,KDMS_SEGMENT_MAP,type,callback,clientData)

/*-----------------------------------------------------------
|
|  Routine Name: kpds_add_location_callback
|
|       Purpose: 
|
|         Input:
|
|        Output:
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 11, 1993 15:55
| Modifications:
|
------------------------------------------------------------*/

#define kpds_add_location_callback(object,type,callback,clientData) \
   kdms_add_callback(object,KDMS_SEGMENT_LOCATION,type,callback,clientData)

/*-----------------------------------------------------------
|
|  Routine Name: kpds_add_time_callback
|
|       Purpose: 
|
|         Input:
|
|        Output:
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 11, 1993 15:55
| Modifications:
|
------------------------------------------------------------*/

#define kpds_add_time_callback(object,type,callback,clientData) \
   kdms_add_callback(object,KDMS_SEGMENT_TIME,type,callback,clientData)

/*-----------------------------------------------------------
|
|  Routine Name: kpds_remove_value_callback
|
|       Purpose: 
|
|         Input:
|
|        Output:
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 11, 1993 15:55
| Modifications:
|
------------------------------------------------------------*/

#define kpds_remove_value_callback(object,type,callback,clientData) \
   kdms_remove_callback(object,KDMS_SEGMENT_VALUE,type,callback,clientData)

/*-----------------------------------------------------------
|
|  Routine Name: kpds_remove_mask_callback
|
|       Purpose: 
|
|         Input:
|
|        Output:
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 11, 1993 15:55
| Modifications:
|
------------------------------------------------------------*/

#define kpds_remove_mask_callback(object,type,callback,clientData) \
   kdms_remove_callback(object,KDMS_SEGMENT_MASK,type,callback,clientData)

/*-----------------------------------------------------------
|
|  Routine Name: kpds_remove_map_callback
|
|       Purpose: 
|
|         Input:
|
|        Output:
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 11, 1993 15:55
| Modifications:
|
------------------------------------------------------------*/

#define kpds_remove_map_callback(object,type,callback,clientData) \
   kdms_remove_callback(object,KDMS_SEGMENT_MAP,type,callback,clientData)

/*-----------------------------------------------------------
|
|  Routine Name: kpds_remove_location_callback
|
|       Purpose: 
|
|         Input:
|
|        Output:
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 11, 1993 15:55
| Modifications:
|
------------------------------------------------------------*/

#define kpds_remove_location_callback(object,type,callback,clientData) \
   kdms_remove_callback(object,KDMS_SEGMENT_LOCATION,type,callback,clientData)

/*-----------------------------------------------------------
|
|  Routine Name: kpds_remove_time_callback
|
|       Purpose: 
|
|         Input:
|
|        Output:
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steve Kubica
|          Date: Jun 11, 1993 15:55
| Modifications:
|
------------------------------------------------------------*/

#define kpds_remove_time_callback(object,type,callback,clientData) \
   kdms_remove_callback(object,KDMS_SEGMENT_TIME,type,callback,clientData)

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* copy.c */
int kdut_initialize_segment PROTO((kobject, char *, double, double));
int kdut_copy_segment_data  PROTO((kobject, kobject, char *));
int kdut_copy_segment_attr  PROTO((kobject, kobject, char *));


/* pds_value.c -- value segment calls */
int kpds_create_value     PROTO((kobject));
int kpds_query_value      PROTO((kobject));
int kpds_destroy_value    PROTO((kobject));
int kpds_initialize_value PROTO((kobject, double, double));
int kpds_copy_value_data  PROTO((kobject, kobject, int));
int kpds_copy_value_attr  PROTO((kobject, kobject));
int kpds_copy_value       PROTO((kobject, kobject, int));

/* pds_mask.c -- mask segment calls */
int kpds_create_mask      PROTO((kobject));
int kpds_query_mask       PROTO((kobject));
int kpds_destroy_mask     PROTO((kobject));
int kpds_initialize_mask  PROTO((kobject, double));
int kpds_copy_mask_data   PROTO((kobject, kobject, int));
int kpds_copy_mask_attr   PROTO((kobject, kobject));
int kpds_copy_mask        PROTO((kobject, kobject, int));

/* pds_map.c -- map segment calls */
int kpds_create_map       PROTO((kobject));
int kpds_query_map        PROTO((kobject));
int kpds_destroy_map      PROTO((kobject));
int kpds_initialize_map   PROTO((kobject, double, double));
int kpds_copy_map_data    PROTO((kobject, kobject, int));
int kpds_copy_map_attr    PROTO((kobject, kobject));
int kpds_copy_map         PROTO((kobject, kobject, int));

/* pds_location.c -- location segment calls */
int kpds_create_location      PROTO((kobject));
int kpds_query_location       PROTO((kobject));
int kpds_destroy_location     PROTO((kobject));
int kpds_initialize_location  PROTO((kobject, double, double));
int kpds_copy_location_data   PROTO((kobject, kobject, int));
int kpds_copy_location_attr   PROTO((kobject, kobject));
int kpds_copy_location        PROTO((kobject, kobject, int));

/* pds_time.c -- time segment calls */
int kpds_create_time      PROTO((kobject));
int kpds_query_time       PROTO((kobject));
int kpds_destroy_time     PROTO((kobject));
int kpds_initialize_time  PROTO((kobject, double, double));
int kpds_copy_time_data   PROTO((kobject, kobject, int));
int kpds_copy_time_attr   PROTO((kobject, kobject));
int kpds_copy_time        PROTO((kobject, kobject, int));

/* polymorphic.c -- attribute calls */
int   kpds_get_attribute    PROTO((kobject, char *, kvalist));
int   kpds_get_attributes   PROTO((kobject, kvalist));
int   kpds_set_attribute    PROTO((kobject, char *, kvalist));
int   kpds_set_attributes   PROTO((kobject, kvalist));
int   kpds_match_attribute  PROTO((kobject, kobject, char *));
int   kpds_match_attributes PROTO((kobject, kobject, kvalist ));
int   kpds_copy_attribute   PROTO((kobject, kobject, char *));
int   kpds_copy_attributes  PROTO((kobject, kobject, kvalist ));
int   kpds_print_attribute  PROTO((kobject, char *, kfile *));
int   kpds_query_attribute  PROTO((kobject, char *, int *,int *,int *,int *));
int   kpds_copy_object_attr PROTO((kobject, kobject));

/* polymorphic.c -- data calls */
kaddr kpds_get_data	    PROTO((kobject, char *, kaddr));
int   kpds_put_data	    PROTO((kobject, char *, kaddr));

/* polymorphic.c -- object calls */
kobject kpds_open_object	  PROTO((char *, int));
kobject kpds_reference_object	  PROTO((kobject));

#endif /* _kappserv_kpolymorphic_h_ */
/* Don't add after this point */
