#! /bin/sh

echo "running test2.sh for ksampline ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  no mask, no map, 5D sampling, partially outside data set
# ------------------------------------------------------------------------
test_num=1
descr="no mask, no map, 5D sampling, partially outside data set"
ksampline -i volume:5D_head -o $tmpdir/out.$$ -wc1 -1 -hc1 -1 -dc1 -1 -ec1 -1 -tc1 -1 -wc2 129 -hc2 129 -dc2 61 -tc2 4 -ec2 4 -n 10 
kprdata -val -attr -i $tmpdir/out.$$
cat <<EOF > $tmpdir/result.$$
0 0 32.47951884 181.6544091 195.6386159 159.7348164 0 0 0 0
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

exit $status

