#! /bin/sh

echo "running test1.sh for ksampline ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  no mask, no map, in-plane sampling, contained in data set
# ------------------------------------------------------------------------
test_num=1
descr="no mask, no map, in-plane sampling, contained in data set"
cat <<EOF > $tmpdir/ascii.$$
1 1 1 1
2 2 2 2
3 3 3 3
4 4 4 4
EOF
ksampline -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -wc1 0 -hc1 0 -wc2 3 -hc2 3 -n 7
cat <<EOF > $tmpdir/result.$$
1 1.5 2 2.5 3 3.5 4
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  2:  no mask, no map, in-plane sampling, partially outside data set
# ------------------------------------------------------------------------
test_num=2
descr="no mask, no map, in-plane sampling, partially outside data set"
cat <<EOF > $tmpdir/ascii.$$
1 1 1 1
2 2 2 2
3 3 3 3
4 4 4 4
EOF
ksampline -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -wc1 -1 -hc1 -1 -wc2 4 -hc2 4 -n 11 
cat <<EOF > $tmpdir/result.$$
0 0 1 1.5 2 2.5 3 3.5 4 0 0
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  3:  mask, no map, in-plane sampling, partially outside data set
# ------------------------------------------------------------------------
test_num=3
descr="mask, no map, in-plane sampling, partially outside data set"
cat <<EOF > $tmpdir/ascii.$$
1 1 1 1
2 2 2 2
3 3 3 3
4 4 4 4
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 4 -type 10 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
1 1 1 1
1 1 1 1
1 1 1 1
1 1 1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 4 -hsize 4 -type 10 -o $tmpdir/in.$$
ksampline -i $tmpdir/in.$$ -o $tmpdir/out.$$ -wc1 -1 -hc1 -1 -wc2 4 -hc2 4 -n 11
cat <<EOF > $tmpdir/ascii.$$
0 0 1 1.5 2 2.5 3 3.5 4 0 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 11 -hsize 1 -type 11 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
0 0 1 1 1 1 1 1 1 0 0
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 11 -hsize 1 -type 3 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/ascii.$$ $tmpdir/in.$$ $tmpdir/result.$$ $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  4:  holey mask, no map, in-plane sampling, partially outside data set
# ------------------------------------------------------------------------
test_num=4
descr="holey mask, no map, in-plane sampling, partially outside data set"
cat <<EOF > $tmpdir/ascii.$$
1 1 1 1
2 2 2 2
3 3 3 3
4 4 4 4
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 4 -hsize 4 -type 10 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
1 1 1 1
1 0 0 1
1 0 1 1
1 1 1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 4 -hsize 4 -type 10 -o $tmpdir/in.$$
ksampline -i $tmpdir/in.$$ -o $tmpdir/out.$$ -wc1 -1 -hc1 -1 -wc2 4 -hc2 4 -n 11
cat <<EOF > $tmpdir/ascii.$$
0 0 1 1.3333333 0 0 3 3.5 4 0 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 11 -hsize 1 -type 11 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
0 0 1 1 0 0 1 1 1 0 0
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 11 -hsize 1 -type 3 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr"
/bin/rm -f $tmpdir/ascii.$$ $tmpdir/in.$$ $tmpdir/result.$$ $tmpdir/out.$$

exit $status

