#! /bin/sh 

echo "running test3.sh for knormal ... process ($$)"

echo "         Test  3 Normalize values between 0 and 255 for all data types"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  3:  normalize (0-255) for all types 
# ------------------------------------------------------------------------

# create and import data 
cat <<EOF > $tmpdir/ascii.$$
-1 -2 -3
57 58 59
36 37 38
-2 -3 -4
EOF
kasc2val -i1 $tmpdir/ascii.$$ -hsize 4 -wsize 3 -type Double -o $tmpdir/data.$$

# create normalized output ascii file
cat <<EOF > $tmpdir/ascii2.$$
 12.14285755   8.095237732   4.047618866  
 246.9047546   250.9523773         255  
 161.9047546   165.9523773         170  
 8.095237732   4.047618866           0  
EOF

# ---------- Test 3a --> double to Propagate Input Type (-type not specified)

test_num=3a
descr="Double to Propagate Input Type (-type not specified)"
knormal -i $tmpdir/data.$$ -o $tmpdir/out.$$ -lval 0 -uval 255
kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -wsize 3 -type Double -o $tmpdir/correct.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/correct.$$" "$descr"

# ---------- Test 3b --> Double to Bit (-type bit)

echo "COMMENTED OUT pending pds bug fix: Test  3b --> Double to Bit (-type 1)"
# test_num=3b
# descr="Double to Bit (-type bit)"
# knormal -i $tmpdir/data.$$ -o $tmpdir/out.$$ -lval 0 -uval 255 -type 1
# kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -wsize 3 -type Bit -o $tmpdir/correct.$$
# report $test_num "$tmpdir/out.$$" "$tmpdir/correct.$$" "$descr"

# ---------- Test 3c --> Double to Byte (-type 2)

test_num=3c
descr="Double to Byte (-type 2)"
knormal -i $tmpdir/data.$$ -o $tmpdir/out.$$ -lval 0 -uval 255 -type 2
kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -wsize 3 -type "Byte" -o $tmpdir/correct.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/correct.$$" "$descr"

# ---------- Test 3d --> Double to Unsigned Byte (-type 3)

test_num=3d
descr="Double to Unsigned Byte (-type 3)"
knormal -i $tmpdir/data.$$ -o $tmpdir/out.$$ -lval 0 -uval 255 -type 3
kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -wsize 3 -type "Unsigned Byte" -o $tmpdir/correct.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/correct.$$" "$descr"

# ---------- Test 3e --> Double to Short (-type 4)

test_num=3e
descr="Double to Short (-type 4)"
knormal -i $tmpdir/data.$$ -o $tmpdir/out.$$ -lval 0 -uval 255 -type 4
kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -wsize 3 -type "Short" -o $tmpdir/correct.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/correct.$$" "$descr"

# ---------- Test 3f --> Double to Unsigned Short (-type 5)

test_num=3f
descr="Double to Unsigned Short (-type 5)"
knormal -i $tmpdir/data.$$ -o $tmpdir/out.$$ -lval 0 -uval 255 -type 5
kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -wsize 3 -type "Unsigned Short" -o $tmpdir/correct.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/correct.$$" "$descr"

# ---------- Test 3g --> Double to Integer (-type 6)

test_num=3g
descr="Double to Integer (-type 6)"
knormal -i $tmpdir/data.$$ -o $tmpdir/out.$$ -lval 0 -uval 255 -type 6
kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -wsize 3 -type "Integer" -o $tmpdir/correct.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/correct.$$" "$descr"

# ---------- Test 3h --> Double to Unsigned Integer (-type 7)

test_num=3h
descr="Double to Unsigned Integer (-type 7)"
knormal -i $tmpdir/data.$$ -o $tmpdir/out.$$ -lval 0 -uval 255 -type 7
kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -wsize 3 -type "Unsigned Integer" -o $tmpdir/correct.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/correct.$$" "$descr"

# ---------- Test 3i --> Double to Long (-type 8)

test_num=3i
descr="Double to Long (-type 8)"
knormal -i $tmpdir/data.$$ -o $tmpdir/out.$$ -lval 0 -uval 255 -type 8
kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -wsize 3 -type "Long" -o $tmpdir/correct.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/correct.$$" "$descr"

# ---------- Test 3j --> Double to Unsigned Long (-type 9)

test_num=3j
descr="Double to Unsigned Long (-type 9)"
knormal -i $tmpdir/data.$$ -o $tmpdir/out.$$ -lval 0 -uval 255 -type 9
kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -wsize 3 -type "Unsigned Long" -o $tmpdir/correct.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/correct.$$" "$descr"

# ---------- Test 3k --> Double to Float (-type 10)

test_num=3k
descr="Double to Float (-type 10)"
knormal -i $tmpdir/data.$$ -o $tmpdir/out.$$ -lval 0 -uval 255 -type 10
kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -wsize 3 -type Float -o $tmpdir/correct.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/correct.$$" "$descr"

# ---------- Test 3l --> Double to Double (-type 11)

test_num=3l
descr="Double to Double (-type 11)"
knormal -i $tmpdir/data.$$ -o $tmpdir/out.$$ -lval 0 -uval 255 -type 11
kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -wsize 3 -type Double -o $tmpdir/correct.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/correct.$$" "$descr"

# ---------- Test 3m --> Double to Complex (-type 12)

# create complex normalized output ascii file
cat <<EOF > $tmpdir/ascii2.$$
 (12.14285755, 0)   (8.095237732, 0)   (4.047618866, 0)  
 (246.9047546, 0)   (250.9523773, 0)         (255, 0)  
 (161.9047546, 0)   (165.9523773, 0)         (170, 0)  
 (8.095237732, 0)   (4.047618866, 0)         (  0, 0)  
EOF

test_num=3m
descr="Double to Complex (-type 12)"
knormal -i $tmpdir/data.$$ -o $tmpdir/out.$$ -lval 0 -uval 255 -type 12
kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -wsize 3 -type Complex -o $tmpdir/correct.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/correct.$$" "$descr"

# ---------- Test 3n --> Double to Double Complex (-type 13)

test_num=3n
descr="Double to Double Complex (-type 13)"
knormal -i $tmpdir/data.$$ -o $tmpdir/out.$$ -lval 0 -uval 255 -type 13
kasc2val -i1 $tmpdir/ascii2.$$ -hsize 4 -wsize 3 -type "Double Complex" -o $tmpdir/correct.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/correct.$$" "$descr"

/bin/rm -f $tmpdir/data.$$ $tmpdir/ascii.$$ $tmpdir/ascii2.$$ 
/bin/rm -f $tmpdir/out.$$ $tmpdir/correct.$$

# ------------------------------------------------------------------------
# end of testing
# ------------------------------------------------------------------------
exit $status

