#! /bin/sh
 
echo "running test2.sh for klinearop ... process ($$)"
echo " "
 
# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test outcput data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"
 
ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-4 -sat 1 -s -rt 1 -all -cast
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}
 
#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0
 
# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}
bpath=`kecho -tb DATAMANIP -echo path`/bin
dpath="./testdata"

#------------------------------------------------------------------------
# clean up tmp directory
#------------------------------------------------------------------------
/bin/rm -f $tmpdir/outc*

# ------------------------------------------------------------------------
# Test  1: convolution data type Double 1D sweet spot w = 0 truncated
# ------------------------------------------------------------------------
test_num=1
descr="convolution Double 1D sweet spot w = 0 truncated"

$bpath/klinearop -i1 $dpath/seq1D.ascii -i2 $dpath/kernel1D.ascii  -w -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 0 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "./test2.results/conv1D_truc_0.ascii" "$descr"

# ------------------------------------------------------------------------
# Test  2: convolution data type Double 1D sweet spot w = 0 extended
# ------------------------------------------------------------------------
test_num=2
descr="convolution Double 1D sweet spot w = 0 extended"

$bpath/klinearop -i1 $dpath/seq1D.ascii -i2 $dpath/kernel1D.ascii  -w -o $tmpdir/outc.$$ -flip 0 -size 1 -l -w0 0 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "./test2.results/conv1D_ext_0.ascii" "$descr"

# ------------------------------------------------------------------------
# Test  3: convolution data type Double 1D sweet spot w = 1 truncated
# ------------------------------------------------------------------------
test_num=3
descr="convolution Double 1D sweet spot w = 1 truncated"

$bpath/klinearop -i1 $dpath/seq1D.ascii -i2 $dpath/kernel1D.ascii  -w -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 1 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "./test2.results/conv1D_truc_1.ascii" "$descr"

# ------------------------------------------------------------------------
# Test  4: convolution data type Double 1D sweet spot w = 1 extended
# ------------------------------------------------------------------------
test_num=4
descr="convolution Double 1D sweet spot w = 1 extended"

$bpath/klinearop -i1 $dpath/seq1D.ascii -i2 $dpath/kernel1D.ascii  -w -o $tmpdir/outc.$$ -flip 0 -size 1 -l -w0 1 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "./test2.results/conv1D_ext_1.ascii" "$descr"

# ------------------------------------------------------------------------
# Test  5: convolution data type Double 1D sweet spot w = 2 truncated
# ------------------------------------------------------------------------
test_num=5
descr="convolution Double 1D sweet spot w = 2 truncated"

$bpath/klinearop -i1 $dpath/seq1D.ascii -i2 $dpath/kernel1D.ascii  -w -o $tmpdir/outc.$$ -flip 0 -size 0 -l -w0 2 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "./test2.results/conv1D_truc_2.ascii" "$descr"

 
# ------------------------------------------------------------------------
# Test  6: convolution data type Double 1D sweet spot w = 2 extended
# ------------------------------------------------------------------------
test_num=6
descr="convolution Double 1D sweet spot w = 2 extended"

$bpath/klinearop -i1 $dpath/seq1D.ascii -i2 $dpath/kernel1D.ascii  -w -o $tmpdir/outc.$$ -flip 0 -size 1 -l -w0 2 -real 0 -imag 0

report $test_num "$tmpdir/outc.$$" "./test2.results/conv1D_ext_2.ascii" "$descr"
/bin/rm -f $tmpdir/outc.$$
exit $status



