#! /bin/sh

echo "running test1.sh for kinverse ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  Inverse filter test
# ------------------------------------------------------------------------
test_num=1
descr="Inverse filter test"
cat <<EOF > $tmpdir/ascii1.$$
(1.0,0.0)
(0.0,1.0)
(1.0,1.0)
(0.0,0.0)
(0.1,0.0)
(0.0,0.1)
EOF
cat <<EOF > $tmpdir/ascii2.$$
(1.0,0.0)
(0.0,1.0)
(1.0,1.0)
(0.0,0.0)
(0.1,0.0)
(0.0,0.1)
EOF
kinverse -i1 $tmpdir/ascii1.$$ -i2 $tmpdir/ascii2.$$ -o $tmpdir/out.$$ -t 0.25
cat <<EOF > $tmpdir/ascii1.$$
(1.0,0.0)
(1.0,0.0)
(1.0,0.0)
(0.0,0.0)
(0.0,0.0)
(0.0,0.0)
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii1.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ $tmpdir/ascii1.$$  $tmpdir/ascii2.$$

exit $status

