#! /bin/sh

echo "running test2.sh for kaxis ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb sampledata -echo path`
dpath="$tbpath/data/volumes"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  SAMPLEDATA/data/volumes/sagittal.viff -wd -dh -hw 
# ------------------------------------------------------------------------
test_num=1
descr="SAMPLEDATA/data/volumes/sagittal.viff -wd -dh -hw"
kaxis -i $dpath/sagittal.viff -o $tmpdir/out.$$ -wd -dh -hw
kaxis -i $tmpdir/out.$$ -o $tmpdir/out.$$ -dw -hd -wh
report $test_num "$tmpdir/out.$$" "$dpath/sagittal.viff" "$descr"
/bin/rm -f $tmpdir/out.$$

exit $status
