#! /bin/sh 

# Replace oname and file.sh in the two lines below with the name 
# of the program you are testing and the file name of this test 
# (for example, test1.sh).

object_name="karith2"
file_name="test3.sh"

# ---------------------------------------------------------------
# ADD TESTS BETWEEN the  "Add tests below this" and "End of test 
# suite" comment lines (line 60).
# ---------------------------------------------------------------

echo "running "$file_name" for "$object_name" ... process ($$)"

# report utility
# ---------------------------------------------------------------
# Usage:  report  test_num test_obj cntrl_obj test_descr tol
#
# The report function uses ksegcmp to compare the test output 
# data object ($2) against the correct result ($3), and reports 
# success or failure of the test.  If the result of ksegcmp is 
# false, status is set to 1.
#
# Input Arguments: test_num - test number
#                  test_obj - the object generated by the test
#                  cntrl_obj - known result to compare against
#                  test_descr - a string describing the test
#                  tol - tolerance allowed when comparing object 
#                        data values. Recommended tolerance 1e-5
# ---------------------------------------------------------------
report()
{
   test_num="$1"
   test_obj="$2"
   cntrl_obj="$3"
   test_descr="$4"
   tol="$5"

   ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tol" -sat 1 -s -rt 1 -all
   if [ $? = 0 ]
   then
      echo "Passed:  Test  $test_num --> "$test_descr""
   else
      echo "FAILED:  Test  $test_num --> "$test_descr""
      status=1
   fi
}

# Initialize status to be success (ie. 0).  Upon failure, status 
# is initialized to 1.  Set the tmpdir variable.  Script will 
# use /tmp if $TMPDIR is not defined.
status=0
tmpdir=${TMPDIR:-/tmp}

# ---------------------------------------------------------------
#  Add tests below this
# ---------------------------------------------------------------
bpath=`kecho -tb DATAMANIP -echo path`/bin
tmpdir=${TMPDIR:-/tmp}

kextract -i image:gull -o $tmpdir/extract.$$ -wsize 100 -hsize 50 \
	 -woff 150 -hoff 10 -subpos 1

# ------------ Test 1 --------------------
# Set the test number and the description of the test
test_num=1
descr="testing subobject position on gull"

$bpath/karith2 -sub -i1 image:gull -i2 $tmpdir/extract.$$ -o $tmpdir/out.$$
kstats -i $tmpdir/out.$$ -o $tmpdir/stats.$$

report $test_num "$tmpdir/stats.$$" "test3.results/gull.stats" "$descr" "1e-4"

# Remove the temporary files created by this test
/bin/rm -f $tmpdir/out.$$ $tmpdir/stats.$$ $tmpdir/extract.$$

# ------------ Test 2 --------------------
test_num=2
descr="test subobject position on object with value data"
cat <<EOF > $tmpdir/ascii.$$
0 1 2 3 4 
5 6 7 8 9
10 11 12 13 14
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 5 -hsize 3 -type byte -o $tmpdir/in1.$$
cat <<EOF > $tmpdir/ascii.$$
15 16 17
18 19 20
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type byte -o $tmpdir/in2.$$
ksetdattr -i $tmpdir/in2.$$ -wpos 3 -hpos 1 -o $tmpdir/in2.$$
$bpath/karith2 -i1 $tmpdir/in1.$$ -i2 $tmpdir/in2.$$ -o $tmpdir/out.$$ -add
cat <<EOF > $tmpdir/ascii.$$
0 1 2 3 4 0
5 6 7 23 25 17
10 11 12 31 33 20
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 6 -hsize 3 -type byte -o $tmpdir/answer.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr" "1e-5"

/bin/rm $tmpdir/ascii.$$ $tmpdir/out.$$
/bin/rm $tmpdir/in2.$$ 

# ------------ Test 3 --------------------
test_num=3
descr="testing subobject position on object with mask"
cat <<EOF > $tmpdir/ascii.$$
15 16 17
18 19 20
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type byte -o $tmpdir/in2.$$
cat <<EOF > $tmpdir/ascii.$$
0 1 0
1 0 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in2.$$ -wsize 3 -hsize 2 -type byte -o $tmpdir/in2.$$
ksetdattr -i $tmpdir/in2.$$ -wpos 3 -hpos 1 -o $tmpdir/in2.$$

$bpath/karith2 -i1 $tmpdir/in1.$$ -i2 $tmpdir/in2.$$ -o $tmpdir/out.$$ -add
cat <<EOF > $tmpdir/ascii.$$
1 1 1 1 1 1
1 1 1 0 1 0
1 1 1 1 0 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/answer.$$ -wsize 6 -hsize 3 \
	 -type byte -o $tmpdir/answer.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr" "1e-5"

/bin/rm $tmpdir/ascii.$$ $tmpdir/out.$$
/bin/rm $tmpdir/answer.$$ $tmpdir/in2.$$

# ------------ Test 4 --------------------
test_num=4
descr="testing subobject position on object with map"
cat <<EOF > $tmpdir/ascii.$$
2 3 4
3 2 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type byte -o $tmpdir/in2.$$
cat <<EOF > $tmpdir/ascii.$$
7
8
9
2 
3
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in2.$$ -wsize 1 -hsize 5 -type byte -o $tmpdir/in2.$$
ksetdattr -i $tmpdir/in2.$$ -wpos 3 -hpos 1 -o $tmpdir/in2.$$
$bpath/karith2 -i1 $tmpdir/in1.$$ -i2 $tmpdir/in2.$$ -o $tmpdir/out.$$ -add
cat <<EOF > $tmpdir/ascii.$$
0 1 2 3 4 0
5 6 7 17 11 3
10 11 12 15 23 8
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 6 -hsize 3 -type byte -o $tmpdir/answer.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr" "1e-5"

/bin/rm $tmpdir/ascii.$$ $tmpdir/out.$$
/bin/rm $tmpdir/answer.$$ $tmpdir/in2.$$
# ------------ Test 5 --------------------
test_num=5
descr="testing subobject position on extracted object with mask and map"
cat <<EOF > $tmpdir/ascii.$$
2 3 4
3 2 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type byte -o $tmpdir/in2.$$
cat <<EOF > $tmpdir/ascii.$$
7
8
9
2
3
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in2.$$ -wsize 1 -hsize 5 \
	 -type byte -o $tmpdir/in2.$$
cat <<EOF > $tmpdir/ascii.$$
0 1 0
1 0 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in2.$$ -wsize 3 -hsize 2 \
	  -type byte -o $tmpdir/in2.$$
ksetdattr -i $tmpdir/in2.$$ -wpos 3 -hpos 1 -o $tmpdir/in2.$$
$bpath/karith2 -i1 $tmpdir/in1.$$ -i2 $tmpdir/in2.$$ -o $tmpdir/out.$$ -add
cat <<EOF > $tmpdir/ascii.$$
0 1 2 3 4 0
5 6 7 17 11 3
10 11 12 15 23 8
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 6 -hsize 3 -type byte -o $tmpdir/answer.$$
cat <<EOF > $tmpdir/ascii.$$
1 1 1 1 1 1
1 1 1 0 1 0
1 1 1 1 0 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/answer.$$ -wsize 6 -hsize 3 \
	 -type byte -o $tmpdir/answer.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr" "1e-5"

/bin/rm $tmpdir/ascii.$$ $tmpdir/out.$$
/bin/rm $tmpdir/answer.$$ $tmpdir/in2.$$
/bin/rm $tmpdir/in1.$$ 

# ---------------------------------------------------------------
#  End of test suite
# ---------------------------------------------------------------

exit $status
