#! /bin/sh

echo "running test1a.sh for karith1 ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num="$1"
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"
tolerance="$5"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tolerance" -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  abs - float input 
# ------------------------------------------------------------------------
test_num=1
descr="abs - float input"
cat <<EOF > $tmpdir/ascii.$$
-1 1
57 -1e20
65536 -1.12345e-38
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
1 1
57 1e20
65536 1.12345e-38
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  2:  abs - masked float input
# ------------------------------------------------------------------------
test_num=2
descr="abs - masked float input"
cat <<EOF > $tmpdir/ascii.$$
-1.12345e-38 1.12345e-38
-1.12345e38 1.123456e38
-3.14159 3.14159
-0.49 0.49
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
0 0
1 0
0 1
1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
1.12345e-38 1.12345e-38
1.12345e38 1.123456e38
3.14159 3.14159
0.49 0.49
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
0 0
1 0
0 1
1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/ascii.$$ $tmpdir/in.$$ $tmpdir/result.$$

# ------------------------------------------------------------------------
# Test  3:  neg - byte input
# ------------------------------------------------------------------------
test_num=3
descr="neg - byte input"
cat <<EOF > $tmpdir/ascii.$$
0  1 -1
127 -127 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type 2 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -neg
cat <<EOF > $tmpdir/ascii.$$
0 -1 1
-127 127 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type 2 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$


# ------------------------------------------------------------------------
# Test  4:  neg - float input
# ------------------------------------------------------------------------
test_num=4
descr="neg - float input"
cat <<EOF > $tmpdir/ascii.$$
-1 1
57 -1e20
65536 -1.12345e-38
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -neg
cat <<EOF > $tmpdir/ascii.$$
1 -1
-57 1e20
-65536 1.12345e-38
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  5:  neg - masked float input
# ------------------------------------------------------------------------
test_num=5
descr="neg - masked float input"
cat <<EOF > $tmpdir/ascii.$$
-1.12345e-38 1.12345e-38
-1.12345e38 1.123456e38
-3.14159 3.14159
-0.49 0.49
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
0 0
1 0
0 1
1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -neg
cat <<EOF > $tmpdir/ascii.$$
1.12345e-38 -1.12345e-38
1.12345e38 -1.123456e38
3.14159 -3.14159
0.49 -0.49
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
0 0
1 0
0 1
1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/ascii.$$ $tmpdir/in.$$ $tmpdir/result.$$

# ------------------------------------------------------------------------
# Test  6:  recip - double input
# ------------------------------------------------------------------------
test_num=6
descr="recip - double input"
cat <<EOF > $tmpdir/ascii.$$
1 2
0.1 0.5 
1.0e-20 -1.0e-20
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 11 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -recip
cat <<EOF > $tmpdir/ascii.$$
1 0.5
10 2
1.0e20 -1.0e+20
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 11 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$


# ------------------------------------------------------------------------
# Test  7:  recip - masked float input
# ------------------------------------------------------------------------
test_num=7a
descr="recip - masked float input"
cat <<EOF > $tmpdir/ascii.$$
-1.12345e20 1.123456e20
-3.14159 3.14159
-0.49 0.49
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
1 0
0 1
1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 3 \
	-type 10 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -recip
cat <<EOF > $tmpdir/ascii.$$
-8.901152678e-21 8.901152678e-21
-0.3183101416 0.3183101416
-2.040816307 2.040816307
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
1 0
0 1
1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 3 \
	-type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/ascii.$$ $tmpdir/in.$$ $tmpdir/result.$$

test_num=7b
descr="recip - masked float input - *very* small number"
cat <<EOF > $tmpdir/ascii.$$
-1.12345e-20 1.12345e-20
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 1 -type 10 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
0 0
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 1 \
	-type 10 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -recip
cat <<EOF > $tmpdir/ascii.$$
-8.901152678e19 8.901152678e19
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 1 -type 10 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
0 0
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 1 \
	-type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e+12"
/bin/rm -f $tmpdir/ascii.$$ $tmpdir/in.$$ $tmpdir/result.$$

# ------------------------------------------------------------------------
# Test  8:  neg - int value data with float map
# ------------------------------------------------------------------------
test_num=8
descr="neg - int value data with float map"
cat <<EOF > $tmpdir/ascii.$$
-1 1
2 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 2 -type 6 -o $tmpdir/in.$$
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 127
-32 32
-32767 32767
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/in.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/in.$$
karith1 -i $tmpdir/in.$$ -o $tmpdir/out.$$ -neg
cat <<EOF > $tmpdir/ascii.$$
-1 1
2 3
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 2 -type 6 -o $tmpdir/result.$$
cat <<EOF > $tmpdir/ascii.$$
1 -1
127 -127
32 -32
32767 -32767
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/result.$$ -wsize 2 -hsize 4 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$ $tmpdir/in.$$


# ------------------------------------------------------------------------
# Test  9:  abs - signed byte value data with no map
# ------------------------------------------------------------------------
test_num=9
descr="abs - signed byte value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0  1 -1
127 -127 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type 2 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
0 1 1
127 127 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type 2 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  10:  abs - unsigned byte value data with no map
# ------------------------------------------------------------------------
test_num=10
descr="abs - unsigned byte value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0  1 255
127 128 32
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type 3 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
0 1 255
127 128 32
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type 3 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  11:  abs - signed short value data with no map
# ------------------------------------------------------------------------
test_num=11
descr="abs - signed short value data with no map"
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 127 
-32767 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 4 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
1 1
127 127 
32767 32767
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 4 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  12:  abs - unsigned short value data with no map
# ------------------------------------------------------------------------
test_num=12
descr="abs - unsigned short value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1
127 127
32767 32767
65535 250
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 4 -type 5 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
0 1
127 127
32767 32767
65535 250
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 4 -type 5 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  13:  abs - signed int value data with no map
# ------------------------------------------------------------------------
test_num=13
descr="abs - signed int value data with no map"
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 127
-32767 32767
-65535 65535
-2147483647 2147483647
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 5 -type 6 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
1 1
127 127
32767 32767
65535 65535
2147483647 2147483647
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 5 -type 6 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  14:  abs - unsigned int value data with no map
# ------------------------------------------------------------------------
test_num=14
descr="abs - unsigned int value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1
127 127
32767 32767
65535 65535
2147483647 4294967295
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 5 -type 7 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
0 1
127 127
32767 32767
65535 65535
2147483647 4294967295
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 5 -type 7 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  15:  abs - signed long value data with no map
# ------------------------------------------------------------------------
test_num=15
descr="abs - signed long value data (32 bit only) with no map"
cat <<EOF > $tmpdir/ascii.$$
-1 1
-127 127
-32767 32767
-65535 65535
-2147483647 2147483647
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 5 -type 8 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -abs
cat <<EOF > $tmpdir/ascii.$$
1 1
127 127
32767 32767
65535 65535
2147483647 2147483647
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 5 -type 8 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

exit $status

