#! /bin/sh

# Replace oname and file.sh in the two lines below with the name 
# of the program you are testing and the file name of this test 
# (for example, test1.sh).

object_name="kappend"
file_name="test2.sh"

# ---------------------------------------------------------------
# ADD TESTS BETWEEN the  "Add tests below this" and "End of test 
# suite" comment lines (line 60).
# ---------------------------------------------------------------

echo "running "$file_name" for "$object_name" ... process ($$)"

# report utility
# ---------------------------------------------------------------
# Usage:  report  test_num test_obj cntrl_obj test_descr tol
#
# The report function uses ksegcmp to compare the test output 
# data object ($2) against the correct result ($3), and reports 
# success or failure of the test.  If the result of ksegcmp is 
# false, status is set to 1.
#
# Input Arguments: test_num - test number
#                  test_obj - the object generated by the test
#                  cntrl_obj - known result to compare against
#                  test_descr - a string describing the test
#                  tol - tolerance allowed when comparing object 
#                        data values. Recommended tolerance 1e-5
# ---------------------------------------------------------------
report()
{
   test_num="$1"
   test_obj="$2"
   cntrl_obj="$3"
   test_descr="$4"
   tol="$5"

   ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tol" -sat 1 -s -rt 1 -all
   if [ $? = 0 ]
   then
      echo "Passed:  Test  $test_num --> "$test_descr""
   else
      echo "FAILED:  Test  $test_num --> "$test_descr""
      status=1
   fi
}

# Initialize status to be success (ie. 0).  Upon failure, status 
# is initialized to 1.  Set the tmpdir variable.  Script will 
# use /tmp if $TMPDIR is not defined.
status=0
tmpdir=${TMPDIR:-/tmp}

# ---------------------------------------------------------------
#  Add tests below this
# ---------------------------------------------------------------

echo "Map Tests:"

# Build data1 - 3w 2h byte value with 3w 5h float map
cat <<EOF > $tmpdir/ascii.$$
3 2 1
0 1 2
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type byte -o $tmpdir/data1.$$
cat <<EOF > $tmpdir/ascii.$$
0.01 0.11 0.21
1.01 1.11 1.21
2.01 2.11 2.21
3.01 3.11 3.21
4.01 4.11 4.21
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/data1.$$ -wsize 3 -hsize 5 \
	 -type float -o $tmpdir/data1.$$

# Build data2 - 3w 2e int value with 5h 2e float map
cat <<EOF > $tmpdir/ascii.$$
3 2 1
0 1 2
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -esize 2 -type int -o $tmpdir/data2.$$
cat <<EOF > $tmpdir/ascii.$$
0.0 1.0 2.0 3.0 4.0 
0.1 1.1 2.1 3.1 4.1
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/data2.$$ -esize 2 -hsize 5 \
	 -type float -o $tmpdir/data2.$$

# Build data3 - 3h 2e byte value with 2e 4h byte map
cat <<EOF > $tmpdir/ascii.$$
3 2 1
0 1 2
EOF
kasc2val -i1 $tmpdir/ascii.$$ -hsize 3 -esize 2 -type byte -o $tmpdir/data3.$$
cat <<EOF > $tmpdir/ascii.$$
0 1 2 3 
10 11 21 31
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/data3.$$ -esize 2 -hsize 4 \
	 -type byte -o $tmpdir/data3.$$

# Build data4 - 3h 2e byte value with no map
cat <<EOF > $tmpdir/ascii.$$
3 2 1
0 1 2
EOF
kasc2val -i1 $tmpdir/ascii.$$ -hsize 3 -esize 2 -type byte -o $tmpdir/data4.$$

# Build data5 - 2h 2w byte value with 2w 4h byte map with mask
cat <<EOF > $tmpdir/ascii.$$
1 2
3 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -hsize 2 -wsize 2 -type byte -o $tmpdir/data5.$$
cat <<EOF > $tmpdir/ascii.$$
0 10
1 11
2 21
3 31
EOF
kasc2map -i1 $tmpdir/ascii.$$ -i2 $tmpdir/data5.$$ -wsize 2 -hsize 4 \
	 -type byte -o $tmpdir/data5.$$
cat <<EOF > $tmpdir/ascii.$$
0 1
1 0
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/data5.$$ -wsize 2 -hsize 2 \
	 -type byte -o $tmpdir/data5.$$

# Build mapped data objects
kmapdata -i $tmpdir/data1.$$ -o $tmpdir/mapped1.$$
kmapdata -i $tmpdir/data2.$$ -o $tmpdir/mapped2.$$
kmapdata -i $tmpdir/data3.$$ -o $tmpdir/mapped3.$$
kmapdata -i $tmpdir/data5.$$ -o $tmpdir/mapped5.$$

# ---------------------------------------------------------------
# data1 - 3w 2h byte value with 3w 5h float map
# data2 - 3w 2e int value with 5h 2e float map
# data3 - 3h 2e byte value with 4h 2e byte map
# data4 - 3h 2e byte value with no map
# data5 - 2h 2w byte value with 2w 4h byte map with mask
# ---------------------------------------------------------------

# ---------------------------------------------------------------
# Test 1a:  all inputs have maps - append along w, mapping = 0
# Test 1b:  some inputs have maps - append along w, mapping = 0
# ---------------------------------------------------------------

test_num=1a
descr="all inputs have maps - append along w, mapping = 0"

kappend -i1 $tmpdir/data1.$$ -i2 $tmpdir/data2.$$ -i3 $tmpdir/data3.$$ \
	-o $tmpdir/out.$$ -w -mapping 0

# Build answer
kappend -i1 $tmpdir/mapped1.$$ -i2 $tmpdir/mapped2.$$ -i3 \
		$tmpdir/mapped3.$$ -o $tmpdir/outmapped.$$ -w -mapping 0
report $test_num "$tmpdir/out.$$" "$tmpdir/outmapped.$$" "$descr" "1e-5"

test_num=1b
descr="some inputs have maps, masks - append along w, mapping = 0"

kappend -i1 $tmpdir/data1.$$ -i2 $tmpdir/data2.$$ -i3 $tmpdir/data3.$$ \
	-i4 $tmpdir/data4.$$ -i5 $tmpdir/data5.$$ -o $tmpdir/out.$$ -w \
	-mapping 0

# Build answer
kappend -i1 $tmpdir/mapped1.$$ -i2 $tmpdir/mapped2.$$ -i3 $tmpdir/mapped3.$$ \
	-i4 $tmpdir/data4.$$ -i5 $tmpdir/mapped5.$$ \
	-o $tmpdir/outmapped.$$ -w -mapping 0

report $test_num "$tmpdir/out.$$" "$tmpdir/outmapped.$$" "$descr" "1e-5"

# ---------------------------------------------------------------
# Test 2a:  all inputs have maps - append along h, mapping = 0
# Test 2b:  some inputs have maps, masks - append along h, mapping = 0
# ---------------------------------------------------------------

test_num=2a
descr="all inputs have maps - append along h, mapping = 0"

kappend -i1 $tmpdir/data1.$$ -i2 $tmpdir/data2.$$ -i3 $tmpdir/data3.$$ \
	-o $tmpdir/out.$$ -h -mapping 0

# Build answer
kappend -i1 $tmpdir/mapped1.$$ -i2 $tmpdir/mapped2.$$ -i3 \
		$tmpdir/mapped3.$$ -o $tmpdir/outmapped.$$ -h -mapping 0
report $test_num "$tmpdir/out.$$" "$tmpdir/outmapped.$$" "$descr" "1e-5"

test_num=2b
descr="some inputs have maps, masks - append along h, mapping = 0"

kappend -i1 $tmpdir/data1.$$ -i2 $tmpdir/data2.$$ -i3 $tmpdir/data3.$$ \
	-i4 $tmpdir/data4.$$ -i5 $tmpdir/data5.$$ -o $tmpdir/out.$$ -h \
	-mapping 0

# Build answer
kappend -i1 $tmpdir/mapped1.$$ -i2 $tmpdir/mapped2.$$ -i3 $tmpdir/mapped3.$$ \
	-i4 $tmpdir/data4.$$ -i5 $tmpdir/mapped5.$$ \
	-o $tmpdir/outmapped.$$ -h -mapping 0

report $test_num "$tmpdir/out.$$" "$tmpdir/outmapped.$$" "$descr" "1e-5"

# ---------------------------------------------------------------
# Test 3a:  all inputs have maps - append along d, mapping 2
# Test 3b:  all inputs have maps - append along t, mapping 2
# Test 3c:  all inputs have maps - append along e, mapping 2
# ---------------------------------------------------------------

# Build answer 3w 3h 3e int value with 3w 5h 2e float map
cat <<EOF > $tmpdir/asciival.$$
3 2 1   
0 1 2   
0 0 0   

3 2 1   
0 0 0   
0 0 0   

3 0 0
2 0 0 
1 0 0 

0 0 0   
0 0 0   
0 0 0   

0 1 2   
0 0 0   
0 0 0   

0 0 0
1 0 0 
2 0 0 
EOF
cat <<EOF > $tmpdir/asciimap.$$
0.01 0.11 0.21
1.01 1.11 1.21
2.01 2.11 2.21
3.01 3.11 3.21
4.01 4.11 4.21

0.0 0.0 0.0
1.0 0.0 0.0
2.0 0.0 0.0
3.0 0.0 0.0
4.0 0.0 0.0

0 0 0
1 0 0
2 0 0
3 0 0
0 0 0

0.0 0.0 0.0
0.0 0.0 0.0
0.0 0.0 0.0
0.0 0.0 0.0
0.0 0.0 0.0

0.1 0.0 0.0
1.1 0.0 0.0
2.1 0.0 0.0
3.1 0.0 0.0
4.1 0.0 0.0

10 0 0
11 0 0
21 0 0
31 0 0
 0 0 0
EOF

test_num=3a
descr="all inputs have maps - append along d, mapping = 2"
kasc2val -i1 $tmpdir/asciival.$$ -wsize 3 -hsize 3 -esize 2 -type int \
	 -dsize 3 -o $tmpdir/answer.$$
kasc2map -i1 $tmpdir/asciimap.$$ -i2 $tmpdir/answer.$$ -wsize 3 -hsize 5 \
	 -dsize 3 -esize 2 -type float -o $tmpdir/answer.$$
kappend -i1 $tmpdir/data1.$$ -i2 $tmpdir/data2.$$ -i3 $tmpdir/data3.$$ \
	-o $tmpdir/out.$$ -d -mapping 2
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr" "1e-5"

test_num=3b
descr="all inputs have maps - append along t, mapping = 2"
kasc2val -i1 $tmpdir/asciival.$$ -wsize 3 -hsize 3 -esize 2 -type int \
	 -tsize 3 -o $tmpdir/answer.$$
kasc2map -i1 $tmpdir/asciimap.$$ -i2 $tmpdir/answer.$$ -wsize 3 -hsize 5 \
	 -tsize 3 -esize 2 -type float -o $tmpdir/answer.$$
kappend -i1 $tmpdir/data1.$$ -i2 $tmpdir/data2.$$ -i3 $tmpdir/data3.$$ \
	-o $tmpdir/out.$$ -t -mapping 2
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr" "1e-5"

test_num=3c
descr="all inputs have maps - append along e, mapping = 2"
kappend -i1 $tmpdir/data1.$$ -i2 $tmpdir/data2.$$ -i3 $tmpdir/data3.$$ \
	-o $tmpdir/out.$$ -e -mapping 2
# Build answer 3w 3h 5e int value with 3w 5h 5e float map
cat <<EOF > $tmpdir/asciival.$$
3 2 1   
0 1 2   
0 0 0   

3 2 1   
0 0 0   
0 0 0   

0 1 2   
0 0 0   
0 0 0   

3 0 0
2 0 0 
1 0 0 

0 0 0
1 0 0 
2 0 0 
EOF
kasc2val -i1 $tmpdir/asciival.$$ -wsize 3 -hsize 3 -esize 5 -type int \
	 -o $tmpdir/answer.$$
cat <<EOF > $tmpdir/asciimap.$$
0.01 0.11 0.21
1.01 1.11 1.21
2.01 2.11 2.21
3.01 3.11 3.21
4.01 4.11 4.21

0.0 0.0 0.0
1.0 0.0 0.0
2.0 0.0 0.0
3.0 0.0 0.0
4.0 0.0 0.0

0.1 0.0 0.0
1.1 0.0 0.0
2.1 0.0 0.0
3.1 0.0 0.0
4.1 0.0 0.0

0 0 0
1 0 0
2 0 0
3 0 0
0 0 0

10 0 0
11 0 0
21 0 0
31 0 0
 0 0 0
EOF
kasc2map -i1 $tmpdir/asciimap.$$ -i2 $tmpdir/answer.$$ -wsize 3 -hsize 5 \
	 -esize 5 -type float -o $tmpdir/answer.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr" "1e-5"

# ---------------------------------------------------------------
# Test 4a:  all inputs have maps - append along d, mapping = 1
# Test 4b:  all inputs have maps - append along t, mapping = 1
# Test 4c:  all inputs have maps - append along e, mapping = 1
# ---------------------------------------------------------------

# Build answer 3w 3h 3e int value with 3w 5h float map
cat <<EOF > $tmpdir/asciival.$$
3 2 1   
0 1 2   
0 0 0   

3 2 1   
0 0 0   
0 0 0   

3 0 0
2 0 0 
1 0 0 

0 0 0   
0 0 0   
0 0 0   

0 1 2   
0 0 0   
0 0 0   

0 0 0
1 0 0 
2 0 0 
EOF
cat <<EOF > $tmpdir/asciimap.$$
0.01 0.11 0.21
1.01 1.11 1.21
2.01 2.11 2.21
3.01 3.11 3.21
4.01 4.11 4.21
EOF

test_num=4a
descr="all inputs have maps - append along d, mapping = 1"
kasc2val -i1 $tmpdir/asciival.$$ -wsize 3 -hsize 3 -esize 2 -type int \
	 -dsize 3 -o $tmpdir/answer.$$
kasc2map -i1 $tmpdir/asciimap.$$ -i2 $tmpdir/answer.$$ -wsize 3 -hsize 5 \
	 -type float -o $tmpdir/answer.$$
kappend -i1 $tmpdir/data1.$$ -i2 $tmpdir/data2.$$ -i3 $tmpdir/data3.$$ \
	-o $tmpdir/out.$$ -d -mapping 1
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr" "1e-5"

test_num=4b
descr="all inputs have maps - append along t, mapping = 1"
kasc2val -i1 $tmpdir/asciival.$$ -wsize 3 -hsize 3 -esize 2 -type int \
	 -tsize 3 -o $tmpdir/answer.$$
kasc2map -i1 $tmpdir/asciimap.$$ -i2 $tmpdir/answer.$$ -wsize 3 -hsize 5 \
	 -type float -o $tmpdir/answer.$$
kappend -i1 $tmpdir/data1.$$ -i2 $tmpdir/data2.$$ -i3 $tmpdir/data3.$$ \
	-o $tmpdir/out.$$ -t -mapping 1
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr" "1e-5"

test_num=4c
descr="all inputs have maps - append along e, mapping = 1"
kappend -i1 $tmpdir/data1.$$ -i2 $tmpdir/data2.$$ -i3 $tmpdir/data3.$$ \
	-o $tmpdir/out.$$ -e -mapping 1
# Build answer 3w 3h 5e int value with 3w 5h float map
cat <<EOF > $tmpdir/asciival.$$
3 2 1   
0 1 2   
0 0 0   

3 2 1   
0 0 0   
0 0 0   

0 1 2   
0 0 0   
0 0 0   

3 0 0
2 0 0 
1 0 0 

0 0 0
1 0 0 
2 0 0 
EOF
kasc2val -i1 $tmpdir/asciival.$$ -wsize 3 -hsize 3 -esize 5 -type int \
	 -o $tmpdir/answer.$$
cat <<EOF > $tmpdir/asciimap.$$
0.01 0.11 0.21
1.01 1.11 1.21
2.01 2.11 2.21
3.01 3.11 3.21
4.01 4.11 4.21
EOF
kasc2map -i1 $tmpdir/asciimap.$$ -i2 $tmpdir/answer.$$ -wsize 3 -hsize 5 \
	 -type float -o $tmpdir/answer.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/ascii.$$ $tmpdir/data1.$$ $tmpdir/data2.$$
/bin/rm -f $tmpdir/data3.$$ $tmpdir/data4.$$ $tmpdir/data5.$$
/bin/rm -f $tmpdir/mapped1.$$ $tmpdir/mapped2.$$ $tmpdir/mapped3.$$
/bin/rm -f $tmpdir/mapped5.$$ $tmpdir/out.$$ $tmpdir/outmapped.$$
/bin/rm -f $tmpdir/asciival.$$ $tmpdir/asciimap.$$ $tmpdir/answer.$$

# ---------------------------------------------------------------
#  End of test suite
# ---------------------------------------------------------------

exit $status
