 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kunmask.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kunmask_get_args
| 
|       Purpose: Gets command line args for kunmask
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kunmask
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kunmask_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kunmask is out of sync with arguments specified in kunmask's *.pane file; please rerun ghostwriter on kunmask.";


	/*
	 * allocate the kunmask structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kunmask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "real",
			  &(clui_info->real_double),
			  &(clui_info->real_flag))))
	{
	    kerror(NULL, "kunmask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "imag",
			  &(clui_info->imag_double),
			  &(clui_info->imag_flag))))
	{
	    kerror(NULL, "kunmask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kunmask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "prop",
			  &(clui_info->prop_flag))))
	{
	    kerror(NULL, "kunmask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "replace",
			  &(clui_info->replace_flag))))
	{
	    kerror(NULL, "kunmask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "attr",
			  &(clui_info->attr_flag))))
	{
	    kerror(NULL, "kunmask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "omask",
			  &(clui_info->omask_file),
			  &(clui_info->omask_flag))))
	{
	    kerror(NULL, "kunmask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "mask",
			  &(clui_info->mask_flag))))
	{
	    kerror(NULL, "kunmask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "val",
			  &(clui_info->val_flag))))
	{
	    kerror(NULL, "kunmask_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



