 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kstats
   >>>> 
   >>>>    Written By: Ashish Malhotra & Donna Koechner
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kstats_h_
#define _kstats_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kstats/uis/kstats.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input object (required infile)
 */
char	*i_file;	/* Input object FILENAME */
int	 i_flag;	/* Input object FLAG */

/*
 *  Gating input data object (optional infile)
 */
char	*igate_file;	/* Gating input data object FILENAME */
int	 igate_flag;	/* Gating input data object FLAG */

/*
 *  Formatted ASCII output file (optional outfile)
 */
char	*f_file;	/* Formatted ASCII output file FILENAME */
int	 f_flag;	/* Formatted ASCII output file FLAG */

/*
 *  Binary output statistics file (optional outfile)
 */
char	*o_file;	/* Binary output statistics file FILENAME */
int	 o_flag;	/* Binary output statistics file FLAG */

/*----- optional ME group ----*/
/*
 *  compute single set of statistics for entire data set (optional flag)
 */
int	 whole_flag;  	/* compute single set of statistics for entire data set FLAG */

	/*---- nested optional   group ----*/
/*
 *  include width in processing unit (optional flag)
 */
int	 w_flag;  	/* include width in processing unit FLAG */

/*
 *  include height in processing unit (optional flag)
 */
int	 h_flag;  	/* include height in processing unit FLAG */

/*
 *  include depth in processing unit (optional flag)
 */
int	 d_flag;  	/* include depth in processing unit FLAG */

/*
 *  include time in processing unit (optional flag)
 */
int	 t_flag;  	/* include time in processing unit FLAG */

/*
 *  include elements in processing unit (optional flag)
 */
int	 e_flag;  	/* include elements in processing unit FLAG */

	/*-- nested optional   group end --*/

/*-- optional ME group end ---*/

/*----- optional ME group ----*/
/*
 *  compute and store all statistics information (optional flag)
 */
int	 all_flag;  	/* compute and store all statistics information FLAG */

	/*---- nested optional   group ----*/
/*
 *  compute mean (optional flag)
 */
int	 mean_flag;  	/* compute mean FLAG */

/*
 *  compute total integral (optional flag)
 */
int	 sum_flag;  	/* compute total integral FLAG */

/*
 *  compute variance (optional flag)
 */
int	 var_flag;  	/* compute variance FLAG */

/*
 *  store width coordinate of the minimum value (optional flag)
 */
int	 wmin_flag;  	/* store width coordinate of the minimum value FLAG */

/*
 *  compute positive part of integral (optional flag)
 */
int	 psum_flag;  	/* compute positive part of integral FLAG */

/*
 *  compute standard deviation (optional flag)
 */
int	 sd_flag;  	/* compute standard deviation FLAG */

/*
 *  store height coordinate of the minimum value (optional flag)
 */
int	 hmin_flag;  	/* store height coordinate of the minimum value FLAG */

/*
 *  compute negative part of integral (optional flag)
 */
int	 nsum_flag;  	/* compute negative part of integral FLAG */

/*
 *  compute root mean square (optional flag)
 */
int	 rms_flag;  	/* compute root mean square FLAG */

/*
 *  store depth coordinate of the minimum value (optional flag)
 */
int	 dmin_flag;  	/* store depth coordinate of the minimum value FLAG */

/*
 *  compute total number of contributing points (optional flag)
 */
int	 pts_flag;  	/* compute total number of contributing points FLAG */

/*
 *  compute skewness (optional flag)
 */
int	 skew_flag;  	/* compute skewness FLAG */

/*
 *  store time coordinate of the minimum value (optional flag)
 */
int	 tmin_flag;  	/* store time coordinate of the minimum value FLAG */

/*
 *  compute number of positive contributing points (optional flag)
 */
int	 ppts_flag;  	/* compute number of positive contributing points FLAG */

/*
 *  compute kurtosis (optional flag)
 */
int	 kur_flag;  	/* compute kurtosis FLAG */

/*
 *  store elements coordinate of the minimum value (optional flag)
 */
int	 emin_flag;  	/* store elements coordinate of the minimum value FLAG */

/*
 *  compute number of negative contributing points (optional flag)
 */
int	 npts_flag;  	/* compute number of negative contributing points FLAG */

/*
 *  compute minimum value (optional flag)
 */
int	 minval_flag;  	/* compute minimum value FLAG */

/*
 *  compute number of zero-valued contributing pts (optional flag)
 */
int	 zpts_flag;  	/* compute number of zero-valued contributing pts FLAG */

/*
 *  compute maximum value (optional flag)
 */
int	 maxval_flag;  	/* compute maximum value FLAG */

/*
 *  store width coordinate of the maximum value (optional flag)
 */
int	 wmax_flag;  	/* store width coordinate of the maximum value FLAG */

/*
 *  store size of objects width dimension (optional flag)
 */
int	 wsize_flag;  	/* store size of objects width dimension FLAG */

/*
 *  store height coordinate of the maximum value (optional flag)
 */
int	 hmax_flag;  	/* store height coordinate of the maximum value FLAG */

/*
 *  store size of objects height dimension (optional flag)
 */
int	 hsize_flag;  	/* store size of objects height dimension FLAG */

/*
 *  store depth coordinate of the maximum value (optional flag)
 */
int	 dmax_flag;  	/* store depth coordinate of the maximum value FLAG */

/*
 *  store size of objects depth dimension (optional flag)
 */
int	 dsize_flag;  	/* store size of objects depth dimension FLAG */

/*
 *  store time coordinate of the maximum value (optional flag)
 */
int	 tmax_flag;  	/* store time coordinate of the maximum value FLAG */

/*
 *  store size of objects time dimension (optional flag)
 */
int	 tsize_flag;  	/* store size of objects time dimension FLAG */

/*
 *  store elements coordinate of the maximum value (optional flag)
 */
int	 emax_flag;  	/* store elements coordinate of the maximum value FLAG */

/*
 *  store size of objects elements dimension (optional flag)
 */
int	 esize_flag;  	/* store size of objects elements dimension FLAG */

	/*-- nested optional   group end --*/

/*-- optional ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kstats_get_args PROTO((kform *));
void kstats_usage_additions PROTO((void));
void kstats_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
