 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "ksetdattr.h"
/*-----------------------------------------------------------
| 
|  Routine Name: ksetdattr_get_args
| 
|       Purpose: Gets command line args for ksetdattr
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ksetdattr
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ksetdattr_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for ksetdattr is out of sync with arguments specified in ksetdattr's *.pane file; please rerun ghostwriter on ksetdattr.";


	/*
	 * allocate the ksetdattr structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "maskpres", KVF_LIST_LABEL,
			  &(clui_info->maskpres_label),
			  &(clui_info->maskpres_flag)) &&
	      kclui_get_value(pane, "maskpres", KVF_LIST_VAL,
			  &(clui_info->maskpres_list),
			  &(clui_info->maskpres_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "wbegin",
			  &(clui_info->wbegin_double),
			  &(clui_info->wbegin_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "wend",
			  &(clui_info->wend_double),
			  &(clui_info->wend_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "hbegin",
			  &(clui_info->hbegin_double),
			  &(clui_info->hbegin_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "hend",
			  &(clui_info->hend_double),
			  &(clui_info->hend_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "dbegin",
			  &(clui_info->dbegin_double),
			  &(clui_info->dbegin_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "dend",
			  &(clui_info->dend_double),
			  &(clui_info->dend_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "wpos",
			  &(clui_info->wpos_int),
			  &(clui_info->wpos_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "wpsize",
			  &(clui_info->wpsize_double),
			  &(clui_info->wpsize_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hpos",
			  &(clui_info->hpos_int),
			  &(clui_info->hpos_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "hpsize",
			  &(clui_info->hpsize_double),
			  &(clui_info->hpsize_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "dpos",
			  &(clui_info->dpos_int),
			  &(clui_info->dpos_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "dpsize",
			  &(clui_info->dpsize_double),
			  &(clui_info->dpsize_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "tpos",
			  &(clui_info->tpos_int),
			  &(clui_info->tpos_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "tpsize",
			  &(clui_info->tpsize_double),
			  &(clui_info->tpsize_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "epos",
			  &(clui_info->epos_int),
			  &(clui_info->epos_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "epsize",
			  &(clui_info->epsize_double),
			  &(clui_info->epsize_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "cspace", KVF_LIST_LABEL,
			  &(clui_info->cspace_label),
			  &(clui_info->cspace_flag)) &&
	      kclui_get_value(pane, "cspace", KVF_LIST_VAL,
			  &(clui_info->cspace_list),
			  &(clui_info->cspace_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "alpha", KVF_LIST_LABEL,
			  &(clui_info->alpha_label),
			  &(clui_info->alpha_flag)) &&
	      kclui_get_value(pane, "alpha", KVF_LIST_VAL,
			  &(clui_info->alpha_list),
			  &(clui_info->alpha_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "rmasksub",
			  &(clui_info->rmasksub_double),
			  &(clui_info->rmasksub_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "imasksub",
			  &(clui_info->imasksub_double),
			  &(clui_info->imasksub_flag))))
	{
	    kerror(NULL, "ksetdattr_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



