 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kresample.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kresample_get_args
| 
|       Purpose: Gets command line args for kresample
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kresample
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kresample_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kresample is out of sync with arguments specified in kresample's *.pane file; please rerun ghostwriter on kresample.";


	/*
	 * allocate the kresample structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "wmag",
			  &(clui_info->wmag_double),
			  &(clui_info->wmag_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "hmag",
			  &(clui_info->hmag_double),
			  &(clui_info->hmag_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "dmag",
			  &(clui_info->dmag_double),
			  &(clui_info->dmag_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "tmag",
			  &(clui_info->tmag_double),
			  &(clui_info->tmag_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "emag",
			  &(clui_info->emag_double),
			  &(clui_info->emag_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "inter", KVF_LIST_LABEL,
			  &(clui_info->inter_label),
			  &(clui_info->inter_flag)) &&
	      kclui_get_value(pane, "inter", KVF_LIST_VAL,
			  &(clui_info->inter_list),
			  &(clui_info->inter_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "resize",
			  &(clui_info->resize_logic),
			  &(clui_info->resize_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "center",
			  &(clui_info->center_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "wc",
			  &(clui_info->wc_int),
			  &(clui_info->wc_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hc",
			  &(clui_info->hc_int),
			  &(clui_info->hc_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "dc",
			  &(clui_info->dc_int),
			  &(clui_info->dc_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "tc",
			  &(clui_info->tc_int),
			  &(clui_info->tc_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "ec",
			  &(clui_info->ec_int),
			  &(clui_info->ec_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kresample_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



