 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kreplace
   >>>> 
   >>>>    Written By: Donna Koechner, Ashish Malhotra
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kreplace_h_
#define _kreplace_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kreplace/uis/kreplace.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input file (required infile)
 */
char	*i_file;	/* Input file FILENAME */
int	 i_flag;	/* Input file FLAG */

/*
 *  Value to be replaced (X) (required double)
 */
double	 oval_double;	/* Value to be replaced (X) DOUBLE */
int	 oval_flag;   	/* Value to be replaced (X) FLAG */

/*
 *  New value to be substituted (Y) (required double)
 */
double	 nval_double;	/* New value to be substituted (Y) DOUBLE */
int	 nval_flag;   	/* New value to be substituted (Y) FLAG */

/*
 *  Output file (required outfile)
 */
char	*o_file;	/* Output file FILENAME */
int	 o_flag;	/* Output file FLAG */

/*
 *  Upper tolerance allowed in searched value (optional double)
 */
double	 utol_double;	/* Upper tolerance allowed in searched value DOUBLE */
int	 utol_flag;   	/* Upper tolerance allowed in searched value FLAG */

/*
 *  Lower tolerance allowed in searched value (optional double)
 */
double	 ltol_double;	/* Lower tolerance allowed in searched value DOUBLE */
int	 ltol_flag;   	/* Lower tolerance allowed in searched value FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kreplace_get_args PROTO((kform *));
void kreplace_usage_additions PROTO((void));
void kreplace_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
