 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kreal2cmplx.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kreal2cmplx_get_args
| 
|       Purpose: Gets command line args for kreal2cmplx
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kreal2cmplx
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kreal2cmplx_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kreal2cmplx is out of sync with arguments specified in kreal2cmplx's *.pane file; please rerun ghostwriter on kreal2cmplx.";


	/*
	 * allocate the kreal2cmplx structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_double(pane, "real",
			  &(clui_info->real_double),
			  &(clui_info->real_flag))))
	{
	    kerror(NULL, "kreal2cmplx_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "imag",
			  &(clui_info->imag_double),
			  &(clui_info->imag_flag))))
	{
	    kerror(NULL, "kreal2cmplx_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kreal2cmplx_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "kreal2cmplx_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "kreal2cmplx_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



